package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingContentModelMapper;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultBiddingContentModelService")
public class BiddingContentModelServiceImpl implements BiddingContentModelService {
    @Resource
    protected BiddingContentModelMapper biddingContentModelMapper;

    @CacheEvict(value={"biddingContentModel"}, allEntries=true)
    @Override
    public void addObj(BiddingContentModel t) {
        this.biddingContentModelMapper.insertSelective(t);
    }

    @CacheEvict(value={"biddingContentModel"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.biddingContentModelMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingContentModel"}, allEntries=true)
    @Override
    public void modifyObj(BiddingContentModel t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingContentModelMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="biddingContentModel", keyGenerator="redisKeyGenerator")
    @Override
    public BiddingContentModel queryObjById(String id) {
        return this.biddingContentModelMapper.selectByPrimaryKey(id);
    }

//    @Cacheable(value="biddingContentModel", keyGenerator="redisKeyGenerator")
    @Override
    public List<BiddingContentModel> queryAllObjByExample(BiddingContentModelExample example) {
        return this.biddingContentModelMapper.selectByExample(example);
    }

    @Cacheable(value="biddingContentModel", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<BiddingContentModel> queryObjByPage(BiddingContentModelExample example) {
        PageView<BiddingContentModel> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingContentModelMapper.selectByExampleByPage(example));
        return pageView;
    }
}