package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingContentOtherMapper;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultBiddingContentOtherService")
public class BiddingContentOtherServiceImpl implements BiddingContentOtherService {
    @Resource
    protected BiddingContentOtherMapper biddingContentOtherMapper;

    @CacheEvict(value={"biddingContentOther"}, allEntries=true)
    @Override
    public void addObj(BiddingContentOther t) {
        this.biddingContentOtherMapper.insertSelective(t);
    }

    @CacheEvict(value={"biddingContentOther"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.biddingContentOtherMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingContentOther"}, allEntries=true)
    @Override
    public void modifyObj(BiddingContentOther t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingContentOtherMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="biddingContentOther", keyGenerator="redisKeyGenerator")
    @Override
    public BiddingContentOther queryObjById(String id) {
        return this.biddingContentOtherMapper.selectByPrimaryKey(id);
    }

//    @Cacheable(value="biddingContentOther", keyGenerator="redisKeyGenerator")
    @Override
    public List<BiddingContentOther> queryAllObjByExample(BiddingContentOtherExample example) {
        return this.biddingContentOtherMapper.selectByExample(example);
    }

    @Cacheable(value="biddingContentOther", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<BiddingContentOther> queryObjByPage(BiddingContentOtherExample example) {
        PageView<BiddingContentOther> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingContentOtherMapper.selectByExampleByPage(example));
        return pageView;
    }
}