package com.els.base.bidding.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.dao.BiddingContentMapper;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentExample;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentMatterExample;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingOnline;
import com.els.base.bidding.entity.BiddingOnlineExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingOnlineService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;

@Service("defaultBiddingContentService")
public class BiddingContentServiceImpl implements BiddingContentService, ITaskListener {
    @Resource
    protected BiddingContentMapper biddingContentMapper;

    @Resource
    protected BiddingContentMatterService biddingContentMatterService;

    @Resource
    protected BiddingHeaderService biddingHeaderService;

    @Resource
    protected BiddingSupplierService biddingSupplierService;

    @Resource
    protected BiddingOfferService biddingOfferService;

    @Resource
    protected WorkFlowService workFlowService;

    @Resource
    protected BiddingContentModelService biddingContentModelService;

    @Resource
    protected BiddingContentOtherService biddingContentOtherService;

    @Resource
    protected CompanyUserRefService companyUserRefService;
    
    @Resource
    protected BiddingOnlineService biddingOnlineService;
    
    @CacheEvict(value = { "biddingContent" }, allEntries = true)
    @Override
    public void addObj(BiddingContent t) {
        t.setCreateTime(new Date());
        this.biddingContentMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingContent" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingContentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingContent" }, allEntries = true)
    @Override
    public void modifyObj(BiddingContent t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingContentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "biddingContent", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingContent queryObjById(String id) {
        return this.biddingContentMapper.selectByPrimaryKey(id);
    }

    // @Cacheable(value="biddingContent", keyGenerator="redisKeyGenerator")
    @Override
    public List<BiddingContent> queryAllObjByExample(BiddingContentExample example) {
        return this.biddingContentMapper.selectByExample(example);
    }

    @Cacheable(value = "biddingContent", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingContent> queryObjByPage(BiddingContentExample example) {
        PageView<BiddingContent> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingContentMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingContentMatterExample matterExample = new BiddingContentMatterExample();
        matterExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContentMatter> biddingContentMatterList = this.biddingContentMatterService
                .queryAllObjByExample(matterExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentMatterList)
                && i < biddingContentMatterList.size(); i++) {
            this.biddingContentMatterService.deleteObjById(biddingContentMatterList.get(i).getId());
        }

        BiddingContentModelExample modelExample = new BiddingContentModelExample();
        modelExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContentModel> biddingContentModelList = this.biddingContentModelService
                .queryAllObjByExample(modelExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentModelList)
                && i < biddingContentModelList.size(); i++) {
            this.biddingContentModelService.deleteObjById(biddingContentModelList.get(i).getId());
        }

        BiddingContentOtherExample otherExample = new BiddingContentOtherExample();
        otherExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContentOther> biddingContentOtherList = this.biddingContentOtherService
                .queryAllObjByExample(otherExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentOtherList)
                && i < biddingContentOtherList.size(); i++) {
            this.biddingContentOtherService.deleteObjById(biddingContentOtherList.get(i).getId());
        }

        BiddingContentExample contentExample = new BiddingContentExample();
        contentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContent> biddingContentList = this.biddingContentMapper.selectByExample(contentExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentList) && i < biddingContentList.size(); i++) {
            this.biddingContentMapper.deleteByPrimaryKey(biddingContentList.get(i).getId());
        }
    }

    @Override
    @Transactional
    public void biddingBeforeApproval(List<String> bidingNoList) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoIn(bidingNoList);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderService
                .queryAllObjByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); i++) {
            ProcessStartVO vo = ProcessStartVO.newInstance("ztbdbsp",
                    biddingHeaderList.get(i).getBiddingNo(), biddingHeaderList.get(i).getId(),
                    "targetBiddingresult?biddingNo=" + biddingHeaderList.get(i).getBiddingNo()
                            + "&state=evaluationresults" + "&biddingRoundsNumber="
                            + biddingHeaderList.get(i).getBiddingCurrentRound());
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess != null) {
                BiddingHeader biddingHeader = new BiddingHeader();
                biddingHeader.setId(biddingHeaderList.get(i).getId());
                biddingHeader.setBiddingAuditstatus("1");// 0-尚未审批，1-正在审批，2-审批通过，3-已驳回
                this.biddingHeaderService.modifyObj(biddingHeader);
            }
        }
    }

    @Override
    @Transactional
    public void listen(TaskOperateEvent event) {
        Assert.isNotBlank(event.getBusinessId(), "审批单据ID为空");
        BiddingHeader biddingHeader = new BiddingHeader();
        biddingHeader.setId(event.getBusinessId());

        BiddingHeader queryObjById = this.biddingHeaderService.queryObjById(event.getBusinessId());

        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria().andBiddingHeaderIdEqualTo(event.getBusinessId());
                //.andSupBiddingStatusEqualTo(TenderStatusEumn.BIDOVER.getValue());把改条件已到下面的判断中去 2018-5-31 TenderStatusEumn.BIDOVER.getValue().equals(biddingSupplierList.get(i).getSupBiddingStatus()
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService
                .queryAllObjByExample(supplierExample);
        if (event.isFinished() && event.isPass()) {//通过
            // 审批流完成而且通过
            biddingHeader.setBiddingAuditstatus("2");//0-尚未审批，1-正在审批，2-审批通过，3-已驳回
            biddingHeader.setBiddingStatus(TenderStatusEumn.ISSCALING.getValue());
            
            //循环该招标单对应的所有供应商列表
            for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); i++) {
            	// 更新 已评标 的供应商招标状态为 已定标
            	if(TenderStatusEumn.BIDOVER.getValue().equals(biddingSupplierList.get(i).getSupBiddingStatus())){
	                BiddingSupplier biddingSupplier = new BiddingSupplier();
	                biddingSupplier.setId(biddingSupplierList.get(i).getId());
	                biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISSCALING.getValue());
	                this.biddingSupplierService.modifyObj(biddingSupplier);
            	}
                //begin 2018-05-28发送通知
            	String str = "";
            	if (!"2".equals(queryObjById.getBiddingType())) {
            		//根据招标单号，供应商id，当前轮次查询供应商目前中标了多少
            		BiddingOfferExample example = new BiddingOfferExample();
            		BiddingOfferExample.Criteria criteria = example.createCriteria();
            		criteria.andBiddingNoEqualTo(queryObjById.getBiddingNo());// 招标单号
            		criteria.andSupCompanyIdEqualTo(biddingSupplierList.get(i).getSupCompanyId());// 供应商id
            		criteria.andBiddingRoundsNumberEqualTo(queryObjById.getBiddingCurrentRound());// 当前轮次
            		
            		List<BiddingOffer> biddingOfferList = this.biddingOfferService.queryAllObjByExample(example);
            		//把中标结果存储到该变量
            		List<String> strList = new ArrayList<String>();
            		for (BiddingOffer biddingOffer : biddingOfferList) {
            			strList.add(biddingOffer.getIsBidding()==null?"0":biddingOffer.getIsBidding());
            		}
            		//如果已中标数量=标的数量，则全部中标
            		if(Collections.frequency(strList, "1") == strList.size()){
            			str="全部中标";
            		}else if(Collections.frequency(strList, "1") < strList.size() && Collections.frequency(strList, "1")>0){
            			//如果已中标数量<标的数量，并且中标数量>0,则部分中标
            			str="部分中标";
            		}else{
            			str="未中标";
            		}
            	} else {
            		// 在线竞价，根据招标单号，供应商ID，查询供应商全部报价，看是否有中标的
            		BiddingOnlineExample onlineExample = new BiddingOnlineExample();
            		onlineExample.createCriteria().andBiddingNoEqualTo(queryObjById.getBiddingNo())
            			.andSupCompanyIdEqualTo(biddingSupplierList.get(i).getSupCompanyId())
            			.andQuotationStateNotEqualTo("0");
            		List<BiddingOnline> onlineList = this.biddingOnlineService.queryAllObjByExample(onlineExample);
            		if (CollectionUtils.isEmpty(onlineList)) {
            			continue;
            		}
            		for (BiddingOnline online : onlineList) {
            			if ("2".equals(online.getQuotationState())) {
            				str="中标";
            			} else {
            				str="未中标";
            			}
            		}
            	}
                
                Map<String, Object> msg = new HashMap<String, Object>();
                msg.put("biddingNo", biddingSupplierList.get(i).getBiddingNo());//招标单号
                msg.put("isBid", str);//提示语

                // 发送消息提醒
                if (StringUtils.isNotBlank(biddingSupplierList.get(i).getSupCompanyId())) {
                    List<String> idList = this.companyUserRefService.queryUserOfCompany(biddingSupplierList.get(i).getSupCompanyId());
                    if (CollectionUtils.isNotEmpty(idList)) {
                    	for (String userid : idList) {
                    		if(StringUtils.isNotBlank(userid)){
                    			Message<Map<String, Object>> message = Message.init(msg)
                    					.setCompanyCode(queryObjById.getPurCompanyCode())// 发送者公司srmcode
                    					.setSenderId(queryObjById.getPurUserId())// 发送者 userId
                    					.addReceiverId(userid)// 接受者 userId
                    					.setBusinessTypeCode("BIDDING_PUR_WIN_BID_NOTICE")// 业务类型
                    					.setMsgLevel(MessageLevelEnum.HIGH);// 消息等级
                    			MessageSendUtils.sendMessage(message);
                    		}
                    	}
                    }
                }
            }
        } else if (event.isFinished() && !event.isPass()) {//驳回
        	
            biddingHeader.setBiddingAuditstatus("3");
            biddingHeader.setBiddingStatus(TenderStatusEumn.INBID.getValue());
            biddingHeader.setBidSubmitDate(null);//提交评标时间设置为空，否则供应商查询时招标状态显示有问题
            
            // 更新 已评标 的供应商招标状态为 评标中
            for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); i++) {
            	// 更新 已评标 的供应商招标状态为 评标中
            	if(TenderStatusEumn.BIDOVER.getValue().equals(biddingSupplierList.get(i).getSupBiddingStatus())){
	                BiddingSupplier biddingSupplier = new BiddingSupplier();
	                biddingSupplier.setId(biddingSupplierList.get(i).getId());
	                biddingSupplier.setSupBiddingStatus(TenderStatusEumn.INBID.getValue());
	                this.biddingSupplierService.modifyObj(biddingSupplier);
            	}
            }
            // 初始化评标数据
            if (!"2".equals(queryObjById.getBiddingType())) {
            	BiddingOfferExample offerExample = new BiddingOfferExample();
            	offerExample.createCriteria().andBiddingNoEqualTo(queryObjById.getBiddingNo())
            	.andBiddingRoundsNumberEqualTo(queryObjById.getBiddingCurrentRound());
            	List<BiddingOffer> biddingOfferList = this.biddingOfferService.queryAllObjByExample(offerExample);
            	for (int i = 0; CollectionUtils.isNotEmpty(biddingOfferList) && i < biddingOfferList.size(); i++) {
            		BiddingOffer biddingOffer = new BiddingOffer();
            		biddingOffer.setId(biddingOfferList.get(i).getId());
            		biddingOffer.setIsBidding("0");
            		biddingOffer.setBidShare("0");
            		biddingOffer.setIsSubmitBid("0");//是否提交评标  //驳回则把提交评标状态更新为未提交评标
            		this.biddingOfferService.modifyObj(biddingOffer);
            	}
            }
        } else {
        	biddingHeader.setBiddingAuditstatus("1");
        }
        this.biddingHeaderService.customModifyObj(biddingHeader);
    }
}