package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingFileMapper;
import com.els.base.bidding.entity.BiddingFile;
import com.els.base.bidding.entity.BiddingFileExample;
import com.els.base.bidding.service.BiddingFileService;
import com.els.base.core.entity.PageView;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultBiddingFileService")
public class BiddingFileServiceImpl implements BiddingFileService {
    @Resource
    protected BiddingFileMapper biddingFileMapper;

    @CacheEvict(value = { "biddingFile" }, allEntries = true)
    @Override
    public void addObj(BiddingFile t) {
        this.biddingFileMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingFile" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingFile" }, allEntries = true)
    @Override
    public void modifyObj(BiddingFile t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "biddingFile", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingFile queryObjById(String id) {
        return this.biddingFileMapper.selectByPrimaryKey(id);
    }

//    @Cacheable(value = "biddingFile", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingFile> queryAllObjByExample(BiddingFileExample example) {
        return this.biddingFileMapper.selectByExample(example);
    }

    @Cacheable(value = "biddingFile", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingFile> queryObjByPage(BiddingFileExample example) {
        PageView<BiddingFile> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingFileExample biddingFileExample = new BiddingFileExample();
        biddingFileExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingFile> biddingFileList = this.biddingFileMapper.selectByExample(biddingFileExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingFileList) && i < biddingFileList.size(); i++) {
            this.biddingFileMapper.deleteByPrimaryKey(biddingFileList.get(i).getId());
        }
    }
}