package com.els.base.bidding.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingFileSupplierMapper;
import com.els.base.bidding.entity.BiddingFileSupplier;
import com.els.base.bidding.entity.BiddingFileSupplierExample;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.service.BiddingFileSupplierService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;

@Service("defaultBiddingFileSupplierService")
public class BiddingFileSupplierServiceImpl implements BiddingFileSupplierService {
    @Resource
    protected BiddingFileSupplierMapper biddingFileSupplierMapper;

    @Resource
    protected BiddingSupplierService biddingSupplierService;

    @CacheEvict(value = { "biddingFileSupplier" }, allEntries = true)
    @Override
    public void addObj(BiddingFileSupplier t) {
        this.biddingFileSupplierMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingFileSupplier" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingFileSupplierMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingFileSupplier" }, allEntries = true)
    @Override
    public void modifyObj(BiddingFileSupplier t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingFileSupplierMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "biddingFileSupplier", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingFileSupplier queryObjById(String id) {
        return this.biddingFileSupplierMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "biddingFileSupplier", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingFileSupplier> queryAllObjByExample(BiddingFileSupplierExample example) {
        return this.biddingFileSupplierMapper.selectByExample(example);
    }

    @Cacheable(value = "biddingFileSupplier", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingFileSupplier> queryObjByPage(BiddingFileSupplierExample example) {
        PageView<BiddingFileSupplier> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingFileSupplierMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = { "biddingFileSupplier" }, allEntries = true)
    @Override
    public void saveFileSupplier(BiddingBaseVo biddingBaseVo) {
        // TODO Auto-generated method stub

        // 招投标文件
        List<BiddingFileSupplier> biddingSupplierFiles = biddingBaseVo.getBiddingFileSupplier();

        // 条件
        BiddingFileSupplierExample biddingFileSupplierExample = new BiddingFileSupplierExample();
        BiddingFileSupplierExample.Criteria criteria = biddingFileSupplierExample.createCriteria();
        // criteria.andSupCompanySapCodeEqualTo(biddingBaseVo.getCompany().getCompanySapCode());//
        // 供应商SAP编码
        criteria.andSupCompanyIdEqualTo(biddingBaseVo.getCompany().getId());// 供应商id
        criteria.andBiddingNoEqualTo(biddingBaseVo.getBiddingHeader().getBiddingNo());// 招标单号
        // 查询供应商上传记录
        List<BiddingFileSupplier> biddingFileSupplierList = this.biddingFileSupplierMapper
                .selectByExample(biddingFileSupplierExample);
        // 先删除后上传
        for (int i = 0; CollectionUtils.isNotEmpty(biddingFileSupplierList)
                && i < biddingFileSupplierList.size(); i++) {
            this.biddingFileSupplierMapper.deleteByPrimaryKey(biddingFileSupplierList.get(i).getId());
        }
        // 后上传
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierFiles) && i < biddingSupplierFiles.size(); i++) {
            addBiddingFile(biddingSupplierFiles.get(i), biddingBaseVo.getBiddingHeader(),
                    biddingBaseVo.getCompany(), biddingBaseVo.getUser());
        }

    }

    private void addBiddingFile(BiddingFileSupplier biddingFileSupplier, BiddingHeader biddingHeader,
            Company supCompany, User supUser) {
        if (biddingFileSupplier != null) {
            biddingFileSupplier.setSupCompanyId(supCompany.getId());
            biddingFileSupplier.setSupCompanyName(supCompany.getCompanyName());
            biddingFileSupplier.setSupCompanySapCode(supCompany.getCompanySapCode());
            biddingFileSupplier.setSupCompanySrmCode(supCompany.getCompanyCode());
            biddingFileSupplier.setSupUserId(supUser.getId());
            biddingFileSupplier.setSupUserName(supUser.getUsername());
            biddingFileSupplier.setBiddingHeaderId(biddingHeader.getId());
            biddingFileSupplier.setBiddingNo(biddingHeader.getBiddingNo());
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            supplierExample.createCriteria().andSupCompanyIdEqualTo(supCompany.getId())
                    .andBiddingNoEqualTo(biddingFileSupplier.getBiddingNo());
            List<BiddingSupplier> biddingSuppliers = this.biddingSupplierService
                    .queryAllObjByExample(supplierExample);
            biddingFileSupplier.setSupplierTemporaryCode(biddingSuppliers.get(0).getSupplierTemporaryCode());
            this.addObj(biddingFileSupplier);
        }
    }
}