package com.els.base.bidding.service.impl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingHeaderMapper;
import com.els.base.bidding.entity.BiddingBond;
import com.els.base.bidding.entity.BiddingBondExample;
import com.els.base.bidding.entity.BiddingContactInfo;
import com.els.base.bidding.entity.BiddingContactInfoExample;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentExample;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentMatterExample;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.entity.BiddingFile;
import com.els.base.bidding.entity.BiddingFileExample;
import com.els.base.bidding.entity.BiddingFileSupplier;
import com.els.base.bidding.entity.BiddingFileSupplierExample;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingMatterStep;
import com.els.base.bidding.entity.BiddingMatterStepExample;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingOnline;
import com.els.base.bidding.entity.BiddingOnlineExample;
import com.els.base.bidding.entity.BiddingPlan;
import com.els.base.bidding.entity.BiddingPlanExample;
import com.els.base.bidding.entity.BiddingPower;
import com.els.base.bidding.entity.BiddingPowerExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.BiddingOfferRankingVO;
import com.els.base.bidding.entity.vo.BiddingPriceToSapVO;
import com.els.base.bidding.entity.vo.ManagementPage;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.event.BiddingPriceToSapEvent;
import com.els.base.bidding.service.BiddingBondService;
import com.els.base.bidding.service.BiddingContactInfoService;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingFileService;
import com.els.base.bidding.service.BiddingFileSupplierService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingOnlineService;
import com.els.base.bidding.service.BiddingPlanService;
import com.els.base.bidding.service.BiddingPowerService;
import com.els.base.bidding.service.BiddingQuestionService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IMouldDetailService;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.MouldDetail;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.detail.OrderItemDetail;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.service.MouldService;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.SpringContextHolder;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
@Service("defaultBiddingHeaderService")
public class BiddingHeaderServiceImpl implements BiddingHeaderService, ITaskListener {
    @Resource
    protected BiddingHeaderMapper biddingHeaderMapper;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected BiddingPowerService biddingPowerService;
    @Resource
    protected BiddingPlanService biddingPlanService;
    @Resource
    protected BiddingContactInfoService biddingContactInfoService;
    @Resource
    protected BiddingContentService biddingContentService;
    
    @Resource
    protected BiddingQuestionService biddingQuestionService;
    @Resource
    protected BiddingContentMatterService biddingContentMatterService;
    @Resource
    protected BiddingContentModelService biddingContentModelService;
    @Resource
    protected BiddingContentOtherService biddingContentOtherService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;
    @Resource
    protected BiddingBondService biddingBondService;
    @Resource
    protected BiddingMatterStepService biddingMatterStepService;
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;
    @Resource
    protected BiddingFileService biddingFileService;
    @Resource
    protected BiddingFileSupplierService biddingFileSupplierService;
    @Resource
    protected WorkFlowService workFlowService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected BiddingOfferService biddingOfferService;
    @Resource
    protected TemplateConfService templateConfService;
    
    @Resource
    protected TplMouldDetailService tplMouldDetailService;
    
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    
    @Resource
    protected BiddingOnlineService biddingOnlineService;
    
    @Resource
    protected MouldService mouldService;
    
    @Resource
    protected CompanyUserRefService companyUserRefService;
    
    
    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    public void addObj(BiddingHeader t) {
    	Assert.isNotBlank(t.getInformationCategory(), "信息类别不能为空");
    	Assert.isNotBlank(t.getPurchaseOrganization(), "采购组织不能为空");
    	Assert.isNotBlank(t.getPurchasingGroup(), "采购组不能为空");
        String biddingNo = this.generateCodeService.getNextCode("BIDDING_NO");
        t.setBiddingNo(biddingNo);
        t.setCreateTime(new Date());
        this.biddingHeaderMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingHeaderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    public void modifyObj(BiddingHeader t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingHeaderMapper.updateByPrimaryKeySelective(t);
    }
    
    //自定义的更新方法，主要更新提交日期为空
    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    public void customModifyObj(BiddingHeader t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingHeaderMapper.customUpdateByPrimaryKeySelective(t);
    }
    
    @Cacheable(value = "biddingHeader", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingHeader queryObjById(String id) {
        return this.biddingHeaderMapper.selectByPrimaryKey(id);
    }
    
    @Cacheable(value = "biddingHeader", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingHeader> queryAllObjByExample(BiddingHeaderExample example) {
        return this.biddingHeaderMapper.selectByExample(example);
    }
    
    @Cacheable(value = "biddingHeader", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingHeader> queryObjByPage(BiddingHeaderExample example) {
        PageView<BiddingHeader> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingHeaderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = { "biddingHeader,biddingPower,biddingPlan,biddingContactInfo,biddingBond,biddingContent,biddingContentItem,biddingSupplier,biddingOnline" }, allEntries = true)
    @Override
    public void saveBiddingInfo(BiddingBaseVo biddingBaseVo) {
        Company purCompany = biddingBaseVo.getCompany();
        User purUser = biddingBaseVo.getUser();
        BiddingHeader biddingHeader = biddingBaseVo.getBiddingHeader();
        //新增时标单号为null转为""
        String biddingNo = biddingHeader.getBiddingNo()==null?"":biddingHeader.getBiddingNo();
        
        if (biddingHeader != null) {
//        	if ("1".equals(biddingHeader.getBiddingType()) 
//        			&& CollectionUtils.isNotEmpty(biddingBaseVo.getBiddingSupplierList())) {
//        		throw new CommonException("公开招标全部供应商都能参与投标，所以不需要选择供应商");
//        	}
            biddingHeader.setPurCompanyId(purCompany.getId());
            biddingHeader.setPurCompanyCode(purCompany.getCompanyCode());
            biddingHeader.setPurCompanyName(purCompany.getCompanyName());
           
            biddingHeader.setBiddingStatus("0");
            biddingHeader.setBiddingPreAuditstatus("0");
            biddingHeader.setBiddingAuditstatus("0");
            if (biddingHeader.getId() == null) {
            	//招标负责人，新增后不能修改
            	 biddingHeader.setPurUserId(purUser.getId());
                 biddingHeader.setPurUserName(StringUtils.isNotBlank(purUser.getNickName())==true?purUser.getNickName():purUser.getLoginName());//招标负责人，账号有用户名就存用户名，否则存账号
                // 招投标基本信息保存
                addObj(biddingHeader);
            } else {
            	//招标负责人，新增后不能修改
           	 	biddingHeader.setPurUserId(null);//不更新负责人字段
                biddingHeader.setPurUserName(null);//不更新负责人字段
                // 招投标基本信息修改
                biddingHeader.setLastUpdateTime(new Date());
                biddingHeader.setLastUpdateUser(biddingBaseVo.getUser().getUsername());
                this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
            }
        }
        BiddingPower biddingPower = biddingHeader.getBiddingPower();
        if (biddingPower != null) {
            if (biddingPower.getId() == null) {
                // 招投标-基本信息-采购方招投标人员权限
                addBiddingPower(biddingHeader, purCompany, purUser);
            } else {
                biddingPower.setLastUpdateTime(new Date());
                biddingPower.setLastUpdateUser(biddingBaseVo.getUser().getUsername());
                this.biddingPowerService.modifyObj(biddingPower);
            }
        }
        // 招标计划保存
        List<BiddingPlan> biddingPlanList = biddingBaseVo.getBiddingPlanList();
        this.biddingPlanService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingPlanList) && i < biddingPlanList.size(); i++) {
            addBiddingPlan(biddingPlanList.get(i), biddingHeader, purCompany, purUser,biddingPlanList);
        }
        // 联系信息保存
        List<BiddingContactInfo> biddingContactInfoList = biddingBaseVo.getBiddingContactInfoList();
        this.biddingContactInfoService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContactInfoList)
                && i < biddingContactInfoList.size(); i++) {
            addBiddingContactInfo(biddingContactInfoList.get(i), biddingHeader, purCompany, purUser);
        }
        // 保证金保存
        BiddingBond biddingBond = biddingBaseVo.getBiddingBond();
        if (biddingBond != null) {
            if (biddingBond.getId() == null) {
                addBiddingBond(biddingBaseVo.getBiddingBond(), biddingHeader, purCompany, purUser);
            } else {
                biddingBond.setLastUpdateTime(new Date());
                biddingBond.setLastUpdateUser(biddingBaseVo.getUser().getUsername());
                this.biddingBondService.modifyObj(biddingBond);
            }
        }
        // 招标内容保存
        BiddingContent biddingContent = biddingBaseVo.getBiddingContent();
        if (biddingContent != null) {
            this.biddingContentService.deleteByBiddingNo(biddingNo);
            addBiddingContent(biddingContent, biddingHeader, purCompany, purUser);
        }
        // 招标意向供应商列表保存
        List<BiddingSupplier> biddingSupplierList = biddingBaseVo.getBiddingSupplierList();
        this.biddingSupplierService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); i++) {
            addBiddingSupplier(biddingSupplierList.get(i), biddingHeader, purCompany, purUser);
        }
        // 招投标文件
        List<BiddingFile> biddingFiles = biddingBaseVo.getBiddingFiles();
        this.biddingFileService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingFiles) && i < biddingFiles.size(); i++) {
            addBiddingFile(biddingFiles.get(i), biddingHeader, purCompany, purUser);
        }
    }

    private void addBiddingFile(BiddingFile biddingFile, BiddingHeader biddingHeader, Company purCompany,
            User purUser) {
        if (biddingFile != null) {
            biddingFile.setPurCompanyId(purCompany.getId());
            biddingFile.setPurCompanyName(purCompany.getCompanyName());
            biddingFile.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingFile.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingFile.setPurUserId(purUser.getId());
            biddingFile.setPurUserName(purUser.getUsername());
            biddingFile.setBiddingHeaderId(biddingHeader.getId());
            biddingFile.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingFileService.addObj(biddingFile);
        }
    }

    private void addBiddingBond(BiddingBond biddingBond, BiddingHeader biddingHeader, Company purCompany,
            User purUser) {
        if (biddingBond != null) {
            biddingBond.setPurCompanyId(purCompany.getId());
            biddingBond.setPurCompanyName(purCompany.getCompanyName());
            biddingBond.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingBond.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingBond.setPurUserId(purUser.getId());
            biddingBond.setPurUserName(purUser.getUsername());
            biddingBond.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingBondService.addObj(biddingBond);
        }
    }

    public void addBiddingSupplier(BiddingSupplier biddingSupplier, BiddingHeader biddingHeader,
            Company purCompany, User purUser) {
        if (biddingSupplier != null) {
            biddingSupplier.setPurCompanyId(purCompany.getId());
            biddingSupplier.setPurCompanyName(purCompany.getCompanyName());
            biddingSupplier.setPurCompanyCode(purCompany.getCompanyCode());
            biddingSupplier.setPurUserId(purUser.getId());
            biddingSupplier.setPurUserName(purUser.getUsername());
            biddingSupplier.setBiddingHeaderId(biddingHeader.getId());
            biddingSupplier.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingSupplierService.addObj(biddingSupplier);
        }

    }

    private void addBiddingContent(BiddingContent biddingContent, BiddingHeader biddingHeader,
            Company purCompany, User purUser) {
        if (biddingContent != null) {
        	//招标内容主表
            biddingContent.setPurCompanyId(purCompany.getId());
            biddingContent.setPurCompanyName(purCompany.getCompanyName());
            biddingContent.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingContent.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingContent.setPurUserId(purUser.getId());
            biddingContent.setPurUserName(purUser.getUsername());
            biddingContent.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingContentService.addObj(biddingContent);
            
            //物料明细
            List<BiddingContentMatter> biddingContentMatterList = biddingContent
                    .getBiddingContentMatterList();
            List<BiddingContentModel> biddingContentModelList = biddingContent.getBiddingContentModelList();
            List<BiddingContentOther> biddingContentOtherList = biddingContent.getBiddingContentOtherList();
            for (int j = 0; CollectionUtils.isNotEmpty(biddingContentMatterList)
                    && j < biddingContentMatterList.size(); j++) {
                BiddingContentMatter biddingContentMatter = biddingContentMatterList.get(j);
                Assert.isNotNull(biddingContentMatter.getPriceUnit(), "物料中价格单位不能为空");
                Assert.isNotBlank(biddingContentMatter.getMaterialNo(), "物料中物料编号不能为空");
                Assert.isNotBlank(biddingContentMatter.getCurrency(), "物料中币种不能为空");
                biddingContentMatter.setPurCompanyId(purCompany.getId());
                biddingContentMatter.setPurCompanyName(purCompany.getCompanyName());
                biddingContentMatter.setPurCompanySapCode(purCompany.getCompanySapCode());
                biddingContentMatter.setPurCompanySrmCode(purCompany.getCompanyCode());
                biddingContentMatter.setPurUserId(purUser.getId());
                biddingContentMatter.setPurUserName(purUser.getUsername());
                biddingContentMatter.setBiddingNo(biddingHeader.getBiddingNo());
                biddingContentMatter.setBiddingContentId(biddingContent.getId());
                this.biddingContentMatterService.addObj(biddingContentMatter);
                // 保存物料阶梯报价
                List<BiddingMatterStep> biddingMatterStepList = biddingContentMatter
                        .getBiddingMatterStepList();
                this.biddingMatterStepService.deleteObjByMatterId(biddingContentMatter.getId());
                for (int i = 0; CollectionUtils.isNotEmpty(biddingMatterStepList)
                        && i < biddingMatterStepList.size(); i++) {
                    BiddingMatterStep biddingMatterStep = biddingMatterStepList.get(i);
                    biddingMatterStep.setPurCompanyId(purCompany.getId());
                    biddingMatterStep.setPurCompanyName(purCompany.getCompanyName());
                    biddingMatterStep.setPurCompanySapCode(purCompany.getCompanySapCode());
                    biddingMatterStep.setPurCompanySrmCode(purCompany.getCompanyCode());
                    biddingMatterStep.setPurUserId(purUser.getId());
                    biddingMatterStep.setPurUserName(purUser.getUsername());
                    biddingMatterStep.setBiddingNo(biddingHeader.getBiddingNo());
                    biddingMatterStep.setBiddingHeaderId(biddingHeader.getId());
                    biddingMatterStep.setMatterId(biddingContentMatter.getId());
                    this.biddingMatterStepService.addObj(biddingMatterStep);
                }
            }
            //模具明细
            for (int j = 0; CollectionUtils.isNotEmpty(biddingContentModelList)
                    && j < biddingContentModelList.size(); j++) {
                BiddingContentModel biddingContentModel = biddingContentModelList.get(j);
                Assert.isNotNull(biddingContentModel.getPriceUnit(), "模具中价格单位不能为空");
                Assert.isNotBlank(biddingContentModel.getMaterialNo(), "模具中模具物料编码不能为空");
                Assert.isNotBlank(biddingContentModel.getCurrency(), "模具中币种不能为空");
//                Assert.isNotBlank(biddingContentModel.getModelId(), "模具ID不能为空");
//                // 模具中的物料编号是根据模具ID在模具主数据中查询
//                Mould mould = this.mouldService.queryObjById(biddingContentModel.getModelId());
                biddingContentModel.setPurCompanyId(purCompany.getId());
                biddingContentModel.setPurCompanyName(purCompany.getCompanyName());
                biddingContentModel.setPurCompanySapCode(purCompany.getCompanySapCode());
                biddingContentModel.setPurCompanySrmCode(purCompany.getCompanyCode());
                biddingContentModel.setPurUserId(purUser.getId());
                biddingContentModel.setPurUserName(purUser.getUsername());
                biddingContentModel.setBiddingNo(biddingHeader.getBiddingNo());
                biddingContentModel.setBiddingContentId(biddingContent.getId());
                this.biddingContentModelService.addObj(biddingContentModel);
            }
            //其他明细
            for (int j = 0; CollectionUtils.isNotEmpty(biddingContentOtherList)
                    && j < biddingContentOtherList.size(); j++) {
                BiddingContentOther biddingContentOther = biddingContentOtherList.get(j);
                Assert.isNotNull(biddingContentOther.getPriceUnit(), "其它中价格单位不能为空");
                Assert.isNotBlank(biddingContentOther.getMaterialNo(), "其它中物料编号不能为空");
                Assert.isNotBlank(biddingContentOther.getCurrency(), "其它中币种不能为空");
                biddingContentOther.setPurCompanyId(purCompany.getId());
                biddingContentOther.setPurCompanyName(purCompany.getCompanyName());
                biddingContentOther.setPurCompanySapCode(purCompany.getCompanySapCode());
                biddingContentOther.setPurCompanySrmCode(purCompany.getCompanyCode());
                biddingContentOther.setPurUserId(purUser.getId());
                biddingContentOther.setPurUserName(purUser.getUsername());
                biddingContentOther.setBiddingNo(biddingHeader.getBiddingNo());
                biddingContentOther.setBiddingContentId(biddingContent.getId());
                this.biddingContentOtherService.addObj(biddingContentOther);
            }
        }
    }

    private void addBiddingContactInfo(BiddingContactInfo biddingContactInfo, BiddingHeader biddingHeader,
            Company purCompany, User purUser) {
        if (biddingContactInfo != null) {
            biddingContactInfo.setPurCompanyId(purCompany.getId());
            biddingContactInfo.setPurCompanyName(purCompany.getCompanyName());
            biddingContactInfo.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingContactInfo.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingContactInfo.setPurUserId(purUser.getId());
            biddingContactInfo.setPurUserName(purUser.getUsername());
            biddingContactInfo.setBiddingNo(biddingHeader.getBiddingNo());
            // if (StringUtils.isNotBlank(biddingContactInfo.getAddress())
            // || StringUtils.isNotBlank(biddingContactInfo.getEmail())
            // || StringUtils.isNotBlank(biddingContactInfo.getFax())
            // || StringUtils.isNotBlank(biddingContactInfo.getOrgName())
            // || StringUtils.isNotBlank(biddingContactInfo.getPrincipal())
            // || StringUtils.isNotBlank(biddingContactInfo.getTelephone())) {
            // }
            this.biddingContactInfoService.addObj(biddingContactInfo);
        }
    }

	private void addBiddingPlan(BiddingPlan biddingPlan, BiddingHeader biddingHeader, Company purCompany,
			User purUser,List<BiddingPlan> biddingPlanList) {
		biddingPlan.setPurCompanyId(purCompany.getId());
		biddingPlan.setPurCompanyName(purCompany.getCompanyName());
		biddingPlan.setPurCompanySapCode(purCompany.getCompanySapCode());
		biddingPlan.setPurCompanySrmCode(purCompany.getCompanyCode());
		biddingPlan.setPurUserId(purUser.getId());
		biddingPlan.setPurUserName(purUser.getUsername());
		biddingPlan.setBiddingId(biddingHeader.getId());
		biddingPlan.setBiddingNo(biddingHeader.getBiddingNo());
		// 更新基本信息表
		BiddingHeader header = new BiddingHeader();
		if (!"2".equals(biddingHeader.getBiddingType())) {
			biddingPlan.setBiddingRoundsNumber("1");
			biddingPlan.setBiddingTotalRound("1");
		}
		header.setBiddingTotalRound(biddingPlan.getBiddingTotalRound());
		header.setId(biddingHeader.getId());
		header.setBiddingCurrentRound("1");
		header.setBiddingBegindate(biddingPlanList.get(0).getBiddingBeginDate());
		header.setBiddingEnddate(biddingPlanList.get(biddingPlanList.size()-1).getBiddingEndDate());
		header.setBiddingDeadline(biddingPlan.getBiddingDeadline());
		header.setBiddingOpenDate(biddingPlan.getBiddingOpenDate());
		this.biddingHeaderMapper.updateByPrimaryKeySelective(header);

		this.biddingPlanService.addObj(biddingPlan);

	}

    private void addBiddingPower(BiddingHeader biddingHeader, Company purCompany, User purUser) {
        BiddingPower biddingPower = biddingHeader.getBiddingPower();
        biddingPower.setPurCompanyId(purCompany.getId());
        biddingPower.setPurCompanyCode(purCompany.getCompanyCode());
        biddingPower.setPurUserId(purUser.getId());
        biddingPower.setPurUserName(purUser.getUsername());
        biddingPower.setBiddingHeaderId(biddingHeader.getId());
        biddingPower.setBiddingNo(biddingHeader.getBiddingNo());
        this.biddingPowerService.addObj(biddingPower);
    }
    
    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    public List<ManagementPage> transform(List<BiddingHeader> queryResult, User user,
            List<String> roleCodeList) {
        List<ManagementPage> managementPages = new ArrayList<ManagementPage>();
        for (int i = 0; CollectionUtils.isNotEmpty(queryResult) && i < queryResult.size(); i++) {
            ManagementPage managementPage = new ManagementPage();
            // 在线竞价的招标轮次根据投标时间动态生成
            this.productCurrentRound(managementPage,queryResult.get(i));
            managementPage.setBiddingNo(queryResult.get(i).getBiddingNo());
            managementPage.setBiddingAuditstatus(queryResult.get(i).getBiddingAuditstatus());
            managementPage.setBiddingPreAuditstatus(queryResult.get(i).getBiddingPreAuditstatus());// 发送前审批状态,0-尚未审批，1-正在审批，2-审批通过，3-已驳回
            managementPage.setBiddingName(queryResult.get(i).getBiddingName());// 招标名称
            managementPage.setBiddingType(queryResult.get(i).getBiddingType());// 招标类型： 0：邀请招标，1：公开招标，2：在线竞价
            managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());// 招标状态
            managementPage.setBiddingTotalRound(queryResult.get(i).getBiddingTotalRound());// 招标总轮数
            managementPage.setPurUserName(queryResult.get(i).getPurUserName());// 采购负责人
            managementPage.setPublishDate(queryResult.get(i).getPublishDate());// 发布日期
            managementPage.setBiddingDeadline(queryResult.get(i).getBiddingDeadline());// 应标截止日期
            managementPage.setBiddingBegindate(queryResult.get(i).getBiddingBegindate());// 投标开始日期
            managementPage.setBiddingEnddate(queryResult.get(i).getBiddingEnddate());// 投标截止日期
            managementPage.setBiddingOpenDate(queryResult.get(i).getBiddingOpenDate());// 开标日期
            
            //设置采购方的问题数据
            int count = this.biddingQuestionService.countPurQuestionInfo(queryResult.get(i).getBiddingNo());
            managementPage.setQuestionCount(count);
            
            // 标单是否当前登录用户创建0:否 1:是
            if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager")
                    && !roleCodeList.contains("supplier")
                    && !queryResult.get(i).getPurUserId().equals(user.getId())) {
                managementPage.setCurrentUserCreate("0");
            } else {
                managementPage.setCurrentUserCreate("1");
            }

            // 招标信息是否填写完
            BiddingContactInfoExample ContactInfoExample = new BiddingContactInfoExample();
            ContactInfoExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List<BiddingContactInfo> biddingContactInfoList = this.biddingContactInfoService
                    .queryAllObjByExample(ContactInfoExample);
            if (biddingContactInfoList.size() == 0) {
                managementPage.setInfoIsAllInsert("0");
            }

            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria createCriteria = supplierExample.createCriteria();
            // 参与数
            createCriteria.andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List<BiddingSupplier> biddingSupplierPartNo = this.biddingSupplierService
                    .queryAllObjByExample(supplierExample);
            //if (CollectionUtils.isNotEmpty(biddingSupplierPartNo)) {
                managementPage.setPartNo(String.valueOf(biddingSupplierPartNo.size()));
            //}
            // 应标数
            createCriteria.andSupParticipateEqualTo("1");
            List<BiddingSupplier> biddingSupplierBidNo = this.biddingSupplierService
                    .queryAllObjByExample(supplierExample);
            //if (CollectionUtils.isNotEmpty(biddingSupplierBidNo)) {
                managementPage.setBidNo(String.valueOf(biddingSupplierBidNo.size()));
            //}
            // 投标数
            /*createCriteria.andSupBiddingEqualTo("1");
            List<BiddingSupplier> biddingSupplierBiddingNumber = this.biddingSupplierService
                    .queryAllObjByExample(supplierExample);
            if (CollectionUtils.isNotEmpty(biddingSupplierBiddingNumber)) {
                managementPage.setBiddingNumber(String.valueOf(biddingSupplierBiddingNumber.size()));
            }*/
            // 在供应商表，根据标单号一个条件，查询供应商的总数是否等于投标的总数，等于则全部投标，否则部分应投标
            BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria criteria = biddingSupplierExample.createCriteria();
            criteria.andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());// 标单号
            //List<BiddingSupplier> totalSumList = this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
            //int totalSum = totalSumList.size();// 供应商总数
            // 根据标单号、投标状态两个条件，查询投标的供应商总数
            criteria.andSupBiddingEqualTo("1");// 供应商应投标状态
            List<BiddingSupplier> sumList = this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
            int sum = sumList.size();// 该标单已投标的供应商总数
            //if (sum >= totalSum) {// 应标
            //如果投标总数=应标总数
            if (sum >= biddingSupplierBidNo.size() && sum>0) {// 应标
                // 已投标供应商总数>=供应商总数，则为全部投标，否则为没有全部投标。
            	managementPage.setIsAllBid("1");//是
            }else{
            	managementPage.setIsAllBid("0");//否
            }
            
            // 招标状态控制 TODO
            List<String> supBiddingStatusList = new ArrayList<String>();
            for (int j = 0; CollectionUtils.isNotEmpty(biddingSupplierPartNo)
                    && j < biddingSupplierPartNo.size(); j++) {
                if (biddingSupplierPartNo.get(j).getSupBiddingStatus() != null) {
                    supBiddingStatusList.add(biddingSupplierPartNo.get(j).getSupBiddingStatus());
                }
            }
            //当前日期与应标截止时间比较
            Date biddingDeadlineDate= queryResult.get(i).getBiddingDeadline();
            if (biddingDeadlineDate == null) {
                Calendar c = Calendar.getInstance();
                c.add(Calendar.DAY_OF_MONTH, 1);
                biddingDeadlineDate = c.getTime();
            }
            int timeCompareBiddingDeadline = compareTwoTimes(new Date(), biddingDeadlineDate);//应标截止时间
            
            
            if (queryResult.get(i).getBiddingStatus() != null
                    && !queryResult.get(i).getBiddingStatus().equals(TenderStatusEumn.ISCANCEL.getValue())
                    && !queryResult.get(i).getBiddingStatus().equals(TenderStatusEumn.NOTPUBLISH.getValue())
                    && CollectionUtils.isNotEmpty(supBiddingStatusList)) {
                // 如果供应商状态都为拒绝应标
                if (Collections.frequency(supBiddingStatusList, TenderStatusEumn.REFUSEBID.getValue()) == supBiddingStatusList
                        .size()) {
                    managementPage.setBiddingStatus(TenderStatusEumn.ALLREFUSEBID.getValue());
                } else {
                	//当前日期与投标开始日期比较
                    int timeCompareBiddingBegindate = compareTwoTimes(new Date(), queryResult.get(i).getBiddingBegindate());
                    
                    // 1,假如当前时间大于或者等于应标截止日期，小于投标开始日期，则招标状态控制范围控制如下
                    if (timeCompareBiddingDeadline == 1 || timeCompareBiddingDeadline == 0) {
                        if (timeCompareBiddingBegindate == -1) {
                            if (Collections.frequency(supBiddingStatusList,
                                    TenderStatusEumn.WAITBID.getValue()) == supBiddingStatusList.size()) {
                                managementPage.setBiddingStatus(TenderStatusEumn.ALLREFUSEBID.getValue());
                            } else if (Collections.frequency(supBiddingStatusList,
                                    TenderStatusEumn.ISBID.getValue()) == supBiddingStatusList.size()) {
                                managementPage.setBiddingStatus(TenderStatusEumn.ALLBID.getValue());
                            } else {
                                managementPage.setBiddingStatus(TenderStatusEumn.PARTBID.getValue());
                            }
                        }
                    }
                    // 2,如果当前时间大于或等于投标开始时间，小于投标结束时间，则招标状态控制范围控制如下
                    int timeCompareBiddingEnddate = compareTwoTimes(new Date(), queryResult.get(i)
                            .getBiddingEnddate());
                    if (timeCompareBiddingBegindate == 1 || timeCompareBiddingBegindate == 0) {
                        if (timeCompareBiddingEnddate == -1) {
                            if (Collections.frequency(supBiddingStatusList,
                                    TenderStatusEumn.WAITBID.getValue()) == supBiddingStatusList.size()) {
                                managementPage.setBiddingStatus(TenderStatusEumn.ALLREFUSEBID.getValue());
                            } else {
                            	if(TenderStatusEumn.BIDOVER.getValue().equals(queryResult.get(i).getBiddingStatus())
                            	|| TenderStatusEumn.ISSCALING.getValue().equals(queryResult.get(i).getBiddingStatus())
                                || TenderStatusEumn.ISFINISH.getValue().equals(queryResult.get(i).getBiddingStatus())
                                || TenderStatusEumn.INBID.getValue().equals(queryResult.get(i).getBiddingStatus())){
                            		managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
                            	}else{
                            		managementPage.setBiddingStatus(TenderStatusEumn.BIDDING.getValue());//BIDDING("2", "投标中"),
                            	}
                            }
                        }
                    }
                    // 3,如果当前时间大于或等于投标结束时间，小于开标时间，则招标状态控制范围控制如下
                    int timeCompareBiddingOpenDate = compareTwoTimes(new Date(), queryResult.get(i)
                            .getBiddingOpenDate());
                    if (timeCompareBiddingEnddate == 1 || timeCompareBiddingEnddate == 0) {
                        if (timeCompareBiddingOpenDate == -1) {
                            if (Collections.frequency(supBiddingStatusList,
                                    TenderStatusEumn.WAITBID.getValue()) == supBiddingStatusList.size()) {
                                managementPage.setBiddingStatus(TenderStatusEumn.ALLREFUSEBID.getValue());
                            } else {
                            	//已评标、已定标、已结案、评标中 由于是存在数据库的，所以保持他们原有的状态不变
                            	if(TenderStatusEumn.BIDOVER.getValue().equals(queryResult.get(i).getBiddingStatus())
                            	|| TenderStatusEumn.ISSCALING.getValue().equals(queryResult.get(i).getBiddingStatus())
                                || TenderStatusEumn.ISFINISH.getValue().equals(queryResult.get(i).getBiddingStatus())
                                || TenderStatusEumn.INBID.getValue().equals(queryResult.get(i).getBiddingStatus())){
                            		managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
                            	}else{
                            		managementPage.setBiddingStatus(TenderStatusEumn.BIDDINGEND.getValue());//BIDDINGEND("3", "投标结束"),
                            	}
                                
                            }
                        }
                    }
                    // 4,如果当前时间大于或等于开标时间，小于评标提交时间，则招标状态控制范围控制如下
                    Date bidSubmitDate = queryResult.get(i).getBidSubmitDate();
                    if (bidSubmitDate == null) {
                        Calendar c = Calendar.getInstance();
                        c.add(Calendar.DAY_OF_MONTH, 1);
                        bidSubmitDate = c.getTime();
                    }
                    int timeCompareBidSubmitDate = compareTwoTimes(new Date(), bidSubmitDate);
                    if (timeCompareBiddingOpenDate == 1 || timeCompareBiddingOpenDate == 0) {
                        if (timeCompareBidSubmitDate == -1) {
                            if (Collections.frequency(supBiddingStatusList,
                                    TenderStatusEumn.WAITBID.getValue()) == supBiddingStatusList.size()) {
                                managementPage.setBiddingStatus(TenderStatusEumn.ALLREFUSEBID.getValue());
                            } else {
                            	//已评标、已定标、已结案 由于是存在数据库的，所以保持他们原有的状态不变
                            	if(TenderStatusEumn.BIDOVER.getValue().equals(queryResult.get(i).getBiddingStatus())
                            	|| TenderStatusEumn.ISSCALING.getValue().equals(queryResult.get(i).getBiddingStatus())
                                || TenderStatusEumn.ISFINISH.getValue().equals(queryResult.get(i).getBiddingStatus())
                                || TenderStatusEumn.INBID.getValue().equals(queryResult.get(i).getBiddingStatus())){
                            		managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
                            	}else{
                            		managementPage.setBiddingStatus(TenderStatusEumn.INBID.getValue());
                            	}
                            	
                            }
                        }
                    }
                }
            }else{
            	//如果是招标状态是未发布状态，并且发送前审批状态为审批中，并且当前日期超过了应标截止时间，则直接将招标单设为“过期终止”状态
            	// 发送前审批状态 ： 0-尚未审批，1-正在审批，2-审批通过，3-已驳回
            	if (TenderStatusEumn.NOTPUBLISH.getValue().equals(queryResult.get(i).getBiddingStatus()) 
            			&& ("1".equals(queryResult.get(i).getBiddingPreAuditstatus())
            			 || "2".equals(queryResult.get(i).getBiddingPreAuditstatus())
            			 || "3".equals(queryResult.get(i).getBiddingPreAuditstatus()))
            			&& timeCompareBiddingDeadline == 1) {
            		managementPage.setBiddingStatus(TenderStatusEumn.OVERTIME.getValue());
            	}
            }
            	
            managementPages.add(managementPage);
        }
        return managementPages;
    }
    
    // 在线竞价招标轮次根据投标时间动态生成
    private void productCurrentRound(ManagementPage managementPage, BiddingHeader biddingHeader) {
    	if ("2".equals(biddingHeader.getBiddingType()) 
    			&& "2".equals(biddingHeader.getBiddingPreAuditstatus())
    			&& !TenderStatusEumn.ISCANCEL.getValue().equals(biddingHeader.getBiddingStatus())
    			&& StringUtils.isNotBlank(biddingHeader.getBiddingTotalRound())
        		&& Integer.valueOf(biddingHeader.getBiddingTotalRound()) > 1) {
        	// 在线竞价的招标轮次根据投标时间动态生成
        	BiddingPlanExample planExample = new BiddingPlanExample();
        	planExample.setOrderByClause("BIDDING_ROUNDS_NUMBER ASC");
        	planExample.createCriteria().andBiddingNoEqualTo(biddingHeader.getBiddingNo());
        	List<BiddingPlan> planList = this.biddingPlanService.queryAllObjByExample(planExample);
        	Long nowTime = System.currentTimeMillis();
        	for (int j = 0; planList.size() > 0 && j < planList.size(); j++) {
        		
        		if (j == 0 && nowTime < planList.get(j+1).getBiddingBeginDate().getTime()) {
        			managementPage.setBiddingCurrentRound(String.valueOf(j+1));// 招标轮次
        			
        		} else if (j == planList.size() - 1 
        				&& nowTime >= planList.get(j).getBiddingBeginDate().getTime()) {
        			managementPage.setBiddingCurrentRound(String.valueOf(j+1));// 招标轮次
        			if (!planList.get(j).getBiddingRoundsNumber().equals(biddingHeader.getBiddingCurrentRound())) {
        				BiddingHeader header = new BiddingHeader();
        				header.setId(biddingHeader.getId());
        				header.setBiddingCurrentRound(String.valueOf(j+1));
        				this.modifyObj(header);
        			}
        			
        		} else if (j > 0 && j < planList.size() - 1 
        				&& nowTime >= planList.get(j).getBiddingBeginDate().getTime() 
        				&& nowTime < planList.get(j+1).getBiddingBeginDate().getTime()) {
        			managementPage.setBiddingCurrentRound(String.valueOf(j+1));// 招标轮次
        		}
        	}
        } else {
        	managementPage.setBiddingCurrentRound(biddingHeader.getBiddingCurrentRound());// 招标轮次
        }
	}

	// 时间比较方法，比较方法为date和biddingDeadline进行比较
    private int compareTwoTimes(Date date, Date biddingDeadline) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = sdf.format(date);
        String format2 = sdf.format(biddingDeadline);
        int compareTo = 0;
        try {
            Date date_01 = sdf.parse(format);
            Date date_02 = sdf.parse(format2);
            compareTo = date_01.compareTo(date_02);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return compareTo;
    }
    
    
    
    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    public List<ManagementPage> transformSup(List<BiddingHeader> queryResult, User user,
            List<String> roleCodeList, Company company) {
        List<ManagementPage> managementPages = new ArrayList<ManagementPage>();
        for (int i = 0; CollectionUtils.isNotEmpty(queryResult) && i < queryResult.size(); i++) {
            ManagementPage managementPage = new ManagementPage();
            // 在线竞价的招标轮次根据投标时间动态生成
            this.productCurrentRound(managementPage,queryResult.get(i));
            managementPage.setBiddingNo(queryResult.get(i).getBiddingNo());
            managementPage.setBiddingAuditstatus(queryResult.get(i).getBiddingAuditstatus());
            managementPage.setBiddingPreAuditstatus(queryResult.get(i).getBiddingPreAuditstatus());
            managementPage.setBiddingName(queryResult.get(i).getBiddingName());
            managementPage.setBiddingType(queryResult.get(i).getBiddingType());
            managementPage.setBiddingCurrentRound(queryResult.get(i).getBiddingCurrentRound());
            managementPage.setBiddingTotalRound(queryResult.get(i).getBiddingTotalRound());
            managementPage.setPurUserName(queryResult.get(i).getPurUserName());
            managementPage.setBiddingBegindate(queryResult.get(i).getBiddingBegindate());
            managementPage.setBiddingEnddate(queryResult.get(i).getBiddingEnddate());
            managementPage.setBiddingDeadline(queryResult.get(i).getBiddingDeadline());// 应标截止日期
            managementPage.setPublishDate(queryResult.get(i).getPublishDate());
            managementPage.setBiddingOpenDate(queryResult.get(i).getBiddingOpenDate());// 开标日期

            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria createCriteria = supplierExample.createCriteria();
            createCriteria.andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());// 标单号条件
            // createCriteria.andSupCompanySapCodeEqualTo(company.getCompanySapCode());// 供应商SAP
            createCriteria.andSupCompanyIdEqualTo(company.getId());// 供应商id
            
            //设置问题数量
            int count = this.biddingQuestionService.countSupplierQuestionInfo(queryResult.get(i).getBiddingNo(), company);
            managementPage.setQuestionCount(count);
            // 查询保证金，获取该单是否需要交保证金
            BiddingBondExample biddingBondExample = new BiddingBondExample();
            biddingBondExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List<BiddingBond> biddingBondList = this.biddingBondService
                    .queryAllObjByExample(biddingBondExample);

            if (CollectionUtils.isNotEmpty(biddingBondList)) {
                managementPage.setCollectMoney(biddingBondList.get(0).getCollectMoney());
            }

            // 招标状态，此处不能获取采购方的招标状态，因为供应商需要各自显示自己的状态
            // 由于生成的方法没有获取一条记录的方法，所以用list获取(只有一条记录)，然后取得数据
            List<BiddingSupplier> biddingSupplierStatus = this.biddingSupplierService
                    .queryAllObjByExample(supplierExample);
            if (CollectionUtils.isNotEmpty(biddingSupplierStatus)) {

                // 设置是否已缴纳保证金
                managementPage.setIsPayMoney(biddingSupplierStatus.get(0).getIsPayMoney());

                Date curDate = new Date();// 当前日期
                // 当前时间与应标截止日期比较
                int biddingDeadline = compareTwoTimes(curDate, queryResult.get(i).getBiddingDeadline());
                // 当前时间与投标开始日期比较
                int biddingBegindate = compareTwoTimes(curDate, queryResult.get(i).getBiddingBegindate());
                // 当前时间与投标结束日期比较
                int biddingEnddate = compareTwoTimes(curDate, queryResult.get(i).getBiddingEnddate());
                // 当前时间与开标日期比较
                int biddingOpenDate = compareTwoTimes(curDate, queryResult.get(i).getBiddingOpenDate());
                // 4,如果当前时间大于或等于开标时间，小于评标提交时间，则招标状态控制范围控制如下
                Date submitDate = queryResult.get(i).getBidSubmitDate();
                if (submitDate == null) {
                    Calendar c = Calendar.getInstance();
                    c.add(Calendar.DAY_OF_MONTH, 1);
                    submitDate = c.getTime();
                }
                int bidSubmitDate = compareTwoTimes(curDate, submitDate);

                // 判断是否作废，如果已作废，则后面所有状态都为作废
                if (TenderStatusEumn.ISCANCEL.getValue().equals(
                        biddingSupplierStatus.get(0).getSupBiddingStatus())) {// "7", "已作废"
                    managementPage.setBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                } else {

                    // 默认状态取数据库的状态
                    managementPage.setBiddingStatus(biddingSupplierStatus.get(0).getSupBiddingStatus());

                    // 当前时间>=应标截止日期 and 当前时间<投标开始时间
                    if ((biddingDeadline == 1 || biddingDeadline == 0) && biddingBegindate == -1) {
                        // 如果供应商未操作应标和拒绝应标,则供应商招标状态：拒绝应标,判断逻辑：当前状态是待应标状态，则设置为拒绝应标
                        if (TenderStatusEumn.WAITBID.getValue().equals(
                                biddingSupplierStatus.get(0).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());// REFUSEBID("12",
                                                                                                   // "拒绝应标")
                        }

                        // 当前时间>=投标开始时间 and 当前时间<投标结束时间
                    } else if ((biddingBegindate == 1 || biddingBegindate == 0) && biddingEnddate == -1) {// 假如当前时间大于或者等于投标开始日期,小于或者等于投标结束日期
                        // 如果供应商未操作应标和拒绝应标,则供应商的招标状态：拒绝应标,判断逻辑：当前状态是待应标状态，则设置为拒绝应标
                        if (TenderStatusEumn.WAITBID.getValue().equals(
                                biddingSupplierStatus.get(0).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());// REFUSEBID("12",
                                                                                                   // "拒绝应标")
                        } else if (TenderStatusEumn.ISBID.getValue().equals(
                                biddingSupplierStatus.get(0).getSupBiddingStatus())) {
                            // 把已应标改为进行中
                            managementPage.setBiddingStatus(TenderStatusEumn.BIDDING.getValue());// BIDDING("2",
                                                                                                 // "招投标进行中")
                        } else if (TenderStatusEumn.REFUSEBID.getValue().equals(
                                biddingSupplierStatus.get(0).getSupBiddingStatus())) {
                            // 把拒绝应标改为拒绝应标
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());// REFUSEBID("12",
                                                                                                   // "拒绝应标")
                        }

                        // 当前时间>=投标结束时间 and 当前时间<开标时间
                    } else if ((biddingEnddate == 1 || biddingEnddate == 0) && biddingOpenDate == -1) {
                        // 如果供应商未操作应标和拒绝应标,则供应商的招标状态：拒绝应标,判断逻辑：当前状态是待应标状态，则设置为拒绝应标
                        if (TenderStatusEumn.WAITBID.getValue().equals(
                                biddingSupplierStatus.get(0).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());// REFUSEBID("12",
                                                                                                   // "拒绝应标")
                        } else if (TenderStatusEumn.ISBID.getValue().equals(
                                biddingSupplierStatus.get(0).getSupBiddingStatus())) {
                            // 把已应标改为投标已结束
                            managementPage.setBiddingStatus(TenderStatusEumn.BIDDINGEND.getValue());// BIDDINGEND("3",
                                                                                                    // "投标已结束"
                        } else if (TenderStatusEumn.REFUSEBID.getValue().equals(
                                biddingSupplierStatus.get(0).getSupBiddingStatus())) {
                            // 把拒绝应标改为拒绝应标
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());// REFUSEBID("12",
                                                                                                   // "拒绝应标")
                        }

                        // 当前时间>=开标时间 and 当前时间<提交评标时间
                    } else if ((biddingOpenDate == 1 || biddingOpenDate == 0) && bidSubmitDate == -1) {
                        // 如果供应商未操作应标和拒绝应标,则供应商的招标状态：拒绝应标,判断逻辑：当前状态是待应标状态，则设置为拒绝应标
                        if (TenderStatusEumn.WAITBID.getValue().equals(
                                biddingSupplierStatus.get(0).getSupBiddingStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());// REFUSEBID("12",
                                                                                                   // "拒绝应标")
                        } else if (TenderStatusEumn.ISBID.getValue().equals(
                                biddingSupplierStatus.get(0).getSupBiddingStatus())) {
                            // 把已应标改为评标中
                            managementPage.setBiddingStatus(TenderStatusEumn.INBID.getValue());// INBID("4",
                                                                                               // "评标中")
                        } else if (TenderStatusEumn.REFUSEBID.getValue().equals(
                                biddingSupplierStatus.get(0).getSupBiddingStatus())) {
                            // 把拒绝应标改为拒绝应标
                            managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());// REFUSEBID("12",
                                                                                                   // "拒绝应标")
                        }
                    }else{
                    	// 当前时间>=应标截止日期 and 供应商招标状态为未应标(供应商未操作应标也没操作拒绝应标)
                        if ((biddingDeadline == 1 || biddingDeadline == 0) && TenderStatusEumn.WAITBID.getValue().equals(biddingSupplierStatus.get(0).getSupBiddingStatus())) 
                        {
                                managementPage.setBiddingStatus(TenderStatusEumn.REFUSEBID.getValue());// REFUSEBID("12","拒绝应标")
                        }
                    }
                }
            }
            // 参与数
            List<BiddingSupplier> biddingSupplierPartNo = this.biddingSupplierService
                    .queryAllObjByExample(supplierExample);
            if (CollectionUtils.isNotEmpty(biddingSupplierPartNo)) {
                managementPage.setPartNo(String.valueOf(biddingSupplierPartNo.size()));
            }
            // 应标数
            createCriteria.andSupParticipateEqualTo("11");
            List<BiddingSupplier> biddingSupplierBidNo = this.biddingSupplierService
                    .queryAllObjByExample(supplierExample);
            if (CollectionUtils.isNotEmpty(biddingSupplierBidNo)) {
                managementPage.setBidNo(String.valueOf(biddingSupplierBidNo.size()));
            }
            // 投标数
            createCriteria.andSupBiddingEqualTo("2");
            List<BiddingSupplier> biddingSupplierBiddingNumber = this.biddingSupplierService
                    .queryAllObjByExample(supplierExample);
            if (CollectionUtils.isNotEmpty(biddingSupplierBiddingNumber)) {
                managementPage.setBiddingNumber(String.valueOf(biddingSupplierBiddingNumber.size()));
            }
            // 如果主信息没有数据，则后面的页签不显示
            BiddingContactInfoExample biddingContactInfoExample = new BiddingContactInfoExample();
            biddingContactInfoExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List<BiddingContactInfo> biddingContactInfoList = this.biddingContactInfoService
                    .queryAllObjByExample(biddingContactInfoExample);
            // 此处为控制页面tab未填完不显示到主页面
            if (biddingContactInfoList.size() > 0) {
                managementPages.add(managementPage);
            }
        }
        return managementPages;
    }

    private void setBiddingItemInfo(BiddingContent biddingContent, BiddingBaseVo baseVo) {
        // 获取物料信息
        BiddingContentMatterExample matterExample = new BiddingContentMatterExample();
        matterExample.createCriteria().andBiddingContentIdEqualTo(biddingContent.getId());
        matterExample.setOrderByClause(" MATERIAL_DESC DESC ");
        // 此处一个标单号可能对于多个物料
        List<BiddingContentMatter> biddingContentMatterList = this.biddingContentMatterService
                .queryAllObjByExample(matterExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentMatterList)
                && i < biddingContentMatterList.size(); i++) {
            BiddingContentMatter biddingContentMatter = biddingContentMatterList.get(i);
            BiddingMatterStepExample example = new BiddingMatterStepExample();
            example.createCriteria().andMatterIdEqualTo(biddingContentMatter.getId());
            List<BiddingMatterStep> queryAllObjByExample = this.biddingMatterStepService
                    .queryAllObjByExample(example);
            biddingContentMatter.setBiddingMatterStepList(queryAllObjByExample);
        }
        biddingContent.setBiddingContentMatterList(biddingContentMatterList);

        // 获取模具信息
        BiddingContentModelExample modelExample = new BiddingContentModelExample();
        modelExample.createCriteria().andBiddingContentIdEqualTo(biddingContent.getId());
        modelExample.setOrderByClause(" MODEL_DESC DESC ");
        // 此处一个标单号可能对于多个模具
        List<BiddingContentModel> biddingContentModelList = this.biddingContentModelService
                .queryAllObjByExample(modelExample);
        biddingContent.setBiddingContentModelList(biddingContentModelList);

        // 获取其他(如设备)信息
        BiddingContentOtherExample otherExample = new BiddingContentOtherExample();
        otherExample.createCriteria().andBiddingContentIdEqualTo(biddingContent.getId());
        otherExample.setOrderByClause(" TAREGT_DESC DESC ");
        // 此处一个标单号可能对于多个设备
        List<BiddingContentOther> biddingContentOtherList = this.biddingContentOtherService
                .queryAllObjByExample(otherExample);
        biddingContent.setBiddingContentOtherList(biddingContentOtherList);

        if (CollectionUtils.isNotEmpty(baseVo.getRoleList())
                && !baseVo.getRoleList().contains("systemManager")
                && !baseVo.getRoleList().contains("manager") && !baseVo.getRoleList().contains("supplier")
                && !biddingContent.getPurUserId().equals(baseVo.getUser().getId())) {
            BiddingPowerExample biddingPowerExample = new BiddingPowerExample();
            biddingPowerExample.createCriteria().andBiddingNoEqualTo(biddingContent.getBiddingNo());
            List<BiddingPower> biddingPowerList = this.biddingPowerService
                    .queryAllObjByExample(biddingPowerExample);
            if (CollectionUtils.isNotEmpty(biddingPowerList)
                    && biddingPowerList.get(0).getBiddingTendererPower().equals("0")) {
                // 物料
                for (BiddingContentMatter matter : biddingContent.getBiddingContentMatterList()) {
                    matter.setIsHidePrice("1");
                }
                // 模具
                for (BiddingContentModel model : biddingContent.getBiddingContentModelList()) {
                    model.setIsHidePrice("1");
                }
                // 其他
                for (BiddingContentOther other : biddingContent.getBiddingContentOtherList()) {
                    other.setIsHidePrice("1");
                }
            }
        }

    }

    private void setBiddingItemInfoSup(BiddingContent biddingContent, String biddingCurrentRound,
            BiddingBaseVo baseVo) {

        // 获取物料信息=============================================
        BiddingOfferExample matterExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria matterCriteria = matterExample.createCriteria();
        matterCriteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());// 招标单号
        // matterCriteria.andSupCompanySapCodeEqualTo(baseVo.getCompany().getCompanySapCode());//
        // 供应商SAP编码
        matterCriteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());// 供应商id
        matterCriteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);// 当前轮次
        matterCriteria.andRequirementTypeCodeEqualTo("material");// 需求类型编码:material(物料),die(模具),device(设备)

        // 此处一个标单号可能对于多个物料
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferService
                .queryAllObjByExample(matterExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingOfferMatterList)
                && i < biddingOfferMatterList.size(); i++) {
            BiddingOffer biddingOfferMatter = biddingOfferMatterList.get(i);// 获取当前报价记录信息

            // 获取阶梯信息
            BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
            BiddingMatterStepSupExample.Criteria criteria = example.createCriteria();
            criteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());// 招标单号
            //criteria.andMaterialNoEqualTo(biddingOfferMatter.getProjectNo());// 物料编码
            criteria.andMatterIdEqualTo(biddingOfferMatter.getMatterId());//物料ID
            // riteria.andSupCompanySapCodeEqualTo(baseVo.getCompany().getCompanySapCode());//
            // 供应商SAP编码
            criteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());// 供应商id
            criteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);// 当前轮次
            example.setOrderByClause("QUANTITY_START ASC");

            List<BiddingMatterStepSup> queryAllObjByExample = this.biddingMatterStepSupService
                    .queryAllObjByExample(example);
            biddingOfferMatter.setBiddingMatterStepSupList(queryAllObjByExample);
            
            if (StringUtils.isNotBlank(biddingOfferMatter.getCostAnalysisId())){
            	IOrderItemDetailService service = this.tplOrderItemDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId()).getOrderItemDetailService();
            	biddingOfferMatter.setOrderItemDetail(service.queryObjByOrderItemId(biddingOfferMatter.getId()));
            }
        }
        
        
        biddingContent.setBiddingOfferMatterList(biddingOfferMatterList);

        // 设置是否已缴纳保证金是否必须全部投标
        if (CollectionUtils.isNotEmpty(biddingOfferMatterList)) {

            BiddingOffer offerMatter = new BiddingOffer();
            // 查询是否已缴纳保证金
            // 由于biddingOfferMatterList里面的是否全部投标字段的内容是一样的所以获取其中一个即可
            offerMatter.setAllBidding(biddingOfferMatterList.get(0).getAllBidding());// 是否全部投标0：必须全部投标、1：可以部分投标
            offerMatter.setIsPayMoney(baseVo.getIsPayMoney());
            biddingContent.setBiddingOfferMatter(offerMatter);
        }

        // 获取模具信息============================================================
        BiddingOfferExample modelExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria modelCriteria = modelExample.createCriteria();
        modelCriteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());// 招标单号
        // modelCriteria.andSupCompanySapCodeEqualTo(baseVo.getCompany().getCompanySapCode());//
        // 供应商SAP编码
        modelCriteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());// 供应商id
        modelCriteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);// 当前轮次
        modelCriteria.andRequirementTypeCodeEqualTo("die");// 需求类型编码:material(物料),die(模具),device(设备)

        // 此处一个标单号可能对于多个
        List<BiddingOffer> biddingOfferModelList = this.biddingOfferService
                .queryAllObjByExample(modelExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingOfferModelList)
                && i < biddingOfferModelList.size(); i++) {
            BiddingOffer biddingOfferMatter = biddingOfferModelList.get(i);// 获取当前报价记录信息
            if (StringUtils.isNotBlank(biddingOfferMatter.getCostAnalysisId())){
	            IMouldDetailService service = this.tplMouldDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId()).getMouldDetailService();
				biddingOfferMatter.setMouldDetail(service.queryByMouldId(biddingOfferMatter.getId()));
            }
        }
        
        biddingContent.setBiddingOfferModelList(biddingOfferModelList);

        // 设置是否已缴纳保证金是否必须全部投标
        if (CollectionUtils.isNotEmpty(biddingOfferModelList)) {

            BiddingOffer offerModel = new BiddingOffer();
            // 查询是否已缴纳保证金
            // 由于biddingOfferMatterList里面的是否全部投标字段的内容是一样的所以获取其中一个即可
            offerModel.setAllBidding(biddingOfferModelList.get(0).getAllBidding());// 是否全部投标0：必须全部投标、1：可以部分投标
            offerModel.setIsPayMoney(baseVo.getIsPayMoney());
            biddingContent.setBiddingOfferMode(offerModel);
        }

        // 获取其他(如设备)信息=====================================================
        BiddingOfferExample otheExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria otheCriteria = otheExample.createCriteria();
        otheCriteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());// 招标单号
        // otheCriteria.andSupCompanySapCodeEqualTo(baseVo.getCompany().getCompanySapCode());//
        // 供应商SAP编码
        otheCriteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());// 供应商id
        otheCriteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);// 当前轮次
        otheCriteria.andRequirementTypeCodeEqualTo("device");// 需求类型编码:material(物料),die(模具),device(设备)

        // 此处一个标单号可能对于多个
        List<BiddingOffer> biddingOfferOtheList = this.biddingOfferService.queryAllObjByExample(otheExample);
        biddingContent.setBiddingOfferOtherList(biddingOfferOtheList);

        // 设置是否已缴纳保证金是否必须全部投标
        if (CollectionUtils.isNotEmpty(biddingOfferOtheList)) {

            BiddingOffer offerOther = new BiddingOffer();
            // 查询是否已缴纳保证金
            // 由于biddingOfferMatterList里面的是否全部投标字段的内容是一样的所以获取其中一个即可
            offerOther.setAllBidding(biddingOfferOtheList.get(0).getAllBidding());// 是否全部投标0：必须全部投标、1：可以部分投标
            offerOther.setIsPayMoney(baseVo.getIsPayMoney());
            biddingContent.setBiddingOfferOther(offerOther);
        }
    }
    
    @Override
    public BiddingBaseVo queryDocument(String biddingNo, Company company, User user, List<String> roleCodeList) {
        BiddingBaseVo baseVo = new BiddingBaseVo();
        baseVo.setRoleList(roleCodeList);
        // 基本信息
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper
                .selectByExample(biddingHeaderExample);
        // 基本信息一个标单号只能查询到一条记录，此处的for循环没有实际意义，只是为了使用生成好的代码（不自己去写代码查询一条记录的方法）
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); i++) {
            BiddingHeader biddingHeader = biddingHeaderList.get(i);
            baseVo.setBiddingHeader(biddingHeader);
            BiddingPowerExample biddingPowerExample = new BiddingPowerExample();
            biddingPowerExample.createCriteria().andBiddingHeaderIdEqualTo(biddingHeader.getId());
            // 人员权限信息
            List<BiddingPower> biddingPowerList = this.biddingPowerService
                    .queryAllObjByExample(biddingPowerExample);
            biddingHeader.setBiddingPower(CollectionUtils.isEmpty(biddingPowerList) ? null : biddingPowerList
                    .get(0));
        }

        // 招标计划
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        biddingPlanExample.setOrderByClause(" BIDDING_ROUNDS_NUMBER ASC ");//根据招标轮次升序排序
        List<BiddingPlan> biddingPlanList = this.biddingPlanService.queryAllObjByExample(biddingPlanExample);
        baseVo.setBiddingPlanList(CollectionUtils.isEmpty(biddingPlanList) ? null : biddingPlanList);

        // 联系信息
        BiddingContactInfoExample biddingContactInfoExample = new BiddingContactInfoExample();
        biddingContactInfoExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContactInfo> biddingContactInfoList = this.biddingContactInfoService
                .queryAllObjByExample(biddingContactInfoExample);
        baseVo.setBiddingContactInfoList(CollectionUtils.isEmpty(biddingContactInfoList) ? null
                : biddingContactInfoList);

        // 保证金
        BiddingBondExample biddingBondExample = new BiddingBondExample();
        biddingBondExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingBond> biddingBondList = this.biddingBondService.queryAllObjByExample(biddingBondExample);
        baseVo.setBiddingBond(CollectionUtils.isEmpty(biddingBondList) ? null : biddingBondList.get(0));

        // 招标内容
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContent> biddingContentList = this.biddingContentService
                .queryAllObjByExample(biddingContentExample);
        // 招标内容一个标单号只能查询到一条记录，此处的for循环没有实际意义，只是为了使用生成好的代码（不自己去写代码查询一条记录的方法）
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentList) && i < biddingContentList.size(); i++) {
            BiddingContent biddingContent = biddingContentList.get(i);
            baseVo.setBiddingContent(biddingContent);

            // 招标内容明细
            baseVo.setCompany(company);
            baseVo.setUser(user);
            setBiddingItemInfo(biddingContent, baseVo);
        }

        // 招标意向供应商
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService
                .queryAllObjByExample(biddingSupplierExample);
        for (BiddingSupplier biddingSupplier : biddingSupplierList) {

            Date curDate = new Date();// 当前日期
            // 当前时间与应标截止日期比较
            int biddingDeadline = compareTwoTimes(curDate, biddingHeaderList.get(0).getBiddingDeadline());

            // 判断是否作废，如果已作废，则后面所有状态都为作废
            if (TenderStatusEumn.ISCANCEL.getValue().equals(biddingSupplier.getSupBiddingStatus())) {// "7", "已作废"
            	biddingSupplier.setSupParticipate("7");
            } else {

                // 当前时间>=应标截止日期
                if (biddingDeadline == 1 || biddingDeadline == 0) {
                    // 如果供应商未操作应标和拒绝应标,则供应商招标状态：拒绝应标,判断逻辑：当前状态是待应标状态，则设置为拒绝应标
                    if (TenderStatusEumn.WAITBID.getValue().equals(biddingSupplier.getSupBiddingStatus())) {
                    	biddingSupplier.setSupParticipate("2");// REFUSEBID("2", "拒绝应标")
                    }
                }
            }

        }
		
        
        baseVo.setBiddingSupplierList(CollectionUtils.isEmpty(biddingSupplierList) ? null
                : biddingSupplierList);
        
        //把已投标的供应商ID存储起来
        List<String> supplierIdList = new ArrayList<String>();
        for (BiddingSupplier sup : biddingSupplierList) {
			if("1".equals(sup.getSupBidding())){
				supplierIdList.add(sup.getSupCompanyId());
			}
		}

        // 招投标文件
        BiddingFileExample biddingFileExample = new BiddingFileExample();
        biddingFileExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingFile> biddingFileList = this.biddingFileService.queryAllObjByExample(biddingFileExample);
        baseVo.setBiddingFiles(CollectionUtils.isEmpty(biddingFileList) ? null : biddingFileList);

        // 供应商回签文件
        BiddingFileSupplierExample fileSupplierExample = new BiddingFileSupplierExample();
        fileSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingFileSupplier> biddingFileSupplier = this.biddingFileSupplierService
                .queryAllObjByExample(fileSupplierExample);
        
        List<BiddingFileSupplier> fileSupplierList = new ArrayList<BiddingFileSupplier>();
        for (BiddingFileSupplier fileSupplier : biddingFileSupplier) {
			if(supplierIdList.contains(fileSupplier.getSupCompanyId())){
				fileSupplierList.add(fileSupplier);//未报价的供应商上传的附件不展示
			}
		}
        //supplierIdList
        //baseVo.setBiddingFileSupplier(CollectionUtils.isEmpty(biddingFileSupplier) ? null: biddingFileSupplier);
        baseVo.setBiddingFileSupplier(CollectionUtils.isEmpty(fileSupplierList) ? null: fileSupplierList);
        
        // 在线竞价供应商报价信息
        BiddingOnlineExample onlineExample = new BiddingOnlineExample();
        onlineExample.setOrderByClause("UNTAXED_UNIT_PRICE ASC");
        onlineExample.createCriteria().andBiddingNoEqualTo(biddingNo)
        	.andPurCompanyIdEqualTo(company.getId());
        List<BiddingOnline> biddingOnlineList = this.biddingOnlineService.queryAllObjByExample(onlineExample);
        baseVo.setBiddingOnlineList(CollectionUtils.isEmpty(biddingOnlineList) ? null:biddingOnlineList);
        
        // 在线竞价供应商报价排名（有效、中标报价）
        onlineExample.clear();
        onlineExample.setOrderByClause("untaxedUnitPrice ASC,offerTime ASC");
        onlineExample.createCriteria().andBiddingNoEqualTo(biddingNo)
        	.andPurCompanyIdEqualTo(company.getId())
        	.andQuotationStateNotEqualTo("0");
        List<BiddingOnline> list = this.biddingOnlineService.queryAllObj(onlineExample);
        BiddingOfferRankingVO offerRankingVo = new BiddingOfferRankingVO();
        offerRankingVo.setOnlineList(CollectionUtils.isEmpty(list) ? null:list);
        baseVo.setOfferRankingVO(offerRankingVo);
        return baseVo;
    }

    // 供应商方查询
    @Override
    public BiddingBaseVo queryDocumentSup(String biddingNo, String biddingCurrentRound, Company company,
            User user, List<String> roleCodeList) {
        BiddingBaseVo baseVo = new BiddingBaseVo();
        baseVo.setRoleList(roleCodeList);
        // 基本信息
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper
                .selectByExample(biddingHeaderExample);
        // 基本信息一个标单号只能查询到一条记录，此处的for循环没有实际意义，只是为了使用生成好的代码（不自己去写代码查询一条记录的方法）
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); i++) {
            BiddingHeader biddingHeader = biddingHeaderList.get(i);
            baseVo.setBiddingHeader(biddingHeader);
            BiddingPowerExample biddingPowerExample = new BiddingPowerExample();
            biddingPowerExample.createCriteria().andBiddingHeaderIdEqualTo(biddingHeader.getId());
            // 人员权限信息
            List<BiddingPower> biddingPowerList = this.biddingPowerService
                    .queryAllObjByExample(biddingPowerExample);
            biddingHeader.setBiddingPower(CollectionUtils.isEmpty(biddingPowerList) ? null : biddingPowerList
                    .get(0));
        }

        // 招标计划
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        biddingPlanExample.setOrderByClause(" BIDDING_ROUNDS_NUMBER ASC ");//根据招标轮次升序排序
        List<BiddingPlan> biddingPlanList = this.biddingPlanService.queryAllObjByExample(biddingPlanExample);
        baseVo.setBiddingPlanList(CollectionUtils.isEmpty(biddingPlanList) ? null : biddingPlanList);

        // 联系信息
        BiddingContactInfoExample biddingContactInfoExample = new BiddingContactInfoExample();
        biddingContactInfoExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContactInfo> biddingContactInfoList = this.biddingContactInfoService
                .queryAllObjByExample(biddingContactInfoExample);
        baseVo.setBiddingContactInfoList(CollectionUtils.isEmpty(biddingContactInfoList) ? null
                : biddingContactInfoList);

        // 根据标单号供应商SAP编码查询改供应商上传的保证金附件
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria criteria = biddingSupplierExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo);// 标单号
        // criteria.andSupCompanySapCodeEqualTo(company.getCompanySapCode());// 当前登录的供应商编码
        criteria.andSupCompanyIdEqualTo(company.getId());// 供应商id

        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService
                .queryAllObjByExample(biddingSupplierExample);
        // baseVo.setBiddingSupplierList(CollectionUtils.isEmpty(biddingSupplierList) ? null:
        // biddingSupplierList);供应商不能显示招标意向供应商
        // 保证金
        BiddingBondExample biddingBondExample = new BiddingBondExample();
        biddingBondExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingBond> biddingBondList = this.biddingBondService.queryAllObjByExample(biddingBondExample);
        BiddingBond bond = null;
        if (CollectionUtils.isEmpty(biddingBondList)) {
            bond = null;
        } else {
            bond = biddingBondList.get(0);
            // 设置附件地址
            bond.setAttachmentSup(CollectionUtils.isEmpty(biddingSupplierList) ? null : biddingSupplierList
                    .get(0).getBankAttachment());
        }
        baseVo.setBiddingBond(bond);

        // 查看是否已缴纳保证金
        // baseVo.getBiddingContent().getBiddingOfferMatter().setIsPayMoney(CollectionUtils.isEmpty(biddingSupplierList)
        // ? null : biddingSupplierList
        // .get(0).getIsPayMoney());
        baseVo.setIsPayMoney(CollectionUtils.isEmpty(biddingSupplierList) ? null : biddingSupplierList.get(0)
                .getIsPayMoney());

        // 招标内容
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContent> biddingContentList = this.biddingContentService
                .queryAllObjByExample(biddingContentExample);
        // 招标内容一个标单号只能查询到一条记录，此处的for循环没有实际意义，只是为了使用生成好的代码（不自己去写代码查询一条记录的方法）
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentList) && i < biddingContentList.size(); i++) {
            BiddingContent biddingContent = biddingContentList.get(i);
            baseVo.setBiddingContent(biddingContent);

            // 招标内容明细
            baseVo.setCompany(company);
            baseVo.setUser(user);
//            if (CollectionUtils.isNotEmpty(biddingSupplierList)) {
            	if (!"2".equals(biddingHeaderList.get(0).getBiddingType())) {
            		// 邀请招标、公开招标
            		setBiddingItemInfoSup(biddingContent, biddingCurrentRound, baseVo);
            	} else {
            		// 在线竞价,直接查询物料信息
            		BiddingContentMatterExample matterExample = new BiddingContentMatterExample();
            		matterExample.createCriteria().andBiddingNoEqualTo(biddingNo);
            		List<BiddingContentMatter> matterList = this.biddingContentMatterService.queryAllObjByExample(matterExample);
            		biddingContent.setBiddingContentMatterList(matterList);
            	}
//            } else {
//            	/**
//            	 * 公开招标在一开始没有选择供应商，全部供应商都可以应标，供应商应标之后才添加供应商信息
//            	 */
//            	// 物料
//            	BiddingContentMatterExample matterExample = new BiddingContentMatterExample();
//        		matterExample.createCriteria().andBiddingNoEqualTo(biddingNo);
//        		List<BiddingContentMatter> matterList = this.biddingContentMatterService.queryAllObjByExample(matterExample);
//        		biddingContent.setBiddingContentMatterList(matterList);
//        		// 模具
//        		BiddingContentModelExample modelExample = new BiddingContentModelExample();
//        		modelExample.createCriteria().andBiddingNoEqualTo(biddingNo);
//        		List<BiddingContentModel> modelList = this.biddingContentModelService.queryAllObjByExample(modelExample);
//        		biddingContent.setBiddingContentModelList(modelList);
//        		// 其它
//        		BiddingContentOtherExample otherExample = new BiddingContentOtherExample();
//        		otherExample.createCriteria().andBiddingNoEqualTo(biddingNo);
//        		List<BiddingContentOther> otherList = this.biddingContentOtherService.queryAllObjByExample(otherExample);
//        		biddingContent.setBiddingContentOtherList(otherList);
//            }
        }

        /*
         * // 招标意向供应商 BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
         * biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
         * List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService
         * .queryAllObjByExample(biddingSupplierExample);
         * baseVo.setBiddingSupplierList(CollectionUtils.isEmpty(biddingSupplierList) ? null :
         * biddingSupplierList);
         */

        // 采购方招投标文件
        BiddingFileExample biddingFileExample = new BiddingFileExample();
        biddingFileExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingFile> biddingFileList = this.biddingFileService.queryAllObjByExample(biddingFileExample);
        baseVo.setBiddingFiles(CollectionUtils.isEmpty(biddingFileList) ? null : biddingFileList);
        
        // 供应商回签文件
        BiddingFileSupplierExample fileSupplierExample = new BiddingFileSupplierExample();
        fileSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo)
        .andSupCompanyIdEqualTo(company.getId());// 供应商id
        
        List<BiddingFileSupplier> biddingFileSupplier = this.biddingFileSupplierService
                .queryAllObjByExample(fileSupplierExample);
        baseVo.setBiddingFileSupplier(CollectionUtils.isEmpty(biddingFileSupplier) ? null
                : biddingFileSupplier);
        
        // 在线竞价供应商报价信息
        BiddingOnlineExample onlineExample = new BiddingOnlineExample();
        onlineExample.setOrderByClause("OFFER_TIME DESC");
        onlineExample.createCriteria().andBiddingNoEqualTo(biddingNo)
        	.andSupCompanyIdEqualTo(company.getId());
        List<BiddingOnline> onlineList = this.biddingOnlineService.queryAllObjByExample(onlineExample);
        // 如果招标单没有通过定标审核(2为通过审核)，供应商看不到中标状态，中标状态变为有效竞价
        if (CollectionUtils.isNotEmpty(biddingHeaderList)) {
        	if (!"2".equals(biddingHeaderList.get(0).getBiddingAuditstatus())) {
        		onlineList.forEach(online ->{
        			// 1是有效竞价，2是中标
        			if ("2".equals(online.getQuotationState())) {
        				online.setQuotationState("1");
        			}
        		});
        	}
        }
        baseVo.setBiddingOnlineList(CollectionUtils.isEmpty(onlineList) ? null : onlineList);
        
        // 在线竞价供应商报价排名
        onlineExample.clear();
        onlineExample.setOrderByClause("untaxedUnitPrice ASC,offerTime ASC");
        onlineExample.createCriteria().andBiddingNoEqualTo(biddingNo)
        	.andQuotationStateNotEqualTo("0");
        List<BiddingOnline> list = this.biddingOnlineService.queryAllObj(onlineExample);
        BiddingOfferRankingVO offerRankingVO = new BiddingOfferRankingVO();
        if (CollectionUtils.isNotEmpty(list)) {
        	int temp = 0;
        	int index = 1;
        	Set<BigDecimal> set = new HashSet<>();
        	for (int i = 0 ; i < list.size(); i++) {
        		if (set.add(list.get(i).getUntaxedUnitPrice())) {
        			if (company.getCompanyCode().equals(list.get(i).getSupCompanySrmCode())) {
        				offerRankingVO.setRanking(String.valueOf(index));
        				offerRankingVO.setLowestPrice(list.get(i).getUntaxedUnitPrice());
        				break;
        			}
        			temp = index;
        			index++;
        		} else {
        			if (company.getCompanyCode().equals(list.get(i).getSupCompanySrmCode())) {
        				offerRankingVO.setRanking(String.valueOf(temp));
        				offerRankingVO.setLowestPrice(list.get(i).getUntaxedUnitPrice());
        				break;
        			}
        		}
        	}
        } else {
        	offerRankingVO.setOnlineList(null);
        	offerRankingVO.setRanking("");
        	offerRankingVO.setLowestPrice(BigDecimal.ZERO);
        }
        baseVo.setOfferRankingVO(offerRankingVO);
        
       /* // 招投标文件
        BiddingFileExample biddingFileExample = new BiddingFileExample();
        biddingFileExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingFile> biddingFileList = this.biddingFileService.queryAllObjByExample(biddingFileExample);
        for (BiddingFile biddingFile : biddingFileList) {
            // 根据采购方的表单号，附件id查询供应商方的附件
            BiddingFileSupplierExample biddingFileSupplierExample = new BiddingFileSupplierExample();
            BiddingFileSupplierExample.Criteria criteriaFileSup = biddingFileSupplierExample.createCriteria();
            criteriaFileSup.andBiddingNoEqualTo(biddingNo);
            criteriaFileSup.andBiddingFileIdEqualTo(biddingFile.getId());// 采购方附件ID
            // criteriaFileSup.andSupCompanySapCodeEqualTo(company.getCompanySapCode());//
            // 当前登录的供应商编码
            criteriaFileSup.andSupCompanyIdEqualTo(company.getId());// 供应商id

            List<BiddingFileSupplier> biddingFileSupplierList = this.biddingFileSupplierService
                    .queryAllObjByExample(biddingFileSupplierExample);
            biddingFile.setAttachmentSup(CollectionUtils.isEmpty(biddingFileSupplierList) ? null
                    : biddingFileSupplierList.get(0).getAttachmentSup());// 把供应商上传的附件赋值给采购方的附件
        }
        baseVo.setBiddingFiles(CollectionUtils.isEmpty(biddingFileList) ? null : biddingFileList);*/

        return baseVo;
    }
    
    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    @Transactional
    public void toVoidDocument(String biddingNo) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper
                .selectByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); i++) {
        	//更新采购方的招标状态为已作废
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(biddingHeaderList.get(i).getId());
            biddingHeader.setBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
            this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
            
            //更新供应商的招标状态为已作废
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            supplierExample.createCriteria().andBiddingNoEqualTo(biddingHeaderList.get(i).getBiddingNo());
            List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService
                    .queryAllObjByExample(supplierExample);
            for (BiddingSupplier supplier : biddingSupplierList) {
            	BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setId(supplier.getId());
                biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                this.biddingSupplierService.modifyObj(biddingSupplier);
			}
            
            
            // 0-尚未审批，1-正在审批，2-审批通过，3-已驳回
            if("1".equals(biddingHeaderList.get(i).getBiddingPreAuditstatus())){
	            //停止发布前审批流
	            this.workFlowService.stopProcess("ztbfbqsp", biddingHeaderList.get(i).getBiddingNo());
            }
            // 0-尚未审批，1-正在审批，2-审批通过，3-已驳回
            if("1".equals(biddingHeaderList.get(i).getBiddingAuditstatus())){
	            //停止定标审批流
	            this.workFlowService.stopProcess("ztbdbsp", biddingHeaderList.get(i).getBiddingNo());
            }
        }
    }
    
    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    @Transactional
    public void deleteDocumentByBiddingNo(String biddingNo) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper
                .selectByExample(biddingHeaderExample);
        BiddingHeader biddingHeader = biddingHeaderList.get(0);
        String biddingHeaderId = biddingHeader.getId();

        this.biddingPowerService.deleteByBiddingNo(biddingNo);

        this.biddingHeaderMapper.deleteByPrimaryKey(biddingHeaderId);

        this.biddingPlanService.deleteByBiddingNo(biddingNo);

        this.biddingContactInfoService.deleteByBiddingNo(biddingNo);

        this.biddingBondService.deleteByBiddingNo(biddingNo);

        this.biddingContentService.deleteByBiddingNo(biddingNo);

        this.biddingSupplierService.deleteByBiddingNo(biddingNo);

        this.biddingFileService.deleteByBiddingNo(biddingNo);

        this.biddingMatterStepService.deleteByBiddingNo(biddingNo);

        this.biddingMatterStepSupService.deleteByBiddingNo(biddingNo);

        this.biddingOfferService.deleteByBiddingNo(biddingNo);
    }
    
    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    public void sendToApprove(List<String> bidingNoList) {
        // 单据状态改为发送审批
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoIn(bidingNoList);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper
                .selectByExample(biddingHeaderExample);
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingHeaderList.get(0).getBiddingNo());
        List<BiddingContent> biddingContentList = this.biddingContentService
                .queryAllObjByExample(biddingContentExample);
        if (CollectionUtils.isEmpty(biddingContentList)) {
            throw new CommonException("招标单信息未填写完整，不可审批！","not_all_complete","招标单");
        }
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); i++) {
            ProcessStartVO vo = ProcessStartVO.newInstance("ztbfbqsp", biddingHeaderList.get(i)
                    .getBiddingNo(), biddingHeaderList.get(i).getId(), "addBidding?biddingNo="
                    + biddingHeaderList.get(i).getBiddingNo() + "&state=view");
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess != null) {
                BiddingHeader biddingHeader = new BiddingHeader();
                biddingHeader.setId(biddingHeaderList.get(i).getId());
                biddingHeader.setBiddingPreAuditstatus("1");// 0-尚未审批，1-正在审批，2-审批通过，3-已驳回
                this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
            }
        }
    }
    
    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    @Transactional
    public void listen(TaskOperateEvent event) {
        // 招标状态:0:未发布 1:已发布
        Assert.isNotBlank(event.getBusinessId(), "发布前审批单据ID为空");
        BiddingHeader headerPrimarykey = this.biddingHeaderMapper.selectByPrimaryKey(event.getBusinessId());
        
        //当前日期与应标截止时间比较
        Date biddingDeadlineDate= headerPrimarykey.getBiddingDeadline();
        
        if (biddingDeadlineDate == null) {
            Calendar c = Calendar.getInstance();
            c.add(Calendar.DAY_OF_MONTH, 1);//是nowDate+1天,一天后的日期
            biddingDeadlineDate = c.getTime();
        }
        int timeCompareBiddingDeadline = compareTwoTimes(new Date(), biddingDeadlineDate);//应标截止时间
        
        boolean flag = false;//是否能发布
    	// getBiddingPreAuditstatus发送前审批状态 ： 0-尚未审批，1-正在审批，2-审批通过，3-已驳回
        //如果是招标状态是未发布状态，并且发送前审批状态为审批中、审批通过、审批驳回
    	
        if (TenderStatusEumn.ISCANCEL.getValue().equals(headerPrimarykey.getBiddingStatus())){
        	flag = true;
        }else if (TenderStatusEumn.NOTPUBLISH.getValue().equals(headerPrimarykey.getBiddingStatus()) 
    			&& ("1".equals(headerPrimarykey.getBiddingPreAuditstatus())
           		 || "2".equals(headerPrimarykey.getBiddingPreAuditstatus())
           		 || "3".equals(headerPrimarykey.getBiddingPreAuditstatus()))) {
    		//当前日期超过了应标截止时间，则提示将招标单设为“过期终止”状态
    		if(timeCompareBiddingDeadline == 1){
    			flag = true;
	    		System.out.println("该招标单已终止不能审批！");
	    		//throw new CommonException("该招标单已终止不能审批！");
    		}
    		/*else{
		        //在招标单发布前审批时，如果该招标单距离应标截止时间小于等于3天，那么警告提醒：“该招标单距离应标截止时间只有X天，请确认是否继续发布此招标单！”
		        //通过时间秒毫秒数判断两个时间的间隔,是通过计算两个日期相差的毫秒数来计算两个日期的天数差的。一样会有一个小问题，就是当他们相差是23个小时的时候，它就不算一天了
		        int days = (int) ((biddingDeadlineDate.getTime() - currDate.getTime()) / (1000*3600*24));
		        System.out.println("两个日期的差距：" + days);
		        if(days<=3 && days>=0){
		        	//throw new CommonException("该招标单距离应标截止时间只有"+days+"天");
		        	//return;
		        }
    		}*/
	       
        }
        
        BiddingHeader biddingHeader = new BiddingHeader();
        biddingHeader.setId(event.getBusinessId());
        if (event.isFinished() && event.isPass()) {
        	BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        	supplierExample.createCriteria().andBiddingNoEqualTo(headerPrimarykey.getBiddingNo());
        	List<BiddingSupplier> supplierList = this.biddingSupplierService.queryAllObjByExample(supplierExample);
            // 审批流完成而且通过
            biddingHeader.setBiddingPreAuditstatus("2");//0-尚未审批，1-正在审批，2-审批通过，3-已驳回
            //如果是过期终止则只更新发送前审批状态，招投标状态不更新
            if(flag==false){//不是过期终止才更新下面的信息，和发送报价
	            biddingHeader.setBiddingStatus(TenderStatusEumn.WAITBID.getValue());
	            biddingHeader.setPublishDate(new Date());
	            // 数据插入报价表,(如果招标类型是在线竞价，就不执行这里)
	            if (!"2".equals(headerPrimarykey.getBiddingType())) {
	            	try {
	            		insertIntoOffer(event.getBusinessId(), new ArrayList<BiddingSupplier>());
	            	} catch (InstantiationException | IllegalAccessException e) {
	            		// TODO Auto-generated catch block
	            		e.printStackTrace();
	            	}
	            } else {
	            	// 在线竞价，改变供应商招标状态
	            	if (CollectionUtils.isNotEmpty(supplierList)) {
	            		supplierList.forEach(supplier ->{
	            			BiddingSupplier biddingSupplier = new BiddingSupplier();
	            			biddingSupplier.setId(supplier.getId());
	            			biddingSupplier.setSupBiddingStatus(TenderStatusEumn.WAITBID.getValue());
	            			this.biddingSupplierService.modifyObj(biddingSupplier);
	            			// 给供应商发送消息
	            			this.sendInformationToSupplier(headerPrimarykey,supplier);
	            		});
	            	}
	            }
            }
        } else if (event.isFinished() && !event.isPass()) {
            biddingHeader.setBiddingPreAuditstatus("3");//0-尚未审批，1-正在审批，2-审批通过，3-已驳回
          //如果是过期终止则只更新发送前审批状态，招投标状态不更新，报价不发送供应商
            if(flag==false){//不是过期终止才更新下面的信息，和发送报价
            	biddingHeader.setBiddingStatus(TenderStatusEumn.NOTPUBLISH.getValue());
            }
        } else {
            biddingHeader.setBiddingPreAuditstatus("1");
        }
        this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
    }
    
    // 采购商新建标单通过发送前审批后给供应商发送消息
    private void sendInformationToSupplier(BiddingHeader biddingHeader,BiddingSupplier supplier) {
    	 // 给供应商发送消息提醒
		Map<String, Object> msg = new HashMap<String, Object>();
		msg.put("biddingNo", biddingHeader.getBiddingNo());
		List<String> userIdList = this.companyUserRefService.queryUserOfCompany(supplier.getSupCompanyId());
		if (CollectionUtils.isNotEmpty(userIdList) && StringUtils.isNotBlank(userIdList.get(0))) {
			Message<Map<String, Object>> message = Message.init(msg)
					.setCompanyCode(supplier.getPurCompanyCode())// 发送者公司srmcode
					.setSenderId(supplier.getPurUserId())// 发送者 userId
					.setBusinessTypeCode("BIDDING_PUR_SEND_INFORMATION")// 业务类型
					.addReceiverId(userIdList.get(0))// 接受者 userId
					.setMsgLevel(MessageLevelEnum.HIGH);// 消息等级
			MessageSendUtils.sendMessage(message);
		}
	}

	public void insertIntoOffer(String biddingHeaderId, List<BiddingSupplier> biddingSupplierListSave) throws InstantiationException, IllegalAccessException {
        BiddingHeader biddingHeader = this.biddingHeaderMapper.selectByPrimaryKey(biddingHeaderId);
		String biddingNo = biddingHeader.getBiddingNo();
        // 招标内容
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContent> biddingContentList = this.biddingContentService
                .queryAllObjByExample(biddingContentExample);
        String contentId = biddingContentList.get(0).getId();
        Integer effectiveNumber = biddingContentList.get(0).getEffectiveNumber();
        // 招标计划
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        biddingPlanExample.setOrderByClause(" BIDDING_ROUNDS_NUMBER DESC ");
        List<BiddingPlan> biddingPlanList = this.biddingPlanService.queryAllObjByExample(biddingPlanExample);

        // 招标意向供应商
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingSupplier> biddingSupplierList = new ArrayList<BiddingSupplier>();
        if (CollectionUtils.isNotEmpty(biddingSupplierListSave)) {
            biddingSupplierList.addAll(biddingSupplierListSave);
        } else {
            List<BiddingSupplier> queryAllObjByExample = this.biddingSupplierService
                    .queryAllObjByExample(biddingSupplierExample);
            biddingSupplierList.addAll(queryAllObjByExample);
        }

        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); i++) {
            // 保存物料信息
            saveMaterialInfo(biddingHeader, biddingSupplierList.get(i), biddingPlanList, contentId,
                    effectiveNumber);
            // 保存模具信息
            saveModelInfo(biddingHeader, biddingSupplierList.get(i), biddingPlanList, contentId,
                    effectiveNumber);
            // 其他
            saveOtherInfo(biddingHeader, biddingSupplierList.get(i), biddingPlanList, contentId,
                    effectiveNumber);
            // 改变投標方状态
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(biddingSupplierList.get(i).getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.WAITBID.getValue());
            this.biddingSupplierService.modifyObj(biddingSupplier);
            this.sendInformationToSupplier(biddingHeader, biddingSupplierList.get(i));
        }
    }

    private void saveOtherInfo(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier,
            List<BiddingPlan> biddingPlanList, String contentId, Integer effectiveNumber) {
        BiddingContentOtherExample otherExample = new BiddingContentOtherExample();
        otherExample.createCriteria().andBiddingContentIdEqualTo(contentId);
        List<BiddingContentOther> biddingContentOtherList = this.biddingContentOtherService
                .queryAllObjByExample(otherExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingContentOtherList)
                && j < biddingContentOtherList.size(); j++) {
            BiddingContentOther biddingContentOther = biddingContentOtherList.get(j);
            BiddingOffer biddingOffer = new BiddingOffer();
            setBaseBiddingOffer(biddingHeader, biddingSupplier, biddingPlanList, biddingOffer);
            biddingOffer.setRequirementTypeCode("device");
            biddingOffer.setRequirementTypeName("其他");
            // 统一使用ModelNo字段存物料编号，价格写入sap时取值方便
            biddingOffer.setModelNo(biddingContentOther.getMaterialNo());
            biddingOffer.setProjectNo(biddingContentOther.getTargetNo());
            biddingOffer.setProjectName(biddingContentOther.getTargetName());
            biddingOffer.setProjectDesc(biddingContentOther.getTaregtDesc());
            biddingOffer.setUnitPrice(biddingContentOther.getUnitPrice());
            biddingOffer.setUnit(biddingContentOther.getUnit());
            biddingOffer.setPriceUnit(biddingContentOther.getPriceUnit());
            biddingOffer.setCurrency(biddingContentOther.getCurrency());
            biddingOffer.setAllBidding(biddingContentOther.getAllBidding());
            biddingOffer.setEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setRestEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());// 当前轮报价剩余有效次数
            biddingOffer.setPictureAttachment(biddingContentOther.getPictureAttachment());
            biddingOffer.setDesignPicAttachment(biddingContentOther.getDesignPicAttachment());
            biddingOffer.setOtherId(biddingContentOther.getId());//2018-5-11
            this.biddingOfferService.addObj(biddingOffer);
        }
    }

    private void saveModelInfo(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier,
            List<BiddingPlan> biddingPlanList, String contentId, Integer effectiveNumber) {
        BiddingContentModelExample modelExample = new BiddingContentModelExample();
        modelExample.createCriteria().andBiddingContentIdEqualTo(contentId);
        List<BiddingContentModel> biddingContentModelList = this.biddingContentModelService
                .queryAllObjByExample(modelExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingContentModelList)
                && j < biddingContentModelList.size(); j++) {
            BiddingOffer biddingOffer = new BiddingOffer();
            setBaseBiddingOffer(biddingHeader, biddingSupplier, biddingPlanList, biddingOffer);
            BiddingContentModel biddingContentModel = biddingContentModelList.get(j);
            biddingOffer.setRequirementTypeCode("die");
            biddingOffer.setRequirementTypeName("模具");
            // 统一使用ModelNo字段存物料编号，价格写入sap时取值方便
            biddingOffer.setModelNo(biddingContentModel.getMaterialNo());
            biddingOffer.setProjectNo(biddingContentModel.getModelNo());
            biddingOffer.setProjectName(biddingContentModel.getModelName());
            biddingOffer.setProjectDesc(biddingContentModel.getModelDesc());
            biddingOffer.setUseModel(biddingContentModel.getUseModel());
            biddingOffer.setBeloneYear(biddingContentModel.getBeloneYear());
            biddingOffer.setModelSerialNumber(biddingContentModel.getModelSerialNumber());
            biddingOffer.setModelMaterial(biddingContentModel.getModelMaterial());
            biddingOffer.setPropertyRight(biddingContentModel.getPropertyRight());
            biddingOffer.setModelSinking(biddingContentModel.getModelSinking());
            biddingOffer.setModelLife(biddingContentModel.getModelLife());
            biddingOffer.setCurrency(biddingContentModel.getCurrency());
            biddingOffer.setUnitPrice(biddingContentModel.getUnitPrice());
            biddingOffer.setPriceUnit(biddingContentModel.getPriceUnit());
            biddingOffer.setDeliveryDate(biddingContentModel.getDeliveryDate());
            biddingOffer.setAllBidding(biddingContentModel.getAllBidding());
            biddingOffer.setEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setRestEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());// 当前轮报价剩余有效次数
            biddingOffer.setPictureAttachment(biddingContentModel.getPictureAttachment());
            biddingOffer.setDesignPicAttachment(biddingContentModel.getDesignPicAttachment());
            biddingOffer.setModelId(biddingContentModel.getId());//2018-5-11
            biddingOffer.setCostAnalysisId(biddingContentModel.getCostAnalysisId());//模具成本分析清单ID2018-6-11
            this.biddingOfferService.addObj(biddingOffer);
            
            //保存询价单
            if (StringUtils.isNotBlank(biddingContentModel.getCostAnalysisId())){
            	
            	//TplOrderItemDetail tpl = this.tplOrderItemDetailService.queryObjById(biddingContentMatter.getCostAnalysisId());
            	//IOrderItemDetailService service = tpl.getOrderItemDetailService();
            	TplMouldDetail tplMould = this.tplMouldDetailService.queryObjById(biddingContentModel.getCostAnalysisId());
            	IMouldDetailService service = tplMould.getMouldDetailService();
            	MouldDetail mouldDetail = new MouldDetail();
            	mouldDetail.setMouldId(biddingOffer.getId());//报价表的ID
            	mouldDetail.setTemplateId(biddingContentModel.getCostAnalysisId());//报价表的ID
    			mouldDetail.setSupCompanyId(biddingSupplier.getSupCompanyId());
    			mouldDetail.setSupCompanyName(biddingSupplier.getSupCompanyName());
    			mouldDetail.setSupCompanySapCode(biddingSupplier.getSupCompanySapCode());
    			mouldDetail.setSupCompanySrmCode(biddingSupplier.getSupCompanySrmCode());
    			mouldDetail.setPurOrderId(biddingHeader.getBiddingNo());//询价单头ID，不能为空
    			mouldDetail.setSupOrderId(biddingHeader.getBiddingNo());
    			mouldDetail.setCreateTime(new Date());
    			mouldDetail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(mouldDetail));
    	        
            	service.addObj(mouldDetail);
            }
        }
    }

    private void saveMaterialInfo(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier,
            List<BiddingPlan> biddingPlanList, String contentId, Integer effectiveNumber) throws InstantiationException, IllegalAccessException {
        BiddingContentMatterExample matterExample = new BiddingContentMatterExample();
        matterExample.createCriteria().andBiddingContentIdEqualTo(contentId);
        List<BiddingContentMatter> biddingContentMatterList = this.biddingContentMatterService
                .queryAllObjByExample(matterExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingContentMatterList)
                && j < biddingContentMatterList.size(); j++) {
            BiddingContentMatter biddingContentMatter = biddingContentMatterList.get(j);
            BiddingOffer biddingOffer = new BiddingOffer();
            setBaseBiddingOffer(biddingHeader, biddingSupplier, biddingPlanList, biddingOffer);
            biddingOffer.setRequirementTypeCode("material");
            biddingOffer.setRequirementTypeName("物料");
            // 统一使用ModelNo字段存物料编号，价格写入sap时取值方便
            biddingOffer.setModelNo(biddingContentMatter.getMaterialNo());
            biddingOffer.setProjectNo(biddingContentMatter.getMaterialNo());
            biddingOffer.setProjectName(biddingContentMatter.getMaterialName());
            biddingOffer.setProjectDesc(biddingContentMatter.getMaterialDesc());
            biddingOffer.setBiddingQuantity(biddingContentMatter.getBiddingQuantity());
            biddingOffer.setCurrency(biddingContentMatter.getCurrency());
            biddingOffer.setUnitPrice(biddingContentMatter.getUnitPrice());
            biddingOffer.setMaterialFeatures(biddingContentMatter.getMaterialFeatures());
            biddingOffer.setMaterialSpec(biddingContentMatter.getMaterialSpec());
            biddingOffer.setMaterialModel(biddingContentMatter.getMaterialModel());
            biddingOffer.setUnit(biddingContentMatter.getUnit());
            biddingOffer.setAllBidding(biddingContentMatter.getAllBidding());
            biddingOffer.setEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());// 每轮报价有效次数
            biddingOffer.setRestEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());// 当前轮报价剩余有效次数
            biddingOffer.setQuotationMethod(biddingContentMatter.getQuotationMethod());
            biddingOffer.setIsStep(biddingContentMatter.getIsStep());
            biddingOffer.setQuantity(biddingContentMatter.getDosage());
            biddingOffer.setAmount(biddingContentMatter.getSetThePrice());
            biddingOffer.setPictureAttachment(biddingContentMatter.getPictureAttachment());
            biddingOffer.setDesignPicAttachment(biddingContentMatter.getDesignPicAttachment());
            biddingOffer.setPriceUnit(biddingContentMatter.getPriceUnit());
            biddingOffer.setMatterId(biddingContentMatter.getId());//2018-5-11
            biddingOffer.setTempMaterialNo(biddingContentMatter.getTempMaterialNo());//物料临时编码2018-6-1
            biddingOffer.setCostAnalysisId(biddingContentMatter.getCostAnalysisId());//物料成本分析清单ID2018-6-11
            // 上一轮报价单价，套价
            // biddingOffer.setLastOfferPrice();
            // biddingOffer.setLastOfferSetPrice();
            this.biddingOfferService.addObj(biddingOffer);
            if (StringUtils.isNotBlank(biddingContentMatter.getQuotationMethod())
                    && biddingContentMatter.getQuotationMethod().equals("2")) {
                // 保存阶梯报价信息到供应商阶梯报价表
                saveStepSupInfo(biddingContentMatter, biddingHeader, biddingSupplier, biddingPlanList,
                        biddingOffer.getId());
            }
            //保存询价单
            if (StringUtils.isNotBlank(biddingContentMatter.getCostAnalysisId())){
            	//biddingContentMatter.getCostAnalysisId()
            	TplOrderItemDetail tpl = this.tplOrderItemDetailService.queryObjById(biddingContentMatter.getCostAnalysisId());
            	IOrderItemDetailService service = tpl.getOrderItemDetailService();
            	IOrderItemDetail detail = tpl.getOrderItemDetailClass().newInstance(); 
            	detail.setOrderItemId(biddingOffer.getId());//报价表的ID
            	detail.setTemplateId(biddingContentMatter.getCostAnalysisId());
            	detail.setMaterialCode(biddingContentMatter.getMaterialNo());
            	detail.setMaterialDesc(biddingContentMatter.getMaterialDesc());
//            	detail.setCreateTime(new Date());
    			detail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(detail));
            	service.addObj(detail);
            }
        }
    }

    private void saveStepSupInfo(BiddingContentMatter biddingContentMatter, BiddingHeader biddingHeader,
            BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, String biddingOfferId) {
        BiddingMatterStepExample example = new BiddingMatterStepExample();
        example.createCriteria().andMatterIdEqualTo(biddingContentMatter.getId());
        List<BiddingMatterStep> biddingMatterStepList = this.biddingMatterStepService
                .queryAllObjByExample(example);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingMatterStepList) && i < biddingMatterStepList.size(); i++) {
            BiddingMatterStep biddingMatterStep = biddingMatterStepList.get(i);
            BiddingMatterStepSup biddingMatterStepSup = new BiddingMatterStepSup();
            biddingMatterStepSup.setBiddingOfferId(biddingOfferId);
            biddingMatterStepSup.setPurCompanyId(biddingHeader.getPurCompanyId());
            biddingMatterStepSup.setPurCompanySrmCode(biddingHeader.getPurCompanyCode());
            biddingMatterStepSup.setPurCompanyName(biddingHeader.getPurCompanyName());
            biddingMatterStepSup.setPurUserId(biddingHeader.getPurUserId());
            biddingMatterStepSup.setPurUserName(biddingHeader.getPurUserName());
            biddingMatterStepSup.setSupCompanyId(biddingSupplier.getSupCompanyId());
            biddingMatterStepSup.setSupCompanyName(biddingSupplier.getSupCompanyName());
            biddingMatterStepSup.setSupCompanySrmCode(biddingSupplier.getSupCompanySrmCode());
            biddingMatterStepSup.setSupCompanySapCode(biddingSupplier.getSupCompanySapCode());
            biddingMatterStepSup.setSupUserId(biddingSupplier.getSupUserId());
            biddingMatterStepSup.setSupUserName(biddingSupplier.getSupUserName());
            biddingMatterStepSup.setCreateTime(new Date());
            biddingMatterStepSup.setBiddingNo(biddingHeader.getBiddingNo());
            biddingMatterStepSup.setBiddingRoundsNumber(biddingPlanList.get(0).getBiddingRoundsNumber());
            biddingMatterStepSup.setBiddingTotalRound(biddingPlanList.get(0).getBiddingTotalRound());
            biddingMatterStepSup.setMaterialNo(biddingMatterStep.getMaterialNo());
            biddingMatterStepSup.setMaterialName(biddingMatterStep.getMaterialName());
            biddingMatterStepSup.setMaterialDesc(biddingMatterStep.getMaterialDesc());
            biddingMatterStepSup.setBiddingHeaderId(biddingHeader.getId());
            biddingMatterStepSup.setMatterId(biddingContentMatter.getId());
            biddingMatterStepSup.setQuantityStart(biddingMatterStep.getQuantityStart());
            biddingMatterStepSup.setQuantityEnd(biddingMatterStep.getQuantityEnd());
            this.biddingMatterStepSupService.addObj(biddingMatterStepSup);
        }
    }

    private void setBaseBiddingOffer(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier,
            List<BiddingPlan> biddingPlanList, BiddingOffer biddingOffer) {
        biddingOffer.setPurCompanyId(biddingHeader.getPurCompanyId());
        biddingOffer.setPurCompanySrmCode(biddingHeader.getPurCompanyCode());
        biddingOffer.setPurCompanyName(biddingHeader.getPurCompanyName());
        biddingOffer.setPurUserId(biddingHeader.getPurUserId());
        biddingOffer.setPurUserName(biddingHeader.getPurUserName());
        biddingOffer.setSupCompanyId(biddingSupplier.getSupCompanyId());
        biddingOffer.setSupCompanyName(biddingSupplier.getSupCompanyName());
        biddingOffer.setSupCompanySrmCode(biddingSupplier.getSupCompanySrmCode());
        biddingOffer.setSupCompanySapCode(biddingSupplier.getSupCompanySapCode());
        biddingOffer.setSupUserId(biddingSupplier.getSupUserId());
        biddingOffer.setSupUserName(biddingSupplier.getSupUserName());
        biddingOffer.setCreateTime(new Date());
        biddingOffer.setBiddingNo(biddingHeader.getBiddingNo());
        biddingOffer.setBiddingRoundsNumber(biddingPlanList.get(0).getBiddingRoundsNumber());
        biddingOffer.setBiddingTotalRound(biddingPlanList.get(0).getBiddingTotalRound());
        biddingOffer.setMaterialStstus(biddingSupplier.getPartnerRoleCode());
        biddingOffer.setSupplierTemporaryCode(biddingSupplier.getSupplierTemporaryCode());
        Company company = this.companyService.queryObjById(biddingSupplier.getSupCompanyId());
        biddingOffer.setMaterialDevel(company.getGrade());
    }
    
    @Transactional
    @CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    public void finisnBidding(String biddingNo) {
    	// 修改招标基本信息中的招标状态为已结案
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper
                .selectByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); i++) {
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(biddingHeaderList.get(i).getId());
            biddingHeader.setBiddingStatus(TenderStatusEumn.ISFINISH.getValue());
            this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
        }
        // 更新 已定标 的供应商招标状态为 已结案
        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria().andBiddingNoEqualTo(biddingNo)
                .andSupBiddingStatusEqualTo(TenderStatusEumn.ISSCALING.getValue());
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService
                .queryAllObjByExample(supplierExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); i++) {
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(biddingSupplierList.get(i).getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISFINISH.getValue());
            this.biddingSupplierService.modifyObj(biddingSupplier);
        }
        
        // 查询单据的基本信息
        BiddingHeaderExample headerExample = new BiddingHeaderExample();
        headerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> headerList = this.queryAllObjByExample(headerExample);
        // 查询已中标的供应商报价
        List<BiddingOffer> materialList = null;
        List<BiddingOnline> biddingOnlineList = null;
        if (!"2".equals(headerList.get(0).getBiddingType())) {
        	// 邀请招标、公开招标
        	BiddingOfferExample offerExample = new BiddingOfferExample();
        	offerExample.createCriteria().andBiddingNoEqualTo(biddingNo)
        	.andIsBiddingEqualTo("1");
        	materialList = this.biddingOfferService.queryAllObjByExample(offerExample);
        	if (CollectionUtils.isEmpty(materialList)) {
        		return;
        	}
        } else {
        	// 在线竞价
        	BiddingOnlineExample onlineExample = new BiddingOnlineExample();
        	onlineExample.createCriteria().andBiddingNoEqualTo(biddingNo)
        		.andQuotationStateEqualTo("2");
        	biddingOnlineList = this.biddingOnlineService.queryAllObjByExample(onlineExample);
        	if (CollectionUtils.isEmpty(biddingOnlineList)) {
        		return;
        	}
        }
        // TODO 取到此单号的价格，放入到BiddingBaseVo中
        List<BiddingPriceToSapVO> voList = this.setPriceInfo(headerList.get(0),materialList,biddingOnlineList);
        
        // 结案后触发将价格写入SAP系统的方法
        SpringContextHolder.getApplicationContext().publishEvent(new BiddingPriceToSapEvent(voList));
    }

	private List<BiddingPriceToSapVO> setPriceInfo(BiddingHeader biddingHeader, List<BiddingOffer> materialList,
			List<BiddingOnline> biddingOnlineList) {
		List<BiddingPriceToSapVO> voList = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(materialList)) {
			for (BiddingOffer biddingOffer : materialList) {
				BiddingPriceToSapVO vo = new BiddingPriceToSapVO();
				Company company = this.companyService.queryObjById(biddingOffer.getSupCompanyId());
				if (StringUtils.isBlank(company.getProductSupplyCycle())) {
					throw new CommonException("SAP编码为："+ company.getCompanySapCode() +"的供应商，供应商基础资料中欲竞投类产品供货周期为空");
				}
				vo.setMaterialCode(biddingOffer.getModelNo()); // 物料编码(物料编号统一存在ModelNo字段中)
				vo.setInformationCategory(biddingHeader.getInformationCategory()); // 信息类别
				vo.setPurchasingGroup(biddingHeader.getPurchasingGroup()); // 采购组
				vo.setPurchaseOrganization(biddingHeader.getPurchaseOrganization()); // 采购组织
				vo.setSupCompanySapCode(company.getCompanySapCode()); // 供应商sap编码
				vo.setPlannedDeliveryTime(Integer.valueOf(company.getProductSupplyCycle())); // 计划交货时间
				vo.setTaxCode(biddingOffer.getTaxCode()); // 税码
				vo.setCurrency(biddingOffer.getCurrency()); // 币种
				vo.setUntaxedUnitPrice(new BigDecimal(biddingOffer.getOfferUnitPrice())); // 不含税单价
				vo.setPriceUnit(biddingOffer.getPriceUnit()); // 价格单位
				vo.setPriceEffectiveFrom(biddingOffer.getPriceEffectiveFrom()); // 价格有效期从
				vo.setPriceEffectiveTo(biddingOffer.getPriceEffectiveTo()); // 价格有效期到
				vo.setBiddingNo(biddingOffer.getBiddingNo());
				voList.add(vo);
			}
		}
		if (CollectionUtils.isNotEmpty(biddingOnlineList)) {
			for (BiddingOnline biddingOnline : biddingOnlineList) {
				BiddingPriceToSapVO vo = new BiddingPriceToSapVO();
				Company company = this.companyService.queryObjById(biddingOnline.getSupCompanyId());
				if (StringUtils.isBlank(company.getProductSupplyCycle())) {
					throw new CommonException("SAP编码为："+ company.getCompanySapCode() +"的供应商，供应商基础资料中欲竞投类产品供货周期为空");
				}
				vo.setMaterialCode(biddingOnline.getMaterialCode()); // 物料编码
				vo.setInformationCategory(biddingHeader.getInformationCategory()); // 信息类别
				vo.setPurchasingGroup(biddingHeader.getPurchasingGroup()); // 采购组
				vo.setPurchaseOrganization(biddingHeader.getPurchaseOrganization()); // 采购组织
				vo.setSupCompanySapCode(company.getCompanySapCode()); // 供应商sap编码
				vo.setPlannedDeliveryTime(Integer.valueOf(company.getProductSupplyCycle())); // 计划交货时间
				vo.setTaxCode(biddingOnline.getTaxCode()); // 税码
				vo.setCurrency(biddingOnline.getCurrency()); // 币种
				vo.setUntaxedUnitPrice(biddingOnline.getUntaxedUnitPrice()); // 不含税单价
				vo.setPriceUnit(biddingOnline.getPriceUnit()); // 价格单位
				vo.setPriceEffectiveFrom(biddingOnline.getPriceEffectiveFrom()); // 价格有效期从
				vo.setPriceEffectiveTo(biddingOnline.getPriceEffectiveTo()); // 价格有效期到
				vo.setBiddingNo(biddingOnline.getBiddingNo());
				voList.add(vo);
			}
		}
		return voList;
	}

	@CacheEvict(value = { "biddingHeader" }, allEntries = true)
    @Override
    public void editStatus(BiddingHeader biddingHeader, BiddingHeaderExample example) {
        this.biddingHeaderMapper.updateByExampleSelective(biddingHeader, example);
    }

    @Override
    public List<ManagementPage> screenDataByBiddingStatus(List<ManagementPage> list,
            List<String> biddingStatusList) {
        if (CollectionUtils.isNotEmpty(biddingStatusList)) {
            List<ManagementPage> finalList = new ArrayList<ManagementPage>();
            for (int i = 0; CollectionUtils.isNotEmpty(list) && i < list.size(); i++) {
                if (biddingStatusList.contains(list.get(i).getBiddingStatus())) {
                    finalList.add(list.get(i));
                }
            }
            return finalList;
        } else {
            return list;
        }
    }
}