package com.els.base.bidding.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.bidding.dao.BiddingMatterStepMapper;
import com.els.base.bidding.entity.BiddingMatterStep;
import com.els.base.bidding.entity.BiddingMatterStepExample;
import com.els.base.bidding.service.BiddingMatterStepService;
import com.els.base.core.entity.PageView;

@Service("defaultBiddingMatterStepService")
public class BiddingMatterStepServiceImpl implements BiddingMatterStepService {
    @Resource
    protected BiddingMatterStepMapper biddingMatterStepMapper;

    @CacheEvict(value = { "biddingMatterStep" }, allEntries = true)
    @Override
    public void addObj(BiddingMatterStep t) {
        this.biddingMatterStepMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingMatterStep" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingMatterStepMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingMatterStep" }, allEntries = true)
    @Override
    public void modifyObj(BiddingMatterStep t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingMatterStepMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "biddingMatterStep", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingMatterStep queryObjById(String id) {
        return this.biddingMatterStepMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "biddingMatterStep", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingMatterStep> queryAllObjByExample(BiddingMatterStepExample example) {
        return this.biddingMatterStepMapper.selectByExample(example);
    }

    @Cacheable(value = "biddingMatterStep", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingMatterStep> queryObjByPage(BiddingMatterStepExample example) {
        PageView<BiddingMatterStep> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingMatterStepMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteObjByMatterId(String id) {
        BiddingMatterStepExample biddingMatterStepExample = new BiddingMatterStepExample();
        biddingMatterStepExample.createCriteria().andMatterIdEqualTo(id);
        this.biddingMatterStepMapper.deleteByExample(biddingMatterStepExample);
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingMatterStepExample biddingMatterStepExample = new BiddingMatterStepExample();
        biddingMatterStepExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingMatterStep> biddingMatterSteps = this.biddingMatterStepMapper
                .selectByExample(biddingMatterStepExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingMatterSteps) && i < biddingMatterSteps.size(); i++) {
            this.biddingMatterStepMapper.deleteByPrimaryKey(biddingMatterSteps.get(i).getId());
        }
    }
}