package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingMatterStepSupMapper;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.core.entity.PageView;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultBiddingMatterStepSupService")
public class BiddingMatterStepSupServiceImpl implements BiddingMatterStepSupService {
    @Resource
    protected BiddingMatterStepSupMapper biddingMatterStepSupMapper;

    @CacheEvict(value = { "biddingMatterStepSup" }, allEntries = true)
    @Override
    public void addObj(BiddingMatterStepSup t) {
        this.biddingMatterStepSupMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingMatterStepSup" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingMatterStepSupMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingMatterStepSup" }, allEntries = true)
    @Override
    public void modifyObj(BiddingMatterStepSup t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingMatterStepSupMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "biddingMatterStepSup", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingMatterStepSup queryObjById(String id) {
        return this.biddingMatterStepSupMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "biddingMatterStepSup", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingMatterStepSup> queryAllObjByExample(BiddingMatterStepSupExample example) {
        return this.biddingMatterStepSupMapper.selectByExample(example);
    }

    @Cacheable(value = "biddingMatterStepSup", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingMatterStepSup> queryObjByPage(BiddingMatterStepSupExample example) {
        PageView<BiddingMatterStepSup> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingMatterStepSupMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingMatterStepSupExample biddingMatterStepSupExample = new BiddingMatterStepSupExample();
        biddingMatterStepSupExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupMapper
                .selectByExample(biddingMatterStepSupExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingMatterStepSups) && i < biddingMatterStepSups.size(); i++) {
            this.biddingMatterStepSupMapper.deleteByPrimaryKey(biddingMatterStepSups.get(i).getId());
        }

    }

    @Override
    public void deleteBySupCompanyId(String biddingNo, String supCompanyId) {
        BiddingMatterStepSupExample biddingMatterStepSupExample = new BiddingMatterStepSupExample();
        biddingMatterStepSupExample.createCriteria().andBiddingNoEqualTo(biddingNo)
                .andSupCompanyIdEqualTo(supCompanyId);
        this.biddingMatterStepSupMapper.deleteByExample(biddingMatterStepSupExample);

    }
}