package com.els.base.bidding.service.impl;

import static java.util.stream.Collectors.toList;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingOfferMapper;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentMatterExample;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.SaveBidInfoVo;
import com.els.base.bidding.entity.vo.TemporaryCodeReducedRate;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IMouldDetailService;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.entity.MouldDetail;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.detail.OrderItemDetail;
import com.els.base.inquiry.entity.detail.OrderItemDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyValueUtils;

@Service("defaultBiddingOfferService")
public class BiddingOfferServiceImpl implements BiddingOfferService {
    @Resource
    protected BiddingOfferMapper biddingOfferMapper;

    @Resource
    protected BiddingContentMatterService biddingContentMatterService;

    @Resource
    protected BiddingContentModelService biddingContentModelService;

    @Resource
    protected BiddingContentOtherService biddingContentOtherService;

    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;

    @Resource
    protected CompanyService companyService;

    @Resource
    protected BiddingContentService biddingContentService;

    @Resource
    protected BiddingHeaderService biddingHeaderService;

    @Resource
    protected BiddingSupplierService biddingSupplierService;
    
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    
    @Resource
    protected TplMouldDetailService tplMouldDetailService;

    @CacheEvict(value = { "biddingOffer" }, allEntries = true)
    @Override
    public void addObj(BiddingOffer t) {
        this.biddingOfferMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingOffer" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingOfferMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingOffer" }, allEntries = true)
    @Override
    public void modifyObj(BiddingOffer t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingOfferMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "biddingOffer", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingOffer queryObjById(String id) {
        return this.biddingOfferMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "biddingOffer", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingOffer> queryAllObjByExample(BiddingOfferExample example) {
        return this.biddingOfferMapper.selectByExample(example);
    }

    @Cacheable(value = "biddingOffer", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingOffer> queryObjByPage(BiddingOfferExample example) {
        PageView<BiddingOffer> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingOfferMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = { "biddingOffer" }, allEntries = true)
    @Override
    @Transactional
    public void saveUnitPrice(BiddingBaseVo biddingBaseVo) throws InstantiationException, IllegalAccessException {
        Company supCompany = biddingBaseVo.getCompany();
        User supUser = biddingBaseVo.getUser();
        // BiddingHeader biddingHeader = biddingBaseVo.getBiddingHeader();
        // String biddingNo = biddingHeader.getBiddingNo();

        String handleType= biddingBaseVo.getHandleType();//操作类型
        // 招标内容保存
        BiddingContent biddingContent = biddingBaseVo.getBiddingContent();
        if (biddingContent != null) {
        	//更新报价
            updateBiddingOfferPrice(biddingContent, supCompany, supUser,handleType);
            
            // 发送报价则更新当前供应商的投标状态
            if ("send".equals(handleType)){
	           //更新供应商招投标状态
	           // 更新的字段
	           BiddingSupplier biddingSupplier = new BiddingSupplier();
	           biddingSupplier.setLastUpdateTime(new Date());// 最后更新时间
	           biddingSupplier.setLastUpdateUser(supUser.getNickName());// 供应商的最后更新人
	           biddingSupplier.setSupBidding("1");// 投标状态：0：未投标，1：已投标
	           
	           BiddingSupplierExample example = new BiddingSupplierExample();
	           BiddingSupplierExample.Criteria biddingCriteria = example.createCriteria();
	           biddingCriteria.andBiddingNoEqualTo(biddingBaseVo.getBiddingHeader().getBiddingNo());// 招标单号
	           //biddingCriteria.andSupCompanySrmCodeEqualTo(company.getCompanyCode());// srm编码
	           //biddingCriteria.andSupCompanySapCodeEqualTo(company.getCompanySapCode());// sap编码
	           biddingCriteria.andSupCompanyIdEqualTo(supCompany.getId());// 供应商id
	
	           this.biddingSupplierService.modifyObjSup(biddingSupplier, example);
	           //updateByExampleSelective(biddingSupplier, example);
            }
        }

    }

    // 校验是否能报价,返回true表示可以报价
    private boolean isUpdateOfferPrice(BiddingOffer biddingOffer) {
        biddingOffer.getEffectiveNumber();// 总共报价次数
        biddingOffer.getRestEffectiveNumber();// 剩余报价次数

        if (Integer.valueOf(biddingOffer.getRestEffectiveNumber() == null ? "0" : biddingOffer
                .getRestEffectiveNumber()) <= 0) {
            return false;
        } else {
            return true;

        }
    }


    //更新剩余有效报价次数，由于界面传入的数据只有上一轮报价过的数据(如第一轮未报价，则第二轮不会显示未报价的记录，所以前端传入的也不包含第一轮未报价的机理)
    private void updatebiddingOfferRestEffectiveNumber(BiddingOffer BiddingOffer, String requirementTypeCode,Company supCompany) {
        // 1、先根据标单号和类型、当前轮次条件，查询出该物料对应的所有报价供应商
        BiddingOfferExample example = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = example.createCriteria();
        criteria.andBiddingNoEqualTo(BiddingOffer.getBiddingNo());// 招标单号
        criteria.andSupCompanyIdEqualTo(supCompany.getId());// 当前供应商ID
        criteria.andBiddingRoundsNumberEqualTo(BiddingOffer.getBiddingRoundsNumber());// 当前轮次
        criteria.andRequirementTypeCodeEqualTo(requirementTypeCode);// 需求类型编码:material(物料),die(模具),device(设备)

        // 查询
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferMapper.selectByExample(example);
			
        // 排序后更新排名
        for (BiddingOffer biddingOffer : biddingOfferMatterList) {
            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOffer.getId());// 主键
            offer.setRestEffectiveNumber(String.valueOf(Integer.valueOf(biddingOffer.getRestEffectiveNumber()) - 1));// 剩余报价次数-1
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);
        }
    }
    
    private void updateBiddingOfferPrice(BiddingContent biddingContent, Company supCompany, User supUser,String handleType) throws InstantiationException, IllegalAccessException {
        if (biddingContent != null) {
            // 物料
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferMatterList())) {
                // 获取界面传入的数据
                List<BiddingOffer> biddingOfferMatterList = biddingContent.getBiddingOfferMatterList();

                // 判断是否超过报价有效次数
                // 随便取出一条记录来获取有效报价次数、已报价次数，标单号
                // BiddingOffer biddingOffer =
                // biddingOfferMapper.selectByPrimaryKey(BiddingOfferMatterList.get(0).getId());
                BiddingOffer biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferMatterList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferMatterList.get(0).getRestEffectiveNumber());
                boolean flag = isUpdateOfferPrice(biddingOffer);

                if (flag == true) {
                    updateBiddingOfferMatter(biddingOfferMatterList, supCompany, supUser,handleType);
                    
                    // 发送报价则更新有效报价次数
                    if ("send".equals(handleType)){
        	            // requirementTypeCode 需求类型编码:material(物料),die(模具),device(设备)
                    	updatebiddingOfferRestEffectiveNumber(biddingOfferMatterList.get(0), "material",supCompany);
                    }
                    
                    
                } else {
                    // less_than_current_time {0}不能小于{1}
                    // throw new CommonException("超过有效报价次数，保存失败", "less_than_current_time",
                    // "有效报价总次数","剩余有效报价次数");
                    throw new CommonException("剩余有效报价次数为0，保存失败", "finish_status", "剩余有效报价次数为0，不能进行报价！");
                }
            }

            // 模具
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferModelList())) {
                List<BiddingOffer> biddingOfferModelList = biddingContent.getBiddingOfferModelList();

                // 判断是否超过报价有效次数
                // 随便取出一条记录来获取有效报价次数、已报价次数，标单号
                // BiddingOffer biddingOffer =
                // biddingOfferMapper.selectByPrimaryKey(BiddingOfferModelList.get(0).getId());
                BiddingOffer biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferModelList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferModelList.get(0).getRestEffectiveNumber());
                boolean flag = isUpdateOfferPrice(biddingOffer);

                if (flag == true) {
                    updateBiddingOffer(biddingOfferModelList, supCompany, supUser, "die",handleType);
                    
                    // 发送报价则更新有效报价次数
                    if ("send".equals(handleType)){
        	            // requirementTypeCode 需求类型编码:material(物料),die(模具),device(设备)
                    	updatebiddingOfferRestEffectiveNumber(biddingOfferModelList.get(0), "die",supCompany);
                    }
                    
                } else {
                    // less_than_current_time {0}不能小于{1}
                    // throw new CommonException("超过有效报价次数，保存失败", "less_than_current_time",
                    // "有效报价总次数","剩余有效报价次数");
                    throw new CommonException("剩余有效报价次数为0，保存失败", "finish_status", "剩余有效报价次数为0，不能进行报价！");
                }

            }

            // 其他
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferOtherList())) {
                List<BiddingOffer> biddingOfferOtherList = biddingContent.getBiddingOfferOtherList();

                // 判断是否超过报价有效次数
                // 随便取出一条记录来获取有效报价次数、已报价次数，标单号
                // BiddingOffer biddingOffer =
                // biddingOfferMapper.selectByPrimaryKey(BiddingOfferOtherList.get(0).getId());
                BiddingOffer biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferOtherList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferOtherList.get(0).getRestEffectiveNumber());
                boolean flag = isUpdateOfferPrice(biddingOffer);

                if (flag == true) {
                    // 需求类型编码:material(物料),die(模具),device(设备)
                    updateBiddingOffer(biddingOfferOtherList, supCompany, supUser, "device",handleType);
                    
                    // 发送报价则更新有效报价次数
                    if ("send".equals(handleType)){
        	            // requirementTypeCode 需求类型编码:material(物料),die(模具),device(设备)
                    	updatebiddingOfferRestEffectiveNumber(biddingOfferOtherList.get(0), "device",supCompany);
                    }
                    
                } else {
                    // less_than_current_time {0}不能小于{1}
                    // throw new CommonException("超过有效报价次数，保存失败", "less_than_current_time",
                    // "有效报价总次数","剩余有效报价次数");
                    throw new CommonException("剩余有效报价次数为0，保存失败", "finish_status", "剩余有效报价次数为0，不能进行报价！");
                }
            }
        }
        
    }

    // 物料
    private void updateBiddingOfferMatter(List<BiddingOffer> BiddingOfferList, Company supCompany,
            User supUser, String handleType) throws InstantiationException, IllegalAccessException {

        for (BiddingOffer biddingOfferMatter : BiddingOfferList) {

            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOfferMatter.getId());
            offer.setPromiseReducedRate(biddingOfferMatter.getPromiseReducedRate());// 承诺年降率
            
            //保存报价到临时报价字段
            if ("save".equals(handleType)){
	            // 剩余报价次数不更新
            	//临时报价字段，由于界面报价字段赋值的是TempOfferUnitPrice，所以此处用的是该字段取值
            	offer.setTempOfferUnitPrice(biddingOfferMatter.getTempOfferUnitPrice());// 临时报价单价
                offer.setTempOfferSetPrice(biddingOfferMatter.getTempOfferSetPrice());// 临时报价套价
            }else if ("send".equals(handleType)){
            	//移到其他地方去
            	//offer.setRestEffectiveNumber(String.valueOf(Integer.valueOf(biddingOfferMatter.getRestEffectiveNumber()) - 1));// 剩余报价次数-1
            	//临时报价字段
            	offer.setTempOfferUnitPrice(biddingOfferMatter.getTempOfferUnitPrice());// 临时报价单价
                offer.setTempOfferSetPrice(biddingOfferMatter.getTempOfferSetPrice());// 临时报价套价
            	//正式报价字段，如果报价了，价格单位、税码、价格有效期从、价格有效期到不能为空
                if (StringUtils.isNotBlank(biddingOfferMatter.getOfferUnitPrice())) {
                	Assert.isNotBlank(biddingOfferMatter.getTaxCode(), "物料中已填写报价单价的标的，请选择其税码");
                	Assert.isNotNull(biddingOfferMatter.getPriceUnit(), "物料中已填写报价单价的标的，价格单位不能为空");
                	Assert.isNotNull(biddingOfferMatter.getPriceEffectiveFrom(), "物料中已填写报价单价的标的，请选择其价格有效期");
                	Assert.isNotNull(biddingOfferMatter.getPriceEffectiveTo(), "物料中已填写报价单价的标的，请选择其价格有效期");
                }
            	offer.setOfferUnitPrice(biddingOfferMatter.getOfferUnitPrice());// 报价单价
                offer.setOfferSetPrice(biddingOfferMatter.getOfferSetPrice());// 报价套价
            }
            offer.setFactBarnd(biddingOfferMatter.getFactBarnd());// 实报品牌
            offer.setFactSpec(biddingOfferMatter.getFactSpec());// 实报规格
            offer.setFactModel(biddingOfferMatter.getFactModel());// 实报型号
            offer.setLastUpdateUser(supUser.getNickName());// 最后更新人
            offer.setLastUpdateTime(new Date());// 最后更新时间
            offer.setPriceUnit(biddingOfferMatter.getPriceUnit()); // 价格单位
            offer.setTaxCode(biddingOfferMatter.getTaxCode()); // 税码
            offer.setPriceEffectiveFrom(biddingOfferMatter.getPriceEffectiveFrom()); // 价格有效期从
            offer.setPriceEffectiveTo(biddingOfferMatter.getPriceEffectiveTo()); // 价格有效期到
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);

            // 保存物料阶梯报价
            List<BiddingMatterStepSup> biddingMatterStepSupList = biddingOfferMatter
                    .getBiddingMatterStepSupList();
            if (CollectionUtils.isNotEmpty(biddingMatterStepSupList)) {
                for (BiddingMatterStepSup biddingMatterStepSup : biddingMatterStepSupList) {

                    BiddingMatterStepSup mstepsup = new BiddingMatterStepSup();
                    mstepsup.setId(biddingMatterStepSup.getId());// 主键
                    mstepsup.setOfferUnitPrice(biddingMatterStepSup.getOfferUnitPrice());// 报价单价
                    mstepsup.setOfferSetPrice(biddingMatterStepSup.getOfferSetPrice());// 报价套价
                    mstepsup.setLastUpdateUser(supUser.getNickName());// 最后更新人
                    mstepsup.setLastUpdateTime(new Date());// 最后更新时间

                    this.biddingMatterStepSupService.modifyObj(mstepsup);
                }
            }

            // 发送报价则更新当前记录的排名
            if ("send".equals(handleType)){
	            // requirementTypeCode 需求类型编码:material(物料),die(模具),device(设备)
	            updateCurrentRanking(biddingOfferMatter, "material");
            }
            
            //更新成本分析清单
            if (StringUtils.isNotBlank(biddingOfferMatter.getCostAnalysisId())){
            	updateMaterialAcostAnalysis(biddingOfferMatter);
            }
        }

    }

    
    
    @SuppressWarnings({ "unused", "rawtypes" })
	private void updateMaterialAcostAnalysis(BiddingOffer biddingOfferMatter) throws InstantiationException, IllegalAccessException{
    	//根据成本清单ID获取对应的service
    	//IOrderItemDetailService service = this.tplOrderItemDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId()).getOrderItemDetailService();
    	TplOrderItemDetail tpl = this.tplOrderItemDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId());
    	IOrderItemDetailService service = tpl.getOrderItemDetailService();
    	
    	List<String> orderItemIdList = new ArrayList<>();
    	orderItemIdList.add(biddingOfferMatter.getId());
    	
    	//先删除，在插入
    	service.deleteByOrderItemIds(orderItemIdList);
    	
    	List<IOrderItemDetail> detailList = new ArrayList<>();
    	//IOrderItemDetail detail = tpl.getOrderItemDetailClass().newInstance();
    	IOrderItemDetail detail = biddingOfferMatter.getOrderItemDetail();
		detail.setOrderItemId(biddingOfferMatter.getId());//报价表主键id
		detail.setTemplateId(biddingOfferMatter.getCostAnalysisId());
		detail.setMaterialCode(biddingOfferMatter.getProjectNo()==null?"":biddingOfferMatter.getProjectNo());
		detail.setMaterialDesc(biddingOfferMatter.getProjectDesc()==null?"":biddingOfferMatter.getProjectDesc());
		detailList.add(detail);
		
    	service.addAll(detailList);
    	
    	
    }
    
    @SuppressWarnings({ "unused", "rawtypes" })
	private void updateMouldAcostAnalysis(BiddingOffer biddingOfferMatter){
    	//根据成本清单ID获取对应的service
    	IMouldDetailService service = this.tplMouldDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId()).getMouldDetailService();
    	
    	List<String> orderItemIdList = new ArrayList<>();
    	orderItemIdList.add(biddingOfferMatter.getId());
    	
    	//先删除，在插入
    	service.deleteByMouldIdList(orderItemIdList);
		
		List<IMouldDetail> mouldDetailList = new ArrayList<>();
		//MouldDetail mouldDetail = new MouldDetail();
		IMouldDetail mouldDetail = biddingOfferMatter.getMouldDetail();//此处获取界面传入的数据
    	mouldDetail.setMouldId(biddingOfferMatter.getId());//报价表主键id
    	mouldDetail.setTemplateId(biddingOfferMatter.getCostAnalysisId());//成本清单id
		mouldDetail.setSupCompanyId(biddingOfferMatter.getSupCompanyId());
		mouldDetail.setSupCompanyName(biddingOfferMatter.getSupCompanyName());
		mouldDetail.setSupCompanySapCode(biddingOfferMatter.getSupCompanySapCode()==null?"":biddingOfferMatter.getSupCompanySapCode());
		mouldDetail.setSupCompanySrmCode(biddingOfferMatter.getSupCompanySrmCode()==null?"":biddingOfferMatter.getSupCompanySrmCode());
		mouldDetail.setPurOrderId(biddingOfferMatter.getBiddingNo());//询价单头ID，不能为空
		mouldDetail.setSupOrderId(biddingOfferMatter.getBiddingNo());
		//mouldDetail.setCreateTime(new Date());
		mouldDetail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(mouldDetail));
		mouldDetailList.add(mouldDetail);
		
    	service.addAll(mouldDetailList);
    	
    }
    
    private void updateCurrentRanking(BiddingOffer BiddingOffer, String requirementTypeCode) {
        // 更新当前记录的排名
        // 1、先根据标单号和物料编码、当前轮次条件，查询出该物料对应的所有报价供应商
        BiddingOfferExample matterExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria matterCriteria = matterExample.createCriteria();
        matterCriteria.andBiddingNoEqualTo(BiddingOffer.getBiddingNo());// 招标单号
        //begin 2018-5-14 由于编码可以为空，所以在此不能同编码判断，改用ID,替换为如下 2018-5-14
        //matterCriteria.andProjectNoEqualTo(BiddingOffer.getProjectNo());// 物料编码
        switch (requirementTypeCode) {
        case "material":
        	matterCriteria.andMatterIdEqualTo(BiddingOffer.getMatterId());// 物料ID
            break;//必须要加
        case "die":
        	matterCriteria.andModelIdEqualTo(BiddingOffer.getModelId());// 模具ID
            break;
        case "device":
        	matterCriteria.andOtherIdEqualTo(BiddingOffer.getOtherId());//其他ID
            break;
        }
        //end 2018-5-14
        matterCriteria.andBiddingRoundsNumberEqualTo(BiddingOffer.getBiddingRoundsNumber());// 当前轮次
        matterCriteria.andRequirementTypeCodeEqualTo(requirementTypeCode);// 需求类型编码:material(物料),die(模具),device(设备)
        matterCriteria.andOfferUnitPriceGreaterThan("0");// 报价>0

        // 查询
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferMapper.selectByExample(matterExample);

        /*
         * for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferMatterList) && j <
         * biddingOfferMatterList.size(); j++) {
         * System.err.println("排序前==标单号："+biddingOfferMatterList
         * .get(j).getBiddingNo()+"报价："+biddingOfferMatterList
         * .get(j).getOfferUnitPrice()+"排名："+(j+1)); }
         */

        // 排序
        Collections.sort(biddingOfferMatterList, new Comparator<BiddingOffer>() {
            @Override
            public int compare(BiddingOffer o1, BiddingOffer o2) {
                // * 升序排的话就是第一个参数.compareTo(第二个参数);
                // * 降序排的话就是第二个参数.compareTo(第一个参数);
                return new BigDecimal(o1.getOfferUnitPrice() == null ? "0" : o1.getOfferUnitPrice())
                        .compareTo(new BigDecimal(o2.getOfferUnitPrice() == null ? "0" : o2
                                .getOfferUnitPrice()));
            }
        });
        // 排序后更新排名，报价相同的话，排名并列
        int index = 1;
        int tamp = 0;
        Set<String> set = new HashSet<>();
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferMatterList)
                && j < biddingOfferMatterList.size(); j++) {
        	
        	BiddingOffer offerSort = new BiddingOffer();
        	offerSort.setId(biddingOfferMatterList.get(j).getId());// 主键
        	
        	if (set.add(biddingOfferMatterList.get(j).getOfferUnitPrice())) {
        		offerSort.setCurrentRanking(String.valueOf(index));// 排名
        		tamp = index;
        		index++;
        	} else {
        		offerSort.setCurrentRanking(String.valueOf(tamp));// 排名
        	}

            this.biddingOfferMapper.updateByPrimaryKeySelective(offerSort);

        }
    }

    // 模具或其他
    private void updateBiddingOffer(List<BiddingOffer> BiddingOfferList, Company supCompany, User supUser,
            String requirementTypeCode, String handleType) {

        for (BiddingOffer biddingOffer : BiddingOfferList) {

            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOffer.getId());
            
            //保存报价到临时报价字段
            if ("save".equals(handleType)){
	            // 剩余报价次数不更新
            	//临时报价字段，由于界面报价字段赋值的是OfferUnitPrice，所以此处用的是该字段取值
            	offer.setTempOfferUnitPrice(biddingOffer.getTempOfferUnitPrice());// 临时报价单价
                offer.setTempOfferSetPrice(biddingOffer.getTempOfferSetPrice());// 临时报价套价
            }else if ("send".equals(handleType)){
            	// 如果报价了，要发送报价，就要判断价格单位、税码、价格有效期从、价格有效期到不能为空
            	if (StringUtils.isNotBlank(biddingOffer.getOfferUnitPrice())) {
            		Assert.isNotBlank(biddingOffer.getTaxCode(), "已填写报价单价的标的，请选择其税码");
            		Assert.isNotNull(biddingOffer.getPriceUnit(), "已填写报价单价的标的，价格单位不能为空");
            		Assert.isNotNull(biddingOffer.getPriceEffectiveFrom(), "已填写报价单价的标的，请选择其价格有效期");
            		Assert.isNotNull(biddingOffer.getPriceEffectiveTo(), "已填写报价单价的标的，请选择其价格有效期");
            	}
            	//正式报价字段
            	offer.setOfferUnitPrice(biddingOffer.getOfferUnitPrice());// 报价单价
                offer.setOfferSetPrice(biddingOffer.getOfferSetPrice());// 报价套价
                //offer.setRestEffectiveNumber(String.valueOf(Integer.valueOf(biddingOffer.getRestEffectiveNumber()) - 1));// 剩余报价次数-1
            	//临时报价字段
            	offer.setTempOfferUnitPrice(biddingOffer.getTempOfferUnitPrice());// 临时报价单价
                offer.setTempOfferSetPrice(biddingOffer.getTempOfferSetPrice());// 临时报价套价
            }
            
            offer.setLastUpdateUser(supUser.getNickName());// 最后更新人
            offer.setLastUpdateTime(new Date());// 最后更新时间
            offer.setPriceUnit(biddingOffer.getPriceUnit()); // 价格单位
            offer.setTaxCode(biddingOffer.getTaxCode()); // 税码
            offer.setPriceEffectiveFrom(biddingOffer.getPriceEffectiveFrom()); // 价格有效期从
            offer.setPriceEffectiveTo(biddingOffer.getPriceEffectiveTo()); // 价格有效期到

            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);

            //发送报价则更新当前记录的排名
            if ("send".equals(handleType)){
	            // requirementTypeCode 需求类型编码:material(物料),die(模具),device(设备)
	            updateCurrentRanking(biddingOffer, requirementTypeCode);
            }

            //requirementTypeCode是模具的时候更新成本分析清单，其他的则不更新
            if ("die".equals(requirementTypeCode)){
            	
            	if (StringUtils.isNotBlank(biddingOffer.getCostAnalysisId())){
            		updateMouldAcostAnalysis(biddingOffer);
            	}
            }
            
        }
    }

    // 评标界面查询
    @Override
    public List<BiddingOffer> findBidInfo(String biddingNo, String type, String isBidding, String currentRound) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.setOrderByClause(" SUP_COMPANY_SRM_CODE DESC,PROJECT_DESC DESC,MATERIAL_DEVEL ASC ");
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type)
                .andBiddingRoundsNumberEqualTo(currentRound);
        if (StringUtils.isNotBlank(isBidding)) {
            criteria.andIsBiddingEqualTo(isBidding);
        }
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);

        // 取出数据做逻辑判断
        List<String> stringsCodeList = getStringsCode(biddingNo, type);// 拿到当前tab页的对应的招标物料内容的所有物料ID
        //循环物料或模具或其他的记录
        for (int i = 0; CollectionUtils.isNotEmpty(stringsCodeList) && i < stringsCodeList.size(); i++) {
            List<BiddingOffer> sameProjectNoList = new ArrayList<BiddingOffer>();// 同一个编码的数据
            
            //循环物料或模具或其他的报价信息记录
            for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); j++) {
                BiddingOffer biddingOffer = biddingOfferList.get(j);
                if (type.equals("material")) {// 如果为物料tab页则查询出阶梯报价信息
                    BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
                    example.createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId())
                            .andBiddingRoundsNumberEqualTo(currentRound);
                    example.setOrderByClause(" QUANTITY_START ASC");
                    List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupService
                            .queryAllObjByExample(example);
                    biddingOffer.setBiddingMatterStepSupList(biddingMatterStepSups);
                    BigDecimal offerUnitPrice = biddingOffer.getOfferUnitPrice() == null ? BigDecimal.ZERO
                            : new BigDecimal(biddingOffer.getOfferUnitPrice());
                    BigDecimal biddingQuantity = biddingOffer.getBiddingQuantity() == null ? BigDecimal.ZERO
                            : new BigDecimal(biddingOffer.getBiddingQuantity());
                    biddingOffer.setSupplierQuotedPrice(offerUnitPrice.multiply(biddingQuantity));
                }
                //begin 2018-5-14
                /*由于编码可以为空，所以在此不能同编码判断，改用ID,替换为如下 2018-5-14
                if (stringsCodeList.get(i).equals(biddingOffer.getProjectNo())) {
                    sameProjectNoList.add(biddingOffer);
                }*/
                
                //若当前匹配成功的case不存在break，则从当前case开始，依次返回后续case的返回值，直到遇到break，跳出判断。
                switch (type) {
                case "material":
                	if (stringsCodeList.get(i).equals(biddingOffer.getMatterId())) {
                        sameProjectNoList.add(biddingOffer);
                    }
                    break;//必须要加
                case "die":
                	if (stringsCodeList.get(i).equals(biddingOffer.getModelId())) {
                        sameProjectNoList.add(biddingOffer);
                    }
                    break;
                case "device":
                	if (stringsCodeList.get(i).equals(biddingOffer.getOtherId())) {
                        sameProjectNoList.add(biddingOffer);
                    }
                    break;
                }
                
                //end 2018-5-14
            }
            // 1,供应商等级A＞Ｂ＞Ｃ＞Ｄ＞没等级.只要有等级则推荐最高等级的供应商。如果最高等级有多个或者几家供应商都没有等级则进行第二个判断
            List<String> maxDevelList = new ArrayList<String>();// 等级最高的那些数据
            List<BiddingOffer> maxDevelOffers = new ArrayList<BiddingOffer>();
            for (BiddingOffer biddingOffer : sameProjectNoList) {
                if (StringUtils.isNotBlank(sameProjectNoList.get(0).getMaterialDevel())
                        && !sameProjectNoList.get(0).getMaterialDevel()
                                .equals(biddingOffer.getMaterialDevel()))
                    continue;
                maxDevelList.add(biddingOffer.getId());
                maxDevelOffers.add(biddingOffer);
            }
            if (CollectionUtils.isNotEmpty(maxDevelList) && maxDevelList.size() == 1) {// 只有一个最高等级
                for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); j++) {
                    BiddingOffer biddingOffer = biddingOfferList.get(j);
                    if (biddingOffer.getId().equals(maxDevelList.get(0))) {
                        biddingOffer.setIsGroomMaterial("1");
                        break;
                    }
                }
            }
            // 2,年降率越高则优先推荐；如果主数据中年降率都为空则进行第三项判断
            if (CollectionUtils.isEmpty(maxDevelList) || maxDevelList.size() > 1) {
                // 如果几家供应商都没有等级则取当前物料的全部数据，如果有多个相同等级，则取对应等级的全部数据
                List<BiddingOffer> reducedRateOffers = new ArrayList<BiddingOffer>();
                if (CollectionUtils.isEmpty(maxDevelList)) {
                    reducedRateOffers.addAll(sameProjectNoList);
                } else {
                    reducedRateOffers.addAll(maxDevelOffers);
                }

                List<Company> reducedRateList = new ArrayList<>();// 对应的供应商主数据
                for (BiddingOffer offer : reducedRateOffers) {
                    Company company = this.companyService.queryObjById(offer.getSupCompanyId());
                    reducedRateList.add(company);
                }

                //TODO 待在主数据加字段
                //暂时注释
               /* Collections.sort(reducedRateList, new Comparator<Company>() {
                    @Override
                    public int compare(Company o1, Company o2) {
                        return new BigDecimal(o2.getReducedRate() == null ? "0" : o2.getReducedRate())
                                .compareTo(new BigDecimal(o1.getReducedRate() == null ? "0" : o1
                                        .getReducedRate()));
                    }
                });*/
                List<String> maxIdList = new ArrayList<String>();// 年降率最高的那些数据
                List<BiddingOffer> maxReducedRateOffers = new ArrayList<BiddingOffer>();
                for (Company company : reducedRateList) {

                    //TODO 待在主数据加字段
                    //暂时注释
                   /* if (StringUtils.isNotBlank(reducedRateList.get(0).getReducedRate())
                            && reducedRateList.get(0).getReducedRate().equals(company.getReducedRate()))*/
                        maxIdList.add(company.getId());
                }
                if (CollectionUtils.isNotEmpty(maxIdList)) {
                    for (BiddingOffer offer : biddingOfferList) {
                        if (maxIdList.size() == 1 && maxIdList.contains(offer.getSupCompanyId())) {
                            offer.setIsGroomMaterial("1");
                            maxReducedRateOffers.add(offer);
                        }
                        if (maxIdList.size() > 1 && maxIdList.contains(offer.getSupCompanyId())) {
                            maxReducedRateOffers.add(offer);
                        }
                    }
                }
                // 如果前两项都没有，则根据价格最低给出推荐供应商
                //maxIdList.size()>1 表示最高年件率，筛选出来的结果有两个
                if (CollectionUtils.isEmpty(maxIdList) || maxIdList.size() > 1) {
                    List<BiddingOffer> priceOffers = new ArrayList<BiddingOffer>();
                    if (CollectionUtils.isEmpty(maxIdList)) {
                        priceOffers.addAll(sameProjectNoList);
                    } else {
                        priceOffers.addAll(maxReducedRateOffers);
                    }

                    Collections.sort(priceOffers, new Comparator<BiddingOffer>() {
                        @Override
                        public int compare(BiddingOffer o1, BiddingOffer o2) {
                            //return o2.getUnitPrice().compareTo(o1.getUnitPrice());
                            //return o1.getOfferUnitPrice().compareTo(o2.getOfferUnitPrice());
                        	if(StringUtils.isBlank(o1.getOfferUnitPrice())){
                        		return 1;//null值往后面排
                        	}
                        	if(StringUtils.isBlank(o2.getOfferUnitPrice())){
                        		return -1;//null值往后面排
                        	}
                        	// * 升序排的话就是第一个参数.compareTo(第二个参数);
                            // * 降序排的话就是第二个参数.compareTo(第一个参数);
                            return new BigDecimal(o1.getOfferUnitPrice()).compareTo(new BigDecimal(o2.getOfferUnitPrice()));
                            
                        }
                    });
              
                    List<String> biddingPriceOffers = new ArrayList<String>();
                    for (BiddingOffer offer : sameProjectNoList) {
                    	//如果指定的数大于参数返回 1。priceOffers.get(0).getUnitPrice().compareTo(offer.getUnitPrice()=1 表示priceOffers.get(0).getUnitPrice()>offer.getUnitPrice()
                    	if (StringUtils.isBlank(offer.getOfferUnitPrice()))
                    		continue;
                    	
                        if (priceOffers.get(0).getOfferUnitPrice().compareTo(offer.getOfferUnitPrice()) == 0)
                            biddingPriceOffers.add(offer.getId());

                    }
                    if(CollectionUtils.isNotEmpty(biddingPriceOffers)){
	                    for (BiddingOffer offer : biddingOfferList) {
	                        if (biddingPriceOffers.contains(offer.getId())) {
	                            offer.setIsGroomMaterial("1");
	                        }
	                    }
                    }

                }

            }
        }

        for (BiddingOffer offer : biddingOfferList) {
        	
        	if (StringUtils.isNotBlank(offer.getCostAnalysisId())){
        		if (type.equals("material")) {
        			IOrderItemDetailService service = this.tplOrderItemDetailService.queryObjById(offer.getCostAnalysisId()).getOrderItemDetailService();
        			offer.setOrderItemDetail(service.queryObjByOrderItemId(offer.getId()));
        		}else if (type.equals("die")) {//模具
        	        IMouldDetailService service = this.tplMouldDetailService.queryObjById(offer.getCostAnalysisId()).getMouldDetailService();
        	        offer.setMouldDetail(service.queryByMouldId(offer.getId()));
        		}
        	}
        }
        return biddingOfferList;
    }

    // 评标界面查询
    @Override
    public List<BiddingOffer> findBidInfoSup(String biddingNo, String type, String isBidding,
            String currentRound, User user, Company company) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.setOrderByClause(" SUP_COMPANY_SRM_CODE DESC,PROJECT_DESC DESC,MATERIAL_DEVEL ASC ");
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo)//招标单号
        		.andRequirementTypeCodeEqualTo(type)//类型
                .andBiddingRoundsNumberEqualTo(currentRound)//当前轮次
                .andSupCompanyIdEqualTo(company.getId());// 供应商id(currentRound);
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);

        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); j++) {
            BiddingOffer biddingOffer = biddingOfferList.get(j);
            if (type.equals(type)) {// 如果为物料tab页则查询出阶梯报价信息
                BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
                example.createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId())
                        .andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId());
                List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupService
                        .queryAllObjByExample(example);
                biddingOffer.setBiddingMatterStepSupList(biddingMatterStepSups);
                BigDecimal offerUnitPrice = biddingOffer.getOfferUnitPrice() == null ? BigDecimal.ZERO
                        : new BigDecimal(biddingOffer.getOfferUnitPrice());
                BigDecimal quantity = biddingOffer.getQuantity() == null ? BigDecimal.ZERO : new BigDecimal(
                        biddingOffer.getQuantity());
                biddingOffer.setOfferSetPrice(offerUnitPrice.multiply(quantity).toString());
            }
            // 是否显示目标价
            BiddingHeaderExample headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
            List<BiddingHeader> biddingHeaders = this.biddingHeaderService
                    .queryAllObjByExample(headerExample);
            String biddingSendBidder = biddingHeaders.get(0).getBiddingSendBidder();
            // 定标(目标价)发送投标方:0、不发送  1、只发送中标方 
            if ("0".equals(biddingSendBidder)) {
                biddingOffer.setUnitPrice(BigDecimal.valueOf(-1));
                biddingOffer.setAmount(BigDecimal.valueOf(-1));
            }else if ("1".equals(biddingSendBidder)) {
            	//如果未中标则也看不到目标价
            	if("0".equals(biddingOffer.getIsBidding())){
		             biddingOffer.setUnitPrice(BigDecimal.valueOf(-1));
		             biddingOffer.setAmount(BigDecimal.valueOf(-1));
            	}
            }
        }

        return biddingOfferList;
    }

    private List<String> getStringsCode(String biddingNo, String type) {
        List<String> stringsCode = new ArrayList<String>();
        switch (type) {
        case "material":
            // 物料
            BiddingContentMatterExample contentMatterExample = new BiddingContentMatterExample();
            contentMatterExample.createCriteria().andBiddingNoEqualTo(biddingNo);
            List<BiddingContentMatter> biddingContentMatters = this.biddingContentMatterService
                    .queryAllObjByExample(contentMatterExample);
            for (int j = 0; CollectionUtils.isNotEmpty(biddingContentMatters)
                    && j < biddingContentMatters.size(); j++) {
            	/*由于物料编码可以为空，所以在此不能同物料编码判断，改用物料ID,替换为如下
                stringsCode.add(biddingContentMatters.get(j).getMaterialNo());*/
            	stringsCode.add(biddingContentMatters.get(j).getId());
            }
            break;

        case "die":
            // 模具
            BiddingContentModelExample contentModelExample = new BiddingContentModelExample();
            contentModelExample.createCriteria().andBiddingNoEqualTo(biddingNo);
            List<BiddingContentModel> biddingContentModels = this.biddingContentModelService
                    .queryAllObjByExample(contentModelExample);
            for (int j = 0; CollectionUtils.isNotEmpty(biddingContentModels)
                    && j < biddingContentModels.size(); j++) {
            	/*由于模具编码可以为空，所以在此不能同模具编码判断，改用模具ID,替换为如下
                stringsCode.add(biddingContentModels.get(j).getModelNo());*/
            	stringsCode.add(biddingContentModels.get(j).getId());
            }
            break;

        case "device":
            // 其他
            BiddingContentOtherExample contentOtherExample = new BiddingContentOtherExample();
            contentOtherExample.createCriteria().andBiddingNoEqualTo(biddingNo);
            List<BiddingContentOther> biddingContentOthers = this.biddingContentOtherService
                    .queryAllObjByExample(contentOtherExample);
            for (int j = 0; CollectionUtils.isNotEmpty(biddingContentOthers)
                    && j < biddingContentOthers.size(); j++) {
            	/*由于编码可以为空，所以在此不能同编码判断，改用ID,替换为如下
                stringsCode.add(biddingContentOthers.get(j).getTargetNo());*/
            	stringsCode.add(biddingContentOthers.get(j).getId());
            }
            break;
        }
        return stringsCode;
    }

    @Override
    public void save(SaveBidInfoVo saveBidInfoVo, String saveOrSubmit) {
        List<BiddingOffer> biddingOfferList = saveBidInfoVo.getBiddingOfferList();
        List<TemporaryCodeReducedRate> codeReducedRates = saveBidInfoVo.getCodeReducedRates();
        if (CollectionUtils.isEmpty(biddingOfferList)) {
            throw new CommonException("数据为空，不可操作", "isNull", "数据");
        }
        
        //biddingOfferList当前传进来的只有一个tab的数据(物料或模具或其他的其他一个)
        for (int j = 0; j < biddingOfferList.size(); j++) {
            BiddingOffer biddingOffer = biddingOfferList.get(j);
            // 0：必须全部投标
            if (biddingOfferList.get(0).getAllBidding().equals("0")) {
                if (CollectionUtils.isEmpty(codeReducedRates)) {
                    throw new CommonException("全部投标时，必须设置中标供应商", "most_set_bid_supplier");
                }
                biddingOffer.setBidShare("0");

                for (TemporaryCodeReducedRate temporaryCodeReducedRate : codeReducedRates) {
                    if (temporaryCodeReducedRate.getTemporaryCode().equals(
                            biddingOffer.getSupplierTemporaryCode())) {
                        biddingOffer.setBidShare(temporaryCodeReducedRate.getReducedRate());
                        //begin  2018-5-28
                        //全部投标时，保存也更新中标状态
                        /*if (StringUtils.isNotBlank(saveOrSubmit) && saveOrSubmit.equals("submit")) {
                            biddingOffer.setIsBidding("1");
                        }*/
                        biddingOffer.setIsBidding("1");
                        //end 
                    }
                }
            }
            //如果是提交评标则更新当前tab页的提交评标状态
            if (StringUtils.isNotBlank(saveOrSubmit) && saveOrSubmit.equals("submit")) {
            	biddingOffer.setIsSubmitBid("1");//是否提交评标
            }
            this.biddingOfferMapper.updateByPrimaryKeySelective(biddingOffer);
        }
        
        BiddingContent biddingContent = saveBidInfoVo.getBiddingContent();
        if (biddingContent != null) {
            //更新招投标评标说明
        	BiddingContent bidContent = new BiddingContent();
        	//String biddingNo = biddingOfferList.get(0).getBiddingNo();
        	bidContent.setId(biddingContent.getId());
        	bidContent.setBidExplain(biddingContent.getBidExplain());
            this.biddingContentService.modifyObj(bidContent);
        }

        if (StringUtils.isNotBlank(saveOrSubmit) && saveOrSubmit.equals("submit")) {
            // 校验所有tab页是否全部提交评标
            boolean boo = isAllSetBidSupplier(biddingOfferList);
            if (boo) {
                BiddingHeaderExample headerExample = new BiddingHeaderExample();
                headerExample.createCriteria().andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo());
                List<BiddingHeader> biddingHeaders = this.biddingHeaderService
                        .queryAllObjByExample(headerExample);
                BiddingHeader biddingHeader = new BiddingHeader();
                biddingHeader.setId(biddingHeaders.get(0).getId());
                biddingHeader.setBiddingStatus(TenderStatusEumn.BIDOVER.getValue());
                biddingHeader.setBiddingAuditstatus("0");// 0-尚未审批，1-正在审批，2-审批通过，3-已驳回  2018-05-30 更新定标前审批状态为未审批
                biddingHeader.setBidSubmitDate(new Date());
                this.biddingHeaderService.modifyObj(biddingHeader);
                // 更新 已应标 的供应商招标状态为 已评标
                BiddingSupplierExample supplierExample = new BiddingSupplierExample();
                supplierExample.createCriteria().andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo())
                        .andSupBiddingStatusEqualTo(TenderStatusEumn.ISBID.getValue());
                supplierExample.or().andSupBiddingStatusEqualTo(TenderStatusEumn.INBID.getValue());
                List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService
                        .queryAllObjByExample(supplierExample);
                for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList)
                        && i < biddingSupplierList.size(); i++) {
                    BiddingSupplier biddingSupplier = new BiddingSupplier();
                    biddingSupplier.setId(biddingSupplierList.get(i).getId());
                    biddingSupplier.setSupBiddingStatus(TenderStatusEumn.BIDOVER.getValue());
                    this.biddingSupplierService.modifyObj(biddingSupplier);
                }
            }
        }

    }

    private boolean isAllSetBidSupplier(List<BiddingOffer> biddingOfferList) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo()).andBiddingRoundsNumberEqualTo(
                biddingOfferList.get(0).getBiddingRoundsNumber());
        List<BiddingOffer> biddingOfferAllList = this.biddingOfferMapper.selectByExample(offerExample);
        List<String> biddingOfferMatterList = new ArrayList<String>();
        List<String> biddingOfferModelList = new ArrayList<String>();
        List<String> biddingOfferOtherList = new ArrayList<String>();
        List<String> booleanList = new ArrayList<String>();
        for (BiddingOffer biddingOffer : biddingOfferAllList) {
            if (biddingOffer.getRequirementTypeCode().equals("material")) {
                //biddingOfferMatterList.add(biddingOffer.getIsBidding());//不能用中标字段判断是否全部提交评标，改用下面的是否提交评标字段
            	biddingOfferMatterList.add(biddingOffer.getIsSubmitBid());
            } else if (biddingOffer.getRequirementTypeCode().equals("die")) {
                biddingOfferModelList.add(biddingOffer.getIsSubmitBid());
            } else {
                biddingOfferOtherList.add(biddingOffer.getIsSubmitBid());
            }
        }

        if (CollectionUtils.isEmpty(biddingOfferMatterList) || biddingOfferMatterList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        if (CollectionUtils.isEmpty(biddingOfferModelList) || biddingOfferModelList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        if (CollectionUtils.isEmpty(biddingOfferOtherList) || biddingOfferOtherList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }

        if (Collections.frequency(booleanList, "Y") == booleanList.size()) {
            return true;
        }
        return false;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); j++) {
            this.biddingOfferMapper.deleteByPrimaryKey(biddingOfferList.get(j).getId());
        }
    }

    @Override
    public void deleteBySupCompanyId(String biddingNo, String supCompanyId) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(supCompanyId);
        this.biddingOfferMapper.deleteByExample(offerExample);
    }

    @Override
    public List<TemporaryCodeReducedRate> findBidSupplier(String biddingNo, String type, String currentRound) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type)
                .andBiddingRoundsNumberEqualTo(currentRound).andBidShareGreaterThan("0")
                .andBidShareIsNotNull();
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        List<TemporaryCodeReducedRate> codeReducedRates = new ArrayList<TemporaryCodeReducedRate>();

        for (int i = 0; CollectionUtils.isNotEmpty(biddingOfferList) && i < biddingOfferList.size(); i++) {
            TemporaryCodeReducedRate codeReducedRate = new TemporaryCodeReducedRate();
            codeReducedRate.setTemporaryCode(biddingOfferList.get(i).getSupplierTemporaryCode());
            codeReducedRate.setReducedRate(biddingOfferList.get(i).getBidShare());
            codeReducedRates.add(codeReducedRate);
        }

        Set<TemporaryCodeReducedRate> personSet = new TreeSet<>((o1, o2) -> o1.getTemporaryCode().compareTo(
                o2.getTemporaryCode()));
        personSet.addAll(codeReducedRates);

        return new ArrayList<>(personSet);
    }
}
