package com.els.base.bidding.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingPlanMapper;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingPlan;
import com.els.base.bidding.entity.BiddingPlanExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingPlanService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.inquiry.IMouldDetailService;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.entity.MouldDetail;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyValueUtils;

@Service("defaultBiddingPlanService")
public class BiddingPlanServiceImpl implements BiddingPlanService {
    @Resource
    protected BiddingPlanMapper biddingPlanMapper;

    @Resource
    protected BiddingHeaderService biddingHeaderService;

    @Resource
    protected BiddingOfferService biddingOfferService;

    @Resource
    protected BiddingSupplierService biddingSupplierService;

    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;

    @Resource
    protected TplMouldDetailService tplMouldDetailService;
    
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    
    @CacheEvict(value = { "biddingPlan" }, allEntries = true)
    @Override
    public void addObj(BiddingPlan t) {
        t.setCreateTime(new Date());
        this.biddingPlanMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingPlan" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingPlanMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingPlan" }, allEntries = true)
    @Override
    public void modifyObj(BiddingPlan t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingPlanMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "biddingPlan", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingPlan queryObjById(String id) {
        return this.biddingPlanMapper.selectByPrimaryKey(id);
    }

    // @Cacheable(value = "biddingPlan", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingPlan> queryAllObjByExample(BiddingPlanExample example) {
        return this.biddingPlanMapper.selectByExample(example);
    }

    // @Cacheable(value = "biddingPlan", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingPlan> queryObjByPage(BiddingPlanExample example) {
        PageView<BiddingPlan> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingPlanMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingPlan> biddingPlanList = this.biddingPlanMapper.selectByExample(biddingPlanExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingPlanList) && i < biddingPlanList.size(); i++) {
            this.biddingPlanMapper.deleteByPrimaryKey(biddingPlanList.get(i).getId());
        }
    }

    @CacheEvict(value = { "biddingPlan" }, allEntries = true)
    @Override
    @Transactional
    public void addTurn(List<BiddingPlan> biddingPlanList, Company company, User user) throws InstantiationException, IllegalAccessException {
        for (BiddingPlan biddingPlan2 : biddingPlanList) {
            if (biddingPlan2.getId() == null) {
            	biddingPlan2.setCreateTime(new Date());
            	biddingPlan2.setLastUpdateTime(new Date());// 最后更新时间
            	biddingPlan2.setLastUpdateUser(user.getNickName());// 供应商的最后更新人
                this.biddingPlanMapper.insert(biddingPlan2);
            }
        }
        Collections.sort(biddingPlanList, new Comparator<BiddingPlan>() {
            @Override
            public int compare(BiddingPlan o1, BiddingPlan o2) {
                return o2.getBiddingRoundsNumber().compareTo(o1.getBiddingRoundsNumber());//降序排序
            }
        });

        // 改变招标基本信息
        BiddingHeader biddingHeader = this.biddingHeaderService.queryObjById(biddingPlanList.get(0)
                .getBiddingId());//获取最大招标轮次的一条记录的招标单ID
        biddingHeader.setBiddingCurrentRound(String.valueOf(biddingPlanList.size()));
        biddingHeader.setBiddingTotalRound(String.valueOf(biddingPlanList.size()));
        biddingHeader.setBiddingBegindate(biddingPlanList.get(0).getBiddingBeginDate());
        biddingHeader.setBiddingEnddate(biddingPlanList.get(0).getBiddingEndDate());
        biddingHeader.setBiddingOpenDate(biddingPlanList.get(0).getBiddingOpenDate());
        //查询出评标中状态的供应商，其他状态的供应商不管
        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria()
        		.andBiddingNoEqualTo(biddingHeader.getBiddingNo())
                //.andSupBiddingStatusEqualTo(TenderStatusEumn.INBID.getValue());替换为如下,因为招标状态为评标中的状态数据库是不存的
        		.andSupBiddingStatusEqualTo(TenderStatusEumn.ISBID.getValue());//获取招标状态为已应标的记录 ISBID("11", "已应标")
        supplierExample.or()
		        .andBiddingNoEqualTo(biddingHeader.getBiddingNo())
				.andSupBiddingStatusEqualTo(TenderStatusEumn.INBID.getValue());//获取招标状态为评标中的记录;INBID("4", "评标中")
        
        List<BiddingSupplier> biddingSupplierPartNo = this.biddingSupplierService
                .queryAllObjByExample(supplierExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingSupplierPartNo) && j < biddingSupplierPartNo.size(); j++) {
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(biddingSupplierPartNo.get(j).getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISBID.getValue());
            biddingSupplier.setSupBidding("0");//1是已投表，0是未投标 2018-05-18
            //把评标中的供应商状态改为已应标，投标状态改为未投标
            this.biddingSupplierService.modifyObj(biddingSupplier);
        }
        
        //查询供应商
        BiddingSupplierExample allSupplierExample = new BiddingSupplierExample();
        allSupplierExample.createCriteria().andBiddingNoEqualTo(biddingHeader.getBiddingNo());
       
        List<BiddingSupplier> allSupplier = this.biddingSupplierService
                .queryAllObjByExample(allSupplierExample);
        //把应标结果存储到该变量
        List<String> strList = new ArrayList<String>();
        for (BiddingSupplier sup : allSupplier) {
        	strList.add(sup.getSupParticipate()==null?"0":sup.getSupParticipate());
		}
        //如果已应标数量=供应商数量，则全部应标
        String str = "";
        if(Collections.frequency(strList, "1") == strList.size()){
        	str=TenderStatusEumn.ALLBID.getValue();
        }else if(Collections.frequency(strList, "1") < strList.size() && Collections.frequency(strList, "1")>0){
        	//如果已应标数量<供应商数量，并且应标数量>0,则部分应标
        	str=TenderStatusEumn.PARTBID.getValue();
        }else{
        	str=TenderStatusEumn.ALLREFUSEBID.getValue();
        }
        biddingHeader.setBiddingStatus(str);//招标状态
        biddingHeader.setBidSubmitDate(null);//提交评标时间设置为空，否则供应商查询时招标状态显示有问题
        this.biddingHeaderService.customModifyObj(biddingHeader);
        
        // 新增供应商报价信息
        BiddingOfferExample example = new BiddingOfferExample();
        example.createCriteria().andBiddingNoEqualTo(biddingHeader.getBiddingNo())
                .andBiddingRoundsNumberEqualTo(String.valueOf(biddingPlanList.size() - 1));
        List<BiddingOffer> biddingOffers = this.biddingOfferService.queryAllObjByExample(example);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingOffers) && i < biddingOffers.size(); i++) {
            BiddingOffer biddingOffer = biddingOffers.get(i);
            // 阶梯报价信息
            BiddingMatterStepSupExample exampleStepSupExample = new BiddingMatterStepSupExample();
            exampleStepSupExample.createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId())
                    .andBiddingRoundsNumberEqualTo(String.valueOf(biddingPlanList.size() - 1));
            List<BiddingMatterStepSup> biddingMatterStepSups = this.biddingMatterStepSupService
                    .queryAllObjByExample(exampleStepSupExample);

            biddingOffer.setId(null);
            biddingOffer.setLastOfferPrice(biddingOffer.getOfferUnitPrice());
            biddingOffer.setLastOfferSetPrice(biddingOffer.getOfferSetPrice());
            biddingOffer.setOfferUnitPrice(null);
            biddingOffer.setOfferSetPrice(null);
            biddingOffer.setTempOfferUnitPrice(null);//临时报价单价 2018-05-18
            biddingOffer.setTempOfferSetPrice(null);//临时报价讨价 2018-05-18
            biddingOffer.setCurrentRanking(null);
            biddingOffer.setRestEffectiveNumber(biddingOffer.getEffectiveNumber());
            biddingOffer.setPromiseReducedRate(null);
            biddingOffer.setFactBarnd(null);
            biddingOffer.setFactSpec(null);
            biddingOffer.setFactModel(null);
            biddingOffer.setBiddingRoundsNumber(String.valueOf(biddingPlanList.size()));
            biddingOffer.setBiddingTotalRound(String.valueOf(biddingPlanList.size()));
            this.biddingOfferService.addObj(biddingOffer);

            if (StringUtils.isNotBlank(biddingOffer.getQuotationMethod())
                    && biddingOffer.getQuotationMethod().equals("2")) {
                for (int j = 0; CollectionUtils.isNotEmpty(biddingMatterStepSups)
                        && j < biddingMatterStepSups.size(); j++) {
                    BiddingMatterStepSup biddingMatterStepSup = biddingMatterStepSups.get(j);
                    biddingMatterStepSup.setId(null);
                    biddingMatterStepSup.setBiddingOfferId(biddingOffer.getId());
                    biddingMatterStepSup.setBiddingRoundsNumber(String.valueOf(biddingPlanList.size()));
                    biddingMatterStepSup.setBiddingTotalRound(String.valueOf(biddingPlanList.size()));
                    biddingMatterStepSup.setLastOfferPrice(biddingMatterStepSup.getOfferUnitPrice());
                    biddingMatterStepSup.setLastOfferSetPrice(biddingMatterStepSup.getOfferSetPrice());
                    biddingMatterStepSup.setOfferUnitPrice(null);
                    biddingMatterStepSup.setOfferSetPrice(null);
                    this.biddingMatterStepSupService.addObj(biddingMatterStepSup);
                }
            }
            
            
            if (StringUtils.isNotBlank(biddingOffer.getCostAnalysisId())){
            	
            	if ("material".equals(biddingOffer.getRequirementTypeCode())){
	            	//保存物料成本清单
	            	//biddingContentMatter.getCostAnalysisId()
	            	TplOrderItemDetail tpl = this.tplOrderItemDetailService.queryObjById(biddingOffer.getCostAnalysisId());
	            	IOrderItemDetailService service = tpl.getOrderItemDetailService();
	            	IOrderItemDetail detail = tpl.getOrderItemDetailClass().newInstance(); 
	            	detail.setOrderItemId(biddingOffer.getId());//报价表的ID
	            	detail.setTemplateId(biddingOffer.getCostAnalysisId());
	            	detail.setMaterialCode(biddingOffer.getProjectNo());
	            	detail.setMaterialDesc(biddingOffer.getProjectDesc());
	//            	detail.setCreateTime(new Date());
	    			detail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(detail));
	            	service.addObj(detail);
            	}
            
            	if ("die".equals(biddingOffer.getRequirementTypeCode())){
            		//保存模具成本清单
	            	TplMouldDetail tplMould = this.tplMouldDetailService.queryObjById(biddingOffer.getCostAnalysisId());
	            	IMouldDetailService service = tplMould.getMouldDetailService();
	            	MouldDetail mouldDetail = new MouldDetail();
	            	mouldDetail.setMouldId(biddingOffer.getId());//报价表的ID
	            	mouldDetail.setTemplateId(biddingOffer.getCostAnalysisId());//报价表的ID
	    			mouldDetail.setSupCompanyId(biddingOffer.getSupCompanyId());
	    			mouldDetail.setSupCompanyName(biddingOffer.getSupCompanyName());
	    			mouldDetail.setSupCompanySapCode(biddingOffer.getSupCompanySapCode());
	    			mouldDetail.setSupCompanySrmCode(biddingOffer.getSupCompanySrmCode());
	    			mouldDetail.setPurOrderId(biddingHeader.getBiddingNo());//询价单头ID，不能为空
	    			mouldDetail.setSupOrderId(biddingHeader.getBiddingNo());
	    			mouldDetail.setCreateTime(new Date());
	    			mouldDetail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(mouldDetail));
	    	        
	            	service.addObj(mouldDetail);
            	}
            }
            
        }
    }
}