package com.els.base.bidding.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.bidding.dao.BiddingPowerMapper;
import com.els.base.bidding.entity.BiddingPower;
import com.els.base.bidding.entity.BiddingPowerExample;
import com.els.base.bidding.service.BiddingPowerService;
import com.els.base.core.entity.PageView;

@Service("defaultBiddingPowerService")
public class BiddingPowerServiceImpl implements BiddingPowerService {
    @Resource
    protected BiddingPowerMapper biddingPowerMapper;

    @CacheEvict(value = { "biddingPower" }, allEntries = true)
    @Override
    public void addObj(BiddingPower t) {
        t.setCreateTime(new Date());
        this.biddingPowerMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingPower" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingPowerMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingPower" }, allEntries = true)
    @Override
    public void modifyObj(BiddingPower t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingPowerMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "biddingPower", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingPower queryObjById(String id) {
        return this.biddingPowerMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "biddingPower", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingPower> queryAllObjByExample(BiddingPowerExample example) {
        return this.biddingPowerMapper.selectByExample(example);
    }

    @Cacheable(value = "biddingPower", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingPower> queryObjByPage(BiddingPowerExample example) {
        PageView<BiddingPower> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingPowerMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingPowerExample biddingPowerExample = new BiddingPowerExample();
        biddingPowerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingPower> biddingPowerList = this.biddingPowerMapper.selectByExample(biddingPowerExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingPowerList) && i < biddingPowerList.size(); i++) {
            this.biddingPowerMapper.deleteByPrimaryKey(biddingPowerList.get(i).getId());
        }
        
    }
}