package com.els.base.bidding.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingSupplierMapper;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;

@Service("defaultBiddingSupplierService")
public class BiddingSupplierServiceImpl implements BiddingSupplierService {
    @Resource
    protected BiddingSupplierMapper biddingSupplierMapper;

    @Resource
    protected BiddingHeaderService biddingHeaderService;

    @Resource
    protected BiddingOfferService biddingOfferService;

    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;
    
    @Resource
    protected GenerateCodeService generateCodeService;

    @CacheEvict(value = { "biddingSupplier" }, allEntries = true)
    @Override
    public void addObj(BiddingSupplier t) {
        t.setCreateTime(new Date());
        // 供应商临时编码生成
        t.setSupplierTemporaryCode(this.generateCodeService.getNextCode("SUPPLIER_TEMPORARY_CODE"));
        this.biddingSupplierMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingSupplier" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingSupplierMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingSupplier" }, allEntries = true)
    @Override
    public void modifyObj(BiddingSupplier t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingSupplierMapper.updateByPrimaryKeySelective(t);
    }

    @CacheEvict(value = { "biddingSupplier" }, allEntries = true)
    @Override
    public void editStatus(BiddingSupplier record, BiddingSupplierExample example) {
        this.biddingSupplierMapper.updateByExampleSelective(record, example);
    }

    @Cacheable(value = "biddingSupplier", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingSupplier queryObjById(String id) {
        return this.biddingSupplierMapper.selectByPrimaryKey(id);
    }

    // @Cacheable(value = "biddingSupplier", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingSupplier> queryAllObjByExample(BiddingSupplierExample example) {
        return this.biddingSupplierMapper.selectByExample(example);
    }

    @Cacheable(value = "biddingSupplier", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingSupplier> queryObjByPage(BiddingSupplierExample example) {
        PageView<BiddingSupplier> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingSupplierMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierMapper
                .selectByExample(biddingSupplierExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); i++) {
            this.biddingSupplierMapper.deleteByPrimaryKey(biddingSupplierList.get(i).getId());
        }

    }

    @CacheEvict(value = { "biddingSupplier" }, allEntries = true)
    @Override
    public void modifyObjSup(BiddingSupplier biddingSupplier, BiddingSupplierExample biddingSupplierExample) {
        this.biddingSupplierMapper.updateByExampleSelective(biddingSupplier, biddingSupplierExample);
    }

    @CacheEvict(value = { "biddingSupplier" }, allEntries = true)
    @Override
    public void supEditStatus(String biddingNo, String statuType, String statu, Company company, User user) {
        // 更新的字段
        BiddingSupplier biddingSupplier = new BiddingSupplier();
        biddingSupplier.setLastUpdateTime(new Date());// 最后更新时间
        biddingSupplier.setLastUpdateUser(user.getNickName());// 供应商的最后更新人

        if (statuType.equals("A")) {// 应标状况： 0：未应标，1：已应标，2：不应标

            // 招标状态：0 未发布 1 已发布 2 招投标进行中 3 投标已结束 4 评标中 5 已评标 6 已定标 7 已作废 8 已结案 9 未应标 10 待应标 11 已应标
            // 12 拒绝应标 13 部分应标 14 全部应标
            String supBiddingStatus = "";// 供应商招标状态
            String supParticipate = "";// 供应商应标状态
            if (statu.equals("Y")) {// 应标
                supBiddingStatus = TenderStatusEumn.ISBID.getValue();// 供应商招标状态为11 已应标
                supParticipate = "1";// 供应商应标状态为1：已应标

            } else if (statu.equals("N")) {// 拒绝应标
                supBiddingStatus = TenderStatusEumn.REFUSEBID.getValue();// 供应商招标状态为12 已应标
                supParticipate = "2";// 供应商应标状态为1：已应标
            }

            // 更新逻辑：先更新供应商的招标状态、应标状态，其次再查询更新后的供应商应标数，再更新采购方的招标状态
            // 1、===========先更新供应商的招标状态===============
            biddingSupplier.setSupParticipate(supParticipate);// 应标状态

            // 供应商各自显示【已应标】
            biddingSupplier.setSupBiddingStatus(supBiddingStatus);// 招标状态

            // 根据招标单号、供应商SRM编码、供应商SAP编码三个条件，更新招标状态、应标状态
            updateBiddingStatus(biddingSupplier, biddingNo, company);

            // 2、===========再查询更新后的供应商应标数===============
            // 在供应商表，根据标单号一个条件，查询供应商的总数是否等于应标的总数，等于则全部应标，否则部分应标
            BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria createCriteria = biddingSupplierExample.createCriteria();
            createCriteria.andBiddingNoEqualTo(biddingNo);// 标单号
            // List<BiddingSupplier> totalSumList =
            // this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
            List<BiddingSupplier> totalSumList = this.biddingSupplierMapper
                    .selectByExample(biddingSupplierExample);
            int totalSum = totalSumList.size();// 招标总数
            // 根据标单号、应标状态两个条件，查询应标总数
            createCriteria.andSupBiddingStatusEqualTo(supBiddingStatus);// 供应商应标状态或拒绝应标状态
            // List<BiddingSupplier> sumList =
            // this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample);
            List<BiddingSupplier> sumList = this.biddingSupplierMapper
                    .selectByExample(biddingSupplierExample);
            int sum = sumList.size();// 该标单应标的供应商总数或拒绝应标的供应商总数

            String purBiddingStatus = "";// 采购方的招标状态
            if (statu.equals("Y")) {// 应标
                // 应标的供应商总数>=招标的供应商总数，则为全部应标，否则为部分应标。采购方显示【部分应标／全部应标】
                purBiddingStatus = (sum >= totalSum) ? TenderStatusEumn.ALLBID.getValue()
                        : TenderStatusEumn.PARTBID.getValue();// 招标状态，13 部分应标 14 全部应标

            } else if (statu.equals("N")) {// 拒绝应标
                // 拒绝应标的供应商总数>=招标的供应商总数，则为全部应标，否则为原来的部分应标状态（不更新）
                purBiddingStatus = (sum >= totalSum) ? TenderStatusEumn.ALLREFUSEBID.getValue() : null;// 招标状态，采购方显示“【全部拒绝】
            }

            // 3、===========再更新采购方的招标状态===============
            // 更新采购方主表的招标状态字段
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setLastUpdateTime(new Date());// 最后更新时间
            biddingHeader.setLastUpdateUser(user.getNickName());// 供应商的最后更新人
            biddingHeader.setBiddingStatus(purBiddingStatus);// 招标状态

            // 更新条件
            BiddingHeaderExample example = new BiddingHeaderExample();
            BiddingHeaderExample.Criteria biddingCriteria = example.createCriteria();
            biddingCriteria.andBiddingNoEqualTo(biddingNo);// 招标单号

            this.biddingHeaderService.editStatus(biddingHeader, example);

        } else if (statuType.equals("B")) {// 投标状态：0：未投标，1：已投标

            biddingSupplier.setSupBidding(statu);// 投标状态
            // 根据招标单号、供应商SRM编码、供应商SAP编码更新状态
            updateBiddingStatus(biddingSupplier, biddingNo, company);

        }
    }

    private void updateBiddingStatus(BiddingSupplier biddingSupplier, String biddingNo, Company company) {
        BiddingSupplierExample example = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria biddingCriteria = example.createCriteria();
        biddingCriteria.andBiddingNoEqualTo(biddingNo);// 招标单号
        //biddingCriteria.andSupCompanySrmCodeEqualTo(company.getCompanyCode());// srm编码
        //biddingCriteria.andSupCompanySapCodeEqualTo(company.getCompanySapCode());// sap编码
        biddingCriteria.andSupCompanyIdEqualTo(company.getId());// 供应商id

        this.biddingSupplierMapper.updateByExampleSelective(biddingSupplier, example);
    }

    @Override
    public void save(BiddingBaseVo biddingBaseVo, Company currentCompany, User loginUser) throws InstantiationException, IllegalAccessException {
        BiddingHeader biddingHeader = biddingBaseVo.getBiddingHeader();
        // 数据库已存在的供应商数据
        BiddingSupplierExample example = new BiddingSupplierExample();
        example.createCriteria().andBiddingNoEqualTo(biddingHeader.getBiddingNo());
        List<BiddingSupplier> biddingSupplierListDataBase = this.biddingSupplierMapper
                .selectByExample(example);
        // 前台传递过来的供应商数据
        List<BiddingSupplier> biddingSupplierList = biddingBaseVo.getBiddingSupplierList();
        // 待处理的数据
        List<BiddingSupplier> biddingSupplierListSave = new ArrayList<BiddingSupplier>();
        List<BiddingSupplier> biddingSupplierListUpdate = new ArrayList<BiddingSupplier>();
        List<BiddingSupplier> biddingSupplierListDelete = new ArrayList<BiddingSupplier>();

        if (CollectionUtils.isEmpty(biddingSupplierListDataBase)) {
            biddingSupplierListSave.addAll(biddingSupplierList);
        } else if(CollectionUtils.isEmpty(biddingSupplierList)){
            biddingSupplierListDelete.addAll(biddingSupplierListDataBase);
        }else{
            biddingSupplierListSave.addAll(biddingSupplierList);
            biddingSupplierListDelete.addAll(biddingSupplierListDataBase);
            for (BiddingSupplier biddingSupplier : biddingSupplierList) {
                for (BiddingSupplier supplierDataBase : biddingSupplierListDataBase) {
                    if (biddingSupplier.getSupCompanySrmCode()
                            .equals(supplierDataBase.getSupCompanySrmCode())) {
                        if (biddingSupplier.getId() == null) {
                            biddingSupplier.setId(supplierDataBase.getId());
                        }
                        biddingSupplierListUpdate.add(biddingSupplier);
                        biddingSupplierListSave.remove(biddingSupplier);
                        biddingSupplierListDelete.remove(supplierDataBase);
                    }
                }
            }
        }

        if(CollectionUtils.isNotEmpty(biddingSupplierListSave)){
            for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierListSave)
                    && i < biddingSupplierListSave.size(); i++) {
                this.biddingHeaderService.addBiddingSupplier(biddingSupplierListSave.get(i), biddingHeader,
                        currentCompany, loginUser);
            }
            this.biddingHeaderService.insertIntoOffer(biddingHeader.getId(),biddingSupplierListSave);
        }

        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierListUpdate)
                && i < biddingSupplierListUpdate.size(); i++) {
            this.biddingSupplierMapper.updateByPrimaryKeySelective(biddingSupplierListUpdate.get(i));
        }

        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierListDelete)
                && i < biddingSupplierListDelete.size(); i++) {
            this.biddingSupplierMapper.deleteByPrimaryKey(biddingSupplierListDelete.get(i).getId());
            this.biddingOfferService.deleteBySupCompanyId(biddingHeader.getBiddingNo(),
                    biddingSupplierListDelete.get(i).getSupCompanyId());
            this.biddingMatterStepSupService.deleteBySupCompanyId(biddingHeader.getBiddingNo(),
                    biddingSupplierListDelete.get(i).getSupCompanyId());
        }
    }
}