package com.els.base.bidding.utils;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryPurFile;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupplier;
import com.els.base.inquiry.entity.MouldDetail;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.detail.OrderItemDetail;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.json.DetailDeSerializer;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class BiddingContentDeSerializer extends JsonDeserializer<BiddingContent> {

    //protected TplMouldDetailService tplMouldDetailService;

    private String itemsJson;
	private String mouldJson;
	
	@SuppressWarnings("rawtypes")
	@Override
	public BiddingContent deserialize(JsonParser p, DeserializationContext ctxt)
			throws IOException, JsonProcessingException {
		BiddingContent content = new BiddingContent();
		ObjectNode objectNode = p.readValueAsTree();
		//Iterator<String> fieldNamesIterator = objectNode.fieldNames();
												
		JsonNode valueMatter = objectNode.get("biddingOfferMatterList");
		JsonNode valueModel = objectNode.get("biddingOfferModelList");
		JsonNode valueOther = objectNode.get("biddingOfferOtherList");
		
		
		List<BiddingOffer> listMatter = this.deserialize(valueMatter);
		content.setBiddingOfferMatterList(listMatter);
		
		List<BiddingOffer> listModel = this.deserialize(valueModel);
		content.setBiddingOfferModelList(listModel);
		
		List<BiddingOffer> listOther = this.deserialize(valueOther);
		content.setBiddingOfferOtherList(listOther);
		
		
		Iterator<String> fieldNamesIterator = objectNode.fieldNames();
		while (fieldNamesIterator.hasNext()) {
			String fieldName = fieldNamesIterator.next();
			JsonNode value = objectNode.get(fieldName);
		
			
			if ("biddingOfferMatterList".equals(fieldName) || "biddingOfferModelList".equals(fieldName) || "biddingOfferOtherList".equals(fieldName)) {
				// 保存itemList的值，保证解析其值在读取templateId之后
				continue;//continue是结束单次循环
			}
			//由于报错：ava.util.LinkedHashMap cannot be cast to com.els.base.bidding.entity.BiddingContentMatter，所以做一下处理
			if ("biddingContentMatterList".equals(fieldName)) {
				// 供应商用户列表，特殊处理，转成List<BiddingContentMatter>类型
				List<BiddingContentMatter> biddingContentMatterList = JsonUtils.convertCollection(value.toString(), List.class, null, BiddingContentMatter.class);
				content.setBiddingContentMatterList(biddingContentMatterList);
				continue;
			}
			//由于报错：ava.util.LinkedHashMap cannot be cast to com.els.base.bidding.entity.BiddingContentModel，所以做一下处理
			if ("biddingContentModelList".equals(fieldName)) {
				// 供应商用户列表，特殊处理，转成List<BiddingContentModel>类型
				List<BiddingContentModel> biddingContentModelList = JsonUtils.convertCollection(value.toString(), List.class, null, BiddingContentModel.class);
				content.setBiddingContentModelList(biddingContentModelList);
				continue;
			}
			
			//由于报错：ava.util.LinkedHashMap cannot be cast to com.els.base.bidding.entity.BiddingContentOther，所以做一下处理
			if ("biddingContentOtherList".equals(fieldName)) {
				// 供应商用户列表，特殊处理，转成List<BiddingContentOther>类型
				List<BiddingContentOther> biddingContentOtherList = JsonUtils.convertCollection(value.toString(), List.class, null, BiddingContentOther.class);
				content.setBiddingContentOtherList(biddingContentOtherList);
				continue;
			}
			
			Field field = null;
			// 先从本类中获取，如果获取不到则从父类中获取，父类获取不到则抛出异常提示解析询价单参数失败
			try {
				field = BiddingContent.class.getDeclaredField(fieldName);
			} catch (NoSuchFieldException e) {
				e.printStackTrace();
			}
			
			
			if(StringUtils.isNotBlank(value.toString())){
				try {
				ReflectUtils.setValue(content, fieldName, JsonUtils.convertValue(value.toString(), field.getType()));
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		
		
		return content;
		
		/*JsonNode orderItemDetailNode = objectNode.get("orderItemDetail");
		JsonNode mouldItemDetailNode = objectNode.get("mouldDetail");
		
		objectNode.remove("orderItemDetail");
		objectNode.remove("mouldDetail");
		
		BiddingOffer biddingOffer = JsonUtils.convertValue(objectNode.toString(), BiddingOffer.class);
		
		//根据成本清单ID获取对应的service
    	//IMouldDetailService service = this.tplMouldDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId()).getMouldDetailService();
    	
		//根据成本清单ID获取对应的service
    	//IOrderItemDetailService service = this.tplOrderItemDetailService.queryObjById(biddingOffer.getCostAnalysisId()).getOrderItemDetailService();
    	
		TplOrderItemDetail tplOrderItemDetail = this.tplOrderItemDetailService.queryObjById(biddingOffer.getCostAnalysisId());
		TplMouldDetail tplMouldDetail = this.tplMouldDetailService.queryObjById(biddingOffer.getCostAnalysisId());
		
		
		String jsonOrderItem = orderItemDetailNode.toString();//物料
		String jsonMould = mouldItemDetailNode.toString();//模具
		DetailDeSerializer orderItemDeSerializer = new DetailDeSerializer<>(tplOrderItemDetail.getOrderItemDetailClass());
		DetailDeSerializer mouldDeSerializer = new DetailDeSerializer<>(tplMouldDetail.getMouldDetailClass());
		
		OrderItemDetail orderItemDetail = null;
		MouldDetail mouldDetail = null;
		
		try {
			orderItemDetail = (OrderItemDetail) orderItemDeSerializer.serializer(jsonOrderItem);
			mouldDetail =  (MouldDetail) mouldDeSerializer.serializer(jsonMould);
		} catch (InstantiationException | IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		biddingOffer.setOrderItemDetail(orderItemDetail);//物料
		biddingOffer.setMouldDetail(mouldDetail);//模具
		
		return biddingOffer;*/
		
	}

	private List<BiddingOffer> deserialize(JsonNode value) throws JsonParseException, JsonMappingException, IOException {
		if(value == null || !value.isArray() ){
			return null;
			
		}
		
		ArrayNode arrayNode = (ArrayNode) value;
		if(arrayNode.size() == 0){
			return null;
		}
		List<BiddingOffer> list = new ArrayList();
		for(int i=0; i<arrayNode.size(); i++){
			JsonNode itemNode = arrayNode.get(i);
			BiddingOffer item = this.deserializeItem(itemNode);
			list.add(item);
		}
		
		return list;
	}

	private BiddingOffer deserializeItem(JsonNode objectNode1) throws JsonParseException, JsonMappingException, IOException {
		ObjectNode objectNode = (ObjectNode) objectNode1;
		
		JsonNode orderItemDetailNode = objectNode.get("orderItemDetail");
		JsonNode mouldItemDetailNode = objectNode.get("mouldDetail");
		
		objectNode.remove("orderItemDetail");
		objectNode.remove("mouldDetail");
		
		BiddingOffer biddingOffer = JsonUtils.convertValue(objectNode.toString(), BiddingOffer.class);

		TplMouldDetailService tplMouldDetailService = SpringContextHolder.getOneBean(TplMouldDetailService.class);
		
		//根据成本清单ID获取对应的service
    	//IMouldDetailService service = this.tplMouldDetailService.queryObjById(biddingOfferMatter.getCostAnalysisId()).getMouldDetailService();
    	
		//根据成本清单ID获取对应的service
    	//IOrderItemDetailService service = this.tplOrderItemDetailService.queryObjById(biddingOffer.getCostAnalysisId()).getOrderItemDetailService();
		TplOrderItemDetailService tplOrderItemDetailService = SpringContextHolder.getOneBean(TplOrderItemDetailService.class);
		TplOrderItemDetail tplOrderItemDetail = tplOrderItemDetailService.queryObjById(biddingOffer.getCostAnalysisId());
		TplMouldDetail tplMouldDetail = tplMouldDetailService.queryObjById(biddingOffer.getCostAnalysisId());
		
		
		String jsonOrderItem = orderItemDetailNode.toString();//物料
		String jsonMould = mouldItemDetailNode.toString();//模具
		
		
		
		//OrderItemDetail orderItemDetail = null;
		IOrderItemDetail orderItemDetail = null;
		IMouldDetail mouldDetail = null;
		
		try {
			if(tplOrderItemDetail!=null){
				DetailDeSerializer orderItemDeSerializer = new DetailDeSerializer<>(tplOrderItemDetail.getOrderItemDetailClass());
				//orderItemDetail = (OrderItemDetail) orderItemDeSerializer.serializer(jsonOrderItem);
				orderItemDetail = (IOrderItemDetail) orderItemDeSerializer.serializer(jsonOrderItem);
				biddingOffer.setOrderItemDetail(orderItemDetail);
			}
			if(tplMouldDetail!=null){
				DetailDeSerializer mouldDeSerializer = new DetailDeSerializer<>(tplMouldDetail.getMouldDetailClass());
				mouldDetail =  (IMouldDetail) mouldDeSerializer.serializer(jsonMould);
				biddingOffer.setMouldDetail(mouldDetail);
			}
			
		} catch (InstantiationException | IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return biddingOffer;
		
		/*BiddingOffer biddingOffer = new BiddingOffer();
		
		Iterator<String> fieldNamesIterator = objectNode.fieldNames();
		while (fieldNamesIterator.hasNext()) {
			String fieldName = fieldNamesIterator.next();
			JsonNode value = objectNode.get(fieldName);
		
			
			if ("orderItemDetail".equals(fieldName)) {
				// 保存itemList的值，保证解析其值在读取templateId之后
				itemsJson = value.toString();
				continue;
			}
			
			if ("mouldDetail".equals(fieldName)) {
				// 保存itemList的值，保证解析其值在读取templateId之后
				mouldJson = value.toString();
				continue;
			}
			
			Field field = null;
			// 先从本类中获取，如果获取不到则从父类中获取，父类获取不到则抛出异常提示解析询价单参数失败
			try {
				field = BiddingOffer.class.getDeclaredField(fieldName);
			} catch (NoSuchFieldException e) {
				e.printStackTrace();
			}
			
			if(StringUtils.isNotBlank(value.toString())){
				try {
				ReflectUtils.setValue(biddingOffer, fieldName, JsonUtils.convertValue(value.toString(), field.getType()));
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		
		
		if (StringUtils.isNotBlank(itemsJson)) {
			//TemplateConf templateConf = this.geTemplateConf(order);
			//Class<? extends IOrderItem> clazz = templateConf.getOrderItemClass();
			Class<? extends IOrderItemDetail> clazz = this.tplOrderItemDetailService.queryObjById(biddingOffer.getCostAnalysisId()).getOrderItemDetailClass();
//			JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametrizedType(List.class, null, clazz);
//			List<IOrderItemDetail> items = JsonUtils.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(itemsJson, javaType);
			IOrderItemDetail items = JsonUtils.convertValue(itemsJson, clazz);
			biddingOffer.setOrderItemDetail(items);
		}
		
		if (StringUtils.isNotBlank(mouldJson)) {
			
			Class<? extends IMouldDetail> clazz = this.tplMouldDetailService.queryObjById(biddingOffer.getCostAnalysisId()).getMouldDetailClass();
			IMouldDetail items = JsonUtils.convertValue(mouldJson, clazz);
			biddingOffer.setMouldDetail(items);
		}
		
		return biddingOffer;*/
	}
}
