package com.els.base.bidding.utils;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.vo.SaveBidInfoVo;
import com.els.base.bidding.entity.vo.TemporaryCodeReducedRate;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryPurFile;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupplier;
import com.els.base.inquiry.entity.MouldDetail;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.detail.OrderItemDetail;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.json.DetailDeSerializer;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class SaveBidInfoVoDeSerializer extends JsonDeserializer<SaveBidInfoVo> {

	@SuppressWarnings("rawtypes")
	@Override
	public SaveBidInfoVo deserialize(JsonParser p, DeserializationContext ctxt)
			throws IOException, JsonProcessingException {
		SaveBidInfoVo saveBidInfoVo = new SaveBidInfoVo();
		ObjectNode objectNode = p.readValueAsTree();
		//Iterator<String> fieldNamesIterator = objectNode.fieldNames();
												
		JsonNode biddingOfferList = objectNode.get("biddingOfferList");
//		JsonNode codeReducedRatesList = objectNode.get("codeReducedRates");
		
		
		List<BiddingOffer> listMatter = this.deserialize(biddingOfferList);
		saveBidInfoVo.setBiddingOfferList(listMatter);
		
//		List<SaveBidInfoVo> listModel = this.deserialize(codeReducedRatesList);
//		content.setCodeReducedRates(listModel);
		
		Iterator<String> fieldNamesIterator = objectNode.fieldNames();
		while (fieldNamesIterator.hasNext()) {
			String fieldName = fieldNamesIterator.next();
			JsonNode value = objectNode.get(fieldName);
		
			
			if ("biddingOfferList".equals(fieldName)) {
				// biddingOfferList已经在上面处理，所以这里跳过
				continue;//continue是结束单次循环
			}
			
			//由于报错：ava.util.LinkedHashMap cannot be cast to com.els.base.bidding.entity.BiddingContentOther，所以做一下处理
			if ("codeReducedRates".equals(fieldName)) {
				// 供应商用户列表，特殊处理，转成List<BiddingContentOther>类型
				List<TemporaryCodeReducedRate> TemporaryCodeReducedRateList = JsonUtils.convertCollection(value.toString(), List.class, null, TemporaryCodeReducedRate.class);
				saveBidInfoVo.setCodeReducedRates(TemporaryCodeReducedRateList);
				continue;
			}
			
			Field field = null;
			// 先从本类中获取，如果获取不到则从父类中获取，父类获取不到则抛出异常提示解析询价单参数失败
			try {
				//field = BiddingContent.class.getDeclaredField(fieldName);
				field = SaveBidInfoVo.class.getDeclaredField(fieldName);
			} catch (NoSuchFieldException e) {
				e.printStackTrace();
			}
			
			
			if(StringUtils.isNotBlank(value.toString())){
				try {
				ReflectUtils.setValue(saveBidInfoVo, fieldName, JsonUtils.convertValue(value.toString(), field.getType()));
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return saveBidInfoVo;
	}

	private List<BiddingOffer> deserialize(JsonNode value) throws JsonParseException, JsonMappingException, IOException {
		if(value == null || !value.isArray() ){
			return null;
		}
		
		ArrayNode arrayNode = (ArrayNode) value;
		if(arrayNode.size() == 0){
			return null;
		}
		List<BiddingOffer> list = new ArrayList();
		for(int i=0; i<arrayNode.size(); i++){
			JsonNode itemNode = arrayNode.get(i);
			BiddingOffer item = this.deserializeItem(itemNode);
			list.add(item);
		}
		return list;
	}

	private BiddingOffer deserializeItem(JsonNode objectNode1) throws JsonParseException, JsonMappingException, IOException {
		ObjectNode objectNode = (ObjectNode) objectNode1;
		
		JsonNode orderItemDetailNode = objectNode.get("orderItemDetail");
		JsonNode mouldItemDetailNode = objectNode.get("mouldDetail");
		
		objectNode.remove("orderItemDetail");
		objectNode.remove("mouldDetail");
		
		BiddingOffer biddingOffer = JsonUtils.convertValue(objectNode.toString(), BiddingOffer.class);
		TplOrderItemDetailService tplOrderItemDetailService = SpringContextHolder.getOneBean(TplOrderItemDetailService.class);
		TplOrderItemDetail tplOrderItemDetail = tplOrderItemDetailService.queryObjById(biddingOffer.getCostAnalysisId());
		TplMouldDetailService tplMouldDetailService = SpringContextHolder.getOneBean(TplMouldDetailService.class);
		TplMouldDetail tplMouldDetail = tplMouldDetailService.queryObjById(biddingOffer.getCostAnalysisId());
		
		
		String jsonOrderItem = orderItemDetailNode.toString();//物料
		String jsonMould = mouldItemDetailNode.toString();//模具
		
		
		
		//OrderItemDetail orderItemDetail = null;
		IOrderItemDetail orderItemDetail = null;
		IMouldDetail mouldDetail = null;
		
		try {
			if(tplOrderItemDetail!=null){
				DetailDeSerializer orderItemDeSerializer = new DetailDeSerializer<>(tplOrderItemDetail.getOrderItemDetailClass());
				//orderItemDetail = (OrderItemDetail) orderItemDeSerializer.serializer(jsonOrderItem);
				orderItemDetail = (IOrderItemDetail) orderItemDeSerializer.serializer(jsonOrderItem);
				biddingOffer.setOrderItemDetail(orderItemDetail);
			}
			if(tplMouldDetail!=null){
				DetailDeSerializer mouldDeSerializer = new DetailDeSerializer<>(tplMouldDetail.getMouldDetailClass());
				mouldDetail =  (IMouldDetail) mouldDeSerializer.serializer(jsonMould);
				biddingOffer.setMouldDetail(mouldDetail);
			}
			
		} catch (InstantiationException | IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return biddingOffer;
		
	}
}
