package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingBond;
import com.els.base.bidding.entity.BiddingBondExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.service.BiddingBondService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;

@Api(value = "保证金")
@Controller
@RequestMapping("biddingBond")
public class BiddingBondController {
    @Resource
    protected BiddingBondService biddingBondService;

    @Resource
    protected BiddingSupplierService biddingSupplierService;

    @ApiOperation(httpMethod = "POST", value = "创建保证金")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingBond biddingBond) {
        this.biddingBondService.addObj(biddingBond);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑保证金")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingBond biddingBond) {
        Assert.isNotBlank(biddingBond.getId(), "id 为空，保存失败");
        this.biddingBondService.modifyObj(biddingBond);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除保证金")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingBondService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询保证金")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingBond", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingBond>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingBondExample example = new BiddingBondExample();
        example.setPageView(new PageView<BiddingBond>(pageNo, pageSize));

        // BiddingBondExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingBond> pageData = this.biddingBondService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "供应商-编辑保证金")
    @RequestMapping("service/editSup")
    @ResponseBody
    public ResponseResult<String> saveBiddingInfo(@RequestBody BiddingBond biddingBond) {
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();

        if (StringUtils.isBlank(biddingBond.getBiddingNo())) {
            throw new CommonException("招标单号为空，保存失败", "base_canot_be_null", "招标单号");
        }
        if (StringUtils.isBlank(biddingBond.getAttachmentSup())) {
            throw new CommonException("保证金附件地址为空，保存失败", "base_canot_be_null", "保证金附件地址");
        }

        /*
         * BiddingBond bond =new BiddingBond(); bond.setBiddingNo(biddingBond.getBiddingNo()); //标单号
         * bond.setSupCompanySapCode(biddingBond.getSupCompanySapCode()); //供应商SAP编码
         * bond.setOpenBankAddress(biddingBond.getAttachmentSup()); //保证金上传地址
         * 
         * //更新条件 BiddingBondExample example = new BiddingBondExample(); BiddingBondExample.Criteria
         * criteria= example.createCriteria();
         * criteria.andBiddingNoEqualTo(biddingBond.getBiddingNo());
         * criteria.andSupCompanySapCodeEqualTo(biddingBond.getSupCompanySapCode());
         * 
         * this.biddingBondService.modifyObjSup(bond,example);//保证金上传地址更新
         */

        BiddingSupplier biddingSupplier = new BiddingSupplier();
        biddingSupplier.setBankAttachment(biddingBond.getAttachmentSup());// 保证金上传地址

        // 更新条件
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria criteria = biddingSupplierExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingBond.getBiddingNo());
        //criteria.andSupCompanySapCodeEqualTo(company.getCompanySapCode()); 把编码替换为id
        criteria.andSupCompanyIdEqualTo(company.getId());

        this.biddingSupplierService.modifyObjSup(biddingSupplier, biddingSupplierExample);

        List<BiddingSupplier> supList = this.biddingSupplierService
                .queryAllObjByExample(biddingSupplierExample);
        // String
        // otherInfo="标单号【"+biddingBond.getBiddingNo()+"】对应的供应商【"+company.getCompanyCode()+"】,已上传保证金缴纳截图，请注意查收！";

        Map<String, Object> msg = new HashMap<String, Object>();
        msg.put("biddingBond", biddingBond);
        msg.put("company", company);

        // 发送消息提醒
        if (CollectionUtils.isNotEmpty(supList)) {
            Message<Map<String, Object>> message = Message.init(msg)
            		.setCompanyCode(company.getCompanyCode())// 发送者公司SRM编码
                    .setSenderId(user.getId())// 发送者 userId
                    .addReceiverId(supList.get(0).getPurUserId())// 接受者 userId
                    .setBusinessTypeCode("BIDDING_SUP_NOTICE")// 业务类型
                    .setMsgLevel(MessageLevelEnum.HIGH);// 消息等级
            MessageSendUtils.sendMessage(message);
        }

        return ResponseResult.success();

    }
}