package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.bidding.entity.BiddingContactInfo;
import com.els.base.bidding.entity.BiddingContactInfoExample;
import com.els.base.bidding.service.BiddingContactInfoService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

@Api(value = "联系信息")
@Controller
@RequestMapping("biddingContactInfo")
public class BiddingContactInfoController {
    @Resource
    protected BiddingContactInfoService biddingContactInfoService;

    @ApiOperation(httpMethod = "POST", value = "创建联系信息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingContactInfo biddingContactInfo) {
        this.biddingContactInfoService.addObj(biddingContactInfo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑联系信息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingContactInfo biddingContactInfo) {
        Assert.isNotBlank(biddingContactInfo.getId(), "id 为空，保存失败");
        this.biddingContactInfoService.modifyObj(biddingContactInfo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除联系信息")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingContactInfoService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询联系信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingContactInfo", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingContactInfo>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingContactInfoExample example = new BiddingContactInfoExample();
        example.setPageView(new PageView<BiddingContactInfo>(pageNo, pageSize));

        // BiddingContactInfoExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingContactInfo> pageData = this.biddingContactInfoService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}