package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import jxl.write.WritableWorkbook;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentExample;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;

@Api(value = "招标内容")
@Controller
@RequestMapping("biddingContent")
public class BiddingContentController {
    @Resource
    protected BiddingContentService biddingContentService;

    @Resource
    protected BiddingContentMatterService biddingContentMatterService;

    @Resource
    protected MaterialService materialService;
    
    @Resource
    protected MouldService mouldService;
    
    @ApiOperation(httpMethod = "POST", value = "创建招标内容")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingContent biddingContent) {
        this.biddingContentService.addObj(biddingContent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑招标内容")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingContent biddingContent) {
        Assert.isNotBlank(biddingContent.getId(), "id 为空，保存失败");
        this.biddingContentService.modifyObj(biddingContent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除招标内容")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingContentService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询招标内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingContent", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingContent>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingContentExample example = new BiddingContentExample();
        example.setPageView(new PageView<BiddingContent>(pageNo, pageSize));

        // BiddingContentExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingContent> pageData = this.biddingContentService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "招标内容导出excel")
    @RequestMapping("service/downloadExcelBidding")
    @ResponseBody
    public ModelAndView downloadExcelBidding(@RequestParam(required = true) String type,
            HttpServletResponse response) {
        try {
            String name = null;
            if (type.equals("material")) {
                name = "物料类招标";
            }
            if (type.equals("mould")) {
                name = "模具类招标";
            }
            if (type.equals("device")) {
                name = "其他类招标";
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode(name + ".xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = getTitleAndModelKeys(type);
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    null, name, null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @ApiOperation(value = "招标内容物料excel导入", httpMethod = "POST")
    @RequestMapping(value = "service/uploadMaterialExcel")
    @ResponseBody
    public ResponseResult<List<BiddingContentMatter>> uploadMaterialExcel(
            MultipartHttpServletRequest request, @RequestParam(required = true) String type) throws IOException, Exception {
        List<BiddingContentMatter> importExcelDataToMap = new ArrayList<BiddingContentMatter>();
        //try {
            Map<String, MultipartFile> fileMap = request.getFileMap();
            MultipartFile file = this.vaildFile(fileMap);

            List<TitleAndModelKey> titleAndModelKeys = getTitleAndModelKeys(type);
            importExcelDataToMap = ExcelUtils.importExcelDataToMap(file.getInputStream(), 0, 1, 0,
                    titleAndModelKeys, BiddingContentMatter.class);
            for (int i = 0; CollectionUtils.isNotEmpty(importExcelDataToMap)
                    && i < importExcelDataToMap.size(); i++) {
                Long dosage = importExcelDataToMap.get(i).getDosage() == null ? 0 : importExcelDataToMap.get(
                        i).getDosage();
                BigDecimal unitPrice = importExcelDataToMap.get(i).getUnitPrice() == null ? BigDecimal.ZERO
                        : importExcelDataToMap.get(i).getUnitPrice();
                // BigDecimal multiply = unitPrice.multiply(new BigDecimal(dosage));
                // if(multiply.compareTo(BigDecimal.ZERO)==0){
                // multiply=null;
                // }
                importExcelDataToMap.get(i).setSetThePrice(unitPrice.multiply(new BigDecimal(dosage)));
                
                //2018-05-09 增加导入的物料物料或模具编码在系统中是否存在，其他页签的不做校验
                if (type.equals("material")) {
                	/*if(StringUtils.isNotBlank(importExcelDataToMap.get(i).getMaterialNo())){
                		boolean isExists = this.materialService.isExists(importExcelDataToMap.get(i).getMaterialNo());
                		if(isExists==false){
                			//finish_status 格式为 {0}
                			String str="导入失败！第"+(i+2)+"条的物料编号【" + importExcelDataToMap.get(i).getMaterialNo()+ "】在系统中不存,请核对后再导入！";
                	        throw new CommonException("编码不存在不能操作", "finish_status",str);
                	        
                		}
                	}*/
                	if(StringUtils.isNotBlank(importExcelDataToMap.get(i).getMaterialNo())){
                		//模具信息
	                	MaterialExample materialExample = new MaterialExample();
	                	materialExample.createCriteria().andMaterialCodeEqualTo(importExcelDataToMap.get(i).getMaterialNo());
	                    List<Material> materialList = this.materialService.queryAllObjByExample(materialExample);
	                    // 基本信息一个标单号只能查询到一条记录，此处的for循环没有实际意义，只是为了使用生成好的代码（不自己去写代码查询一条记录的方法）
	                    if( materialList.size() > 0 ){
	                    	//物料名称、物料描述取查询出来的值
                			importExcelDataToMap.get(i).setMaterialName(materialList.get(0).getMaterialName());
                			importExcelDataToMap.get(i).setMaterialDesc(materialList.get(0).getDescription());
                			
                		}else{
                			//finish_status 格式为 {0}
                			String str="导入失败！第"+(i+2)+"行的物料编号【" + importExcelDataToMap.get(i).getMaterialNo()+ "】在系统中不存在,请核对后再导入！";
                			throw new CommonException("物料编码不存在不能操作", "finish_status",str);
                			
                		}
                	}
                }
            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new CommonException("导入异常：" + e.getMessage());
//        }

        return ResponseResult.success(importExcelDataToMap);
    }

    @ApiOperation(value = "招标内容模具excel导入", httpMethod = "POST")
    @RequestMapping(value = "service/uploadMouldExcel")
    @ResponseBody
    public ResponseResult<List<BiddingContentModel>> uploadMouldExcel(MultipartHttpServletRequest request,
            @RequestParam(required = true) String type) throws IOException, Exception {
        List<BiddingContentModel> importExcelDataToMap = new ArrayList<BiddingContentModel>();
//        try {
            Map<String, MultipartFile> fileMap = request.getFileMap();
            MultipartFile file = this.vaildFile(fileMap);

            List<TitleAndModelKey> titleAndModelKeys = getTitleAndModelKeys(type);
            importExcelDataToMap = ExcelUtils.importExcelDataToMap(file.getInputStream(), 0, 1, 0,
                    titleAndModelKeys, BiddingContentModel.class);
            
            for (int i = 0; CollectionUtils.isNotEmpty(importExcelDataToMap)
                    && i < importExcelDataToMap.size(); i++) {
            	
            
	            if (type.equals("mould")) {
	            	if(StringUtils.isNotBlank(importExcelDataToMap.get(i).getModelNo())){
	                	//模具信息
	            		MouldExample mouldExample = new MouldExample();
	            		mouldExample.createCriteria().andMouldCodeEqualTo(importExcelDataToMap.get(i).getModelNo());
	                    List<Mould> mouldList = this.mouldService.queryAllObjByExample(mouldExample);
	                    // 基本信息一个标单号只能查询到一条记录，此处的for循环没有实际意义，只是为了使用生成好的代码（不自己去写代码查询一条记录的方法）
	                    if(mouldList.size() > 0){
	                    	//模具描述取查询出来的值
	            			importExcelDataToMap.get(i).setModelDesc(mouldList.get(0).getMouldDesc());//模具描述
	            			importExcelDataToMap.get(i).setUseModel(mouldList.get(0).getMouldModel());//模具机型
	            			importExcelDataToMap.get(i).setModelSerialNumber(mouldList.get(0).getMouldSerialNumber());//模具序号
	            			//importExcelDataToMap.get(i).setBeloneYear(mouldList.get(0).getBelongedYear());//所属年份
	            			importExcelDataToMap.get(i).setModelMaterial(mouldList.get(0).getMouldMaterial());//模具材料
	            			importExcelDataToMap.get(i).setModelLife(mouldList.get(0).getMouldLifetime().toString());//模具寿命
	            			importExcelDataToMap.get(i).setPropertyRight(mouldList.get(0).getMouldPropertyRightState());//产权状况
	            			importExcelDataToMap.get(i).setModelSinking(mouldList.get(0).getMouldAscription());//开模归属
	            			importExcelDataToMap.get(i).setMaterialNo(mouldList.get(0).getMouldMaterialCode());//模具物料编码
	            	        
	            		}else{
	            			
	            			//finish_status 格式为 {0}
	            			String str="导入失败！第"+(i+2)+"行的模具编码【" + importExcelDataToMap.get(i).getModelNo()+ "】在系统中不存在,请核对后再导入！";
	            	        throw new CommonException("模具编码不存在不能操作", "finish_status",str);
	            	        
	            		}
	            	}
	            }
        }
            
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new CommonException("导入异常：" + e.getMessage());
//        }

        return ResponseResult.success(importExcelDataToMap);
    }

    @ApiOperation(value = "招标内容其他excel导入", httpMethod = "POST")
    @RequestMapping(value = "service/uploadOtherExcel")
    @ResponseBody
    public ResponseResult<List<BiddingContentOther>> uploadOtherExcel(MultipartHttpServletRequest request,
            @RequestParam(required = true) String type) throws IOException, Exception {
        List<BiddingContentOther> importExcelDataToMap = new ArrayList<BiddingContentOther>();
//        try {
            Map<String, MultipartFile> fileMap = request.getFileMap();
            MultipartFile file = this.vaildFile(fileMap);

            List<TitleAndModelKey> titleAndModelKeys = getTitleAndModelKeys(type);
            importExcelDataToMap = ExcelUtils.importExcelDataToMap(file.getInputStream(), 0, 1, 0,
                    titleAndModelKeys, BiddingContentOther.class);
            for (int i = 0; CollectionUtils.isNotEmpty(importExcelDataToMap) 
            		&& i < importExcelDataToMap.size(); i++) {
            	if (StringUtils.isNotBlank(importExcelDataToMap.get(i).getMaterialNo())) {
            		MaterialExample materialExample = new MaterialExample();
            		materialExample.createCriteria()
            		.andMaterialCodeEqualTo(importExcelDataToMap.get(i).getMaterialNo());
            		List<Material> materialList = this.materialService.queryAllObjByExample(materialExample);
            		if( materialList.size() == 0 ){
            			//finish_status 格式为 {0}
            			String str="导入失败！第"+(i+2)+"行的物料编号【" + importExcelDataToMap.get(i).getMaterialNo()+ "】在系统中不存在,请核对后再导入！";
            			throw new CommonException("物料编号不存在不能操作", "finish_status",str);
            		}
            	}
            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new CommonException("导入异常：" + e.getMessage());
//        }

        return ResponseResult.success(importExcelDataToMap);
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("只接受单个文件导入");
        }

        Set<String> fileKeySet = fileMap.keySet();// 获取所有的key集合

        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        return file;
    }

    private List<TitleAndModelKey> getTitleAndModelKeys(String type) {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        if (type.equals("material")) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编号", "materialNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料名称", "materialName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("指定品牌", "materialFeatures"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("指定规格", "materialSpec"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("指定型号", "materialModel"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单位", "unit"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("招标数量", "biddingQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("用量", "dosage"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价格单位", "priceUnit"));
        }
        if (type.equals("mould")) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("模具编码", "modelNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("模具描述", "modelDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("模具物料编码", "materialNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("使用机型", "useModel"));
            TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("所属年份", "beloneYear");
            DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey2.setToObjConverter(dateConverter2);
            titleAndModelKey2.setToStrConverter(dateConverter2);
            titleAndModelKeys.add(titleAndModelKey2);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("模具序号", "modelSerialNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("模具材料", "modelMaterial"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("模具寿命", "modelLife"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("产权状况", "propertyRight"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("开模归属", "modelSinking"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价格单位", "priceUnit"));
        }
        if (type.equals("device")) {
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编号", "materialNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("标的编码", "targetNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("标的描述", "taregtDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("标的名称", "targetName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单位", "unit"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价格单位", "priceUnit"));
        }
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("目标单价(不含税单价)", "unitPrice"));
        //titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "remark"));
        return titleAndModelKeys;
    }
}