package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

@Api(value = "模具类招标")
@Controller
@RequestMapping("biddingContentModel")
public class BiddingContentModelController {
    @Resource
    protected BiddingContentModelService biddingContentModelService;

    @ApiOperation(httpMethod = "POST", value = "创建模具类招标")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingContentModel biddingContentModel) {
        this.biddingContentModelService.addObj(biddingContentModel);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑模具类招标")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingContentModel biddingContentModel) {
        Assert.isNotBlank(biddingContentModel.getId(), "id 为空，保存失败");
        this.biddingContentModelService.modifyObj(biddingContentModel);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除模具类招标")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingContentModelService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询模具类招标")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingContentModel", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingContentModel>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingContentModelExample example = new BiddingContentModelExample();
        example.setPageView(new PageView<BiddingContentModel>(pageNo, pageSize));

        // BiddingContentModelExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingContentModel> pageData = this.biddingContentModelService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod = "POST", value = "根据主键查询模具信息")
    @RequestMapping("service/queryObjById")
    @ResponseBody
    public ResponseResult<BiddingContentModel> queryObjById(String id) {
        return ResponseResult.success(this.biddingContentModelService.queryObjById(id));
    }
}