package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

@Api(value = "其他类招标")
@Controller
@RequestMapping("biddingContentOther")
public class BiddingContentOtherController {
    @Resource
    protected BiddingContentOtherService biddingContentOtherService;

    @ApiOperation(httpMethod = "POST", value = "创建其他类招标")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingContentOther biddingContentOther) {
        this.biddingContentOtherService.addObj(biddingContentOther);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑其他类招标")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingContentOther biddingContentOther) {
        Assert.isNotBlank(biddingContentOther.getId(), "id 为空，保存失败");
        this.biddingContentOtherService.modifyObj(biddingContentOther);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除其他类招标")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingContentOtherService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询其他类招标")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingContentOther", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingContentOther>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingContentOtherExample example = new BiddingContentOtherExample();
        example.setPageView(new PageView<BiddingContentOther>(pageNo, pageSize));

        // BiddingContentOtherExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingContentOther> pageData = this.biddingContentOtherService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}