package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingFileSupplier;
import com.els.base.bidding.entity.BiddingFileSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.service.BiddingFileSupplierService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

@Api(value="招标文件回签")
@Controller
@RequestMapping("biddingFileSupplier")
public class BiddingFileSupplierController {
    @Resource
    protected BiddingFileSupplierService biddingFileSupplierService;

    @ApiOperation(httpMethod="POST", value="创建招标文件回签")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingFileSupplier biddingFileSupplier) {
        this.biddingFileSupplierService.addObj(biddingFileSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑招标文件回签")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingFileSupplier biddingFileSupplier) {
        Assert.isNotBlank(biddingFileSupplier.getId(), "id 为空，保存失败");
        this.biddingFileSupplierService.modifyObj(biddingFileSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除招标文件回签")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingFileSupplierService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询招标文件回签")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingFileSupplier", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingFileSupplier>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        BiddingFileSupplierExample example = new BiddingFileSupplierExample();
        example.setPageView(new PageView<BiddingFileSupplier>(pageNo, pageSize));
        
        //        BiddingFileSupplierExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<BiddingFileSupplier> pageData = this.biddingFileSupplierService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod = "POST", value = "供应商回签文件上传保存")
    @RequestMapping("service/saveFileSupplier")
    @ResponseBody
    public ResponseResult<BiddingBaseVo> saveFileSupplier(@RequestBody BiddingBaseVo biddingBaseVo) {

        if (CollectionUtils.isEmpty(biddingBaseVo.getBiddingFileSupplier())) {
            throw new CommonException("列表数据为空，保存失败", "base_canot_be_null", "回签列表数据");
        }

        biddingBaseVo.setCompany(CompanyUtils.currentCompany());
        biddingBaseVo.setUser(SpringSecurityUtils.getLoginUser());
        // this.biddingHeaderService.saveBiddingInfo(biddingBaseVo);
        this.biddingFileSupplierService.saveFileSupplier(biddingBaseVo);
        return ResponseResult.success(biddingBaseVo);
    }
}