package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.ManagementPage;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;

@Api(value = "招投标-基本信息")
@Controller
@RequestMapping("biddingHeader")
public class BiddingHeaderController {
    @Resource
    protected BiddingHeaderService biddingHeaderService;

    @Resource
    protected BiddingContentService biddingContentService;

    @Resource
    protected BiddingSupplierService biddingSupplierService;

    @ApiOperation(httpMethod = "POST", value = "创建招投标-基本信息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingHeader biddingHeader) {
        this.biddingHeaderService.addObj(biddingHeader);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑招投标-基本信息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingHeader biddingHeader) {
        Assert.isNotBlank(biddingHeader.getId(), "id 为空，保存失败");
        this.biddingHeaderService.modifyObj(biddingHeader);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除招投标-基本信息")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingHeaderService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询招投标-基本信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingHeader", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingHeader>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingHeaderExample example = new BiddingHeaderExample();
        example.setPageView(new PageView<BiddingHeader>(pageNo, pageSize));
        // BiddingHeaderExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingHeader> pageData = this.biddingHeaderService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "保存招投标单据信息")
    @RequestMapping("service/saveBiddingInfo")
    @ResponseBody
    public ResponseResult<BiddingBaseVo> saveBiddingInfo(@RequestBody BiddingBaseVo biddingBaseVo) {
        biddingBaseVo.setCompany(CompanyUtils.currentCompany());
        biddingBaseVo.setUser(SpringSecurityUtils.getLoginUser());
        this.biddingHeaderService.saveBiddingInfo(biddingBaseVo);
        return ResponseResult.success(biddingBaseVo);
    }

    @ApiOperation(httpMethod = "POST", value = "查询招投标管理页面(采购方)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingHeader", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findManagementByPageForPur")
    @ResponseBody
    public ResponseResult<PageView<ManagementPage>> findManagementByPageForPur(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        String[] split = null;
        QueryParam confirgStatus = null;
        for (int i = 0; wapper != null && CollectionUtils.isNotEmpty(wapper.getQueryParams())
                && i < wapper.getQueryParams().size(); i++) {
            if (wapper.getQueryParams().get(i).getProperty().equals("biddingStatus")) {
                confirgStatus = wapper.getQueryParams().get(i);
                String value = confirgStatus.getValue();
                String b = value.replaceAll("[\\[\\]]", "");
                if (StringUtils.isNotBlank(b)) {
                    String all = b.replaceAll("\"([^\"]*)\"", "$1");
                    split = all.split(",");
                }
                break;
            }
        }
        if (confirgStatus != null) {
            wapper.getQueryParams().remove(confirgStatus);
        }
        List<String> biddingStatusList = new ArrayList<String>();
        if (split != null && split.length != 0) {
            for (String string : split) {
                biddingStatusList.add(string);
            }
        }
        BiddingHeaderExample example = new BiddingHeaderExample();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        // 查询基本信息
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderService.queryAllObjByExample(example);
        // 根据基本信息组装招标主页面数据
        // 角色信息
        List<Role> loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        List<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(loginUserRoleList) && i < loginUserRoleList.size(); i++) {
            roleCodeList.add(loginUserRoleList.get(i).getRoleCode());
        }
        List<ManagementPage> list = this.biddingHeaderService.transform(biddingHeaderList,
                SpringSecurityUtils.getLoginUser(), roleCodeList);

    	//筛选出当前创建人创建的数据
        //使用lambda表达式过滤出结果并放到result列表里
        List<ManagementPage> result = list.stream()
        		.filter((ManagementPage m)-> "1".contains(m.getCurrentUserCreate()))
        		.collect(Collectors.toList());
        
        // 招标状态查询条件筛选
        //List<ManagementPage> finalList = this.biddingHeaderService.screenDataByBiddingStatus(list,biddingStatusList);
        List<ManagementPage> finalList = this.biddingHeaderService.screenDataByBiddingStatus(result,biddingStatusList);
        // 给页面数据分页
        PageView<ManagementPage> page = new PageView<ManagementPage>(pageNo, pageSize);
        page.setRowCount(CollectionUtils.isEmpty(finalList) ? 0 : finalList.size());
        page.setQueryResult(finalList.subList(page.getStartRowNo(), page.getEndRowNo()));

        return ResponseResult.success(page);
    }

    @ApiOperation(httpMethod = "POST", value = "查询招投标管理页面(供应商)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingHeader", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findManagementByPageForSup")
    @ResponseBody
    public ResponseResult<PageView<ManagementPage>> findManagementByPageForSup(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {

        String[] split = new String[] {};
        QueryParam confirgStatus = null;
        for (int i = 0; wapper != null && CollectionUtils.isNotEmpty(wapper.getQueryParams())
                && i < wapper.getQueryParams().size(); i++) {
            if (wapper.getQueryParams().get(i).getProperty().equals("biddingStatus")) {
                confirgStatus = wapper.getQueryParams().get(i);// 获取界面传入的状态状态值，格式["10","11","12"]
                String value = confirgStatus.getValue();
                String b = value.replaceAll("[\\[\\]]", "");
                String b2 = b.replaceAll("\"", "");// 去空值
                if (StringUtils.isNotBlank(b2)) {
                    split = b2.split(",");
                }
                break;
            }
        }
        if (confirgStatus != null) {
            wapper.getQueryParams().remove(confirgStatus);// 移除招标状态条件
        }
        List<String> biddingStatusList = new ArrayList<String>();
        if (split.length > 0) {
            biddingStatusList = Arrays.asList(split);// 把传过来的查询条件动态封装成list
        }

        List<String> listStatus = new ArrayList<String>();
        listStatus.add(TenderStatusEumn.BIDDING.getValue());// 2 招投标进行中
        listStatus.add(TenderStatusEumn.BIDDINGEND.getValue());// 3 投标已结束
        listStatus.add(TenderStatusEumn.INBID.getValue());// 4 评标中
        listStatus.add(TenderStatusEumn.BIDOVER.getValue());// 5 已评标
        listStatus.add(TenderStatusEumn.ISSCALING.getValue());// 6 已定标
        listStatus.add(TenderStatusEumn.ISCANCEL.getValue());// 7 已作废
        listStatus.add(TenderStatusEumn.ISFINISH.getValue());// 8 已结案
        listStatus.add(TenderStatusEumn.WAITBID.getValue());// 10 待应标
        listStatus.add(TenderStatusEumn.ISBID.getValue());// 11 已应标
        listStatus.add(TenderStatusEumn.REFUSEBID.getValue());// 12 拒绝应标
        // 根据招标状态，供应商SAP编码查询出当前供应商对应的招标单据(排除采购方未发布的单据)
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria criteriaStatus = biddingSupplierExample.createCriteria();
        // criteriaStatus.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());//
        // SAP编码
        criteriaStatus.andSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());// 供应商id
        criteriaStatus.andSupBiddingStatusIn(listStatus);// 招标状态

        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService
                .queryAllObjByExample(biddingSupplierExample);
        List<String> biddingNoList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); i++) {
            biddingNoList.add(biddingSupplierList.get(i).getBiddingNo());
        }

        // PageView<BiddingHeader> pageData = new PageView<BiddingHeader>();
        List<BiddingHeader> biddingHeaderList = new ArrayList<BiddingHeader>();
        List<ManagementPage> list = new ArrayList<ManagementPage>();
        List<ManagementPage> finalList = new ArrayList<ManagementPage>();
        if (CollectionUtils.isNotEmpty(biddingSupplierList)) {

            BiddingHeaderExample example = new BiddingHeaderExample();
            // example.setPageView(new PageView<BiddingHeader>(pageNo, pageSize));
            example.createCriteria().andBiddingNoIn(biddingNoList);

            if (wapper != null) {
                CriteriaUtils.addExample(example, wapper);
            }

            // 分页查询基本信息
            // pageData = this.biddingHeaderService.queryObjByPage(example);
            biddingHeaderList = this.biddingHeaderService.queryAllObjByExample(example);
            // 根据基本信息组装招标主页面数据
            Company company = CompanyUtils.currentCompany();
            List<String> roleCodeList = new ArrayList<String>();// 目前没用到
            // list =
            // this.biddingHeaderService.transformSup(pageData.getQueryResult(),SpringSecurityUtils.getLoginUser(),
            // roleCodeList, company);
            list = this.biddingHeaderService.transformSup(biddingHeaderList,
                    SpringSecurityUtils.getLoginUser(), roleCodeList, company);

            // 招标状态查询条件筛选
            finalList = this.biddingHeaderService.screenDataByBiddingStatus(list, biddingStatusList);

        }

        // 给页面数据分页
        PageView<ManagementPage> page = new PageView<ManagementPage>(pageNo, pageSize);
        page.setRowCount(CollectionUtils.isEmpty(finalList) ? 0 : finalList.size());
        page.setQueryResult(finalList.subList(page.getStartRowNo(), page.getEndRowNo()));

        return ResponseResult.success(page);
    }

    /*
     * @ApiOperation(httpMethod = "POST", value = "查询招投标管理页面(供应商)") >>>>>>> branch 'develop' of
     * http://119.23.132.137:10080/business_group/base_bidding.git
     * 
     * @ApiImplicitParams({
     * 
     * @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query",
     * dataType = "String", defaultValue = "0"),
     * 
     * @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query",
     * dataType = "String", defaultValue = "10"),
     * 
     * @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingHeader",
     * paramType = "body", dataType = "QueryParamWapper") })
     * 
     * @RequestMapping("service/findManagementByPageForSup")
     * 
     * @ResponseBody public ResponseResult<PageView<ManagementPage>> findManagementByPageForSup(
     * 
     * @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int
     * pageSize,
     * 
     * @RequestBody(required = false) QueryParamWapper wapper) {
     * 
     * String[] split = new String[] {}; QueryParam confirgStatus = null; for (int i = 0; wapper !=
     * null && CollectionUtils.isNotEmpty(wapper.getQueryParams()) && i <
     * wapper.getQueryParams().size(); i++) { if
     * (wapper.getQueryParams().get(i).getProperty().equals("biddingStatus")) { confirgStatus =
     * wapper.getQueryParams().get(i);//获取界面传入的状态状态值，格式["10","11","12"] String value =
     * confirgStatus.getValue(); String b = value.replaceAll("[\\[\\]]", ""); String b2 =
     * b.replaceAll("\"", "");//去空值 if (StringUtils.isNotBlank(b2)) { split = b2.split(","); }
     * break; } } if (confirgStatus != null) {
     * wapper.getQueryParams().remove(confirgStatus);//移除招标状态条件 } List<String> biddingStatusList =
     * new ArrayList<String>(); if (split.length > 0) { biddingStatusList = Arrays.asList(split);//
     * 把传过来的查询条件动态封装成list }
     * 
     * 
     * 
     * // 查询当前登录的供应商所分配的招投標單據號 List<Role> loginUserRoleList =
     * SpringSecurityUtils.getLoginUserRoleList(); List<String> roleCodeList = new
     * ArrayList<String>(); for (int i = 0; CollectionUtils.isNotEmpty(loginUserRoleList) && i <
     * loginUserRoleList.size(); i++) { roleCodeList.add(loginUserRoleList.get(i).getRoleCode()); }
     * 
     * List<String> listStatus = new ArrayList<String>();
     * listStatus.add(TenderStatusEumn.BIDDING.getValue());// 2 招投标进行中
     * listStatus.add(TenderStatusEumn.BIDDINGEND.getValue());// 3 投标已结束
     * listStatus.add(TenderStatusEumn.INBID.getValue());// 4 评标中
     * listStatus.add(TenderStatusEumn.BIDOVER.getValue());// 5 已评标
     * listStatus.add(TenderStatusEumn.ISSCALING.getValue());// 6 已定标
     * listStatus.add(TenderStatusEumn.ISCANCEL.getValue());// 7 已作废
     * listStatus.add(TenderStatusEumn.ISFINISH.getValue());// 8 已结案
     * listStatus.add(TenderStatusEumn.WAITBID.getValue());// 10 待应标
     * listStatus.add(TenderStatusEumn.ISBID.getValue());// 11 已应标
     * listStatus.add(TenderStatusEumn.REFUSEBID.getValue());// 12 拒绝应标
     * 
     * BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
     * BiddingSupplierExample.Criteria criteriaStatus = biddingSupplierExample.createCriteria();
     * criteriaStatus
     * .andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
     * criteriaStatus.andSupBiddingStatusIn(listStatus);// 招标状态
     * 
     * List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService
     * .queryAllObjByExample(biddingSupplierExample); List<String> biddingNoList = new
     * ArrayList<String>(); for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i <
     * biddingSupplierList.size(); i++) {
     * biddingNoList.add(biddingSupplierList.get(i).getBiddingNo()); }
     * 
     * PageView<BiddingHeader> pageData = new PageView<BiddingHeader>(); List<ManagementPage> list =
     * new ArrayList<ManagementPage>(); List<ManagementPage> finalList = new
     * ArrayList<ManagementPage>(); if (CollectionUtils.isNotEmpty(biddingSupplierList)) {
     * 
     * BiddingHeaderExample example = new BiddingHeaderExample(); example.setPageView(new
     * PageView<BiddingHeader>(pageNo, pageSize));
     * example.createCriteria().andBiddingNoIn(biddingNoList); // 分页查询基本信息 pageData =
     * this.biddingHeaderService.queryObjByPage(example); // 根据基本信息组装招标主页面数据 Company company =
     * CompanyUtils.currentCompany(); list =
     * this.biddingHeaderService.transformSup(pageData.getQueryResult(),
     * SpringSecurityUtils.getLoginUser(), roleCodeList, company);
     * 
     * //招标状态查询条件筛选 finalList = this.biddingHeaderService.screenDataByBiddingStatus(list,
     * biddingStatusList);
     * 
     * }
     * 
     * if (wapper != null) { // CriteriaUtils.addExample(example, wapper); } // 给页面数据分页
     * PageView<ManagementPage> page = new PageView<ManagementPage>(pageNo, pageSize); //
     * page.setQueryResult(list); page.setQueryResult(finalList); // 总条数 //
     * page.setRowCount(CollectionUtils.isEmpty(list) ? 0 : list.size());
     * page.setRowCount(CollectionUtils.isEmpty(finalList) ? 0 : finalList.size());
     * 
     * return ResponseResult.success(page); }
     * 
     * /* @ApiOperation(httpMethod = "POST", value = "查询招投标管理页面(供应商)")
     * 
     * @ApiImplicitParams({
     * 
     * @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query",
     * dataType = "String", defaultValue = "0"),
     * 
     * @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query",
     * dataType = "String", defaultValue = "10"),
     * 
     * @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingHeader",
     * paramType = "body", dataType = "QueryParamWapper") })
     * 
     * @RequestMapping("service/findManagementByPageForSup")
     * 
     * @ResponseBody public ResponseResult<PageView<ManagementPage>> findManagementByPageForSup(
     * 
     * @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int
     * pageSize,
     * 
     * @RequestBody(required = false) QueryParamWapper wapper) {
     * 
     * String[] split = new String[] {}; QueryParam confirgStatus = null; for (int i = 0; wapper !=
     * null && CollectionUtils.isNotEmpty(wapper.getQueryParams()) && i <
     * wapper.getQueryParams().size(); i++) { if
     * (wapper.getQueryParams().get(i).getProperty().equals("biddingStatus")) { confirgStatus =
     * wapper.getQueryParams().get(i);//获取界面传入的状态状态值，格式["10","11","12"] String value =
     * confirgStatus.getValue(); String b = value.replaceAll("[\\[\\]]", ""); String b2 =
     * b.replaceAll("\"", "");//去空值 if (StringUtils.isNotBlank(b2)) { split = b2.split(","); }
     * break; } } if (confirgStatus != null) {
     * wapper.getQueryParams().remove(confirgStatus);//移除招标状态条件 } List<String> biddingStatusList =
     * new ArrayList<String>(); if (split.length > 0) { biddingStatusList = Arrays.asList(split);//
     * 把传过来的查询条件动态封装成list }
     * 
     * List<String> listStatus = new ArrayList<String>();
     * listStatus.add(TenderStatusEumn.BIDDING.getValue());// 2 招投标进行中
     * listStatus.add(TenderStatusEumn.BIDDINGEND.getValue());// 3 投标已结束
     * listStatus.add(TenderStatusEumn.INBID.getValue());// 4 评标中
     * listStatus.add(TenderStatusEumn.BIDOVER.getValue());// 5 已评标
     * listStatus.add(TenderStatusEumn.ISSCALING.getValue());// 6 已定标
     * listStatus.add(TenderStatusEumn.ISCANCEL.getValue());// 7 已作废
     * listStatus.add(TenderStatusEumn.ISFINISH.getValue());// 8 已结案
     * listStatus.add(TenderStatusEumn.WAITBID.getValue());// 10 待应标
     * listStatus.add(TenderStatusEumn.ISBID.getValue());// 11 已应标
     * listStatus.add(TenderStatusEumn.REFUSEBID.getValue());// 12 拒绝应标
     * //根据招标状态，供应商SAP编码查询出当前供应商对应的招标单据(排除采购方未发布的单据) BiddingSupplierExample biddingSupplierExample =
     * new BiddingSupplierExample(); BiddingSupplierExample.Criteria criteriaStatus =
     * biddingSupplierExample.createCriteria();
     * criteriaStatus.andSupCompanySapCodeEqualTo(CompanyUtils
     * .currentCompany().getCompanySapCode());//SAP编码
     * criteriaStatus.andSupBiddingStatusIn(listStatus);// 招标状态
     * //criteriaStatus.andSupBiddingStatusIn(biddingStatusList);// 界面转换后的招标状态
     * 
     * List<BiddingSupplier> biddingSupplierList =
     * this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample); List<String>
     * biddingNoList = new ArrayList<String>(); for (int i = 0;
     * CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); i++) {
     * biddingNoList.add(biddingSupplierList.get(i).getBiddingNo()); }
     * 
     * PageView<BiddingHeader> pageData = new PageView<BiddingHeader>(); List<ManagementPage> list =
     * new ArrayList<ManagementPage>(); //List<ManagementPage> finalList = new
     * ArrayList<ManagementPage>(); if (CollectionUtils.isNotEmpty(biddingSupplierList)) {
     * 
     * BiddingHeaderExample example = new BiddingHeaderExample(); example.setPageView(new
     * PageView<BiddingHeader>(pageNo, pageSize));
     * example.createCriteria().andBiddingNoIn(biddingNoList);
     * 
     * if (wapper != null) { CriteriaUtils.addExample(example, wapper); }
     * 
     * // 分页查询基本信息 pageData = this.biddingHeaderService.queryObjByPage(example); // 根据基本信息组装招标主页面数据
     * Company company = CompanyUtils.currentCompany(); List<String> roleCodeList = new
     * ArrayList<String>();//目前没用到 list =
     * this.biddingHeaderService.transformSup(pageData.getQueryResult
     * (),SpringSecurityUtils.getLoginUser(), roleCodeList, company);
     * 
     * //招标状态查询条件筛选 //finalList = this.biddingHeaderService.screenDataByBiddingStatus(list,
     * biddingStatusList);
     * 
     * }
     * 
     * // 给页面数据分页 PageView<ManagementPage> page = new PageView<ManagementPage>(pageNo, pageSize);
     * page.setQueryResult(list); //page.setQueryResult(finalList); // 总条数 BiddingHeaderExample
     * allObjByExample = new BiddingHeaderExample(); if (wapper != null) {
     * CriteriaUtils.addExample(allObjByExample, wapper); } List<BiddingHeader> queryAllObjByExample
     * = this.biddingHeaderService.queryAllObjByExample(allObjByExample);
     * page.setRowCount(CollectionUtils.isEmpty(queryAllObjByExample) ? 0 :
     * queryAllObjByExample.size()); //page.setRowCount(CollectionUtils.isEmpty(list) ? 0 :
     * list.size()); //page.setRowCount(CollectionUtils.isEmpty(finalList) ? 0 : finalList.size());
     * 
     * return ResponseResult.success(page); }
     */

    @ApiOperation(httpMethod = "POST", value = "采购方-查询招投标单据")
    @RequestMapping("service/queryDocument")
    @ResponseBody
    public ResponseResult<BiddingBaseVo> queryDocument(String biddingNo) {
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();
        // 当前登录人的角色信息
        List<Role> loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        List<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(loginUserRoleList) && i < loginUserRoleList.size(); i++) {
            roleCodeList.add(loginUserRoleList.get(i).getRoleCode());
        }
        BiddingBaseVo biddingBaseVo = this.biddingHeaderService.queryDocument(biddingNo, company, user,
                roleCodeList);
        return ResponseResult.success(biddingBaseVo);
    }

    @ApiOperation(httpMethod = "POST", value = "供应方-查询招投标单据")
    @RequestMapping("service/queryDocumentSup")
    @ResponseBody
    public ResponseResult<BiddingBaseVo> queryDocumentSup(String biddingNo, String biddingCurrentRound) {
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();

        BiddingBaseVo biddingBaseVo = this.biddingHeaderService.queryDocumentSup(biddingNo,
                biddingCurrentRound, company, user, null);
        return ResponseResult.success(biddingBaseVo);
    }

    @ApiOperation(httpMethod = "POST", value = "作废招投标单据")
    @RequestMapping("service/toVoidDocument")
    @ResponseBody
    public ResponseResult<String> toVoidDocument(String biddingNo) {
        this.biddingHeaderService.toVoidDocument(biddingNo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "批量删除招投标单据")
    @RequestMapping("service/deleteDocumentByBiddingNo")
    @ResponseBody
    //public ResponseResult<String> deleteDocumentByBiddingNo(@RequestParam(required = true) String biddingNo) {
    public ResponseResult<String> deleteDocumentByBiddingNo(@RequestBody List<String> bidingNoList) {
    	
    	for (String biddingNo : bidingNoList) {
    		Assert.isNotBlank(biddingNo, "删除失败,biddingNo不能为空");
            this.biddingHeaderService.deleteDocumentByBiddingNo(biddingNo);
		}
        
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "发布前审批")
    @RequestMapping("service/sendBeforeApproval")
    @ResponseBody
    public ResponseResult<String> sendBeforeApproval(@RequestBody List<String> bidingNoList) {
        if (CollectionUtils.isEmpty(bidingNoList)) {
            throw new CommonException("发送失败，数据不能为空");
        }
        this.biddingHeaderService.sendToApprove(bidingNoList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "定标前审批")
    @RequestMapping("service/biddingBeforeApproval")
    @ResponseBody
    public ResponseResult<String> biddingBeforeApproval(@RequestBody List<String> bidingNoList) {
        if (CollectionUtils.isEmpty(bidingNoList)) {
            throw new CommonException("审批失败，数据不能为空");
        }
        this.biddingContentService.biddingBeforeApproval(bidingNoList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "结案")
    @RequestMapping("service/finisnBidding")
    @ResponseBody
    public ResponseResult<String> finisnBidding(String biddingNo) {
        if (StringUtils.isBlank(biddingNo)) {
            throw new CommonException("结案失败，招标单号不能为空");
        }
        this.biddingHeaderService.finisnBidding(biddingNo);
        return ResponseResult.success();
    }

}
