package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.bidding.entity.BiddingMatterStep;
import com.els.base.bidding.entity.BiddingMatterStepExample;
import com.els.base.bidding.service.BiddingMatterStepService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

@Api(value = "物料阶梯报价")
@Controller
@RequestMapping("biddingMatterStep")
public class BiddingMatterStepController {
    @Resource
    protected BiddingMatterStepService biddingMatterStepService;

    @ApiOperation(httpMethod = "POST", value = "创建物料阶梯报价")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingMatterStep biddingMatterStep) {
        this.biddingMatterStepService.addObj(biddingMatterStep);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑物料阶梯报价")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingMatterStep biddingMatterStep) {
        Assert.isNotBlank(biddingMatterStep.getId(), "id 为空，保存失败");
        this.biddingMatterStepService.modifyObj(biddingMatterStep);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除物料阶梯报价")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingMatterStepService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询物料阶梯报价")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingMatterStep", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingMatterStep>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingMatterStepExample example = new BiddingMatterStepExample();
        example.setPageView(new PageView<BiddingMatterStep>(pageNo, pageSize));

        // BiddingMatterStepExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingMatterStep> pageData = this.biddingMatterStepService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}