package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

@Api(value = "供应商物料阶梯报价")
@Controller
@RequestMapping("biddingMatterStepSup")
public class BiddingMatterStepSupController {
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;

    @ApiOperation(httpMethod = "POST", value = "创建供应商物料阶梯报价")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingMatterStepSup biddingMatterStepSup) {
        this.biddingMatterStepSupService.addObj(biddingMatterStepSup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑供应商物料阶梯报价")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingMatterStepSup biddingMatterStepSup) {
        Assert.isNotBlank(biddingMatterStepSup.getId(), "id 为空，保存失败");
        this.biddingMatterStepSupService.modifyObj(biddingMatterStepSup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除供应商物料阶梯报价")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingMatterStepSupService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询供应商物料阶梯报价")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingMatterStepSup", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingMatterStepSup>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
        example.setPageView(new PageView<BiddingMatterStepSup>(pageNo, pageSize));

        // BiddingMatterStepSupExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingMatterStepSup> pageData = this.biddingMatterStepSupService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}