package com.els.base.bidding.web.controller;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingPlan;
import com.els.base.bidding.entity.BiddingPlanExample;
import com.els.base.bidding.service.BiddingPlanService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

@Api(value = "招投标-招标计划")
@Controller
@RequestMapping("biddingPlan")
public class BiddingPlanController {
    @Resource
    protected BiddingPlanService biddingPlanService;

    @ApiOperation(httpMethod = "POST", value = "创建招投标-招标计划")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingPlan biddingPlan) {
        this.biddingPlanService.addObj(biddingPlan);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑招投标-招标计划")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingPlan biddingPlan) {
        Assert.isNotBlank(biddingPlan.getId(), "id 为空，保存失败");
        this.biddingPlanService.modifyObj(biddingPlan);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除招投标-招标计划")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingPlanService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询招投标-招标计划")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingPlan", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingPlan>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingPlanExample example = new BiddingPlanExample();
        example.setPageView(new PageView<BiddingPlan>(pageNo, pageSize));

        // BiddingPlanExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingPlan> pageData = this.biddingPlanService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod = "POST", value = "增加轮次")
    @RequestMapping("service/addTurn")
    @ResponseBody
    public ResponseResult<String> addTurn(@RequestBody List<BiddingPlan> biddingPlanList) throws InstantiationException, IllegalAccessException {
        if (CollectionUtils.isEmpty(biddingPlanList)) {
            throw new CommonException("增加轮次失败，数据不能为空");
        }
        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();
        this.biddingPlanService.addTurn(biddingPlanList, company, user);
        return ResponseResult.success();
    }
}