package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.bidding.entity.BiddingPower;
import com.els.base.bidding.entity.BiddingPowerExample;
import com.els.base.bidding.service.BiddingPowerService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

@Api(value = "招投标-基本信息-采购方招投标人员权限")
@Controller
@RequestMapping("biddingPower")
public class BiddingPowerController {
    @Resource
    protected BiddingPowerService biddingPowerService;

    @ApiOperation(httpMethod = "POST", value = "创建招投标-基本信息-采购方招投标人员权限")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingPower biddingPower) {
        this.biddingPowerService.addObj(biddingPower);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑招投标-基本信息-采购方招投标人员权限")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingPower biddingPower) {
        Assert.isNotBlank(biddingPower.getId(), "id 为空，保存失败");
        this.biddingPowerService.modifyObj(biddingPower);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除招投标-基本信息-采购方招投标人员权限")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingPowerService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询招投标-基本信息-采购方招投标人员权限")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingPower", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingPower>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingPowerExample example = new BiddingPowerExample();
        example.setPageView(new PageView<BiddingPower>(pageNo, pageSize));

        // BiddingPowerExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingPower> pageData = this.biddingPowerService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}