package com.els.base.bidding.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.util.Date;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

@Api(value = "招投标-招标意向供应商列表")
@Controller
@RequestMapping("biddingSupplier")
public class BiddingSupplierController {
    @Resource
    protected BiddingSupplierService biddingSupplierService;

    @Resource
    protected BiddingHeaderService biddingHeaderService;

    @Resource
    protected BiddingOfferService biddingOfferService;

    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;

    @ApiOperation(httpMethod = "POST", value = "创建招投标-招标意向供应商列表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingSupplier biddingSupplier) {
        this.biddingSupplierService.addObj(biddingSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "保存招标意向供应商列表")
    @RequestMapping("service/save")
    @ResponseBody
    public ResponseResult<String> save(@RequestBody BiddingBaseVo biddingBaseVo) throws InstantiationException, IllegalAccessException {
        this.biddingSupplierService.save(biddingBaseVo, CompanyUtils.currentCompany(),
                SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑招投标-招标意向供应商列表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingSupplier biddingSupplier) {
        Assert.isNotBlank(biddingSupplier.getId(), "id 为空，保存失败");
        this.biddingSupplierService.modifyObj(biddingSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑招投标-供应商更新投标或应标状态")
    @RequestMapping("service/supEditStatus")
    @ResponseBody
    public ResponseResult<String> supEditStatus(@RequestParam(required = true) String biddingNo,
            @RequestParam(required = true) String statuType, @RequestParam(required = true) String statu) {
        if (StringUtils.isBlank(biddingNo)) {
            throw new CommonException("招标单号  为空，操作失败", "base_canot_be_null", "招标单号");
        }
        /*
         * A '应标状态：0：未应标，1：已应标，2：不应标'; B '投标状态：0：未投标，1：已投标';
         */
        if (StringUtils.isBlank(statuType)) {
            throw new CommonException("状态类型  为空，操作失败", "base_canot_be_null", "状态类型");
        }
        if (StringUtils.isBlank(statu)) {
            throw new CommonException("状态  为空，操作失败", "base_canot_be_null", "状态");
        }

        // 获取当前登录人用户信息
        User user = SpringSecurityUtils.getLoginUser();
        // 获取当前登录人公司信息
        Company company = CompanyUtils.currentCompany();

        // 更新的字段
        BiddingSupplier biddingSupplier = new BiddingSupplier();
        biddingSupplier.setLastUpdateTime(new Date());// 最后更新时间
        biddingSupplier.setLastUpdateUser(user.getNickName());// 供应商的最后更新人

        biddingSupplierService.supEditStatus(biddingNo, statuType, statu, company, user);

        /*
         * if(statuType.equals("A")){//应标状况： 0：未应标，1：已应标，2：不应标
         * 
         * //招标状态：0 未发布 1 已发布 2 招投标进行中 3 投标已结束 4 评标中 5 已评标 6 已定标 7 已作废 8 已结案 9 未应标 10 待应标 11 已应标 12
         * 拒绝应标 13 部分应标 14 全部应标 String supBiddingStatus="";//供应商招标状态 String
         * supParticipate="";//供应商应标状态 if(statu=="Y"){//应标
         * supBiddingStatus=TenderStatusEumn.ISBID.getValue();//供应商招标状态为11 已应标
         * supParticipate="1";//供应商应标状态为1：已应标
         * 
         * 
         * }else if(statu=="N"){//拒绝应标
         * supBiddingStatus=TenderStatusEumn.REFUSEBID.getValue();//供应商招标状态为12 已应标
         * supParticipate="2";//供应商应标状态为1：已应标 }
         * 
         * //更新逻辑：先更新供应商的招标状态、应标状态，其次再查询更新后的供应商应标数，再更新采购方的招标状态
         * //1、===========先更新供应商的招标状态===============
         * biddingSupplier.setSupParticipate(supParticipate);//应标状态
         * 
         * //供应商各自显示【已应标】 biddingSupplier.setSupBiddingStatus(supBiddingStatus);//招标状态
         * 
         * //根据招标单号、供应商SRM编码、供应商SAP编码三个条件，更新招标状态、应标状态
         * updateBiddingStatus(biddingSupplier,biddingNo,company);
         * 
         * //2、===========再查询更新后的供应商应标数===============
         * //在供应商表，根据标单号一个条件，查询供应商的总数是否等于应标的总数，等于则全部应标，否则部分应标 BiddingSupplierExample
         * biddingSupplierExample = new BiddingSupplierExample(); BiddingSupplierExample.Criteria
         * createCriteria = biddingSupplierExample.createCriteria();
         * createCriteria.andBiddingNoEqualTo(biddingNo);//标单号 List<BiddingSupplier> totalSumList =
         * this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample); int
         * totalSum=totalSumList.size();//招标总数 //根据标单号、应标状态两个条件，查询应标总数
         * createCriteria.andSupBiddingStatusEqualTo(supBiddingStatus);//供应商应标状态或拒绝应标状态
         * List<BiddingSupplier> sumList =
         * this.biddingSupplierService.queryAllObjByExample(biddingSupplierExample); int
         * sum=sumList.size();//该标单应标的供应商总数或拒绝应标的供应商总数
         * 
         * String purBiddingStatus="";//采购方的招标状态 if(statu=="Y"){//应标
         * //应标的供应商总数>=招标的供应商总数，则为全部应标，否则为部分应标。采购方显示【部分应标／全部应标】 purBiddingStatus=
         * (sum>=totalSum)?TenderStatusEumn
         * .ALLBID.getValue():TenderStatusEumn.PARTBID.getValue();//招标状态，13 部分应标 14 全部应标
         * 
         * }else if(statu=="N"){//拒绝应标 //拒绝应标的供应商总数>=招标的供应商总数，则为全部应标，否则为原来的部分应标状态（不更新）
         * purBiddingStatus=
         * (sum>=totalSum)?TenderStatusEumn.ALLREFUSEBID.getValue():null;//招标状态，采购方显示“【全部拒绝】 }
         * 
         * //3、===========再更新采购方的招标状态=============== //更新采购方主表的招标状态字段 BiddingHeader biddingHeader =
         * new BiddingHeader(); biddingHeader.setLastUpdateTime(new Date());//最后更新时间
         * biddingHeader.setLastUpdateUser(user.getNickName());//供应商的最后更新人
         * biddingHeader.setBiddingStatus(purBiddingStatus);//招标状态
         * 
         * //更新条件 BiddingHeaderExample example = new BiddingHeaderExample();
         * BiddingHeaderExample.Criteria biddingCriteria = example.createCriteria();
         * biddingCriteria.andBiddingNoEqualTo(biddingNo);//招标单号
         * 
         * this.biddingHeaderService.editStatus(biddingHeader,example);
         * 
         * 
         * }else if(statuType.equals("B")){//投标状态：0：未投标，1：已投标
         * 
         * biddingSupplier.setSupBidding(statu);//投标状态 //根据招标单号、供应商SRM编码、供应商SAP编码更新状态
         * updateBiddingStatus(biddingSupplier,biddingNo,company);
         * 
         * }
         */

        // 根据招标单号、供应商SRM编码、供应商SAP编码更新状态
        /*
         * BiddingSupplierExample example = new BiddingSupplierExample();
         * BiddingSupplierExample.Criteria biddingCriteria = example.createCriteria();
         * biddingCriteria.andBiddingNoEqualTo(biddingNo);//招标单号
         * biddingCriteria.andSupCompanySrmCodeEqualTo(company.getCompanyCode());//srm编码
         * biddingCriteria.andSupCompanySapCodeEqualTo(company.getCompanySapCode());//sap编码
         * 
         * this.biddingSupplierService.editStatus(biddingSupplier,example);
         */

        return ResponseResult.success();
    }

    @SuppressWarnings("unused")
    private void updateBiddingStatus(BiddingSupplier biddingSupplier, String biddingNo, Company company) {
        BiddingSupplierExample example = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria biddingCriteria = example.createCriteria();
        biddingCriteria.andBiddingNoEqualTo(biddingNo);// 招标单号
        //biddingCriteria.andSupCompanySrmCodeEqualTo(company.getCompanyCode());// srm编码
        //biddingCriteria.andSupCompanySapCodeEqualTo(company.getCompanySapCode());// sap编码
        biddingCriteria.andSupCompanyIdEqualTo(company.getId());// 供应商id

        this.biddingSupplierService.editStatus(biddingSupplier, example);
    }

    @ApiOperation(httpMethod = "POST", value = "删除招投标-招标意向供应商列表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.biddingSupplierService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询招投标-招标意向供应商列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BiddingSupplier", paramType = "body", dataType = "QueryParamWapper") })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BiddingSupplier>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BiddingSupplierExample example = new BiddingSupplierExample();
        example.setPageView(new PageView<BiddingSupplier>(pageNo, pageSize));

        // BiddingSupplierExample.Criteria criteria = example.createCriteria();
        // 填写具体的查询条件，例如
        // criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<BiddingSupplier> pageData = this.biddingSupplierService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}