/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.bidding.dao.BiddingQuestionMapper;
import com.els.base.bidding.entity.BiddingQuestion;
import com.els.base.bidding.entity.BiddingQuestionExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.service.BiddingQuestionService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultBiddingQuestionService")
public class BiddingQuestionServiceImpl
implements BiddingQuestionService {
    @Resource
    protected BiddingQuestionMapper biddingQuestionMapper;
    @Resource
    protected BiddingSupplierService biddingSupplierService;

    @CacheEvict(value={"biddingQuestion"}, allEntries=true)
    public void addObj(BiddingQuestion t) {
        this.biddingQuestionMapper.insertSelective(t);
    }

    @CacheEvict(value={"biddingQuestion"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingQuestionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingQuestion"}, allEntries=true)
    public void modifyObj(BiddingQuestion t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingQuestionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingQuestion"}, keyGenerator="redisKeyGenerator")
    public BiddingQuestion queryObjById(String id) {
        return this.biddingQuestionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"biddingQuestion"}, keyGenerator="redisKeyGenerator")
    public List<BiddingQuestion> queryAllObjByExample(BiddingQuestionExample example) {
        return this.biddingQuestionMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingQuestion"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingQuestion> queryObjByPage(BiddingQuestionExample example) {
        PageView<BiddingQuestion> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingQuestionMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"biddingQuestion"}, allEntries=true)
    public void createBiddingQuestion(BiddingQuestion question, Company supCompany, User supUser) {
        this.isCreateLegalParmas(question);
        this.initQuestionInfo(question, supCompany, supUser);
        this.addObj(question);
    }

    private void isCreateLegalParmas(BiddingQuestion question) {
        Assert.isNotBlank((String)question.getBiddingNo(), (String)"\u62db\u6807\u5355\u5355\u636e\u53f7\u4e0d\u80fd\u7a7a!");
        Assert.isNotBlank((String)question.getQuestionContent(), (String)"\u63d0\u95ee\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    private void initQuestionInfo(BiddingQuestion question, Company supCompany, User supUser) {
        question.setSupCompanyId(supCompany.getId());
        question.setSupCompanySrmCode(supCompany.getCompanyCode());
        question.setSupCompanySapCode(supCompany.getCompanySapCode());
        question.setSupCompanyFullName(supCompany.getCompanyFullName());
        question.setSupCompanyName(supCompany.getCompanyName());
        BiddingSupplierExample example = new BiddingSupplierExample();
        example.createCriteria().andBiddingNoEqualTo(question.getBiddingNo()).andSupCompanyIdEqualTo(supCompany.getId());
        List list = this.biddingSupplierService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            question.setSupCompanyTempCode(((BiddingSupplier)list.get(0)).getSupplierTemporaryCode());
        }
        question.setSupUserId(supUser.getId());
        StringBuffer supUserName = new StringBuffer();
        if (StringUtils.isNotEmpty((String)supUser.getLoginName())) {
            supUserName.append(supUser.getLoginName());
        }
        if (StringUtils.isNotEmpty((String)supUser.getNickName())) {
            supUserName.append("+");
            supUserName.append(supUser.getNickName());
        }
        question.setSupUserName(supUserName.toString());
        question.setQuestionType(Constant.NO_INT);
        question.setIsSupCheck(Constant.NO_INT);
        question.setIsPurAnswer(Constant.NO_INT);
        question.setIsEnable(Constant.YES_INT);
        question.setCreateTime(new Date());
    }

    @Override
    @CacheEvict(value={"biddingQuestion"}, allEntries=true)
    public void deleteQuestion(List<String> ids) {
        Assert.isNotNull(ids, (String)"\u4f20\u9012\u7684ID\u4e0d\u80fd\u4e3a\u7a7a");
        BiddingQuestionExample example = new BiddingQuestionExample();
        example.createCriteria().andIsPurAnswerEqualTo(Constant.YES_INT).andIdIn((List)ids);
        if (this.biddingQuestionMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u91c7\u8d2d\u5546\u5df2\u7b54\u590d\u7684\u95ee\u9898,\u65e0\u6cd5\u5220\u9664\u6570\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        BiddingQuestion question = new BiddingQuestion();
        question.setIsEnable(Constant.NO_INT);
        question.setUpdateTime(new Date());
        this.biddingQuestionMapper.updateByExampleSelective(question, example);
    }

    @Override
    @CacheEvict(value={"biddingQuestion"}, allEntries=true)
    public BiddingQuestion findDetailById(String id, Company supCompany) {
        Assert.isNotBlank((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a!");
        BiddingQuestion question = this.queryObjById(id);
        Assert.isNotNull((Object)question, (String)"\u67e5\u8be2\u7684\u95ee\u9898\u4e0d\u5b58\u5728!");
        if (supCompany.getId().equals(question.getSupCompanyId()) && question.getIsSupCheck() != null && Constant.NO_INT.equals(question.getIsSupCheck()) && question.getIsPurAnswer() != null && Constant.YES_INT.equals(question.getIsPurAnswer())) {
            question.setIsSupCheck(Constant.YES_INT);
            question.setUpdateTime(new Date());
            this.biddingQuestionMapper.updateByPrimaryKeySelective(question);
        }
        return question;
    }

    @Override
    @CacheEvict(value={"biddingQuestion"}, allEntries=true)
    public void editQuestionForSup(BiddingQuestion question) {
        Assert.isNotNull((Object)question, (String)"\u95ee\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)question.getId(), (String)"\u95ee\u9898id\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)question.getQuestionContent(), (String)"\u95ee\u9898\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
        BiddingQuestion bq = this.queryObjById(question.getId());
        Assert.isNotNull((Object)bq, (String)"\u95ee\u9898\u4e0d\u5b58\u5728!");
        if (Constant.NO_INT.equals(bq.getIsEnable())) {
            throw new CommonException("\u5df2\u5220\u9664\u95ee\u9898\u4e0d\u80fd\u4fee\u6539!");
        }
        if (Constant.YES_INT.equals(bq.getIsPurAnswer())) {
            throw new CommonException("\u5df2\u56de\u590d\u7684\u95ee\u9898\u4e0d\u80fd\u4fee\u6539!");
        }
        BiddingQuestion data = new BiddingQuestion();
        data.setId(question.getId());
        data.setQuestionContent(question.getQuestionContent());
        data.setUpdateTime(new Date());
        this.biddingQuestionMapper.updateByPrimaryKeySelective(data);
    }

    @Override
    public int countSupplierQuestionInfo(String biddingNo, Company supCompany) {
        BiddingQuestionExample example = new BiddingQuestionExample();
        example.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(supCompany.getId()).andIsEnableEqualTo(Constant.YES_INT).andIsPurAnswerEqualTo(Constant.NO_INT);
        example.or().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(supCompany.getId()).andIsEnableEqualTo(Constant.YES_INT).andIsPurAnswerEqualTo(Constant.YES_INT).andIsSupCheckEqualTo(Constant.NO_INT);
        int count = this.biddingQuestionMapper.countByExample(example);
        return count;
    }

    @Override
    public int countPurQuestionInfo(String biddingNo) {
        BiddingQuestionExample example = new BiddingQuestionExample();
        example.createCriteria().andBiddingNoEqualTo(biddingNo).andIsEnableEqualTo(Constant.YES_INT).andIsPurAnswerEqualTo(Constant.NO_INT);
        int count = this.biddingQuestionMapper.countByExample(example);
        return count;
    }

    @Override
    @CacheEvict(value={"biddingQuestion"}, allEntries=true)
    public void answerSupQuestion(BiddingQuestion question, User purUser) {
        Assert.isNotNull((Object)question, (String)"\u95ee\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)question.getId(), (String)"\u95ee\u9898id\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)question.getAnswerContent(), (String)"\u7b54\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotNull((Object)question.getQuestionType(), (String)"\u662f\u5426\u516c\u5f00\u95ee\u9898\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!");
        BiddingQuestion ques = this.queryObjById(question.getId());
        if (null == ques) {
            throw new CommonException("\u95ee\u9898\u4e0d\u5b58\u5728!");
        }
        BiddingQuestion q = new BiddingQuestion();
        q.setId(question.getId());
        q.setAnswerContent(question.getAnswerContent());
        q.setAnswerTime(new Date());
        q.setIsPurAnswer(Constant.YES_INT);
        q.setQuestionType(question.getQuestionType());
        q.setIsSupCheck(Constant.NO_INT);
        q.setUpdateTime(new Date());
        q.setPurUserId(purUser.getId());
        StringBuffer purUserName = new StringBuffer();
        if (StringUtils.isNotEmpty((String)purUser.getLoginName())) {
            purUserName.append(purUser.getLoginName());
        }
        if (StringUtils.isNotEmpty((String)purUser.getNickName())) {
            purUserName.append("+");
            purUserName.append(purUser.getNickName());
        }
        q.setPurUserName(purUserName.toString());
        this.biddingQuestionMapper.updateByPrimaryKeySelective(q);
    }

    public void deleteByExample(BiddingQuestionExample example) {
    }

    public void addAll(List<BiddingQuestion> list) {
    }
}

