/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingPlan;
import com.els.base.bidding.entity.BiddingPlanExample;
import com.els.base.bidding.service.BiddingPlanService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u62db\u6295\u6807-\u62db\u6807\u8ba1\u5212")
@Controller
@RequestMapping(value={"biddingPlan"})
public class BiddingPlanController {
    @Resource
    protected BiddingPlanService biddingPlanService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6295\u6807-\u62db\u6807\u8ba1\u5212")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingPlan biddingPlan) {
        this.biddingPlanService.addObj(biddingPlan);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6295\u6807-\u62db\u6807\u8ba1\u5212")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingPlan biddingPlan) {
        Assert.isNotBlank((String)biddingPlan.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingPlanService.modifyObj(biddingPlan);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u62db\u6295\u6807-\u62db\u6807\u8ba1\u5212")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingPlanService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807-\u62db\u6807\u8ba1\u5212")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingPlan", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingPlan>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingPlanExample example = new BiddingPlanExample();
        example.setPageView((PageView<BiddingPlan>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.biddingPlanService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u589e\u52a0\u8f6e\u6b21")
    @RequestMapping(value={"service/addTurn"})
    @ResponseBody
    public ResponseResult<String> addTurn(@RequestBody List<BiddingPlan> biddingPlanList) throws InstantiationException, IllegalAccessException {
        if (CollectionUtils.isEmpty(biddingPlanList)) {
            throw new CommonException("\u589e\u52a0\u8f6e\u6b21\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = SpringSecurityUtils.getLoginUser();
        Company company = CompanyUtils.currentCompany();
        this.biddingPlanService.addTurn(biddingPlanList, company, user);
        return ResponseResult.success();
    }
}

