/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingPlanMapper;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingPlan;
import com.els.base.bidding.entity.BiddingPlanExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingPlanService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.inquiry.IExtendable;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyValueUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingPlanService")
public class BiddingPlanServiceImpl
implements BiddingPlanService {
    @Resource
    protected BiddingPlanMapper biddingPlanMapper;
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected BiddingOfferService biddingOfferService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;

    @CacheEvict(value={"biddingPlan"}, allEntries=true)
    public void addObj(BiddingPlan t) {
        t.setCreateTime(new Date());
        this.biddingPlanMapper.insertSelective(t);
    }

    @CacheEvict(value={"biddingPlan"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingPlanMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingPlan"}, allEntries=true)
    public void modifyObj(BiddingPlan t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingPlanMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingPlan"}, keyGenerator="redisKeyGenerator")
    public BiddingPlan queryObjById(String id) {
        return this.biddingPlanMapper.selectByPrimaryKey(id);
    }

    public List<BiddingPlan> queryAllObjByExample(BiddingPlanExample example) {
        return this.biddingPlanMapper.selectByExample(example);
    }

    public PageView<BiddingPlan> queryObjByPage(BiddingPlanExample example) {
        PageView<BiddingPlan> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingPlanMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingPlan> biddingPlanList = this.biddingPlanMapper.selectByExample(biddingPlanExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingPlanList) && i < biddingPlanList.size(); ++i) {
            this.biddingPlanMapper.deleteByPrimaryKey(biddingPlanList.get(i).getId());
        }
    }

    @Override
    @CacheEvict(value={"biddingPlan"}, allEntries=true)
    @Transactional
    public void addTurn(List<BiddingPlan> biddingPlanList, Company company, User user) throws InstantiationException, IllegalAccessException {
        for (BiddingPlan biddingPlan2 : biddingPlanList) {
            if (biddingPlan2.getId() != null) continue;
            biddingPlan2.setCreateTime(new Date());
            biddingPlan2.setLastUpdateTime(new Date());
            biddingPlan2.setLastUpdateUser(user.getNickName());
            this.biddingPlanMapper.insert(biddingPlan2);
        }
        Collections.sort(biddingPlanList, new Comparator<BiddingPlan>(){

            @Override
            public int compare(BiddingPlan o1, BiddingPlan o2) {
                return o2.getBiddingRoundsNumber().compareTo(o1.getBiddingRoundsNumber());
            }
        });
        BiddingHeader biddingHeader = (BiddingHeader)this.biddingHeaderService.queryObjById(biddingPlanList.get(0).getBiddingId());
        biddingHeader.setBiddingCurrentRound(String.valueOf(biddingPlanList.size()));
        biddingHeader.setBiddingTotalRound(String.valueOf(biddingPlanList.size()));
        biddingHeader.setBiddingBegindate(biddingPlanList.get(0).getBiddingBeginDate());
        biddingHeader.setBiddingEnddate(biddingPlanList.get(0).getBiddingEndDate());
        biddingHeader.setBiddingOpenDate(biddingPlanList.get(0).getBiddingOpenDate());
        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria().andBiddingNoEqualTo(biddingHeader.getBiddingNo());
        List biddingSupplierPartNo = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
        for (int j = 0; CollectionUtils.isNotEmpty((Collection)biddingSupplierPartNo) && j < biddingSupplierPartNo.size(); ++j) {
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(((BiddingSupplier)biddingSupplierPartNo.get(j)).getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISBID.getValue());
            biddingSupplier.setSupBidding("0");
            this.biddingSupplierService.modifyObj(biddingSupplier);
        }
        BiddingSupplierExample allSupplierExample = new BiddingSupplierExample();
        allSupplierExample.createCriteria().andBiddingNoEqualTo(biddingHeader.getBiddingNo());
        List allSupplier = this.biddingSupplierService.queryAllObjByExample((IExample)allSupplierExample);
        ArrayList<String> strList = new ArrayList<String>();
        for (BiddingSupplier sup : allSupplier) {
            strList.add(sup.getSupParticipate() == null ? "1" : sup.getSupParticipate());
        }
        String str = "";
        str = Collections.frequency(strList, "1") == strList.size() ? TenderStatusEumn.ALLBID.getValue() : (Collections.frequency(strList, "1") < strList.size() && Collections.frequency(strList, "1") > 0 ? TenderStatusEumn.PARTBID.getValue() : TenderStatusEumn.ALLREFUSEBID.getValue());
        biddingHeader.setBiddingStatus(str);
        biddingHeader.setBidSubmitDate(null);
        this.biddingHeaderService.customModifyObj(biddingHeader);
        BiddingOfferExample example = new BiddingOfferExample();
        example.createCriteria().andBiddingNoEqualTo(biddingHeader.getBiddingNo()).andBiddingRoundsNumberEqualTo(String.valueOf(biddingPlanList.size() - 1));
        List biddingOffers = this.biddingOfferService.queryAllObjByExample((IExample)example);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingOffers) && i < biddingOffers.size(); ++i) {
            BiddingOffer biddingOffer = (BiddingOffer)biddingOffers.get(i);
            BiddingMatterStepSupExample exampleStepSupExample = new BiddingMatterStepSupExample();
            exampleStepSupExample.createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId()).andBiddingRoundsNumberEqualTo(String.valueOf(biddingPlanList.size() - 1));
            List biddingMatterStepSups = this.biddingMatterStepSupService.queryAllObjByExample((IExample)exampleStepSupExample);
            biddingOffer.setId(null);
            biddingOffer.setLastOfferPrice(biddingOffer.getOfferUnitPrice());
            biddingOffer.setLastOfferSetPrice(biddingOffer.getOfferSetPrice());
            biddingOffer.setOfferUnitPrice(null);
            biddingOffer.setOfferSetPrice(null);
            biddingOffer.setTempOfferUnitPrice(null);
            biddingOffer.setTempOfferSetPrice(null);
            biddingOffer.setCurrentRanking(null);
            biddingOffer.setRestEffectiveNumber(biddingOffer.getEffectiveNumber());
            biddingOffer.setPromiseReducedRate(null);
            biddingOffer.setFactBarnd(null);
            biddingOffer.setFactSpec(null);
            biddingOffer.setFactModel(null);
            biddingOffer.setBiddingRoundsNumber(String.valueOf(biddingPlanList.size()));
            biddingOffer.setBiddingTotalRound(String.valueOf(biddingPlanList.size()));
            this.biddingOfferService.addObj(biddingOffer);
            if (StringUtils.isNotBlank((String)biddingOffer.getQuotationMethod()) && biddingOffer.getQuotationMethod().equals("2")) {
                for (int j = 0; CollectionUtils.isNotEmpty((Collection)biddingMatterStepSups) && j < biddingMatterStepSups.size(); ++j) {
                    BiddingMatterStepSup biddingMatterStepSup = (BiddingMatterStepSup)biddingMatterStepSups.get(j);
                    biddingMatterStepSup.setId(null);
                    biddingMatterStepSup.setBiddingOfferId(biddingOffer.getId());
                    biddingMatterStepSup.setBiddingRoundsNumber(String.valueOf(biddingPlanList.size()));
                    biddingMatterStepSup.setBiddingTotalRound(String.valueOf(biddingPlanList.size()));
                    biddingMatterStepSup.setLastOfferPrice(biddingMatterStepSup.getOfferUnitPrice());
                    biddingMatterStepSup.setLastOfferSetPrice(biddingMatterStepSup.getOfferSetPrice());
                    biddingMatterStepSup.setOfferUnitPrice(null);
                    biddingMatterStepSup.setOfferSetPrice(null);
                    this.biddingMatterStepSupService.addObj(biddingMatterStepSup);
                }
            }
            if (!StringUtils.isNotBlank((String)biddingOffer.getCostAnalysisId()) || !"material".equals(biddingOffer.getRequirementTypeCode())) continue;
            TplOrderItemDetail tpl = (TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById((Object)biddingOffer.getCostAnalysisId());
            IOrderItemDetailService service = tpl.getOrderItemDetailService();
            IOrderItemDetail detail = (IOrderItemDetail)tpl.getOrderItemDetailClass().newInstance();
            detail.setOrderItemId(biddingOffer.getId());
            detail.setTemplateId(biddingOffer.getCostAnalysisId());
            detail.setMaterialCode(biddingOffer.getProjectNo());
            detail.setMaterialDesc(biddingOffer.getProjectDesc());
            detail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue((IExtendable)detail));
            service.addObj((Serializable)detail);
        }
    }

    public void deleteByExample(BiddingPlanExample example) {
    }

    public void addAll(List<BiddingPlan> list) {
    }
}

