/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingTemplateInfoMapper;
import com.els.base.bidding.entity.BiddingTemplateInfo;
import com.els.base.bidding.entity.BiddingTemplateInfoExample;
import com.els.base.bidding.service.BiddingTemplateInfoService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingTemplateInfoService")
public class BiddingTemplateInfoServiceImpl
implements BiddingTemplateInfoService {
    @Resource
    protected BiddingTemplateInfoMapper biddingTemplateInfoMapper;

    @CacheEvict(value={"biddingTemplateInfo"}, allEntries=true)
    public void addObj(BiddingTemplateInfo t) {
        this.biddingTemplateInfoMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"biddingTemplateInfo"}, allEntries=true)
    public void addAll(List<BiddingTemplateInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingTemplateInfoMapper.insertBatch(list);
    }

    @CacheEvict(value={"biddingTemplateInfo"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingTemplateInfoMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingTemplateInfo"}, allEntries=true)
    public void deleteByExample(BiddingTemplateInfoExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingTemplateInfoMapper.deleteByExample(example);
    }

    @CacheEvict(value={"biddingTemplateInfo"}, allEntries=true)
    public void modifyObj(BiddingTemplateInfo t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingTemplateInfoMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingTemplateInfo"}, keyGenerator="redisKeyGenerator")
    public BiddingTemplateInfo queryObjById(String id) {
        return this.biddingTemplateInfoMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"biddingTemplateInfo"}, keyGenerator="redisKeyGenerator")
    public List<BiddingTemplateInfo> queryAllObjByExample(BiddingTemplateInfoExample example) {
        return this.biddingTemplateInfoMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingTemplateInfo"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingTemplateInfo> queryObjByPage(BiddingTemplateInfoExample example) {
        PageView<BiddingTemplateInfo> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingTemplateInfoMapper.selectByExampleByPage(example));
        return pageView;
    }
}

