/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingGroup;
import com.els.base.bidding.entity.BiddingGroupExample;
import com.els.base.bidding.service.BiddingGroupService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
@Controller
@RequestMapping(value={"biddingGroup"})
public class BiddingGroupController {
    @Resource
    protected BiddingGroupService biddingGroupService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingGroup biddingGroup) {
        this.biddingGroupService.insert(biddingGroup, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)biddingGroup.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingGroup biddingGroup) {
        Assert.isNotBlank((String)biddingGroup.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingGroupService.modifyObj(biddingGroup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6fc0\u6d3b\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
    @RequestMapping(value={"service/activationByIds"})
    @ResponseBody
    public ResponseResult<String> activationByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u6fc0\u6d3b\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingGroupService.activation(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        BiddingGroupExample example = new BiddingGroupExample();
        example.createCriteria().andIdIn((List)ids);
        this.biddingGroupService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingGroup", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingGroup>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingGroupExample example = new BiddingGroupExample();
        example.setPageView((PageView<BiddingGroup>)new PageView(pageNo, pageSize));
        BiddingGroupExample.Criteria criteria = example.createCriteria();
        criteria.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.biddingGroupService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6807\u5355\u65f6\u6dfb\u52a0\u8bc4\u6807\u4eba\u5458")
    @RequestMapping(value={"service/findGroup"})
    @ResponseBody
    public ResponseResult<List<BiddingGroup>> findGroup(@RequestParam(required=true) String bidGroup, @RequestParam(required=true) int number) {
        Assert.isNotBlank((String)bidGroup, (String)"\u8bc4\u6807\u5c0f\u7ec4\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)number, (String)"\u4eba\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        if (number == 0) {
            throw new CommonException("\u4eba\u6570\u503c\u4e0d\u80fd\u4e3a0");
        }
        Company company = CompanyUtils.currentCompany();
        BiddingGroupExample example = new BiddingGroupExample();
        example.createCriteria().andAffiliateIdEqualTo(company.getId()).andBidGroupEqualTo(bidGroup).andIsEnabledEqualTo(Constant.YES_INT);
        List list = this.biddingGroupService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list) && number < list.size()) {
            Random index = new Random();
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            ArrayList groupList = new ArrayList();
            for (int i = 0; i < number; ++i) {
                int j = index.nextInt(list.size());
                if (!indexList.contains(j)) {
                    indexList.add(j);
                    groupList.add(list.get(j));
                    continue;
                }
                --i;
            }
            return ResponseResult.success(groupList);
        }
        return ResponseResult.success((Object)list);
    }
}

