/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingStandard;
import com.els.base.bidding.entity.BiddingStandardExample;
import com.els.base.bidding.service.BiddingStandardService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u62db\u6295\u6807-\u8bc4\u6807\u6807\u51c6\u7ba1\u7406")
@Controller
@RequestMapping(value={"biddingStandard"})
public class BiddingStandardController {
    @Resource
    protected BiddingStandardService biddingStandardService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6295\u6807-\u8bc4\u6807\u6807\u51c6\u7ba1\u7406")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingStandard biddingStandard) {
        this.biddingStandardService.insertObj(biddingStandard, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)biddingStandard.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6295\u6807-\u8bc4\u6807\u6807\u51c6\u7ba1\u7406")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingStandard biddingStandard) {
        Assert.isNotBlank((String)biddingStandard.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingStandardService.updateObj(biddingStandard, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6fc0\u6d3b\u62db\u6295\u6807-\u8bc4\u6807\u6807\u51c6\u7ba1\u7406")
    @RequestMapping(value={"service/activationByIds"})
    @ResponseBody
    public ResponseResult<String> activationByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u6fc0\u6d3b\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingStandardService.activation(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u62db\u6295\u6807-\u8bc4\u6807\u6807\u51c6\u7ba1\u7406")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        BiddingStandardExample example = new BiddingStandardExample();
        example.createCriteria().andIdIn((List)ids);
        this.biddingStandardService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807-\u8bc4\u6807\u6807\u51c6\u7ba1\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingStandard", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingStandard>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingStandardExample example = new BiddingStandardExample();
        example.setPageView((PageView<BiddingStandard>)new PageView(pageNo, pageSize));
        BiddingStandardExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnabledEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.biddingStandardService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

