-- ----------------------------
-- 招投标----贸易条件
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_TRADE_CONDITION" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"CONDITION_DESC" VARCHAR2(255 BYTE) NULL ,
"UNTAXED_UNIT_PRICE" NUMBER(11,2) NULL ,
"SUP_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"CREATE_TIME" DATE NULL ,
"LAST_UPDATE_USER" DATE NULL ,
"BIDDING_HEADER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"BIDDING_NO" VARCHAR2(255 BYTE) NULL ,
"PUR_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"TEMP_MATERIAL_NO" VARCHAR2(255 BYTE) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(50) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_TRADE_CONDITION" IS '招投标----贸易条件';
COMMENT ON COLUMN "T_BASE_BIDDING_TRADE_CONDITION"."CONDITION_DESC" IS '条件描述';
COMMENT ON COLUMN "T_BASE_BIDDING_TRADE_CONDITION"."UNTAXED_UNIT_PRICE" IS '不含税价格';
COMMENT ON COLUMN "T_BASE_BIDDING_TRADE_CONDITION"."SUP_ITEM_ID" IS '关联行id';
COMMENT ON COLUMN "T_BASE_BIDDING_TRADE_CONDITION"."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_BIDDING_TRADE_CONDITION"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_BIDDING_TRADE_CONDITION"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_BIDDING_TRADE_CONDITION"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_TRADE_CONDITION"."TEMP_MATERIAL_NO" IS '临时物料编号：招标单号+序号';
COMMENT ON COLUMN "T_BASE_BIDDING_TRADE_CONDITION"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';

ALTER TABLE "T_BASE_BIDDING_TRADE_CONDITION" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 招投标-招标意向供应商列表
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_SUPPLIER" (
"ID" NVARCHAR2(50) NOT NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(50) NULL ,
"BIDDING_NO" NVARCHAR2(50) NULL ,
"SUP_PARTICIPATE" NVARCHAR2(1) NULL ,
"SUP_GETDOC" NVARCHAR2(1) NULL ,
"SUP_BIDDING" NVARCHAR2(1) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(100) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(100) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"SUPPLIER_STATUS" NVARCHAR2(255) NULL ,
"IS_PAY_MONEY" NVARCHAR2(255) NULL ,
"PARTNER_ROLE_NAME" NVARCHAR2(255) NULL ,
"PARTNER_ROLE_CODE" NVARCHAR2(32) NULL ,
"SUPPLIER_TEMPORARY_CODE" NVARCHAR2(255) NULL ,
"SUP_BIDDING_STATUS" NVARCHAR2(50) NULL ,
"BANK_ATTACHMENT" CLOB NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_SUPPLIER" IS '招投标-招标意向供应商列表';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."PUR_COMPANY_ID" IS '采购员公司ID';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."PUR_COMPANY_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."PUR_COMPANY_NAME" IS '客户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."PUR_USER_ID" IS '采购员ID';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."PUR_USER_NAME" IS '采购负责人';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."BIDDING_HEADER_ID" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUP_PARTICIPATE" IS '应标：0：未应标，1：已应标，2：不应标';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUP_GETDOC" IS '招标文件：0：已领取，1：未领取';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUP_BIDDING" IS '投标情况：0：未投标，1：已投标';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUP_COMPANY_ID" IS '供应商企业ID';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUP_COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUP_USER_NAME" IS '销售方负责人';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUP_USER_ID" IS '供应商负责人ID';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUPPLIER_STATUS" IS '供应商状态 0:合格供应商,1:陌生供应商,2:潜在供应商';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."IS_PAY_MONEY" IS '保证金是否缴纳 0:否 1:是';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."PARTNER_ROLE_NAME" IS '伙伴角色:陌生供应商、潜在供应商、合格供应商、淘汰供应商';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."PARTNER_ROLE_CODE" IS '伙伴角色编码:stranger/potenial/qualified/eliminate';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUPPLIER_TEMPORARY_CODE" IS '供应商临时编码';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."SUP_BIDDING_STATUS" IS '0 ：未发布 、1 ：已发布  、2 ：招投标进行中 、3 ：投标已结束、  4 评标中、 5 已评标 、6 已定标  、7 已作废 、 8 已结案
    、 9 未应标   、10 待应标  、11 已应标  、12 拒绝应标、 13 部分应标  、14 全部应标';
COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER"."BANK_ATTACHMENT" IS '银行水单附件';

ALTER TABLE "T_BASE_BIDDING_SUPPLIER" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 招投标在线答疑
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_QUESTION" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_TEMP_CODE" VARCHAR2(255 BYTE) NULL ,
"BIDDING_ID" VARCHAR2(32 BYTE) NULL ,
"BIDDING_NO" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"QUESTION_CONTENT" VARCHAR2(1000 BYTE) NULL ,
"ANSWER_CONTENT" VARCHAR2(1000 BYTE) NULL ,
"ANSWER_TIME" DATE NULL ,
"QUESTION_TYPE" NUMBER(7) DEFAULT 0  NULL ,
"IS_SUP_CHECK" NUMBER(7) DEFAULT 0  NULL ,
"IS_PUR_ANSWER" NUMBER(7) DEFAULT 0  NULL ,
"IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"UPDATE_TIME" DATE NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_QUESTION" IS '招投标在线答疑';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."SUP_COMPANY_TEMP_CODE" IS '供应商临时编码';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."BIDDING_ID" IS '招投标ID';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."BIDDING_NO" IS '招投标单号';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."PUR_USER_ID" IS '采购答复者ID';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."PUR_USER_NAME" IS '采购答复者名称';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."SUP_USER_ID" IS '供应商提问者ID';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."SUP_USER_NAME" IS '供应商提问者名称';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."QUESTION_CONTENT" IS '问题内容';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."ANSWER_CONTENT" IS '答复内容';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."ANSWER_TIME" IS '答复时间';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."QUESTION_TYPE" IS '问题类型(0=私有,1=公开)';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."IS_SUP_CHECK" IS '供应商是否查看问题(0=未查看,1=已查看)';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."IS_PUR_ANSWER" IS '采购方是否答复问题(0=未回复,1=已回复)';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."IS_ENABLE" IS '是否删除(0=已删除,1=未删除)';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."CREATE_TIME" IS '创建时间(提问日期)';
COMMENT ON COLUMN "T_BASE_BIDDING_QUESTION"."UPDATE_TIME" IS '修改时间(修改时间)';

ALTER TABLE "T_BASE_BIDDING_QUESTION" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 招投标-基本信息-采购方招投标人员权限
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_POWER" (
"ID" NVARCHAR2(50) NOT NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(50) NULL ,
"BIDDING_NO" NVARCHAR2(50) NULL ,
"BIDDING_TENDERER_MEMBERS" NVARCHAR2(2000) NULL ,
"BIDDING_TENDERER_POWER" NVARCHAR2(2) NULL ,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"BIDDING_TENDERER_MEMBER_IDS" NVARCHAR2(255) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_POWER" IS '招投标-基本信息-采购方招投标人员权限';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."PUR_COMPANY_ID" IS '采购员公司ID';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."PUR_COMPANY_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."PUR_COMPANY_NAME" IS '客户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."PUR_USER_ID" IS '采购员ID';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."PUR_USER_NAME" IS '采购负责人';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."BIDDING_HEADER_ID" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."BIDDING_TENDERER_MEMBERS" IS '招标组成员';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."BIDDING_TENDERER_POWER" IS '招标组成员权限：0-不公开价格，1-招标单公开，2-招标单保密';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_POWER"."BIDDING_TENDERER_MEMBER_IDS" IS '招标组成员id';

ALTER TABLE "T_BASE_BIDDING_POWER" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 招投标-招标计划
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_PLAN" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_ID" NVARCHAR2(32) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(50) NULL ,
"BIDDING_TYPE" NVARCHAR2(255) NULL ,
"BIDDING_TOTAL_ROUND" NVARCHAR2(50) NULL ,
"BIDDING_SECRET" NVARCHAR2(50) NULL ,
"BIDDING_STATUS" NVARCHAR2(50) NULL ,
"BIDDING_BEGIN_DATE" DATE NULL ,
"BIDDING_BEGIN_TIME" DATE NULL ,
"BIDDING_END_DATE" DATE NULL ,
"BIDDING_END_TIME" DATE NULL ,
"BIDDING_OPEN_DATE" DATE NULL ,
"BIDDING_OPEN_TIME" DATE NULL ,
"BIDDING_ADDRESS" NVARCHAR2(255) NULL ,
"SEND_LOW_BACK" NVARCHAR2(50) NULL ,
"LOW_BACK_PERC" NVARCHAR2(255) NULL ,
"SEND_RANKINGS" NVARCHAR2(50) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"BIDDING_DEADLINE" DATE NULL ,
"TOTAL_ROUND" NVARCHAR2(50) NULL ,
"EACH_ROUND_TIME" NVARCHAR2(50) NULL ,
"EACH_ROUND_INTERVAL_TIME" NVARCHAR2(50) NULL ,
"MAXIMUM_TIME_DELAY" NVARCHAR2(50) NULL ,
"DEADLINE" NVARCHAR2(50) NULL ,
"PRICE_CUT_PERCENTAGE" NVARCHAR2(50) NULL ,
"AMPLITUDE_UNIT" NVARCHAR2(50) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_PLAN" IS '招投标-招标计划';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_ID" IS '招标id';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_TYPE" IS '招标类型： 0：邀请招标，1：公开招标';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_TOTAL_ROUND" IS '招标总轮数';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_SECRET" IS '开标前是否可以查看投标内容：0：保密,1：公开';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_STATUS" IS '招标状态 : 未开始  1 : 招标进行中  2 : 未开标  3 : 评标中  4 ：本轮完成  5 ：招标中止';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_BEGIN_DATE" IS '投标开始日期';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_BEGIN_TIME" IS '投标开始时间';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_END_DATE" IS '投标截止日期';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_END_TIME" IS '投标截止时间';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_OPEN_DATE" IS '开标日期';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_OPEN_TIME" IS '开标时间';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_ADDRESS" IS '开标地址';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."SEND_LOW_BACK" IS '发送低靠: 0：否、1：是';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."LOW_BACK_PERC" IS '低靠百分比';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."SEND_RANKINGS" IS '发送排名 0：否、1：是';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."PUR_COMPANY_SRM_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."BIDDING_DEADLINE" IS '应标截止时间';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."TOTAL_ROUND" IS '总轮次（在线竞价）';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."EACH_ROUND_TIME" IS '每轮持续时间（在线竞价）';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."EACH_ROUND_INTERVAL_TIME" IS '每轮间隔时间（在线竞价）';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."MAXIMUM_TIME_DELAY" IS '最大延时次数（在线竞价）';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."DEADLINE" IS '应标期限（在线竞价）';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."PRICE_CUT_PERCENTAGE" IS '降价幅度（在线竞价）';
COMMENT ON COLUMN "T_BASE_BIDDING_PLAN"."AMPLITUDE_UNIT" IS '幅度单位（在线竞价）';

ALTER TABLE "T_BASE_BIDDING_PLAN" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 招投标-在线竞价
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_ONLINE" (
"ID" NVARCHAR2(32) NOT NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL ,
"UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_ID" NVARCHAR2(32) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(30) NULL ,
"OFFER_TIME" DATE NULL ,
"UNTAXED_UNIT_PRICE" NVARCHAR2(32) NULL ,
"UNTAXED_TOTAL_PRICE" NVARCHAR2(32) NULL ,
"TAXED_UNIT_PRICE" NVARCHAR2(32) NULL ,
"TAXED_TOTAL_PRICE" NVARCHAR2(32) NULL ,
"TAX_RATE" NVARCHAR2(32) NULL ,
"TAX_CODE" NVARCHAR2(255) NULL ,
"CURRENCY" NVARCHAR2(255) NULL ,
"QUOTATION_STATE" NVARCHAR2(255) NULL ,
"PRICE_EFFECTIVE_FROM" DATE NULL ,
"PRICE_EFFECTIVE_TO" DATE NULL ,
"MATERIAL_CODE" NVARCHAR2(255) NULL ,
"PRICE_UNIT" NVARCHAR2(32) NULL ,
"PRICE_CUT_PERCENTAGE" NVARCHAR2(32) NULL ,
"AMPLITUDE_UNIT" NVARCHAR2(25) NULL ,
"BEFORE_UNTAXED_PRICE" NVARCHAR2(32) NULL ,
"CONTENT_TYPE" NUMBER(5) NULL ,
"TEMP_MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(255 BYTE) NULL ,
"BIDDING_QUANTITY" NUMBER(20) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_ONLINE" IS '招投标-在线竞价';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."UPDATE_USER" IS '修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."BIDDING_ID" IS '招标id';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."OFFER_TIME" IS '报价时间';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."UNTAXED_UNIT_PRICE" IS '未税单价';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."UNTAXED_TOTAL_PRICE" IS '未税总价';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."TAXED_UNIT_PRICE" IS '含税单价';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."TAXED_TOTAL_PRICE" IS '含税总价';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."CURRENCY" IS '币种';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."QUOTATION_STATE" IS '报价状态（0无效竞价，1有效竞价，2中标）';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."PRICE_EFFECTIVE_FROM" IS '价格有效期从';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."PRICE_EFFECTIVE_TO" IS '价格有效期到';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."MATERIAL_CODE" IS '招标内容编码';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."PRICE_UNIT" IS '价格单位';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."PRICE_CUT_PERCENTAGE" IS '降价幅度';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."AMPLITUDE_UNIT" IS '幅度单位';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."BEFORE_UNTAXED_PRICE" IS '前一次不含税报价';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."CONTENT_TYPE" IS '招标内容类型: 1-物料 2-模具';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."TEMP_MATERIAL_CODE" IS '临时编码';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_BIDDING_ONLINE"."BIDDING_QUANTITY" IS '数量';

ALTER TABLE "T_BASE_BIDDING_ONLINE" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 供应商报价
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_OFFER" (
"ID" NVARCHAR2(32) NOT NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(50) NULL ,
"BIDDING_TOTAL_ROUND" NVARCHAR2(50) NULL ,
"REQUIREMENT_TYPE_CODE" NVARCHAR2(255) NULL ,
"REQUIREMENT_TYPE_NAME" NVARCHAR2(255) NULL ,
"BIDDING_CONTECT_ITEM_NO" NVARCHAR2(255) NULL ,
"PROJECT_NO" NVARCHAR2(255) NULL ,
"PROJECT_NAME" NVARCHAR2(500) NULL ,
"PROJECT_DESC" NVARCHAR2(2000) NULL ,
"PROMISE_REDUCED_RATE" NVARCHAR2(50) NULL ,
"QUANTITY" NUMBER(13) NULL ,
"UNIT_PRICE" NUMBER(13,2) NULL ,
"AMOUNT" NUMBER(13,2) NULL ,
"OFFER_UNIT_PRICE" NVARCHAR2(50) NULL ,
"OFFER_SET_PRICE" NVARCHAR2(50) NULL ,
"LAST_OFFER_PRICE" NVARCHAR2(50) NULL ,
"CURRENT_RANKING" NVARCHAR2(50) NULL ,
"FACT_BARND" NVARCHAR2(200) NULL ,
"FACT_SPEC" NVARCHAR2(200) NULL ,
"FACT_MODEL" NVARCHAR2(200) NULL ,
"IS_BIDDING" NVARCHAR2(255) NULL ,
"IS_GROOM_MATERIAL" NVARCHAR2(255) NULL ,
"MATERIAL_STSTUS" NVARCHAR2(255) NULL ,
"MATERIAL_DEVEL" NVARCHAR2(255) NULL ,
"BIDDING_QUANTITY" NUMBER(13) NULL ,
"MATERIAL_FEATURES" NVARCHAR2(255) NULL ,
"MATERIAL_SPEC" NVARCHAR2(255) NULL ,
"MATERIAL_MODEL" NVARCHAR2(255) NULL ,
"UNIT" NVARCHAR2(255) NULL ,
"DELIVERY_DATE" DATE NULL ,
"MODEL_NO" NVARCHAR2(255) NULL ,
"MODEL_DESC" NVARCHAR2(255) NULL ,
"MODEL_NAME" NVARCHAR2(255) NULL ,
"USE_MODEL" NVARCHAR2(255) NULL ,
"BELONE_YEAR" NVARCHAR2(255) NULL ,
"MODEL_SERIAL_NUMBER" NVARCHAR2(255) NULL ,
"MODEL_MATERIAL" NVARCHAR2(255) NULL ,
"MODEL_LIFE" NVARCHAR2(255) NULL ,
"PROPERTY_RIGHT" NVARCHAR2(255) NULL ,
"MODEL_SINKING" NVARCHAR2(255) NULL ,
"REFERENCE_PRICE" NUMBER(13,2) NULL ,
"TARGET_NO" NVARCHAR2(255) NULL ,
"TAREGT_DESC" NVARCHAR2(255) NULL ,
"TARGET_NAME" NVARCHAR2(255) NULL ,
"BID_SHARE" NVARCHAR2(255) NULL ,
"ACTUAL_DROP_RATE" NVARCHAR2(255) NULL ,
"CURRENCY" NVARCHAR2(255) NULL ,
"CURRENT_RATE" NVARCHAR2(255) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(32) NULL ,
"MATTER_ID" NVARCHAR2(32) NULL ,
"MODEL_ID" NVARCHAR2(32) NULL ,
"OTHER_ID" NVARCHAR2(32) NULL ,
"ALL_BIDDING" NVARCHAR2(32) NULL ,
"EFFECTIVE_NUMBER" NVARCHAR2(50) NULL ,
"REST_EFFECTIVE_NUMBER" NVARCHAR2(50) NULL ,
"LAST_OFFER_SET_PRICE" NVARCHAR2(50) NULL ,
"QUOTATION_METHOD" NVARCHAR2(255) NULL ,
"IS_STEP" NVARCHAR2(255) NULL ,
"SUPPLIER_TEMPORARY_CODE" NVARCHAR2(255) NULL ,
"PICTURE_ATTACHMENT" CLOB NULL ,
"DESIGN_PIC_ATTACHMENT" CLOB NULL ,
"SUPPLIER_QUOTED_PRICE" NUMBER(13,2) NULL ,
"TEMP_OFFER_UNIT_PRICE" NVARCHAR2(50) NULL ,
"TEMP_OFFER_SET_PRICE" NVARCHAR2(50) NULL ,
"TEMP_MATERIAL_NO" NVARCHAR2(255) NULL ,
"IS_SUBMIT_BID" NVARCHAR2(25) NULL ,
"COST_ANALYSIS_ID" NVARCHAR2(32) NULL ,
"OFFER_PRICE_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"OFFER_PRICE_UPDATE_USER" NVARCHAR2(255) NULL ,
"FACTORY_NAME" VARCHAR2(255 BYTE) NULL ,
"FACTORY_CODE" VARCHAR2(255 BYTE) NULL ,
"INSTRUMENT_STATUS" VARCHAR2(255 BYTE) DEFAULT 0  NULL ,
"TEMP_OTHER_NO" VARCHAR2(50 BYTE) NULL ,
"TEMP_MODEL_NO" VARCHAR2(50 BYTE) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_OFFER" IS '供应商报价';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."BIDDING_TOTAL_ROUND" IS '招标总轮数';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."REQUIREMENT_TYPE_CODE" IS '需求类型编码:material(物料),die(模具),device(设备)';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."REQUIREMENT_TYPE_NAME" IS '需求类型名称';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."BIDDING_CONTECT_ITEM_NO" IS '招标内容行项目号';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PROJECT_NO" IS '编码';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PROJECT_NAME" IS '名称';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PROJECT_DESC" IS '描述';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PROMISE_REDUCED_RATE" IS '承诺年降率';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."QUANTITY" IS '用量';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."UNIT_PRICE" IS '目标单价（不含税单价）';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."AMOUNT" IS '目标套价（不含税单价）';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."OFFER_UNIT_PRICE" IS '报价单价(不含税单价)';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."OFFER_SET_PRICE" IS '报价套价(不含税单价)';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."LAST_OFFER_PRICE" IS '上轮报价单价(不含税单价)';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."CURRENT_RANKING" IS '当前排名';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."FACT_BARND" IS '实报品牌';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."FACT_SPEC" IS '实报规格';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."FACT_MODEL" IS '实报型号';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."IS_BIDDING" IS '是否中标 0:否 1:是';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."IS_GROOM_MATERIAL" IS '推荐供应商 0：否  1：是';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MATERIAL_STSTUS" IS '供应商状态 0:陌生 1:潜在 2:合格';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MATERIAL_DEVEL" IS '供应商等级';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."BIDDING_QUANTITY" IS '招标数量';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MATERIAL_FEATURES" IS '物料品牌';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MATERIAL_SPEC" IS '规格';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MATERIAL_MODEL" IS '型号';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."UNIT" IS '单位';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."DELIVERY_DATE" IS '交货日期';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."USE_MODEL" IS '使用机型';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."BELONE_YEAR" IS '所属年份';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MODEL_SERIAL_NUMBER" IS '模具序号';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MODEL_MATERIAL" IS '模具材料';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MODEL_LIFE" IS '模具寿命';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PROPERTY_RIGHT" IS '产权状况';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MODEL_SINKING" IS '开模归属';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."REFERENCE_PRICE" IS '参考价格';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."TARGET_NO" IS '标的编码';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."TAREGT_DESC" IS '标的描述';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."TARGET_NAME" IS '标的名称';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."BID_SHARE" IS '中标份额';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."ACTUAL_DROP_RATE" IS '实际年降率';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."CURRENCY" IS '报价币种';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."CURRENT_RATE" IS '当前汇率';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."BIDDING_HEADER_ID" IS '招投标id';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MATTER_ID" IS '物料id';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."MODEL_ID" IS '模具id';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."OTHER_ID" IS '其他id';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."ALL_BIDDING" IS '0：必须全部投标、1：可以部分投标';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."EFFECTIVE_NUMBER" IS '每轮报价有效次数';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."REST_EFFECTIVE_NUMBER" IS '当前轮报价剩余有效次数';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."LAST_OFFER_SET_PRICE" IS '上轮报价套价(不含税套价)';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."QUOTATION_METHOD" IS '报价方式 0:阶梯报价,1:常规报价';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."IS_STEP" IS '是否阶梯报价';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."SUPPLIER_TEMPORARY_CODE" IS '供应商临时编码';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."PICTURE_ATTACHMENT" IS '图片附件';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."DESIGN_PIC_ATTACHMENT" IS '方案、设计图纸';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."SUPPLIER_QUOTED_PRICE" IS '供应商报价金额';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."TEMP_OFFER_UNIT_PRICE" IS '临时报价单价(不含税单价)';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."TEMP_OFFER_SET_PRICE" IS '临时报价套价(不含税单价)';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."TEMP_MATERIAL_NO" IS '临时物料编号：招标单号+序号';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."IS_SUBMIT_BID" IS '是否提交评标   0：否    1：是';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."COST_ANALYSIS_ID" IS '物料成本分析清单ID';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."OFFER_PRICE_UPDATE_TIME" IS '报价时间';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."OFFER_PRICE_UPDATE_USER" IS '报价人';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."FACTORY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."FACTORY_CODE" IS '工厂';
COMMENT ON COLUMN "T_BASE_BIDDING_OFFER"."INSTRUMENT_STATUS" IS '议标状态';

ALTER TABLE "T_BASE_BIDDING_OFFER" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 供应商物料阶梯报价
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_MATTER_STEP_SUP" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"MATERIAL_NO" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(50) NULL ,
"BIDDING_TOTAL_ROUND" NVARCHAR2(50) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(32) NULL ,
"MATTER_ID" NVARCHAR2(32) NULL ,
"QUANTITY_START" NUMBER NULL ,
"QUANTITY_END" NUMBER NULL ,
"OFFER_UNIT_PRICE" NVARCHAR2(50) NULL ,
"OFFER_SET_PRICE" NVARCHAR2(50) NULL ,
"LAST_OFFER_PRICE" NVARCHAR2(50) NULL ,
"LAST_OFFER_SET_PRICE" NVARCHAR2(50) NULL ,
"BIDDING_OFFER_ID" NVARCHAR2(32) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_MATTER_STEP_SUP" IS '供应商物料阶梯报价';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."MATERIAL_NO" IS '物料编号';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."MATERIAL_DESC" IS '名称描述';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."BIDDING_TOTAL_ROUND" IS '招标总轮数';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."QUANTITY_START" IS '数量从';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."QUANTITY_END" IS '数量到';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."OFFER_UNIT_PRICE" IS '报价单价(不含税单价)';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."OFFER_SET_PRICE" IS '报价套价(不含税单价)';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."LAST_OFFER_PRICE" IS '上轮报价单价(不含税单价)';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP_SUP"."LAST_OFFER_SET_PRICE" IS '上轮报价套价(不含税单价)';

ALTER TABLE "T_BASE_BIDDING_MATTER_STEP_SUP" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 物料阶梯报价
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_MATTER_STEP" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"MATERIAL_NO" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(50) NULL ,
"BIDDING_TOTAL_ROUND" NVARCHAR2(50) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(32) NULL ,
"MATTER_ID" NVARCHAR2(32) NULL ,
"QUANTITY_START" NUMBER NULL ,
"QUANTITY_END" NUMBER NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_MATTER_STEP" IS '物料阶梯报价';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."MATERIAL_NO" IS '物料编号';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."MATERIAL_DESC" IS '名称描述';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."BIDDING_TOTAL_ROUND" IS '招标总轮数';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."QUANTITY_START" IS '数量从';
COMMENT ON COLUMN "T_BASE_BIDDING_MATTER_STEP"."QUANTITY_END" IS '数量到';

ALTER TABLE "T_BASE_BIDDING_MATTER_STEP" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 招投标-基本信息
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_HEADER" (
"ID" NVARCHAR2(50) NOT NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(50) NULL ,
"BIDDING_NAME" NVARCHAR2(300) NULL ,
"BIDDING_PROJECT_NUMBER" NVARCHAR2(50) NULL ,
"BIDDING_TYPE" NVARCHAR2(2) NULL ,
"BIDDING_STATUS" NVARCHAR2(2) NULL ,
"BIDDING_AMOUNT" NVARCHAR2(18) NULL ,
"BIDDING_CURRENCY" NVARCHAR2(10) NULL ,
"BIDDING_FUNDSOURCE" NVARCHAR2(50) NULL ,
"BIDDING_SUMMARY" NVARCHAR2(300) NULL ,
"BIDDING_CURRENT_ROUND" NVARCHAR2(2) NULL ,
"BIDDING_TOTAL_ROUND" NVARCHAR2(2) NULL ,
"BIDDING_PRINCIPAL" NVARCHAR2(100) NULL ,
"BIDDING_BEGINDATE" DATE NULL ,
"BIDDING_ENDDATE" DATE NULL ,
"BIDDING_AUDITSTATUS" NVARCHAR2(2) NULL ,
"BIDDING_PRE_AUDITSTATUS" NVARCHAR2(2) NULL ,
"BIDDING_REMARK" NVARCHAR2(2000) NULL ,
"BIDDING_SEND_BIDDER" NVARCHAR2(100) NULL ,
"BIDDING_FILE" NVARCHAR2(2000) NULL ,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"PUBLISH_DATE" DATE NULL ,
"BIDDING_DEADLINE" DATE NULL ,
"BIDDING_OPEN_DATE" DATE NULL ,
"BID_SUBMIT_DATE" DATE NULL ,
"APPROVE_FLOW_ID" VARCHAR2(255 BYTE) NULL ,
"APPROVE_FLOW_ID2" VARCHAR2(255 BYTE) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_HEADER" IS '招投标-基本信息';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."PUR_COMPANY_ID" IS '采购员公司ID';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."PUR_COMPANY_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."PUR_COMPANY_NAME" IS '客户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."PUR_USER_ID" IS '采购员ID';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."PUR_USER_NAME" IS '采购负责人';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_NAME" IS '招标名称';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_PROJECT_NUMBER" IS '项目编号';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_TYPE" IS '招标类型： 0：邀请招标，1：公开招标， 2：在线竞价-邀请，3：在线竞价-公开，4：暂定招标-邀请，5：暂定招标-公开，6：竞争性谈判';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_STATUS" IS '招标状态';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_AMOUNT" IS '预算金额';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_CURRENCY" IS '结算货币';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_FUNDSOURCE" IS '资金来源';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_SUMMARY" IS '概况与范围';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_CURRENT_ROUND" IS '当前轮数';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_TOTAL_ROUND" IS '招标总轮数';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_PRINCIPAL" IS '负责人';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_BEGINDATE" IS '开始日期';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_ENDDATE" IS '结束日期';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_AUDITSTATUS" IS '定标审批状态,默认为1：0-审批通过，1-未审批，2-审批中，3-审批拒绝';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_PRE_AUDITSTATUS" IS '发送前审批状态,默认为1：0-审批通过，1-未审批，2-审批中，3-审批拒绝';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_SEND_BIDDER" IS '定标(目标价)发送投标方:1、全部发送   2、不发送  3、只发送中标方';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_FILE" IS '附件';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."PUBLISH_DATE" IS '发布日期';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_DEADLINE" IS '应标截止时间';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BIDDING_OPEN_DATE" IS '开标日期';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."BID_SUBMIT_DATE" IS '评标提交时间';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."APPROVE_FLOW_ID" IS '审批流ID';
COMMENT ON COLUMN "T_BASE_BIDDING_HEADER"."APPROVE_FLOW_ID2" IS '定标审批流ID';

ALTER TABLE "T_BASE_BIDDING_HEADER" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 招标文件回签
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_FILE_SUPPLIER" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(32) NULL ,
"FILE_TYPE" NVARCHAR2(255) NULL ,
"FILE_NAME" NVARCHAR2(255) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(50) NULL ,
"BIDDING_TYPE" NVARCHAR2(255) NULL ,
"BIDDING_FILE_ID" NVARCHAR2(32) NULL ,
"ATTACHMENT_SUP" CLOB NULL ,
"SUPPLIER_TEMPORARY_CODE" NVARCHAR2(255) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_FILE_SUPPLIER" IS '招标文件回签';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."FILE_TYPE" IS '文件类别';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."FILE_NAME" IS '文件名称';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."BIDDING_TYPE" IS '招标类型： 0：邀请招标，1：公开招标';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."BIDDING_FILE_ID" IS '附件ID(采购方)';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."ATTACHMENT_SUP" IS '附件(供应商)';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE_SUPPLIER"."SUPPLIER_TEMPORARY_CODE" IS '供应商临时编码';

ALTER TABLE "T_BASE_BIDDING_FILE_SUPPLIER" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 招标文件上传，查阅
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_FILE" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(32) NULL ,
"FILE_TYPE" NVARCHAR2(255) NULL ,
"FILE_NAME" NVARCHAR2(255) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(50) NULL ,
"BIDDING_TYPE" NVARCHAR2(255) NULL ,
"ATTACHMENT_PUR" CLOB NULL ,
"ATTACHMENT_SUP" CLOB NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_FILE" IS '招标文件上传，查阅';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."FILE_TYPE" IS '文件类别';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."FILE_NAME" IS '文件名称';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."BIDDING_TYPE" IS '招标类型： 0：邀请招标，1：公开招标';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."ATTACHMENT_PUR" IS '附件(采购方)';
COMMENT ON COLUMN "T_BASE_BIDDING_FILE"."ATTACHMENT_SUP" IS '附件(供应商)';

ALTER TABLE "T_BASE_BIDDING_FILE" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 其他类招标
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_CONTENT_OTHER" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(32) NULL ,
"TARGET_NO" NVARCHAR2(255) NULL ,
"TAREGT_DESC" NVARCHAR2(255) NULL ,
"TARGET_NAME" NVARCHAR2(255) NULL ,
"MOST_ALL_BIDDING" NVARCHAR2(255) NULL ,
"CURRENCY" NVARCHAR2(255) NULL ,
"UNIT_PRICE" NUMBER(13,2) NULL ,
"UNIT" NVARCHAR2(255) NULL ,
"BIDDING_CONTENT_ID" NVARCHAR2(32) NULL ,
"LAST_QUOTE" NUMBER(13,2) NULL ,
"BIDDING_CONTENT_ITEM_NO" NVARCHAR2(255) NULL ,
"QUOTATION_METHOD" NVARCHAR2(255) NULL ,
"ALL_BIDDING" NVARCHAR2(50) NULL ,
"PICTURE_ATTACHMENT" CLOB NULL ,
"DESIGN_PIC_ATTACHMENT" CLOB NULL ,
"INSTRUMENT_STATUS" VARCHAR2(10 BYTE) DEFAULT 0  NULL ,
"TEMP_OTHER_NO" VARCHAR2(50 BYTE) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_CONTENT_OTHER" IS '其他类招标';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."TARGET_NO" IS '标的编码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."TAREGT_DESC" IS '标的描述';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."TARGET_NAME" IS '标的名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."MOST_ALL_BIDDING" IS '必须全部投标 0:否 1:是';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."CURRENCY" IS '币种';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."UNIT_PRICE" IS '目标单价（不含税单价）';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."UNIT" IS '单位';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."LAST_QUOTE" IS '上一轮报价';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."QUOTATION_METHOD" IS '报价方式 0:阶梯报价,1:常规报价';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."ALL_BIDDING" IS '0：必须全部投标、1：可以部分投标';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."PICTURE_ATTACHMENT" IS '图片附件';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."DESIGN_PIC_ATTACHMENT" IS '方案、设计图纸';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_OTHER"."INSTRUMENT_STATUS" IS '是否议标';

ALTER TABLE "T_BASE_BIDDING_CONTENT_OTHER" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 模具类招标
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_CONTENT_MODEL" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(32) NULL ,
"MOST_ALL_BIDDING" NVARCHAR2(255) NULL ,
"BIDDING_CONTENT_ID" NVARCHAR2(32) NULL ,
"MODEL_NO" NVARCHAR2(255) NULL ,
"MODEL_DESC" NVARCHAR2(255) NULL ,
"MODEL_NAME" NVARCHAR2(255) NULL ,
"USE_MODEL" NVARCHAR2(255) NULL ,
"BELONE_YEAR" NVARCHAR2(255) NULL ,
"MODEL_SERIAL_NUMBER" NVARCHAR2(255) NULL ,
"MODEL_MATERIAL" NVARCHAR2(255) NULL ,
"MODEL_LIFE" NVARCHAR2(255) NULL ,
"PROPERTY_RIGHT" NVARCHAR2(255) NULL ,
"MODEL_SINKING" NVARCHAR2(255) NULL ,
"CURRENCY" NVARCHAR2(255) NULL ,
"UNIT_PRICE" NUMBER(13,2) NULL ,
"DELIVERY_DATE" DATE NULL ,
"LAST_QUOTE" NUMBER(13,2) NULL ,
"BIDDING_CONTENT_ITEM_NO" NVARCHAR2(255) NULL ,
"QUOTATION_METHOD" NVARCHAR2(255) NULL ,
"ALL_BIDDING" NVARCHAR2(50) NULL ,
"PICTURE_ATTACHMENT" CLOB NULL ,
"DESIGN_PIC_ATTACHMENT" CLOB NULL ,
"MODEL_ID" NVARCHAR2(32) NULL ,
"COST_ANALYSIS_ID" NVARCHAR2(32) NULL ,
"INSTRUMENT_STATUS" VARCHAR2(10 BYTE) DEFAULT 0  NULL ,
"TEMP_MODEL_NO" VARCHAR2(50 BYTE) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_CONTENT_MODEL" IS '模具类招标';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."BIDDING_HEADER_ID" IS '招投标主表ID';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."MOST_ALL_BIDDING" IS '必须全部投标 0:否 1:是';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."BIDDING_CONTENT_ID" IS '内容主表ID';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."MODEL_NO" IS '模具编码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."MODEL_DESC" IS '模具描述';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."MODEL_NAME" IS '模具名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."USE_MODEL" IS '使用机型';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."BELONE_YEAR" IS '所属年份';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."MODEL_SERIAL_NUMBER" IS '模具序号';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."MODEL_MATERIAL" IS '模具材料';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."MODEL_LIFE" IS '模具寿命';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."PROPERTY_RIGHT" IS '产权状况';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."MODEL_SINKING" IS '开模归属';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."CURRENCY" IS '币种';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."UNIT_PRICE" IS '目标单价';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."DELIVERY_DATE" IS '交货日期';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."LAST_QUOTE" IS '上一轮报价';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."QUOTATION_METHOD" IS '报价方式 0:阶梯报价,1:常规报价';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."ALL_BIDDING" IS '0：必须全部投标、1：可以部分投标';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."PICTURE_ATTACHMENT" IS '图片附件';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."DESIGN_PIC_ATTACHMENT" IS '方案、设计图纸';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."MODEL_ID" IS '模具ID';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."COST_ANALYSIS_ID" IS '物料成本分析清单ID';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MODEL"."INSTRUMENT_STATUS" IS '是否议标';

ALTER TABLE "T_BASE_BIDDING_CONTENT_MODEL" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 物料类招标
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_CONTENT_MATTER" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(32) NULL ,
"MATERIAL_NO" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"MATERIAL_NAME" NVARCHAR2(255) NULL ,
"MATERIAL_FEATURES" NVARCHAR2(255) NULL ,
"MATERIAL_SPEC" NVARCHAR2(255) NULL ,
"MATERIAL_MODEL" NVARCHAR2(255) NULL ,
"UNIT" NVARCHAR2(255) NULL ,
"BIDDING_QUANTITY" NUMBER(13) NULL ,
"CURRENCY" NVARCHAR2(255) NULL ,
"DOSAGE" NUMBER(13) NULL ,
"UNIT_PRICE" NUMBER(13,2) NULL ,
"SET_THE_PRICE" NUMBER(13,2) NULL ,
"MOST_ALL_BIDDING" NVARCHAR2(255) NULL ,
"BIDDING_CONTENT_ID" NVARCHAR2(32) NULL ,
"LAST_QUOTE" NUMBER(13,2) NULL ,
"BIDDING_CONTENT_ITEM_NO" NVARCHAR2(255) NULL ,
"QUOTATION_METHOD" NVARCHAR2(255) NULL ,
"IS_STEP" NVARCHAR2(255) NULL ,
"ALL_BIDDING" NVARCHAR2(50) NULL ,
"PICTURE_ATTACHMENT" CLOB NULL ,
"DESIGN_PIC_ATTACHMENT" CLOB NULL ,
"TEMP_MATERIAL_NO" NVARCHAR2(255) NULL ,
"COST_ANALYSIS_ID" NVARCHAR2(32) NULL ,
"FACTORY" VARCHAR2(255 BYTE) NULL ,
"FACTORY_NAME" VARCHAR2(255 BYTE) NULL ,
"INSTRUMENT_STATUS" VARCHAR2(255 BYTE) DEFAULT 0  NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_CONTENT_MATTER" IS '物料类招标';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."BIDDING_HEADER_ID" IS '招标单ID';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."MATERIAL_NO" IS '物料编号';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."MATERIAL_DESC" IS '名称描述';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."MATERIAL_FEATURES" IS '物料品牌';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."MATERIAL_SPEC" IS '规格';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."MATERIAL_MODEL" IS '型号';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."UNIT" IS '单位';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."BIDDING_QUANTITY" IS '招标数量';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."CURRENCY" IS '币种';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."DOSAGE" IS '用量';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."UNIT_PRICE" IS '目标单价（不含税单价）';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."SET_THE_PRICE" IS '目标套价(不含税套价)';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."MOST_ALL_BIDDING" IS '必须全部投标 0:否 1:是';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."BIDDING_CONTENT_ID" IS '招标内容主表ID';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."LAST_QUOTE" IS '上一轮报价';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."QUOTATION_METHOD" IS '报价方式 0:阶梯报价,1:常规报价';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."IS_STEP" IS '是否阶梯报价';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."ALL_BIDDING" IS '0：必须全部投标、1：可以部分投标';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."PICTURE_ATTACHMENT" IS '图片附件';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."DESIGN_PIC_ATTACHMENT" IS '方案、设计图纸';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."TEMP_MATERIAL_NO" IS '临时物料编号：招标单号+序号';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."COST_ANALYSIS_ID" IS '物料成本分析清单ID';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."FACTORY" IS '工厂代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."FACTORY_NAME" IS '工厂名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT_MATTER"."INSTRUMENT_STATUS" IS '议标';

ALTER TABLE "T_BASE_BIDDING_CONTENT_MATTER" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 招标内容
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_CONTENT" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"SUMMARY" NVARCHAR2(255) NULL ,
"DELIVERY_START_TIME" DATE NULL ,
"DELIVERY_END_TIME" DATE NULL ,
"DELIVERY_ADDRESS" NVARCHAR2(255) NULL ,
"QUALITY" NVARCHAR2(255) NULL ,
"ALL_BIDDING" NVARCHAR2(50) NULL ,
"EFFECTIVE_NUMBER" NUMBER NULL ,
"BID_EXPLAIN" NVARCHAR2(2000) NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_CONTENT" IS '招标内容';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."SUMMARY" IS '招标内容概述';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."DELIVERY_START_TIME" IS '交付起始日期';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."DELIVERY_END_TIME" IS '交付结束日期';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."DELIVERY_ADDRESS" IS '交付地点';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."QUALITY" IS '质量要求';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."ALL_BIDDING" IS '0：必须全部投标、1：可以部分投标';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."EFFECTIVE_NUMBER" IS '每轮报价有效次数';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTENT"."BID_EXPLAIN" IS '评标说明(针对一个招标单一个)';

ALTER TABLE "T_BASE_BIDDING_CONTENT" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 保证金
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_BOND" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_ITEM_NO" NVARCHAR2(255) NULL ,
"COLLECT_MONEY" NVARCHAR2(50) NULL ,
"BACK_MONEY" NVARCHAR2(50) NULL ,
"AMOUNT" NVARCHAR2(50) NULL ,
"CURRENCY" NVARCHAR2(255) NULL ,
"PAY_BEGIN_TIME" DATE NULL ,
"PAY_END_TIME" DATE NULL ,
"BOND_RULE" NVARCHAR2(255) NULL ,
"OPEN_BANK_ADDRESS" NVARCHAR2(255) NULL ,
"OPEN_BANK_NAME" NVARCHAR2(255) NULL ,
"BANK_ACCOUNT" NVARCHAR2(255) NULL ,
"BIDDING_HEADER_ID" NVARCHAR2(32) NULL ,
"EFFECTIVE_NUMBER" NUMBER NULL 
);
COMMENT ON TABLE "T_BASE_BIDDING_BOND" IS '保证金';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."BIDDING_ITEM_NO" IS '标段序号';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."COLLECT_MONEY" IS '收取保证金 0：否 1：是';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."BACK_MONEY" IS '退还保证金 0：否 1：是';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."AMOUNT" IS '保证金金额';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."CURRENCY" IS '币别';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."PAY_BEGIN_TIME" IS '缴纳开始日期';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."PAY_END_TIME" IS '缴纳结束日期';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."BOND_RULE" IS '保证金细节规则';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."OPEN_BANK_ADDRESS" IS '开户行地址';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."OPEN_BANK_NAME" IS '开户行名称';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."BANK_ACCOUNT" IS '对公银行卡帐号';
COMMENT ON COLUMN "T_BASE_BIDDING_BOND"."EFFECTIVE_NUMBER" IS '每轮报价有效次数';

ALTER TABLE "T_BASE_BIDDING_BOND" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 联系信息
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_CONTACT_INFO" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"SUP_COMPANY_NAME" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"SUP_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"SUP_USER_ID" NVARCHAR2(32) NULL ,
"SUP_USER_NAME" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(2000) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"LINK_MAN_TYPE" NVARCHAR2(50) NULL ,
"ORG_NAME" NVARCHAR2(255) NULL ,
"PRINCIPAL" NVARCHAR2(255) NULL ,
"TELEPHONE" NVARCHAR2(255) NULL ,
"EMAIL" NVARCHAR2(255) NULL ,
"FAX" NVARCHAR2(255) NULL ,
"ADDRESS" NVARCHAR2(255) NULL,
"OPEN_BANK_ADDRESS" NVARCHAR2(255) NULL ,
"OPEN_BANK_NAME" NVARCHAR2(255) NULL ,
"BANK_ACCOUNT" NVARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_BIDDING_CONTACT_INFO" IS '联系信息';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."ID" IS 'id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."PUR_COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."PUR_COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."PUR_COMPANY_SRM_CODE" IS '公司srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."PUR_COMPANY_SAP_CODE" IS '公司sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."SUP_COMPANY_ID" IS '供应商companyid';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."SUP_COMPANY_SRM_CODE" IS '供应商srm代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."SUP_COMPANY_SAP_CODE" IS '供应商sap代码';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."SUP_USER_NAME" IS '供应商用户名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."BIDDING_NO" IS '招标编号';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."LINK_MAN_TYPE" IS '联系信息类型：0：招标机构，1：招标代理机构';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."ORG_NAME" IS '单位名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."PRINCIPAL" IS '负责人';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."TELEPHONE" IS '联系电话';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."EMAIL" IS '电子邮箱';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."FAX" IS '电子传真';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."ADDRESS" IS '详细地址';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."OPEN_BANK_ADDRESS" IS '开户行地址';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."OPEN_BANK_NAME" IS '开户行名称';
COMMENT ON COLUMN "T_BASE_BIDDING_CONTACT_INFO"."BANK_ACCOUNT" IS '对公银行卡帐号';

ALTER TABLE "T_BASE_BIDDING_CONTACT_INFO" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 招投标-评标小组管理
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_BID_GROUP" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"BID_GROUP" NVARCHAR2(50) NULL ,
"BID_USER_ID" NVARCHAR2(32) NULL ,
"BID_USER_CODE" NVARCHAR2(255) NULL ,
"BID_USER_NAME" NVARCHAR2(255) NULL ,
"AFFILIATE_ID" NVARCHAR2(32) NULL ,
"AFFILIATE_NAME" NVARCHAR2(255) NULL ,
"DEPARTMENT_ID" NVARCHAR2(32) NULL ,
"DEPARTMENT_NAME" NVARCHAR2(255) NULL ,
"BID_TIMES" NUMBER(11) NULL ,
"IS_ENABLED" NUMBER(2) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL ,
"UPDATE_USER" NVARCHAR2(255) NULL ,
PRIMARY KEY ("ID")
);

COMMENT ON TABLE "T_BASE_BIDDING_BID_GROUP" IS '招投标-评标小组管理';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."ID" IS '主键';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."PROJECT_ID" IS '项目ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."PUR_COMPANY_ID" IS '采购公司ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."PUR_COMPANY_NAME" IS '采购公司名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."PUR_COMPANY_SRM_CODE" IS '采购公司srm编码';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."PUR_COMPANY_SAP_CODE" IS '采购公司sap编码';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."PUR_USER_ID" IS '采购用户ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."PUR_USER_NAME" IS '采购用户名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."BID_GROUP" IS '评标小组';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."BID_USER_ID" IS '评标员ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."BID_USER_CODE" IS '评标员编码';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."BID_USER_NAME" IS '评标员姓名';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."AFFILIATE_ID" IS '所属机构ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."AFFILIATE_NAME" IS '所属机构名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."DEPARTMENT_ID" IS '部门ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."DEPARTMENT_NAME" IS '部门名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."BID_TIMES" IS '评标次数';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."IS_ENABLED" IS '是否有效（0失效，1有效）';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."UPDATE_TIME" IS '修改时间';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_GROUP"."UPDATE_USER" IS '修改人';


-- ----------------------------
-- 招投标-评标标准管理
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_BID_STANDARD" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"STANDARD_TYPE" NVARCHAR2(50) NULL ,
"STANDARD_CODE" NVARCHAR2(255) NULL ,
"STANDARD_NAME" NVARCHAR2(255) NULL ,
"IS_ENABLED" NUMBER(2) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL ,
"UPDATE_USER" NVARCHAR2(255) NULL ,
"ACTIVATION_STATUS" NUMBER(2) NULL ,
PRIMARY KEY ("ID")
);

COMMENT ON TABLE "T_BASE_BIDDING_BID_STANDARD" IS '招投标-评标标准管理';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."ID" IS '主键';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."PROJECT_ID" IS '项目ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."PUR_COMPANY_ID" IS '采购公司ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."PUR_COMPANY_NAME" IS '采购公司名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."PUR_COMPANY_SRM_CODE" IS '采购公司srm编码';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."PUR_COMPANY_SAP_CODE" IS '采购公司sap编码';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."PUR_USER_ID" IS '采购用户ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."PUR_USER_NAME" IS '采购用户名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."STANDARD_TYPE" IS '标准类型';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."STANDARD_CODE" IS '标准编码';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."STANDARD_NAME" IS '标准名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."IS_ENABLED" IS '是否可用（0不可用，1可用）';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."UPDATE_TIME" IS '修改时间';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."UPDATE_USER" IS '修改人';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_STANDARD"."ACTIVATION_STATUS" IS '激活状态（0失效，1激活）';


-- ----------------------------
-- 招投标-评标模板管理头
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_BID_TEMPLATE" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"TEMPLATE_TYPE" NVARCHAR2(50) NULL ,
"TEMPLATE_CODE" NVARCHAR2(255) NULL ,
"TEMPLATE_NAME" NVARCHAR2(255) NULL ,
"APPLY_SCOPE" NVARCHAR2(50) NULL ,
"ACTIVATION_STATUS" NUMBER(2) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL ,
"UPDATE_USER" NVARCHAR2(255) NULL ,
"IS_ENABLED" NUMBER(2) NULL ,
PRIMARY KEY ("ID")
);

COMMENT ON TABLE "T_BASE_BIDDING_BID_TEMPLATE" IS '招投标-评标模板管理头';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."ID" IS '主键';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."PROJECT_ID" IS '项目ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."PUR_COMPANY_ID" IS '采购公司ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."PUR_COMPANY_NAME" IS '采购公司名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."PUR_COMPANY_SRM_CODE" IS '采购公司srm编码';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."PUR_COMPANY_SAP_CODE" IS '采购公司sap编码';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."PUR_USER_ID" IS '采购用户ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."PUR_USER_NAME" IS '采购用户名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."TEMPLATE_TYPE" IS '模板类型';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."TEMPLATE_CODE" IS '模板编码';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."TEMPLATE_NAME" IS '模板名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."APPLY_SCOPE" IS '适用范围';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."ACTIVATION_STATUS" IS '激活状态（0失效，1激活）';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."UPDATE_TIME" IS '修改时间';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."UPDATE_USER" IS '修改人';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMPLATE"."IS_ENABLED" IS '是否可用（0不可用，1可用）';



-- ----------------------------
-- 招投标-评标模板管理行
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_BID_TEMP_ITEM" (
"ID" NVARCHAR2(32) NOT NULL ,
"TEMPLATE_ID" NVARCHAR2(32) NOT NULL ,
"STANDARD_ID" NVARCHAR2(32) NOT NULL ,
"STANDARD_TYPE" NVARCHAR2(255) NULL ,
"STANDARD_CODE" NVARCHAR2(255) NULL ,
"STANDARD_NAME" NVARCHAR2(255) NULL ,
"WEIGHT_COEFFICIENT" NUMBER(10,2) NULL ,
"CREATE_TIME" DATE NULL ,
"CREATER" NVARCHAR2(255) NULL ,
"UPDATE_TIME" DATE NULL ,
"IS_ENABLED" NUMBER(2) NULL ,
PRIMARY KEY ("ID")
);

COMMENT ON TABLE "T_BASE_BIDDING_BID_TEMP_ITEM" IS '招投标-评标模板管理行';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."ID" IS '主键';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."TEMPLATE_ID" IS '模板头ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."STANDARD_ID" IS '评标标准ID';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."STANDARD_TYPE" IS '标准类型';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."STANDARD_CODE" IS '标准编码';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."STANDARD_NAME" IS '标准名称';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."WEIGHT_COEFFICIENT" IS '权重';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."CREATER" IS '创建人';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."UPDATE_TIME" IS '修改时间';

COMMENT ON COLUMN "T_BASE_BIDDING_BID_TEMP_ITEM"."IS_ENABLED" IS '是否可用（0不可用，1可用）';


-- ----------------------------
-- 评标小组信息-招标单
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_TEAM" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(50) NULL ,
"GROUP_ID" NVARCHAR2(32) NULL ,
"BID_GROUP" NVARCHAR2(50) NULL ,
"BID_USER_ID" NVARCHAR2(32) NULL ,
"BID_USER_CODE" NVARCHAR2(255) NULL ,
"BID_USER_NAME" NVARCHAR2(255) NULL ,
"AFFILIATE_ID" NVARCHAR2(32) NULL ,
"AFFILIATE_NAME" NVARCHAR2(255) NULL ,
"DEPARTMENT_ID" NVARCHAR2(32) NULL ,
"DEPARTMENT_NAME" NVARCHAR2(255) NULL ,
"BID_TIMES" NUMBER(11) NULL ,
"JOIN_DATE" DATE NULL ,
"CREATE_TIME" DATE NULL ,
"IS_ENABLED" NUMBER(2) NULL ,
"UPDATE_TIME" DATE NULL ,
"UPDATE_USER" NVARCHAR2(255) NULL ,
PRIMARY KEY ("ID")
);

COMMENT ON TABLE "T_BASE_BIDDING_TEAM" IS '评标小组信息-招标单';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."ID" IS '主键';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."PROJECT_ID" IS '项目ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."PUR_COMPANY_ID" IS '采购公司ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."PUR_COMPANY_NAME" IS '采购公司名称';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."PUR_COMPANY_SRM_CODE" IS '采购公司srm编码';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."PUR_COMPANY_SAP_CODE" IS '采购公司sap编码';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."PUR_USER_ID" IS '采购用户ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."PUR_USER_NAME" IS '采购用户名称';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."BIDDING_NO" IS '招标编号';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."GROUP_ID" IS '评标小组ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."BID_GROUP" IS '评标小组';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."BID_USER_ID" IS '评标员ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."BID_USER_CODE" IS '评标员编码';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."BID_USER_NAME" IS '评标员姓名';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."AFFILIATE_ID" IS '所属机构ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."AFFILIATE_NAME" IS '所属机构名称';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."DEPARTMENT_ID" IS '部门ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."DEPARTMENT_NAME" IS '部门名称';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."BID_TIMES" IS '评标次数';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."JOIN_DATE" IS '加入时间';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."IS_ENABLED" IS '是否可用（0不可用，1可用）';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."UPDATE_TIME" IS '修改时间';

COMMENT ON COLUMN "T_BASE_BIDDING_TEAM"."UPDATE_USER" IS '修改人';


-- ----------------------------
-- 评标模板信息-招标单
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_TEMPLATE_INFO" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(50) NULL ,
"TEMPLATE_ID" NVARCHAR2(32) NULL ,
"TEMPLATE_TYPE" VARCHAR2(255) NULL ,
"TEMPLATE_CODE" VARCHAR2(255) NULL ,
"TEMPLATE_NAME" VARCHAR2(255) NULL ,
"APPLY_SCOPE" VARCHAR2(255) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL ,
"UPDATE_USER" NVARCHAR2(255) NULL ,
"IS_ENABLED" NUMBER(2) NULL ,
PRIMARY KEY ("ID")
);

COMMENT ON TABLE "T_BASE_BIDDING_TEMPLATE_INFO" IS '评标模板信息-招标单';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."ID" IS '主键';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."PROJECT_ID" IS '项目ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."PUR_COMPANY_ID" IS '采购公司ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."PUR_COMPANY_NAME" IS '采购公司名称';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."PUR_COMPANY_SRM_CODE" IS '采购公司srm编码';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."PUR_COMPANY_SAP_CODE" IS '采购公司sap编码';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."PUR_USER_ID" IS '采购用户ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."PUR_USER_NAME" IS '采购用户名称';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."BIDDING_NO" IS '招标编号';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."TEMPLATE_ID" IS '评标模板头ID';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."TEMPLATE_TYPE" IS '模板类型';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."TEMPLATE_CODE" IS '模板编码';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."TEMPLATE_NAME" IS '模板名称';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."APPLY_SCOPE" IS '适用范围';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."UPDATE_TIME" IS '修改时间';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."UPDATE_USER" IS '修改人';

COMMENT ON COLUMN "T_BASE_BIDDING_TEMPLATE_INFO"."IS_ENABLED" IS '是否可用（0不可用，1可用）';



-- ----------------------------
-- 评分-招标单
-- ----------------------------
CREATE TABLE "T_BASE_BIDDING_SUPPLIER_SCORE" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SRM_CODE" NVARCHAR2(255) NULL ,
"PUR_COMPANY_SAP_CODE" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"BIDDING_NO" NVARCHAR2(255) NULL ,
"BIDDING_ROUNDS_NUMBER" NVARCHAR2(50) NULL ,
"TEMPLATE_ID" NVARCHAR2(32) NULL ,
"TEMPLATE_TYPE" VARCHAR2(255) NULL ,
"SUP_COMPANY_CODE" VARCHAR2(255) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255) NULL ,
"SUP_COMPANY_ID" NVARCHAR2(32) NULL ,
"RATERS_ID" NVARCHAR2(32) NULL ,
"RATERS_NAME" VARCHAR2(255) NULL ,
"STANDARD_CODE" VARCHAR2(255) NULL ,
"STANDARD_NAME" VARCHAR2(255) NULL ,
"WEIGHT_COEFFICIENT" NUMBER(10,2) NULL ,
"SCORE" NUMBER(10,2) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL ,
"UPDATE_USER" VARCHAR2(255) NULL ,
"IS_ENABLED" NUMBER(2) NULL ,
PRIMARY KEY ("ID")
);

COMMENT ON TABLE "T_BASE_BIDDING_SUPPLIER_SCORE" IS '评分-招标单';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."ID" IS '主键';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."PROJECT_ID" IS '项目ID';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."PUR_COMPANY_ID" IS '采购公司ID';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."PUR_COMPANY_NAME" IS '采购公司名称';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."PUR_COMPANY_SRM_CODE" IS '采购公司srm编码';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."PUR_COMPANY_SAP_CODE" IS '采购公司sap编码';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."PUR_USER_ID" IS '采购用户ID';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."PUR_USER_NAME" IS '采购用户名称';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."BIDDING_NO" IS '招标编号';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."BIDDING_ROUNDS_NUMBER" IS '招标轮次';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."TEMPLATE_ID" IS '评标模板头ID';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."TEMPLATE_TYPE" IS '模板类型';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."SUP_COMPANY_CODE" IS '供应商编码';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."SUP_COMPANY_NAME" IS '供应商名称';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."SUP_COMPANY_ID" IS '供应商ID';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."RATERS_ID" IS '评分人ID';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."RATERS_NAME" IS '评分人姓名';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."STANDARD_CODE" IS '标准编码';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."STANDARD_NAME" IS '标准名称';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."WEIGHT_COEFFICIENT" IS '权重';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."SCORE" IS '得分';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."CREATE_TIME" IS '创建时间';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."UPDATE_TIME" IS '修改时间';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."UPDATE_USER" IS '修改人';

COMMENT ON COLUMN "T_BASE_BIDDING_SUPPLIER_SCORE"."IS_ENABLED" IS '是否可用（0不可用，1可用）';

