/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingFileSupplierMapper;
import com.els.base.bidding.entity.BiddingFileSupplier;
import com.els.base.bidding.entity.BiddingFileSupplierExample;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.enums.BiddingFileTypeEnum;
import com.els.base.bidding.service.BiddingFileSupplierService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultBiddingFileSupplierService")
public class BiddingFileSupplierServiceImpl
implements BiddingFileSupplierService {
    @Resource
    protected BiddingFileSupplierMapper biddingFileSupplierMapper;
    @Resource
    protected BiddingSupplierService biddingSupplierService;

    @CacheEvict(value={"biddingFileSupplier"}, allEntries=true)
    public void addObj(BiddingFileSupplier t) {
        this.biddingFileSupplierMapper.insertSelective(t);
    }

    @CacheEvict(value={"biddingFileSupplier"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingFileSupplierMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingFileSupplier"}, allEntries=true)
    public void modifyObj(BiddingFileSupplier t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingFileSupplierMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingFileSupplier"}, keyGenerator="redisKeyGenerator")
    public BiddingFileSupplier queryObjById(String id) {
        return this.biddingFileSupplierMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"biddingFileSupplier"}, keyGenerator="redisKeyGenerator")
    public List<BiddingFileSupplier> queryAllObjByExample(BiddingFileSupplierExample example) {
        return this.biddingFileSupplierMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingFileSupplier"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingFileSupplier> queryObjByPage(BiddingFileSupplierExample example) {
        PageView<BiddingFileSupplier> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingFileSupplierMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"biddingFileSupplier"}, allEntries=true)
    public void saveFileSupplier(BiddingBaseVo biddingBaseVo) {
        int i;
        List<BiddingFileSupplier> biddingSupplierFiles = biddingBaseVo.getBiddingFileSupplier();
        Assert.isNotEmpty(biddingSupplierFiles, (String)"\u5fc5\u987b\u4e0a\u4f20\u6280\u672f\u3001\u5546\u52a1\u7c7b\u578b\u6807\u4e66");
        int technologyCount = biddingSupplierFiles.stream().filter(file -> BiddingFileTypeEnum.TECHNOLOGY_DOCUMENTS.getValue().equals(file.getFileType())).collect(Collectors.toList()).size();
        int businessCount = biddingSupplierFiles.stream().filter(file -> BiddingFileTypeEnum.BUSINESS_DOCUMENTS.getValue().equals(file.getFileType())).collect(Collectors.toList()).size();
        if (technologyCount == 0 || businessCount == 0) {
            throw new CommonException("\u5fc5\u987b\u4e0a\u4f20\u6280\u672f\u3001\u5546\u52a1\u7c7b\u578b\u4e24\u79cd\u6807\u4e66");
        }
        BiddingFileSupplierExample biddingFileSupplierExample = new BiddingFileSupplierExample();
        BiddingFileSupplierExample.Criteria criteria = biddingFileSupplierExample.createCriteria();
        criteria.andSupCompanyIdEqualTo(biddingBaseVo.getCompany().getId());
        criteria.andBiddingNoEqualTo(biddingBaseVo.getBiddingHeader().getBiddingNo());
        List<BiddingFileSupplier> biddingFileSupplierList = this.biddingFileSupplierMapper.selectByExample(biddingFileSupplierExample);
        for (i = 0; CollectionUtils.isNotEmpty(biddingFileSupplierList) && i < biddingFileSupplierList.size(); ++i) {
            this.biddingFileSupplierMapper.deleteByPrimaryKey(biddingFileSupplierList.get(i).getId());
        }
        for (i = 0; CollectionUtils.isNotEmpty(biddingSupplierFiles) && i < biddingSupplierFiles.size(); ++i) {
            this.addBiddingFile(biddingSupplierFiles.get(i), biddingBaseVo.getBiddingHeader(), biddingBaseVo.getCompany(), biddingBaseVo.getUser());
        }
    }

    private void addBiddingFile(BiddingFileSupplier biddingFileSupplier, BiddingHeader biddingHeader, Company supCompany, User supUser) {
        if (biddingFileSupplier != null) {
            biddingFileSupplier.setSupCompanyId(supCompany.getId());
            biddingFileSupplier.setSupCompanyName(supCompany.getCompanyName());
            biddingFileSupplier.setSupCompanySapCode(supCompany.getCompanySapCode());
            biddingFileSupplier.setSupCompanySrmCode(supCompany.getCompanyCode());
            biddingFileSupplier.setSupUserId(supUser.getId());
            biddingFileSupplier.setSupUserName(supUser.getNickName());
            biddingFileSupplier.setBiddingHeaderId(biddingHeader.getId());
            biddingFileSupplier.setBiddingNo(biddingHeader.getBiddingNo());
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            supplierExample.createCriteria().andSupCompanyIdEqualTo(supCompany.getId()).andBiddingNoEqualTo(biddingFileSupplier.getBiddingNo());
            List biddingSuppliers = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
            biddingFileSupplier.setSupplierTemporaryCode(((BiddingSupplier)biddingSuppliers.get(0)).getSupplierTemporaryCode());
            this.addObj(biddingFileSupplier);
        }
    }

    public void deleteByExample(BiddingFileSupplierExample example) {
    }

    public void addAll(List<BiddingFileSupplier> list) {
    }
}

