/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.base.bidding.dao.BiddingHeaderMapper;
import com.els.base.bidding.entity.BiddingBond;
import com.els.base.bidding.entity.BiddingBondExample;
import com.els.base.bidding.entity.BiddingContactInfo;
import com.els.base.bidding.entity.BiddingContactInfoExample;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentExample;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentMatterExample;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.entity.BiddingFile;
import com.els.base.bidding.entity.BiddingFileExample;
import com.els.base.bidding.entity.BiddingFileSupplier;
import com.els.base.bidding.entity.BiddingFileSupplierExample;
import com.els.base.bidding.entity.BiddingGroup;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingMatter;
import com.els.base.bidding.entity.BiddingMatterStep;
import com.els.base.bidding.entity.BiddingMatterStepExample;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingPlan;
import com.els.base.bidding.entity.BiddingPlanExample;
import com.els.base.bidding.entity.BiddingPower;
import com.els.base.bidding.entity.BiddingPowerExample;
import com.els.base.bidding.entity.BiddingScore;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.BiddingTeam;
import com.els.base.bidding.entity.BiddingTeamExample;
import com.els.base.bidding.entity.BiddingTemplateInfo;
import com.els.base.bidding.entity.BiddingTemplateInfoExample;
import com.els.base.bidding.entity.BiddingTemplateItem;
import com.els.base.bidding.entity.BiddingTemplateItemExample;
import com.els.base.bidding.entity.BiddingTradeCondition;
import com.els.base.bidding.entity.BiddingTradeConditionExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.BiddingScoreAndPrice;
import com.els.base.bidding.entity.vo.ManagementPage;
import com.els.base.bidding.enums.ApprovalStatusEnum;
import com.els.base.bidding.enums.BiddingFileTypeEnum;
import com.els.base.bidding.enums.BiddingGroupTypeEnum;
import com.els.base.bidding.enums.BiddingSendOaTemplateEnum;
import com.els.base.bidding.enums.BiddingTypeEnum;
import com.els.base.bidding.enums.ConfirmStatusEnum;
import com.els.base.bidding.enums.SendBiddingStatusEnum;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingBondService;
import com.els.base.bidding.service.BiddingContactInfoService;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingFileService;
import com.els.base.bidding.service.BiddingFileSupplierService;
import com.els.base.bidding.service.BiddingGroupService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterService;
import com.els.base.bidding.service.BiddingMatterStepService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingPlanService;
import com.els.base.bidding.service.BiddingPowerService;
import com.els.base.bidding.service.BiddingQuestionService;
import com.els.base.bidding.service.BiddingScoreService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.bidding.service.BiddingTeamService;
import com.els.base.bidding.service.BiddingTemplateInfoService;
import com.els.base.bidding.service.BiddingTemplateItemService;
import com.els.base.bidding.service.BiddingTradeConditionService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.Department;
import com.els.base.company.enums.AccountSetEnum;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.web.vo.DepartmentExcelVO;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.inquiry.IExtendable;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.materialprice.entity.MaterialPrice;
import com.els.base.materialprice.entity.MaterialPriceExample;
import com.els.base.materialprice.service.MaterialPriceService;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.template.center.entity.TemplateCenter;
import com.els.base.template.center.service.TemplateCenterService;
import com.els.base.template.center.utils.TemplateUtils;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.sinolifesdk.service.SinoLifeApiService;
import com.els.sinolifesdk.util.SFFileUtils;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingHeaderService")
public class BiddingHeaderServiceImpl
implements BiddingHeaderService,
ITaskListener {
    private static Logger logger = LoggerFactory.getLogger(BiddingHeaderServiceImpl.class);
    @Resource
    protected BiddingHeaderMapper biddingHeaderMapper;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected BiddingPowerService biddingPowerService;
    @Resource
    protected BiddingPlanService biddingPlanService;
    @Resource
    protected BiddingContactInfoService biddingContactInfoService;
    @Resource
    protected BiddingContentService biddingContentService;
    @Resource
    protected BiddingQuestionService biddingQuestionService;
    @Resource
    protected BiddingContentMatterService biddingContentMatterService;
    @Resource
    protected BiddingContentModelService biddingContentModelService;
    @Resource
    protected BiddingContentOtherService biddingContentOtherService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;
    @Resource
    protected BiddingBondService biddingBondService;
    @Resource
    protected BiddingMatterStepService biddingMatterStepService;
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;
    @Resource
    protected BiddingFileService biddingFileService;
    @Resource
    protected BiddingFileSupplierService biddingFileSupplierService;
    @Resource
    protected WorkFlowService workFlowService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected BiddingOfferService biddingOfferService;
    @Resource
    protected TemplateConfService templateConfService;
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    @Resource
    protected BiddingTradeConditionService biddingTradeConditionService;
    @Resource
    protected BiddingContentMatterService biddingContentMatterServiceService;
    @Resource
    protected BiddingTeamService biddingTeamService;
    @Resource
    protected BiddingTemplateInfoService biddingTemplateInfoService;
    @Resource
    protected BiddingTemplateItemService biddingTemplateItemService;
    @Resource
    protected BiddingScoreService biddingScoreService;
    @Resource
    protected BiddingGroupService biddingGroupService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected BiddingMatterService biddingMatterService;
    @Resource
    protected SinoLifeApiService sinoLifeApiService;
    @Resource
    protected TemplateCenterService templateCenterService;
    @Resource
    protected MaterialPriceService materialPriceService;
    @Resource
    protected DepartmentService departmentService;

    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void addObj(BiddingHeader t) {
        String biddingNo = this.generateCodeService.getNextCode("BIDDING_NO");
        t.setBiddingNo(biddingNo);
        t.setCreateTime(new Date());
        this.biddingHeaderMapper.insertSelective(t);
    }

    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingHeaderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void modifyObj(BiddingHeader t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingHeaderMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void customModifyObj(BiddingHeader t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingHeaderMapper.customUpdateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingHeader"}, keyGenerator="redisKeyGenerator")
    public BiddingHeader queryObjById(String id) {
        return this.biddingHeaderMapper.selectByPrimaryKey(id);
    }

    public List<BiddingHeader> queryAllObjByExample(BiddingHeaderExample example) {
        return this.biddingHeaderMapper.selectByExample(example);
    }

    public PageView<BiddingHeader> queryObjByPage(BiddingHeaderExample example) {
        PageView<BiddingHeader> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingHeaderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingHeader,biddingPower,biddingPlan,biddingContactInfo,biddingBond,biddingContent,biddingContentItem,biddingSupplier,biddingMatterStep,biddingContentMatter,biddingContentModel,biddingContentOther,biddingTeam,biddingTemplateInfo"}, allEntries=true)
    public void saveBiddingInfo(BiddingBaseVo biddingBaseVo) {
        BiddingContent biddingContent;
        BiddingPower biddingPower;
        String biddingNo;
        Company purCompany = biddingBaseVo.getCompany();
        User purUser = biddingBaseVo.getUser();
        BiddingHeader biddingHeader = biddingBaseVo.getBiddingHeader();
        String string = biddingNo = biddingHeader.getBiddingNo() == null ? "" : biddingHeader.getBiddingNo();
        if (biddingHeader != null) {
            biddingHeader.setPurCompanyId(purCompany.getId());
            biddingHeader.setPurCompanyCode(purCompany.getCompanyCode());
            biddingHeader.setPurCompanyName(purCompany.getCompanyName());
            biddingHeader.setBiddingStatus(TenderStatusEumn.NOTPUBLISH.getValue());
            biddingHeader.setBiddingPreAuditstatus(SendBiddingStatusEnum.UNSEND.getValue());
            biddingHeader.setBiddingAuditstatus(ApprovalStatusEnum.NOT_APPROVAL.getValue());
            biddingHeader.setScoreStatus(ConfirmStatusEnum.NO_CONFIRM.getValue());
            Assert.isNotBlank((String)biddingHeader.getDepartId(), (String)"\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isBlank((String)biddingHeader.getBiddingMatterId())) {
                throw new CommonException("\u62db\u6807\u4e8b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BiddingMatter biddingMatter = (BiddingMatter)this.biddingMatterService.queryObjById(biddingHeader.getBiddingMatterId());
            biddingHeader.setTechnicalWeight(biddingMatter.getTechnicalWeight());
            biddingHeader.setBusniessWeight(biddingMatter.getBusniessWeight());
            biddingHeader.setBiddingMatterName(biddingMatter.getBiddingMatterName());
            if (biddingHeader.getId() == null) {
                biddingHeader.setPurUserId(purUser.getId());
                biddingHeader.setPurUserName(StringUtils.isNotBlank((String)purUser.getNickName()) ? purUser.getNickName() : purUser.getLoginName());
                this.addObj(biddingHeader);
            } else {
                biddingHeader.setPurUserId(null);
                biddingHeader.setPurUserName(null);
                biddingHeader.setLastUpdateTime(new Date());
                biddingHeader.setLastUpdateUser(biddingBaseVo.getUser().getNickName());
                this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
            }
        }
        if ((biddingPower = biddingHeader.getBiddingPower()) != null) {
            if (biddingPower.getId() == null) {
                this.addBiddingPower(biddingHeader, purCompany, purUser);
            } else {
                biddingPower.setLastUpdateTime(new Date());
                biddingPower.setLastUpdateUser(biddingBaseVo.getUser().getNickName());
                this.biddingPowerService.modifyObj(biddingPower);
            }
        }
        List<BiddingPlan> biddingPlanList = biddingBaseVo.getBiddingPlanList();
        this.biddingPlanService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingPlanList) && i < biddingPlanList.size(); ++i) {
            this.addBiddingPlan(biddingPlanList, biddingHeader, purCompany, purUser);
        }
        List<BiddingContactInfo> biddingContactInfoList = biddingBaseVo.getBiddingContactInfoList();
        this.biddingContactInfoService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContactInfoList) && i < biddingContactInfoList.size(); ++i) {
            this.addBiddingContactInfo(biddingContactInfoList.get(i), biddingHeader, purCompany, purUser);
        }
        BiddingBond biddingBond = biddingBaseVo.getBiddingBond();
        if (biddingBond != null) {
            this.biddingBondService.deleteByBiddingNo(biddingNo);
            this.addBiddingBond(biddingBaseVo.getBiddingBond(), biddingHeader, purCompany, purUser);
        }
        if ((biddingContent = biddingBaseVo.getBiddingContent()) != null) {
            this.biddingContentService.deleteByBiddingNo(biddingNo);
            this.addBiddingContent(biddingContent, biddingHeader, purCompany, purUser);
        }
        List<BiddingSupplier> biddingSupplierList = biddingBaseVo.getBiddingSupplierList();
        this.biddingSupplierService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
            this.addBiddingSupplier(biddingSupplierList.get(i), biddingHeader, purCompany, purUser);
        }
        List<BiddingFile> biddingFiles = biddingBaseVo.getBiddingFiles();
        this.biddingFileService.deleteByBiddingNo(biddingNo);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingFiles) && i < biddingFiles.size(); ++i) {
            this.addBiddingFile(biddingFiles.get(i), biddingHeader, purCompany, purUser);
        }
        List<BiddingTeam> biddingTeamList = biddingBaseVo.getBiddingTeamList();
        this.biddingTeamService.deleteByBiddingNo(biddingNo);
        if (CollectionUtils.isNotEmpty(biddingTeamList)) {
            List technicalTeamList = biddingTeamList.stream().filter(team -> team.getBidGroup().equals(BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(technicalTeamList)) {
                throw new CommonException("\u5fc5\u987b\u6dfb\u52a0\u6280\u672f\u7ec4\u7684\u8bc4\u6807\u4eba\u5458");
            }
            long technicalCount = technicalTeamList.stream().map(BiddingTeam::getBidUserId).distinct().count();
            if (technicalCount < (long)technicalTeamList.size()) {
                throw new CommonException("\u6280\u672f\u7ec4\u4e2d\u6dfb\u52a0\u4e86\u76f8\u540c\u7684\u8bc4\u6807\u4eba\u5458");
            }
            List businessTeamList = biddingTeamList.stream().filter(team -> team.getBidGroup().equals(BiddingGroupTypeEnum.BUSINESS_GROUP.getValue())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(businessTeamList)) {
                throw new CommonException("\u5fc5\u987b\u6dfb\u52a0\u5546\u52a1\u7ec4\u7684\u8bc4\u6807\u4eba\u5458");
            }
            long businessCount = businessTeamList.stream().map(BiddingTeam::getBidUserId).distinct().count();
            if (businessCount < (long)businessTeamList.size()) {
                throw new CommonException("\u5546\u52a1\u7ec4\u4e2d\u6dfb\u52a0\u4e86\u76f8\u540c\u7684\u8bc4\u6807\u4eba\u5458");
            }
            int allCount = technicalTeamList.size() + businessTeamList.size();
            if (allCount < 5 || allCount % 2 == 0) {
                throw new CommonException("\u5546\u52a1\u5c0f\u7ec4\u52a0\u4e0a\u6280\u672f\u5c0f\u7ec4\u4eba\u6570\u8981\u5927\u4e8e\u7b49\u4e8e5\uff0c\u5e76\u4e14\u4eba\u6570\u548c\u5fc5\u987b\u4e3a\u5947\u6570");
            }
            for (int i = 0; i < biddingTeamList.size(); ++i) {
                Assert.isNotBlank((String)biddingTeamList.get(i).getBidUserId(), (String)"\u8bc4\u6807\u5458\u7684\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
                this.addBiddingTeam(biddingTeamList.get(i), biddingHeader, purCompany, purUser);
            }
        }
        List<BiddingTemplateInfo> biddingTemplateInfoList = biddingBaseVo.getBiddingTemplateInfoList();
        this.biddingTemplateInfoService.deleteByBiddingNo(biddingNo);
        if (CollectionUtils.isNotEmpty(biddingTemplateInfoList)) {
            int technicalCount = biddingTemplateInfoList.stream().filter(info -> info.getTemplateType().equals(BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue())).collect(Collectors.toList()).size();
            if (technicalCount == 0 || technicalCount > 1) {
                throw new CommonException("\u6280\u672f\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a\u6280\u672f\u6a21\u677f");
            }
            int businessCount = biddingTemplateInfoList.stream().filter(info -> info.getTemplateType().equals(BiddingGroupTypeEnum.BUSINESS_GROUP.getValue())).collect(Collectors.toList()).size();
            if (businessCount == 0 || businessCount > 1) {
                throw new CommonException("\u5546\u52a1\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a\u5546\u52a1\u6a21\u677f");
            }
            for (int i = 0; i < biddingTemplateInfoList.size(); ++i) {
                Assert.isNotBlank((String)biddingTemplateInfoList.get(i).getTemplateId(), (String)"\u5728\u8bc4\u6807\u6a21\u677f\u7ba1\u7406\u4e2d\u7684\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
                this.addBiddingTemplateInfo(biddingTemplateInfoList.get(i), biddingHeader, purCompany, purUser);
            }
        }
    }

    private void addBiddingTemplateInfo(BiddingTemplateInfo biddingTemplateInfo, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        biddingTemplateInfo.setPurCompanyId(purCompany.getId());
        biddingTemplateInfo.setPurCompanyName(purCompany.getCompanyFullName());
        biddingTemplateInfo.setPurCompanySapCode(purCompany.getCompanySapCode());
        biddingTemplateInfo.setPurCompanySrmCode(purCompany.getCompanyCode());
        biddingTemplateInfo.setPurUserId(purUser.getId());
        biddingTemplateInfo.setPurUserName(purUser.getNickName());
        biddingTemplateInfo.setBiddingNo(biddingHeader.getBiddingNo());
        biddingTemplateInfo.setBiddingRoundsNumber(biddingHeader.getBiddingCurrentRound());
        biddingTemplateInfo.setCreateTime(new Date());
        biddingTemplateInfo.setIsEnabled(Constant.YES_INT);
        this.biddingTemplateInfoService.addObj(biddingTemplateInfo);
    }

    private void addBiddingTeam(BiddingTeam biddingTeam, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        biddingTeam.setPurCompanyId(purCompany.getId());
        biddingTeam.setPurCompanyName(purCompany.getCompanyFullName());
        biddingTeam.setPurCompanySapCode(purCompany.getCompanySapCode());
        biddingTeam.setPurCompanySrmCode(purCompany.getCompanyCode());
        biddingTeam.setPurUserId(purUser.getId());
        biddingTeam.setPurUserName(purUser.getNickName());
        biddingTeam.setBiddingNo(biddingHeader.getBiddingNo());
        biddingTeam.setBiddingRoundsNumber(biddingHeader.getBiddingCurrentRound());
        biddingTeam.setCreateTime(new Date());
        biddingTeam.setIsEnabled(Constant.YES_INT);
        biddingTeam.setBidStatus(Constant.NO_INT);
        biddingTeam.setConfirmStatus(Constant.NO_INT);
        this.biddingTeamService.addObj(biddingTeam);
    }

    private void addBiddingFile(BiddingFile biddingFile, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        if (biddingFile != null) {
            biddingFile.setPurCompanyId(purCompany.getId());
            biddingFile.setPurCompanyName(purCompany.getCompanyName());
            biddingFile.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingFile.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingFile.setPurUserId(purUser.getId());
            biddingFile.setPurUserName(purUser.getNickName());
            biddingFile.setBiddingHeaderId(biddingHeader.getId());
            biddingFile.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingFileService.addObj(biddingFile);
        }
    }

    private void addBiddingBond(BiddingBond biddingBond, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        if (biddingBond != null) {
            biddingBond.setId(null);
            biddingBond.setPurCompanyId(purCompany.getId());
            biddingBond.setPurCompanyName(purCompany.getCompanyName());
            biddingBond.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingBond.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingBond.setPurUserId(purUser.getId());
            biddingBond.setPurUserName(purUser.getNickName());
            biddingBond.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingBondService.addObj(biddingBond);
        }
    }

    @Override
    public void addBiddingSupplier(BiddingSupplier biddingSupplier, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        if (biddingSupplier != null) {
            biddingSupplier.setPurCompanyId(purCompany.getId());
            biddingSupplier.setPurCompanyName(purCompany.getCompanyName());
            biddingSupplier.setPurCompanyCode(purCompany.getCompanyCode());
            biddingSupplier.setPurUserId(purUser.getId());
            biddingSupplier.setPurUserName(purUser.getNickName());
            biddingSupplier.setBiddingHeaderId(biddingHeader.getId());
            biddingSupplier.setBiddingNo(biddingHeader.getBiddingNo());
            biddingSupplier.setSupParticipate("0");
            this.biddingSupplierService.addObj(biddingSupplier);
        }
    }

    private void addBiddingContent(BiddingContent biddingContent, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        if (biddingContent != null) {
            int j;
            biddingContent.setPurCompanyId(purCompany.getId());
            biddingContent.setPurCompanyName(purCompany.getCompanyName());
            biddingContent.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingContent.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingContent.setPurUserId(purUser.getId());
            biddingContent.setPurUserName(purUser.getNickName());
            biddingContent.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingContentService.addObj(biddingContent);
            List<BiddingContentMatter> biddingContentMatterList = biddingContent.getBiddingContentMatterList();
            List<BiddingContentOther> biddingContentOtherList = biddingContent.getBiddingContentOtherList();
            for (j = 0; CollectionUtils.isNotEmpty(biddingContentMatterList) && j < biddingContentMatterList.size(); ++j) {
                BiddingContentMatter biddingContentMatter = biddingContentMatterList.get(j);
                biddingContentMatter.setId(null);
                biddingContentMatter.setPurCompanyId(purCompany.getId());
                biddingContentMatter.setPurCompanyName(purCompany.getCompanyName());
                biddingContentMatter.setPurCompanySapCode(purCompany.getCompanySapCode());
                biddingContentMatter.setPurCompanySrmCode(purCompany.getCompanyCode());
                biddingContentMatter.setPurUserId(purUser.getId());
                biddingContentMatter.setPurUserName(purUser.getNickName());
                biddingContentMatter.setBiddingNo(biddingHeader.getBiddingNo());
                biddingContentMatter.setBiddingContentId(biddingContent.getId());
                biddingContentMatter.setBiddingQuantity(biddingContentMatter.getDosage());
                this.biddingContentMatterService.addObj(biddingContentMatter);
                List<BiddingMatterStep> biddingMatterStepList = biddingContentMatter.getBiddingMatterStepList();
                for (int i = 0; CollectionUtils.isNotEmpty(biddingMatterStepList) && i < biddingMatterStepList.size(); ++i) {
                    BiddingMatterStep biddingMatterStep = biddingMatterStepList.get(i);
                    biddingMatterStep.setPurCompanyId(purCompany.getId());
                    biddingMatterStep.setPurCompanyName(purCompany.getCompanyName());
                    biddingMatterStep.setPurCompanySapCode(purCompany.getCompanySapCode());
                    biddingMatterStep.setPurCompanySrmCode(purCompany.getCompanyCode());
                    biddingMatterStep.setPurUserId(purUser.getId());
                    biddingMatterStep.setPurUserName(purUser.getNickName());
                    biddingMatterStep.setBiddingNo(biddingHeader.getBiddingNo());
                    biddingMatterStep.setBiddingHeaderId(biddingHeader.getId());
                    biddingMatterStep.setMatterId(biddingContentMatter.getId());
                    this.biddingMatterStepService.addObj(biddingMatterStep);
                }
                BiddingTradeCondition biddingTradeCondition = new BiddingTradeCondition();
                biddingTradeCondition.setPurCompanyId(purCompany.getId());
                biddingTradeCondition.setPurCompanyName(purCompany.getCompanyName());
                biddingTradeCondition.setPurCompanySapCode(purCompany.getCompanySapCode());
                biddingTradeCondition.setPurCompanySrmCode(purCompany.getCompanyCode());
                biddingTradeCondition.setPurUserId(purUser.getId());
                biddingTradeCondition.setPurUserName(purUser.getNickName());
                this.biddingTradeConditionService.addObj(biddingTradeCondition);
            }
            for (j = 0; CollectionUtils.isNotEmpty(biddingContentOtherList) && j < biddingContentOtherList.size(); ++j) {
                BiddingContentOther biddingContentOther = biddingContentOtherList.get(j);
                biddingContentOther.setPurCompanyId(purCompany.getId());
                biddingContentOther.setPurCompanyName(purCompany.getCompanyName());
                biddingContentOther.setPurCompanySapCode(purCompany.getCompanySapCode());
                biddingContentOther.setPurCompanySrmCode(purCompany.getCompanyCode());
                biddingContentOther.setPurUserId(purUser.getId());
                biddingContentOther.setPurUserName(purUser.getNickName());
                biddingContentOther.setBiddingNo(biddingHeader.getBiddingNo());
                biddingContentOther.setBiddingContentId(biddingContent.getId());
                this.biddingContentOtherService.addObj(biddingContentOther);
            }
        }
    }

    private void addBiddingContactInfo(BiddingContactInfo biddingContactInfo, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        if (biddingContactInfo != null) {
            biddingContactInfo.setPurCompanyId(purCompany.getId());
            biddingContactInfo.setPurCompanyName(purCompany.getCompanyName());
            biddingContactInfo.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingContactInfo.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingContactInfo.setPurUserId(purUser.getId());
            biddingContactInfo.setPurUserName(purUser.getNickName());
            biddingContactInfo.setBiddingNo(biddingHeader.getBiddingNo());
            this.biddingContactInfoService.addObj(biddingContactInfo);
        }
    }

    private void addBiddingPlan(List<BiddingPlan> biddingPlanList, BiddingHeader biddingHeader, Company purCompany, User purUser) {
        for (int i = 0; CollectionUtils.isNotEmpty(biddingPlanList) && i < biddingPlanList.size(); ++i) {
            BiddingPlan biddingPlan = biddingPlanList.get(i);
            biddingPlan.setPurCompanyId(purCompany.getId());
            biddingPlan.setPurCompanyName(purCompany.getCompanyName());
            biddingPlan.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingPlan.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingPlan.setPurUserId(purUser.getId());
            biddingPlan.setPurUserName(purUser.getNickName());
            biddingPlan.setBiddingId(biddingHeader.getId());
            biddingPlan.setBiddingNo(biddingHeader.getBiddingNo());
            biddingPlan.setBiddingRoundsNumber("1");
            biddingPlan.setBiddingTotalRound("1");
            biddingHeader.setBiddingCurrentRound(biddingPlan.getBiddingRoundsNumber());
            BiddingHeader header = new BiddingHeader();
            header.setId(biddingHeader.getId());
            header.setBiddingCurrentRound(biddingPlan.getBiddingRoundsNumber());
            header.setBiddingTotalRound(biddingPlan.getBiddingTotalRound());
            header.setBiddingBegindate(biddingPlan.getBiddingBeginDate());
            header.setBiddingEnddate(biddingPlan.getBiddingEndDate());
            header.setBiddingDeadline(biddingPlan.getBiddingDeadline());
            header.setBiddingOpenDate(biddingPlan.getBiddingOpenDate());
            this.biddingHeaderMapper.updateByPrimaryKeySelective(header);
            this.biddingPlanService.addObj(biddingPlan);
        }
    }

    private void addBiddingPower(BiddingHeader biddingHeader, Company purCompany, User purUser) {
        BiddingPower biddingPower = biddingHeader.getBiddingPower();
        biddingPower.setPurCompanyId(purCompany.getId());
        biddingPower.setPurCompanyCode(purCompany.getCompanyCode());
        biddingPower.setPurUserId(purUser.getId());
        biddingPower.setPurUserName(purUser.getNickName());
        biddingPower.setBiddingHeaderId(biddingHeader.getId());
        biddingPower.setBiddingNo(biddingHeader.getBiddingNo());
        this.biddingPowerService.addObj(biddingPower);
    }

    @Override
    public List<ManagementPage> transform(List<BiddingHeader> queryResult, User user, List<String> roleCodeList) {
        ArrayList<ManagementPage> managementPages = new ArrayList<ManagementPage>();
        for (int i = 0; CollectionUtils.isNotEmpty(queryResult) && i < queryResult.size(); ++i) {
            int timeCompareBiddingDeadline;
            Date biddingDeadlineDate;
            ManagementPage managementPage = new ManagementPage();
            managementPage.setBiddingNo(queryResult.get(i).getBiddingNo());
            managementPage.setBiddingAuditstatus(queryResult.get(i).getBiddingAuditstatus());
            managementPage.setBiddingPreAuditstatus(queryResult.get(i).getBiddingPreAuditstatus());
            managementPage.setBiddingName(queryResult.get(i).getBiddingName());
            managementPage.setBiddingType(queryResult.get(i).getBiddingType());
            managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
            managementPage.setBiddingRoundsNumber(queryResult.get(i).getBiddingCurrentRound());
            managementPage.setBiddingTotalRound(queryResult.get(i).getBiddingTotalRound());
            managementPage.setPurUserName(queryResult.get(i).getPurUserName());
            managementPage.setPublishDate(queryResult.get(i).getPublishDate());
            managementPage.setBiddingDeadline(queryResult.get(i).getBiddingDeadline());
            managementPage.setBiddingBegindate(queryResult.get(i).getBiddingBegindate());
            managementPage.setBiddingEnddate(queryResult.get(i).getBiddingEnddate());
            managementPage.setBiddingOpenDate(queryResult.get(i).getBiddingOpenDate());
            managementPage.setApproveFlowId(queryResult.get(i).getApproveFlowId());
            managementPage.setApproveFlowId2(queryResult.get(i).getApproveFlowId2());
            managementPage.setScoreStatus(queryResult.get(i).getScoreStatus());
            managementPage.setBusinessStatus(queryResult.get(i).getBusinessStatus());
            managementPage.setCreateTime(queryResult.get(i).getCreateTime());
            managementPage.setTotalGroupId(queryResult.get(i).getTotalGroupId());
            managementPage.setTotalGroupName(queryResult.get(i).getTotalGroupName());
            managementPage.setAccountCode(queryResult.get(i).getAccountCode());
            managementPage.setAccountSetId(queryResult.get(i).getAccountSetId());
            managementPage.setAccountSetName(queryResult.get(i).getAccountSetName());
            managementPage.setInstitutionsId(queryResult.get(i).getInstitutionsId());
            managementPage.setInstitutionsName(queryResult.get(i).getInstitutionsName());
            managementPage.setInTheOrganizationId(queryResult.get(i).getInTheOrganizationId());
            managementPage.setInTheOrganizationName(queryResult.get(i).getInTheOrganizationName());
            managementPage.setDepartId(queryResult.get(i).getDepartId());
            managementPage.setDepartName(queryResult.get(i).getDepartName());
            int count = this.biddingQuestionService.countPurQuestionInfo(queryResult.get(i).getBiddingNo());
            managementPage.setQuestionCount(count);
            if (queryResult.get(i).getPurUserId().equals(user.getId())) {
                managementPage.setCurrentUserCreate("1");
            } else {
                managementPage.setCurrentUserCreate("0");
            }
            BiddingContactInfoExample ContactInfoExample = new BiddingContactInfoExample();
            ContactInfoExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List biddingContactInfoList = this.biddingContactInfoService.queryAllObjByExample((IExample)ContactInfoExample);
            if (biddingContactInfoList.size() == 0) {
                managementPage.setInfoIsAllInsert("0");
            }
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria createCriteria = supplierExample.createCriteria();
            createCriteria.andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List biddingSupplierPartNo = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
            managementPage.setPartNo(String.valueOf(biddingSupplierPartNo.size()));
            createCriteria.andSupParticipateEqualTo("1");
            List biddingSupplierBidNo = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
            managementPage.setBidNo(String.valueOf(biddingSupplierBidNo.size()));
            createCriteria.andSupBiddingEqualTo("1");
            List biddingSupplierBiddingNumber = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
            if (CollectionUtils.isNotEmpty((Collection)biddingSupplierBiddingNumber)) {
                managementPage.setBiddingNumber(String.valueOf(biddingSupplierBiddingNumber.size()));
            }
            BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria criteria = biddingSupplierExample.createCriteria();
            criteria.andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            criteria.andSupBiddingEqualTo("1");
            List sumList = this.biddingSupplierService.queryAllObjByExample((IExample)biddingSupplierExample);
            int sum = sumList.size();
            if (sum >= biddingSupplierBidNo.size() && sum > 0) {
                managementPage.setIsAllBid("1");
            } else {
                managementPage.setIsAllBid("0");
            }
            ArrayList<String> supBiddingStatusList = new ArrayList<String>();
            for (int j = 0; CollectionUtils.isNotEmpty((Collection)biddingSupplierPartNo) && j < biddingSupplierPartNo.size(); ++j) {
                if (((BiddingSupplier)biddingSupplierPartNo.get(j)).getSupBiddingStatus() == null) continue;
                supBiddingStatusList.add(((BiddingSupplier)biddingSupplierPartNo.get(j)).getSupBiddingStatus());
            }
            if (queryResult.get(i).getBiddingStatus() != null && !queryResult.get(i).getBiddingStatus().equals(TenderStatusEumn.ISCANCEL.getValue()) && !queryResult.get(i).getBiddingStatus().equals(TenderStatusEumn.NOTPUBLISH.getValue()) && CollectionUtils.isNotEmpty(supBiddingStatusList)) {
                Date bidSubmitDate;
                int timeCompareBiddingBegindate = this.compareTwoTimes(new Date(), queryResult.get(i).getBiddingBegindate());
                int timeCompareBiddingEnddate = this.compareTwoTimes(new Date(), queryResult.get(i).getBiddingEnddate());
                if ((timeCompareBiddingBegindate == 1 || timeCompareBiddingBegindate == 0) && timeCompareBiddingEnddate == -1) {
                    if (TenderStatusEumn.BIDOVER.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISSCALING.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISFINISH.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.INBID.getValue().equals(queryResult.get(i).getBiddingStatus())) {
                        managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
                    } else {
                        managementPage.setBiddingStatus(TenderStatusEumn.BIDDING.getValue());
                    }
                }
                int timeCompareBiddingOpenDate = this.compareTwoTimes(new Date(), queryResult.get(i).getBiddingOpenDate());
                if ((timeCompareBiddingEnddate == 1 || timeCompareBiddingEnddate == 0) && timeCompareBiddingOpenDate == -1) {
                    if (TenderStatusEumn.BIDOVER.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISSCALING.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISFINISH.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.INBID.getValue().equals(queryResult.get(i).getBiddingStatus())) {
                        managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
                    } else {
                        managementPage.setBiddingStatus(TenderStatusEumn.BIDDINGEND.getValue());
                    }
                }
                if ((bidSubmitDate = queryResult.get(i).getBidSubmitDate()) == null) {
                    Calendar c = Calendar.getInstance();
                    c.add(5, 1);
                    bidSubmitDate = c.getTime();
                }
                int timeCompareBidSubmitDate = this.compareTwoTimes(new Date(), bidSubmitDate);
                if ((timeCompareBiddingOpenDate == 1 || timeCompareBiddingOpenDate == 0) && timeCompareBidSubmitDate == -1) {
                    if (TenderStatusEumn.BIDOVER.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISSCALING.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.ISFINISH.getValue().equals(queryResult.get(i).getBiddingStatus()) || TenderStatusEumn.INBID.getValue().equals(queryResult.get(i).getBiddingStatus())) {
                        managementPage.setBiddingStatus(queryResult.get(i).getBiddingStatus());
                    } else {
                        managementPage.setBiddingStatus(TenderStatusEumn.INBID.getValue());
                    }
                }
                if (timeCompareBiddingEnddate == 1 && (CollectionUtils.isEmpty((Collection)biddingSupplierBiddingNumber) || biddingSupplierBiddingNumber.size() < 3)) {
                    managementPage.setBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                    BiddingHeader header2 = new BiddingHeader();
                    header2.setId(queryResult.get(i).getId());
                    header2.setBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                    this.biddingHeaderMapper.updateByPrimaryKeySelective(header2);
                    BiddingSupplierExample supExample2 = new BiddingSupplierExample();
                    supExample2.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
                    BiddingSupplier sup2 = new BiddingSupplier();
                    sup2.setSupBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                    this.biddingSupplierService.modifyObjSup(sup2, supExample2);
                }
            }
            if ((biddingDeadlineDate = queryResult.get(i).getBiddingDeadline()) == null) {
                Calendar c = Calendar.getInstance();
                c.add(5, 1);
                biddingDeadlineDate = c.getTime();
            }
            if ((timeCompareBiddingDeadline = this.compareTwoTimes(new Date(), biddingDeadlineDate)) == 1 && SendBiddingStatusEnum.SEND.getValue().equals(managementPage.getBiddingPreAuditstatus()) && !TenderStatusEumn.ISCANCEL.getValue().equals(managementPage.getBiddingStatus()) && (CollectionUtils.isEmpty((Collection)biddingSupplierBidNo) || biddingSupplierBidNo.size() < 3)) {
                managementPage.setBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                BiddingHeader header = new BiddingHeader();
                header.setId(queryResult.get(i).getId());
                header.setBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                this.biddingHeaderMapper.updateByPrimaryKeySelective(header);
                BiddingSupplierExample supExample = new BiddingSupplierExample();
                supExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
                BiddingSupplier sup = new BiddingSupplier();
                sup.setSupBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                this.biddingSupplierService.modifyObjSup(sup, supExample);
            }
            managementPages.add(managementPage);
        }
        return managementPages;
    }

    private int compareTwoTimes(Date date, Date biddingDeadline) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = sdf.format(date);
        String format2 = sdf.format(biddingDeadline);
        int compareTo = 0;
        try {
            Date date_01 = sdf.parse(format);
            Date date_02 = sdf.parse(format2);
            compareTo = date_01.compareTo(date_02);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return compareTo;
    }

    @Override
    public List<ManagementPage> transformSup(List<BiddingHeader> queryResult, User user, List<String> roleCodeList, Company company) {
        ArrayList<ManagementPage> managementPages = new ArrayList<ManagementPage>();
        for (int i = 0; CollectionUtils.isNotEmpty(queryResult) && i < queryResult.size(); ++i) {
            List biddingSupplierPartNo;
            List biddingSupplierStatus;
            ManagementPage managementPage = new ManagementPage();
            managementPage.setBiddingNo(queryResult.get(i).getBiddingNo());
            managementPage.setBiddingAuditstatus(queryResult.get(i).getBiddingAuditstatus());
            managementPage.setBiddingPreAuditstatus(queryResult.get(i).getBiddingPreAuditstatus());
            managementPage.setBiddingName(queryResult.get(i).getBiddingName());
            managementPage.setBiddingType(queryResult.get(i).getBiddingType());
            managementPage.setBiddingRoundsNumber(queryResult.get(i).getBiddingCurrentRound());
            managementPage.setBiddingTotalRound(queryResult.get(i).getBiddingTotalRound());
            managementPage.setPurUserName(queryResult.get(i).getPurUserName());
            managementPage.setBiddingBegindate(queryResult.get(i).getBiddingBegindate());
            managementPage.setBiddingEnddate(queryResult.get(i).getBiddingEnddate());
            managementPage.setBiddingDeadline(queryResult.get(i).getBiddingDeadline());
            managementPage.setPublishDate(queryResult.get(i).getPublishDate());
            managementPage.setBiddingOpenDate(queryResult.get(i).getBiddingOpenDate());
            managementPage.setApproveFlowId(queryResult.get(i).getApproveFlowId());
            managementPage.setApproveFlowId2(queryResult.get(i).getApproveFlowId2());
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            BiddingSupplierExample.Criteria createCriteria = supplierExample.createCriteria();
            createCriteria.andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            createCriteria.andSupCompanyIdEqualTo(company.getId());
            int count = this.biddingQuestionService.countSupplierQuestionInfo(queryResult.get(i).getBiddingNo(), company);
            managementPage.setQuestionCount(count);
            BiddingBondExample biddingBondExample = new BiddingBondExample();
            biddingBondExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List biddingBondList = this.biddingBondService.queryAllObjByExample((IExample)biddingBondExample);
            if (CollectionUtils.isNotEmpty((Collection)biddingBondList)) {
                managementPage.setCollectMoney(((BiddingBond)biddingBondList.get(0)).getCollectMoney());
            }
            if (CollectionUtils.isNotEmpty((Collection)(biddingSupplierStatus = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample)))) {
                managementPage.setIsPayMoney(((BiddingSupplier)biddingSupplierStatus.get(0)).getIsPayMoney());
                Date curDate = new Date();
                int biddingBegindate = this.compareTwoTimes(curDate, queryResult.get(i).getBiddingBegindate());
                int biddingEnddate = this.compareTwoTimes(curDate, queryResult.get(i).getBiddingEnddate());
                int biddingOpenDate = this.compareTwoTimes(curDate, queryResult.get(i).getBiddingOpenDate());
                Date submitDate = queryResult.get(i).getBidSubmitDate();
                if (submitDate == null) {
                    Calendar c = Calendar.getInstance();
                    c.add(5, 1);
                    submitDate = c.getTime();
                }
                int bidSubmitDate = this.compareTwoTimes(curDate, submitDate);
                if (TenderStatusEumn.ISCANCEL.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                    managementPage.setBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                } else {
                    BiddingOfferExample biddingOfferExample = new BiddingOfferExample();
                    biddingOfferExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo()).andSupCompanyIdEqualTo(company.getId());
                    List biddingOfferList = this.biddingOfferService.queryAllObjByExample((IExample)biddingOfferExample);
                    Boolean isInstrumentStatus = biddingOfferList.stream().allMatch(b -> "0".equals(b.getInstrumentStatus()));
                    if (CollectionUtils.isNotEmpty((Collection)biddingOfferList)) {
                        if (isInstrumentStatus.booleanValue() && TenderStatusEumn.INSTRUMENT.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                            if ((biddingBegindate == 1 || biddingBegindate == 0) && biddingEnddate == -1) {
                                managementPage.setBiddingStatus(TenderStatusEumn.BIDDING.getValue());
                            } else {
                                managementPage.setBiddingStatus(TenderStatusEumn.INBID.getValue());
                            }
                        } else if ("1".equals(((BiddingOffer)biddingOfferList.get(0)).getInstrumentStatus())) {
                            managementPage.setBiddingStatus(TenderStatusEumn.INSTRUMENT.getValue());
                        } else {
                            managementPage.setBiddingStatus(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus());
                            if ((biddingBegindate == 1 || biddingBegindate == 0) && biddingEnddate == -1 && TenderStatusEumn.ISBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                                managementPage.setBiddingStatus(TenderStatusEumn.BIDDING.getValue());
                            }
                            if ((biddingEnddate == 1 || biddingEnddate == 0) && biddingOpenDate == -1) {
                                if (TenderStatusEumn.ISBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                                    managementPage.setBiddingStatus(TenderStatusEumn.BIDDINGEND.getValue());
                                }
                            } else if ((biddingOpenDate == 1 || biddingOpenDate == 0) && bidSubmitDate == -1 && TenderStatusEumn.ISBID.getValue().equals(((BiddingSupplier)biddingSupplierStatus.get(0)).getSupBiddingStatus())) {
                                managementPage.setBiddingStatus(TenderStatusEumn.INBID.getValue());
                            }
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(biddingSupplierPartNo = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample)))) {
                managementPage.setPartNo(String.valueOf(biddingSupplierPartNo.size()));
            }
            createCriteria.andSupParticipateEqualTo("11");
            List biddingSupplierBidNo = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
            if (CollectionUtils.isNotEmpty((Collection)biddingSupplierBidNo)) {
                managementPage.setBidNo(String.valueOf(biddingSupplierBidNo.size()));
            }
            createCriteria.andSupBiddingEqualTo("2");
            List biddingSupplierBiddingNumber = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
            if (CollectionUtils.isNotEmpty((Collection)biddingSupplierBiddingNumber)) {
                managementPage.setBiddingNumber(String.valueOf(biddingSupplierBiddingNumber.size()));
            }
            BiddingContactInfoExample biddingContactInfoExample = new BiddingContactInfoExample();
            biddingContactInfoExample.createCriteria().andBiddingNoEqualTo(queryResult.get(i).getBiddingNo());
            List biddingContactInfoList = this.biddingContactInfoService.queryAllObjByExample((IExample)biddingContactInfoExample);
            if (biddingContactInfoList.size() <= 0) continue;
            managementPages.add(managementPage);
        }
        return managementPages;
    }

    private void setBiddingItemInfo(BiddingContent biddingContent, BiddingBaseVo baseVo) {
        BiddingContentMatterExample matterExample = new BiddingContentMatterExample();
        matterExample.createCriteria().andBiddingContentIdEqualTo(biddingContent.getId());
        matterExample.setOrderByClause(" MATERIAL_DESC DESC ");
        List biddingContentMatterList = this.biddingContentMatterService.queryAllObjByExample((IExample)matterExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingContentMatterList) && i < biddingContentMatterList.size(); ++i) {
            BiddingContentMatter biddingContentMatter = (BiddingContentMatter)biddingContentMatterList.get(i);
            BiddingMatterStepExample example = new BiddingMatterStepExample();
            example.createCriteria().andMatterIdEqualTo(biddingContentMatter.getId());
            List queryAllObjByExample = this.biddingMatterStepService.queryAllObjByExample((IExample)example);
            biddingContentMatter.setBiddingMatterStepList(queryAllObjByExample);
            BiddingTradeConditionExample biddingTradeConditionExample = new BiddingTradeConditionExample();
            biddingTradeConditionExample.createCriteria().andBiddingNoEqualTo(biddingContentMatter.getBiddingNo());
            List biddingTradeConditionList = this.biddingTradeConditionService.queryAllObjByExample((IExample)biddingTradeConditionExample);
            biddingContentMatter.setBiddingTradeConditionList(biddingTradeConditionList);
        }
        biddingContent.setBiddingContentMatterList(biddingContentMatterList);
        BiddingContentModelExample modelExample = new BiddingContentModelExample();
        modelExample.createCriteria().andBiddingContentIdEqualTo(biddingContent.getId());
        modelExample.setOrderByClause(" MODEL_DESC DESC ");
        List biddingContentModelList = this.biddingContentModelService.queryAllObjByExample((IExample)modelExample);
        biddingContent.setBiddingContentModelList(biddingContentModelList);
        BiddingContentOtherExample otherExample = new BiddingContentOtherExample();
        otherExample.createCriteria().andBiddingContentIdEqualTo(biddingContent.getId());
        otherExample.setOrderByClause(" TAREGT_DESC DESC ");
        List biddingContentOtherList = this.biddingContentOtherService.queryAllObjByExample((IExample)otherExample);
        biddingContent.setBiddingContentOtherList(biddingContentOtherList);
        if (!(!CollectionUtils.isNotEmpty(baseVo.getRoleList()) || baseVo.getRoleList().contains("systemManager") || baseVo.getRoleList().contains("manager") || baseVo.getRoleList().contains("supplier") || biddingContent.getPurUserId().equals(baseVo.getUser().getId()))) {
            BiddingPowerExample biddingPowerExample = new BiddingPowerExample();
            biddingPowerExample.createCriteria().andBiddingNoEqualTo(biddingContent.getBiddingNo());
            List biddingPowerList = this.biddingPowerService.queryAllObjByExample((IExample)biddingPowerExample);
            if (CollectionUtils.isNotEmpty((Collection)biddingPowerList) && ((BiddingPower)biddingPowerList.get(0)).getBiddingTendererPower().equals("0")) {
                for (BiddingContentMatter matter : biddingContent.getBiddingContentMatterList()) {
                    matter.setIsHidePrice("1");
                }
                for (BiddingContentModel model : biddingContent.getBiddingContentModelList()) {
                    model.setIsHidePrice("1");
                }
                for (BiddingContentOther other : biddingContent.getBiddingContentOtherList()) {
                    other.setIsHidePrice("1");
                }
            }
        }
    }

    private void setBiddingItemInfoSup(BiddingContent biddingContent, String biddingCurrentRound, BiddingBaseVo baseVo) {
        Object queryAllObjByExample;
        BiddingOfferExample matterExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria matterCriteria = matterExample.createCriteria();
        matterCriteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());
        matterCriteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());
        matterCriteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);
        matterCriteria.andRequirementTypeCodeEqualTo("material");
        List biddingOfferMatterList = this.biddingOfferService.queryAllObjByExample((IExample)matterExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingOfferMatterList) && i < biddingOfferMatterList.size(); ++i) {
            BiddingOffer biddingOfferMatter = (BiddingOffer)biddingOfferMatterList.get(i);
            BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
            BiddingMatterStepSupExample.Criteria criteria = example.createCriteria();
            criteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());
            criteria.andMatterIdEqualTo(biddingOfferMatter.getMatterId());
            criteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());
            criteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);
            example.setOrderByClause("QUANTITY_START ASC");
            queryAllObjByExample = this.biddingMatterStepSupService.queryAllObjByExample((IExample)example);
            biddingOfferMatter.setBiddingMatterStepSupList((List<BiddingMatterStepSup>)queryAllObjByExample);
            if (StringUtils.isNotBlank((String)biddingOfferMatter.getCostAnalysisId())) {
                IOrderItemDetailService service = ((TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById((Object)biddingOfferMatter.getCostAnalysisId())).getOrderItemDetailService();
                biddingOfferMatter.setOrderItemDetail(service.queryObjByOrderItemId(biddingOfferMatter.getId()));
            }
            BiddingTradeConditionExample biddingTradeExample = new BiddingTradeConditionExample();
            biddingTradeExample.createCriteria().andSupItemIdEqualTo(biddingOfferMatter.getId());
            List biddingTradeConditionList = this.biddingTradeConditionService.queryAllObjByExample((IExample)biddingTradeExample);
            biddingOfferMatter.setBiddingTradeConditionList(biddingTradeConditionList);
        }
        biddingContent.setBiddingOfferMatterList(biddingOfferMatterList);
        if (CollectionUtils.isNotEmpty((Collection)biddingOfferMatterList)) {
            BiddingOffer offerMatter = new BiddingOffer();
            offerMatter.setAllBidding(((BiddingOffer)biddingOfferMatterList.get(0)).getAllBidding());
            offerMatter.setIsPayMoney(baseVo.getIsPayMoney());
            biddingContent.setBiddingOfferMatter(offerMatter);
        }
        BiddingOfferExample modelExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria modelCriteria = modelExample.createCriteria();
        modelCriteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());
        modelCriteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());
        modelCriteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);
        modelCriteria.andRequirementTypeCodeEqualTo("die");
        List biddingOfferModelList = this.biddingOfferService.queryAllObjByExample((IExample)modelExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingOfferModelList) && i < biddingOfferModelList.size(); ++i) {
            queryAllObjByExample = (BiddingOffer)biddingOfferModelList.get(i);
        }
        biddingContent.setBiddingOfferModelList(biddingOfferModelList);
        if (CollectionUtils.isNotEmpty((Collection)biddingOfferModelList)) {
            BiddingOffer offerModel = new BiddingOffer();
            offerModel.setAllBidding(((BiddingOffer)biddingOfferModelList.get(0)).getAllBidding());
            offerModel.setIsPayMoney(baseVo.getIsPayMoney());
            biddingContent.setBiddingOfferMode(offerModel);
        }
        BiddingOfferExample otheExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria otheCriteria = otheExample.createCriteria();
        otheCriteria.andBiddingNoEqualTo(biddingContent.getBiddingNo());
        otheCriteria.andSupCompanyIdEqualTo(baseVo.getCompany().getId());
        otheCriteria.andBiddingRoundsNumberEqualTo(biddingCurrentRound);
        otheCriteria.andRequirementTypeCodeEqualTo("device");
        List biddingOfferOtheList = this.biddingOfferService.queryAllObjByExample((IExample)otheExample);
        biddingContent.setBiddingOfferOtherList(biddingOfferOtheList);
        if (CollectionUtils.isNotEmpty((Collection)biddingOfferOtheList)) {
            BiddingOffer offerOther = new BiddingOffer();
            offerOther.setAllBidding(((BiddingOffer)biddingOfferOtheList.get(0)).getAllBidding());
            offerOther.setIsPayMoney(baseVo.getIsPayMoney());
            biddingContent.setBiddingOfferOther(offerOther);
        }
    }

    @Override
    public BiddingBaseVo queryDocument(String biddingNo, String biddingGroupType, Company company, User user, List<String> roleCodeList) {
        BiddingBaseVo baseVo = new BiddingBaseVo();
        baseVo.setRoleList(roleCodeList);
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            BiddingHeader biddingHeader = biddingHeaderList.get(i);
            baseVo.setBiddingHeader(biddingHeader);
            BiddingPowerExample biddingPowerExample = new BiddingPowerExample();
            biddingPowerExample.createCriteria().andBiddingHeaderIdEqualTo(biddingHeader.getId());
            List biddingPowerList = this.biddingPowerService.queryAllObjByExample((IExample)biddingPowerExample);
            biddingHeader.setBiddingPower(CollectionUtils.isEmpty((Collection)biddingPowerList) ? null : (BiddingPower)biddingPowerList.get(0));
        }
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        biddingPlanExample.setOrderByClause(" BIDDING_ROUNDS_NUMBER ASC ");
        List biddingPlanList = this.biddingPlanService.queryAllObjByExample((IExample)biddingPlanExample);
        baseVo.setBiddingPlanList(CollectionUtils.isEmpty((Collection)biddingPlanList) ? null : biddingPlanList);
        BiddingContactInfoExample biddingContactInfoExample = new BiddingContactInfoExample();
        biddingContactInfoExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContactInfoList = this.biddingContactInfoService.queryAllObjByExample((IExample)biddingContactInfoExample);
        baseVo.setBiddingContactInfoList(CollectionUtils.isEmpty((Collection)biddingContactInfoList) ? null : biddingContactInfoList);
        BiddingBondExample biddingBondExample = new BiddingBondExample();
        biddingBondExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingBondList = this.biddingBondService.queryAllObjByExample((IExample)biddingBondExample);
        baseVo.setBiddingBond(CollectionUtils.isEmpty((Collection)biddingBondList) ? null : (BiddingBond)biddingBondList.get(0));
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentList = this.biddingContentService.queryAllObjByExample((IExample)biddingContentExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingContentList) && i < biddingContentList.size(); ++i) {
            BiddingContent biddingContent = (BiddingContent)biddingContentList.get(i);
            baseVo.setBiddingContent(biddingContent);
            baseVo.setCompany(company);
            baseVo.setUser(user);
            this.setBiddingItemInfo(biddingContent, baseVo);
        }
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)biddingSupplierExample);
        for (Object biddingSupplier : biddingSupplierList) {
            if (!TenderStatusEumn.ISCANCEL.getValue().equals(((BiddingSupplier)biddingSupplier).getSupBiddingStatus())) continue;
            ((BiddingSupplier)biddingSupplier).setSupParticipate("7");
        }
        baseVo.setBiddingSupplierList(CollectionUtils.isEmpty((Collection)biddingSupplierList) ? null : biddingSupplierList);
        ArrayList<String> supplierIdList = new ArrayList<String>();
        for (BiddingSupplier sup : biddingSupplierList) {
            if (!"1".equals(sup.getSupBidding())) continue;
            supplierIdList.add(sup.getSupCompanyId());
        }
        BiddingFileExample biddingFileExample = new BiddingFileExample();
        biddingFileExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingFileList = this.biddingFileService.queryAllObjByExample((IExample)biddingFileExample);
        baseVo.setBiddingFiles(CollectionUtils.isEmpty((Collection)biddingFileList) ? null : biddingFileList);
        BiddingFileSupplierExample fileSupplierExample = new BiddingFileSupplierExample();
        fileSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingFileSupplier = this.biddingFileSupplierService.queryAllObjByExample((IExample)fileSupplierExample);
        if (CollectionUtils.isNotEmpty((Collection)biddingFileSupplier) && StringUtils.isNotBlank((String)biddingGroupType)) {
            if (BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue().equals(biddingGroupType)) {
                biddingFileSupplier = biddingFileSupplier.stream().filter(supFile -> !BiddingFileTypeEnum.BUSINESS_DOCUMENTS.getValue().equals(supFile.getFileType())).collect(Collectors.toList());
            } else if (BiddingGroupTypeEnum.BUSINESS_GROUP.getValue().equals(biddingGroupType)) {
                biddingFileSupplier = biddingFileSupplier.stream().filter(supFile -> !BiddingFileTypeEnum.TECHNOLOGY_DOCUMENTS.getValue().equals(supFile.getFileType())).collect(Collectors.toList());
            }
        }
        ArrayList<BiddingFileSupplier> fileSupplierList = new ArrayList<BiddingFileSupplier>();
        for (BiddingFileSupplier fileSupplier : biddingFileSupplier) {
            if (!supplierIdList.contains(fileSupplier.getSupCompanyId())) continue;
            fileSupplierList.add(fileSupplier);
        }
        baseVo.setBiddingFileSupplier(CollectionUtils.isEmpty(fileSupplierList) ? null : fileSupplierList);
        BiddingTeamExample teamExample = new BiddingTeamExample();
        teamExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List teamList = this.biddingTeamService.queryAllObjByExample((IExample)teamExample);
        baseVo.setBiddingTeamList(CollectionUtils.isEmpty((Collection)teamList) ? null : teamList);
        BiddingTemplateInfoExample infoExample = new BiddingTemplateInfoExample();
        infoExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List infoList = this.biddingTemplateInfoService.queryAllObjByExample((IExample)infoExample);
        baseVo.setBiddingTemplateInfoList(CollectionUtils.isEmpty((Collection)infoList) ? null : infoList);
        return baseVo;
    }

    @Override
    public BiddingBaseVo queryDocumentSup(String biddingNo, String biddingCurrentRound, Company company, User user, List<String> roleCodeList) {
        BiddingBaseVo baseVo = new BiddingBaseVo();
        baseVo.setRoleList(roleCodeList);
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            BiddingHeader biddingHeader = biddingHeaderList.get(i);
            baseVo.setBiddingHeader(biddingHeader);
            BiddingPowerExample biddingPowerExample = new BiddingPowerExample();
            biddingPowerExample.createCriteria().andBiddingHeaderIdEqualTo(biddingHeader.getId());
            List biddingPowerList = this.biddingPowerService.queryAllObjByExample((IExample)biddingPowerExample);
            biddingHeader.setBiddingPower(CollectionUtils.isEmpty((Collection)biddingPowerList) ? null : (BiddingPower)biddingPowerList.get(0));
        }
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        biddingPlanExample.setOrderByClause(" BIDDING_ROUNDS_NUMBER ASC ");
        List biddingPlanList = this.biddingPlanService.queryAllObjByExample((IExample)biddingPlanExample);
        baseVo.setBiddingPlanList(CollectionUtils.isEmpty((Collection)biddingPlanList) ? null : biddingPlanList);
        BiddingContactInfoExample biddingContactInfoExample = new BiddingContactInfoExample();
        biddingContactInfoExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContactInfoList = this.biddingContactInfoService.queryAllObjByExample((IExample)biddingContactInfoExample);
        baseVo.setBiddingContactInfoList(CollectionUtils.isEmpty((Collection)biddingContactInfoList) ? null : biddingContactInfoList);
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria criteria = biddingSupplierExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo);
        criteria.andSupCompanyIdEqualTo(company.getId());
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)biddingSupplierExample);
        BiddingBondExample biddingBondExample = new BiddingBondExample();
        biddingBondExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingBondList = this.biddingBondService.queryAllObjByExample((IExample)biddingBondExample);
        BiddingBond bond = null;
        if (CollectionUtils.isNotEmpty((Collection)biddingBondList)) {
            bond = (BiddingBond)biddingBondList.get(0);
            bond.setAttachmentSup(CollectionUtils.isEmpty((Collection)biddingSupplierList) ? null : ((BiddingSupplier)biddingSupplierList.get(0)).getBankAttachment());
        }
        baseVo.setBiddingBond(bond);
        baseVo.setIsPayMoney(CollectionUtils.isEmpty((Collection)biddingSupplierList) ? null : ((BiddingSupplier)biddingSupplierList.get(0)).getIsPayMoney());
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentList = this.biddingContentService.queryAllObjByExample((IExample)biddingContentExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingContentList) && i < biddingContentList.size(); ++i) {
            BiddingContent biddingContent = (BiddingContent)biddingContentList.get(i);
            baseVo.setBiddingContent(biddingContent);
            baseVo.setCompany(company);
            baseVo.setUser(user);
            this.setBiddingItemInfoSup(biddingContent, biddingCurrentRound, baseVo);
        }
        BiddingFileExample biddingFileExample = new BiddingFileExample();
        biddingFileExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingFileList = this.biddingFileService.queryAllObjByExample((IExample)biddingFileExample);
        baseVo.setBiddingFiles(CollectionUtils.isEmpty((Collection)biddingFileList) ? null : biddingFileList);
        BiddingFileSupplierExample fileSupplierExample = new BiddingFileSupplierExample();
        fileSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(company.getId());
        List biddingFileSupplier = this.biddingFileSupplierService.queryAllObjByExample((IExample)fileSupplierExample);
        baseVo.setBiddingFileSupplier(CollectionUtils.isEmpty((Collection)biddingFileSupplier) ? null : biddingFileSupplier);
        return baseVo;
    }

    @Override
    @Transactional
    public void toVoidDocument(String biddingNo) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(biddingHeaderList.get(i).getId());
            biddingHeader.setBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
            this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            supplierExample.createCriteria().andBiddingNoEqualTo(biddingHeaderList.get(i).getBiddingNo());
            List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
            for (BiddingSupplier supplier : biddingSupplierList) {
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setId(supplier.getId());
                biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISCANCEL.getValue());
                this.biddingSupplierService.modifyObj(biddingSupplier);
            }
        }
    }

    @Override
    @Transactional
    public void deleteDocumentByBiddingNo(String biddingNo) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        BiddingHeader biddingHeader = biddingHeaderList.get(0);
        String biddingHeaderId = biddingHeader.getId();
        this.biddingPowerService.deleteByBiddingNo(biddingNo);
        this.biddingHeaderMapper.deleteByPrimaryKey(biddingHeaderId);
        this.biddingPlanService.deleteByBiddingNo(biddingNo);
        this.biddingContactInfoService.deleteByBiddingNo(biddingNo);
        this.biddingBondService.deleteByBiddingNo(biddingNo);
        this.biddingContentService.deleteByBiddingNo(biddingNo);
        this.biddingSupplierService.deleteByBiddingNo(biddingNo);
        this.biddingFileService.deleteByBiddingNo(biddingNo);
        this.biddingMatterStepService.deleteByBiddingNo(biddingNo);
        this.biddingMatterStepSupService.deleteByBiddingNo(biddingNo);
        this.biddingOfferService.deleteByBiddingNo(biddingNo);
        this.biddingTeamService.deleteByBiddingNo(biddingNo);
        this.biddingTemplateInfoService.deleteByBiddingNo(biddingNo);
        this.biddingScoreService.deleteByBiddingNo(biddingNo);
    }

    @Override
    @Transactional
    public void sendToApprove(List<String> bidingNoList) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoIn((List)bidingNoList);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingHeaderList.get(0).getBiddingNo());
        List biddingContentList = this.biddingContentService.queryAllObjByExample((IExample)biddingContentExample);
        if (CollectionUtils.isEmpty((Collection)biddingContentList)) {
            throw new CommonException("\u62db\u6807\u5355\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6574\uff0c\u4e0d\u53ef\u5ba1\u6279\uff01", "not_all_complete", new Object[]{"\u62db\u6807\u5355"});
        }
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            ProcessStartVO vo = ProcessStartVO.newInstance((String)"ztbfbqsp", (String)biddingHeaderList.get(i).getBiddingNo(), (String)biddingHeaderList.get(i).getId(), (String)("addBidding?biddingNo=" + biddingHeaderList.get(i).getBiddingNo() + "&state=view"));
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(biddingHeaderList.get(i).getId());
            biddingHeader.setBiddingPreAuditstatus("1");
            biddingHeader.setApproveFlowId(startProcess.getProcessInstanceId());
            this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
        }
    }

    @Transactional
    public void listen(TaskOperateEvent event) {
        logger.info("\u5ba1\u6279\u6d41\u65e5\u5fd7\u8f93\u51fa=====================================");
        Assert.isNotBlank((String)event.getBusinessId(), (String)"\u53d1\u5e03\u524d\u5ba1\u6279\u5355\u636eID\u4e3a\u7a7a");
        BiddingHeader biddingHeader = new BiddingHeader();
        biddingHeader.setId(event.getBusinessId());
        BiddingHeader headerPrimarykey = this.biddingHeaderMapper.selectByPrimaryKey(event.getBusinessId());
        Date currDate = new Date();
        System.out.println("\u5f53\u524d\u65e5\u671f       date1\uff1a" + currDate);
        boolean flag = false;
        if (TenderStatusEumn.ISCANCEL.getValue().equals(headerPrimarykey.getBiddingStatus())) {
            flag = true;
        }
        if (event.isFinished() && event.isPass()) {
            logger.info("\u5ba1\u6279\u6d41\u65e5\u5fd7\u8f93\u51fa=====================================\u5ba1\u6279\u901a\u8fc7");
            biddingHeader.setBiddingPreAuditstatus("2");
            biddingHeader.setBiddingBegindate(new Date());
            biddingHeader.setBiddingStatus(TenderStatusEumn.BIDDING.getValue());
            if (!flag) {
                biddingHeader.setPublishDate(new Date());
                try {
                    this.insertIntoOffer(event.getBusinessId(), new ArrayList<BiddingSupplier>());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        } else if (event.isFinished() && !event.isPass()) {
            logger.info("\u5ba1\u6279\u6d41\u65e5\u5fd7\u8f93\u51fa=====================================\u5ba1\u6279\u9a73\u56de");
            biddingHeader.setBiddingPreAuditstatus("3");
            if (!flag) {
                biddingHeader.setBiddingStatus(TenderStatusEumn.NOTPUBLISH.getValue());
            }
        } else {
            logger.info("\u5ba1\u6279\u6d41\u65e5\u5fd7\u8f93\u51fa=====================================\u6b63\u5728\u5ba1\u6279");
            biddingHeader.setBiddingPreAuditstatus("1");
        }
        this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
    }

    @Override
    public void insertIntoOffer(String businessId, List<BiddingSupplier> biddingSupplierListSave) throws InstantiationException, IllegalAccessException {
        BiddingHeader biddingHeader = this.biddingHeaderMapper.selectByPrimaryKey(businessId);
        String biddingNo = biddingHeader.getBiddingNo();
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentList = this.biddingContentService.queryAllObjByExample((IExample)biddingContentExample);
        String contentId = ((BiddingContent)biddingContentList.get(0)).getId();
        Integer effectiveNumber = ((BiddingContent)biddingContentList.get(0)).getEffectiveNumber();
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        biddingPlanExample.setOrderByClause(" BIDDING_ROUNDS_NUMBER DESC ");
        List biddingPlanList = this.biddingPlanService.queryAllObjByExample((IExample)biddingPlanExample);
        biddingPlanList.forEach(planList -> {
            BiddingPlan biddingPlan = new BiddingPlan();
            biddingPlan.setId(planList.getId());
            biddingPlan.setBiddingBeginDate(new Date());
            this.biddingPlanService.modifyObj(biddingPlan);
        });
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        ArrayList<BiddingSupplier> biddingSupplierList = new ArrayList<BiddingSupplier>();
        if (CollectionUtils.isNotEmpty(biddingSupplierListSave)) {
            biddingSupplierList.addAll(biddingSupplierListSave);
        } else {
            List queryAllObjByExample = this.biddingSupplierService.queryAllObjByExample((IExample)biddingSupplierExample);
            biddingSupplierList.addAll(queryAllObjByExample);
        }
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
            this.saveMaterialInfo(biddingHeader, (BiddingSupplier)biddingSupplierList.get(i), biddingPlanList, contentId, effectiveNumber);
            this.saveOtherInfo(biddingHeader, (BiddingSupplier)biddingSupplierList.get(i), biddingPlanList, contentId, effectiveNumber);
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISBID.getValue());
            this.biddingSupplierService.modifyObj(biddingSupplier);
        }
    }

    private void saveOtherInfo(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, String contentId, Integer effectiveNumber) {
        BiddingContentOtherExample otherExample = new BiddingContentOtherExample();
        otherExample.createCriteria().andBiddingContentIdEqualTo(contentId);
        List biddingContentOtherList = this.biddingContentOtherService.queryAllObjByExample((IExample)otherExample);
        for (int j = 0; CollectionUtils.isNotEmpty((Collection)biddingContentOtherList) && j < biddingContentOtherList.size(); ++j) {
            BiddingContentOther biddingContentOther = (BiddingContentOther)biddingContentOtherList.get(j);
            BiddingOffer biddingOffer = new BiddingOffer();
            this.setBaseBiddingOffer(biddingHeader, biddingSupplier, biddingPlanList, biddingOffer);
            biddingOffer.setRequirementTypeCode("device");
            biddingOffer.setRequirementTypeName("\u5176\u4ed6");
            biddingOffer.setProjectNo(biddingContentOther.getTargetNo());
            biddingOffer.setProjectName(biddingContentOther.getTargetName());
            biddingOffer.setProjectDesc(biddingContentOther.getTaregtDesc());
            biddingOffer.setUnitPrice(biddingContentOther.getUnitPrice());
            biddingOffer.setUnit(biddingContentOther.getUnit());
            biddingOffer.setCurrency(biddingContentOther.getCurrency());
            biddingOffer.setAllBidding(biddingContentOther.getAllBidding());
            biddingOffer.setEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setRestEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setPictureAttachment(biddingContentOther.getPictureAttachment());
            biddingOffer.setDesignPicAttachment(biddingContentOther.getDesignPicAttachment());
            biddingOffer.setOtherId(biddingContentOther.getId());
            this.biddingOfferService.addObj(biddingOffer);
        }
    }

    private void saveModelInfo(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, String contentId, Integer effectiveNumber) {
        BiddingContentModelExample modelExample = new BiddingContentModelExample();
        modelExample.createCriteria().andBiddingContentIdEqualTo(contentId);
        List biddingContentModelList = this.biddingContentModelService.queryAllObjByExample((IExample)modelExample);
        for (int j = 0; CollectionUtils.isNotEmpty((Collection)biddingContentModelList) && j < biddingContentModelList.size(); ++j) {
            BiddingOffer biddingOffer = new BiddingOffer();
            this.setBaseBiddingOffer(biddingHeader, biddingSupplier, biddingPlanList, biddingOffer);
            BiddingContentModel biddingContentModel = (BiddingContentModel)biddingContentModelList.get(j);
            biddingOffer.setRequirementTypeCode("die");
            biddingOffer.setRequirementTypeName("\u6a21\u5177");
            biddingOffer.setProjectNo(biddingContentModel.getModelNo());
            biddingOffer.setProjectName(biddingContentModel.getModelName());
            biddingOffer.setProjectDesc(biddingContentModel.getModelDesc());
            biddingOffer.setUseModel(biddingContentModel.getUseModel());
            biddingOffer.setBeloneYear(biddingContentModel.getBeloneYear());
            biddingOffer.setModelSerialNumber(biddingContentModel.getModelSerialNumber());
            biddingOffer.setModelMaterial(biddingContentModel.getModelMaterial());
            biddingOffer.setPropertyRight(biddingContentModel.getPropertyRight());
            biddingOffer.setModelSinking(biddingContentModel.getModelSinking());
            biddingOffer.setModelLife(biddingContentModel.getModelLife());
            biddingOffer.setCurrency(biddingContentModel.getCurrency());
            biddingOffer.setUnitPrice(biddingContentModel.getUnitPrice());
            biddingOffer.setDeliveryDate(biddingContentModel.getDeliveryDate());
            biddingOffer.setAllBidding(biddingContentModel.getAllBidding());
            biddingOffer.setEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setRestEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setPictureAttachment(biddingContentModel.getPictureAttachment());
            biddingOffer.setDesignPicAttachment(biddingContentModel.getDesignPicAttachment());
            biddingOffer.setModelId(biddingContentModel.getId());
            biddingOffer.setCostAnalysisId(biddingContentModel.getCostAnalysisId());
            this.biddingOfferService.addObj(biddingOffer);
        }
    }

    private void saveMaterialInfo(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, String contentId, Integer effectiveNumber) throws InstantiationException, IllegalAccessException {
        BiddingContentMatterExample matterExample = new BiddingContentMatterExample();
        matterExample.createCriteria().andBiddingContentIdEqualTo(contentId);
        List biddingContentMatterList = this.biddingContentMatterService.queryAllObjByExample((IExample)matterExample);
        for (int j = 0; CollectionUtils.isNotEmpty((Collection)biddingContentMatterList) && j < biddingContentMatterList.size(); ++j) {
            BiddingContentMatter biddingContentMatter = (BiddingContentMatter)biddingContentMatterList.get(j);
            BiddingOffer biddingOffer = new BiddingOffer();
            this.setBaseBiddingOffer(biddingHeader, biddingSupplier, biddingPlanList, biddingOffer);
            biddingOffer.setRequirementTypeCode("material");
            biddingOffer.setRequirementTypeName("\u7269\u6599");
            biddingOffer.setProjectNo(biddingContentMatter.getMaterialNo());
            biddingOffer.setProjectName(biddingContentMatter.getMaterialName());
            biddingOffer.setProjectDesc(biddingContentMatter.getMaterialDesc());
            biddingOffer.setBiddingQuantity(biddingContentMatter.getBiddingQuantity());
            biddingOffer.setCurrency(biddingContentMatter.getCurrency());
            biddingOffer.setUnitPrice(biddingContentMatter.getUnitPrice());
            biddingOffer.setMaterialFeatures(biddingContentMatter.getMaterialFeatures());
            biddingOffer.setMaterialSpec(biddingContentMatter.getMaterialSpec());
            biddingOffer.setMaterialModel(biddingContentMatter.getMaterialModel());
            biddingOffer.setUnit(biddingContentMatter.getUnit());
            biddingOffer.setAllBidding(biddingContentMatter.getAllBidding());
            biddingOffer.setEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setRestEffectiveNumber(effectiveNumber == null ? "0" : effectiveNumber.toString());
            biddingOffer.setQuotationMethod(biddingContentMatter.getQuotationMethod());
            biddingOffer.setIsStep(biddingContentMatter.getIsStep());
            biddingOffer.setQuantity(biddingContentMatter.getDosage());
            biddingOffer.setAmount(biddingContentMatter.getSetThePrice());
            biddingOffer.setPictureAttachment(biddingContentMatter.getPictureAttachment());
            biddingOffer.setDesignPicAttachment(biddingContentMatter.getDesignPicAttachment());
            biddingOffer.setMatterId(biddingContentMatter.getId());
            biddingOffer.setTempMaterialNo(biddingContentMatter.getTempMaterialNo());
            biddingOffer.setCostAnalysisId(biddingContentMatter.getCostAnalysisId());
            biddingOffer.setFactoryCode(biddingContentMatter.getFactory());
            biddingOffer.setFactoryName(biddingContentMatter.getFactoryName());
            this.biddingOfferService.addObj(biddingOffer);
            if (StringUtils.isNotBlank((String)biddingContentMatter.getQuotationMethod()) && biddingContentMatter.getQuotationMethod().equals("2")) {
                this.saveStepSupInfo(biddingContentMatter, biddingHeader, biddingSupplier, biddingPlanList, biddingOffer.getId());
            }
            if (!StringUtils.isNotBlank((String)biddingContentMatter.getCostAnalysisId())) continue;
            TplOrderItemDetail tpl = (TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById((Object)biddingContentMatter.getCostAnalysisId());
            IOrderItemDetailService service = tpl.getOrderItemDetailService();
            IOrderItemDetail detail = (IOrderItemDetail)tpl.getOrderItemDetailClass().newInstance();
            detail.setOrderItemId(biddingOffer.getId());
            detail.setTemplateId(biddingContentMatter.getCostAnalysisId());
            detail.setMaterialCode(biddingContentMatter.getMaterialNo());
            detail.setMaterialDesc(biddingContentMatter.getMaterialDesc());
            detail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue((IExtendable)detail));
            service.addObj((Serializable)detail);
        }
    }

    private void saveStepSupInfo(BiddingContentMatter biddingContentMatter, BiddingHeader biddingHeader, BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, String biddingOfferId) {
        BiddingMatterStepExample example = new BiddingMatterStepExample();
        example.createCriteria().andMatterIdEqualTo(biddingContentMatter.getId());
        List biddingMatterStepList = this.biddingMatterStepService.queryAllObjByExample((IExample)example);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingMatterStepList) && i < biddingMatterStepList.size(); ++i) {
            BiddingMatterStep biddingMatterStep = (BiddingMatterStep)biddingMatterStepList.get(i);
            BiddingMatterStepSup biddingMatterStepSup = new BiddingMatterStepSup();
            biddingMatterStepSup.setBiddingOfferId(biddingOfferId);
            biddingMatterStepSup.setPurCompanyId(biddingHeader.getPurCompanyId());
            biddingMatterStepSup.setPurCompanySrmCode(biddingHeader.getPurCompanyCode());
            biddingMatterStepSup.setPurCompanyName(biddingHeader.getPurCompanyName());
            biddingMatterStepSup.setPurUserId(biddingHeader.getPurUserId());
            biddingMatterStepSup.setPurUserName(biddingHeader.getPurUserName());
            biddingMatterStepSup.setSupCompanyId(biddingSupplier.getSupCompanyId());
            biddingMatterStepSup.setSupCompanyName(biddingSupplier.getSupCompanyName());
            biddingMatterStepSup.setSupCompanySrmCode(biddingSupplier.getSupCompanySrmCode());
            biddingMatterStepSup.setSupCompanySapCode(biddingSupplier.getSupCompanySapCode());
            biddingMatterStepSup.setSupUserId(biddingSupplier.getSupUserId());
            biddingMatterStepSup.setSupUserName(biddingSupplier.getSupUserName());
            biddingMatterStepSup.setCreateTime(new Date());
            biddingMatterStepSup.setBiddingNo(biddingHeader.getBiddingNo());
            biddingMatterStepSup.setBiddingRoundsNumber(biddingPlanList.get(0).getBiddingRoundsNumber());
            biddingMatterStepSup.setBiddingTotalRound(biddingPlanList.get(0).getBiddingTotalRound());
            biddingMatterStepSup.setMaterialNo(biddingMatterStep.getMaterialNo());
            biddingMatterStepSup.setMaterialName(biddingMatterStep.getMaterialName());
            biddingMatterStepSup.setMaterialDesc(biddingMatterStep.getMaterialDesc());
            biddingMatterStepSup.setBiddingHeaderId(biddingHeader.getId());
            biddingMatterStepSup.setMatterId(biddingContentMatter.getId());
            biddingMatterStepSup.setQuantityStart(biddingMatterStep.getQuantityStart());
            biddingMatterStepSup.setQuantityEnd(biddingMatterStep.getQuantityEnd());
            this.biddingMatterStepSupService.addObj(biddingMatterStepSup);
        }
    }

    private void setBaseBiddingOffer(BiddingHeader biddingHeader, BiddingSupplier biddingSupplier, List<BiddingPlan> biddingPlanList, BiddingOffer biddingOffer) {
        biddingOffer.setPurCompanyId(biddingHeader.getPurCompanyId());
        biddingOffer.setPurCompanySrmCode(biddingHeader.getPurCompanyCode());
        biddingOffer.setPurCompanyName(biddingHeader.getPurCompanyName());
        biddingOffer.setPurUserId(biddingHeader.getPurUserId());
        biddingOffer.setPurUserName(biddingHeader.getPurUserName());
        biddingOffer.setSupCompanyId(biddingSupplier.getSupCompanyId());
        biddingOffer.setSupCompanyName(biddingSupplier.getSupCompanyName());
        biddingOffer.setSupCompanySrmCode(biddingSupplier.getSupCompanySrmCode());
        biddingOffer.setSupCompanySapCode(biddingSupplier.getSupCompanySapCode());
        biddingOffer.setSupUserId(biddingSupplier.getSupUserId());
        biddingOffer.setSupUserName(biddingSupplier.getSupUserName());
        biddingOffer.setCreateTime(new Date());
        biddingOffer.setBiddingNo(biddingHeader.getBiddingNo());
        biddingOffer.setBiddingRoundsNumber(biddingPlanList.get(0).getBiddingRoundsNumber());
        biddingOffer.setBiddingTotalRound(biddingPlanList.get(0).getBiddingTotalRound());
        biddingOffer.setMaterialStstus(biddingSupplier.getPartnerRoleCode());
        biddingOffer.setSupplierTemporaryCode(biddingSupplier.getSupplierTemporaryCode());
        Company company = (Company)this.companyService.queryObjById((Object)biddingSupplier.getSupCompanyId());
        biddingOffer.setMaterialDevel(company.getGrade());
    }

    @Override
    @Transactional
    public void finisnBidding(String biddingNo) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(biddingHeaderList.get(i).getId());
            biddingHeader.setBiddingStatus(TenderStatusEumn.ISFINISH.getValue());
            this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
        }
        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupBiddingStatusEqualTo(TenderStatusEumn.ISSCALING.getValue());
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISFINISH.getValue());
            this.biddingSupplierService.modifyObj(biddingSupplier);
        }
        supplierExample.clear();
        supplierExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupBiddingEqualTo("1");
        List bidSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
        if (CollectionUtils.isNotEmpty((Collection)bidSupplierList)) {
            bidSupplierList.forEach(sup -> {
                List userIdList;
                BiddingOfferExample offerExample = new BiddingOfferExample();
                offerExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(sup.getSupCompanyId()).andBiddingRoundsNumberEqualTo(((BiddingHeader)biddingHeaderList.get(0)).getBiddingCurrentRound());
                List offerList = this.biddingOfferService.queryAllObjByExample((IExample)offerExample);
                ArrayList<String> strList = null;
                String str = "";
                if (CollectionUtils.isNotEmpty((Collection)offerList)) {
                    strList = new ArrayList<String>(offerList.size());
                    for (BiddingOffer offe : offerList) {
                        strList.add(offe.getIsBidding() == null ? "0" : offe.getIsBidding());
                    }
                    if (CollectionUtils.isNotEmpty(strList)) {
                        str = Collections.frequency(strList, "1") == strList.size() ? "\u5168\u90e8\u4e2d\u6807" : (Collections.frequency(strList, "1") < strList.size() && Collections.frequency(strList, "1") > 0 ? "\u90e8\u5206\u4e2d\u6807" : "\u672a\u4e2d\u6807");
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)(userIdList = this.companyUserRefService.queryUserOfCompany(sup.getSupCompanyId())))) {
                    this.sendBidMessage((BiddingSupplier)sup, userIdList, str);
                }
            });
        }
    }

    private void sendBidMessage(BiddingSupplier biddingSupplier, List<String> userIdList, String str) {
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("biddingNo", biddingSupplier.getBiddingNo());
        msg.put("isBid", str);
        Message message = Message.init(msg).setCompanyCode(biddingSupplier.getPurCompanyCode()).setBusinessTypeCode("BIDDING_SEND_BID_INFORMATION").setSenderId(biddingSupplier.getPurUserId()).addReceiverIdList(userIdList).setMsgLevel(MessageLevelEnum.HIGH);
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void editStatus(BiddingHeader biddingHeader, BiddingHeaderExample example) {
        this.biddingHeaderMapper.updateByExampleSelective(biddingHeader, example);
    }

    @Override
    public List<ManagementPage> screenDataByBiddingStatus(List<ManagementPage> list, List<String> biddingStatusList) {
        if (CollectionUtils.isNotEmpty(biddingStatusList)) {
            ArrayList<ManagementPage> finalList = new ArrayList<ManagementPage>();
            for (int i = 0; CollectionUtils.isNotEmpty(list) && i < list.size(); ++i) {
                if (!biddingStatusList.contains(list.get(i).getBiddingStatus())) continue;
                finalList.add(list.get(i));
            }
            return finalList;
        }
        return list;
    }

    public void deleteByExample(BiddingHeaderExample example) {
    }

    public void addAll(List<BiddingHeader> list) {
    }

    @Override
    @Transactional
    public void instrument(List<BiddingOffer> biddingOfferList) {
        biddingOfferList.forEach(biddingOffer -> {
            biddingOffer.setInstrumentStatus("1");
            this.biddingOfferService.modifyObj((Serializable)biddingOffer);
            BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
            biddingSupplierExample.createCriteria().andSupCompanyIdEqualTo(biddingOffer.getSupCompanyId()).andBiddingNoEqualTo(biddingOffer.getBiddingNo());
            List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)biddingSupplierExample);
            if (CollectionUtils.isNotEmpty((Collection)biddingSupplierList)) {
                biddingSupplierList.forEach(biddingSupplier -> {
                    biddingSupplier.setSupBiddingStatus("17");
                    this.biddingSupplierService.modifyObj((Serializable)biddingSupplier);
                });
            }
        });
    }

    @Override
    @Transactional
    public void sendBiddingToSupplier(List<String> bidingNoList, Company purCompany, User purUser) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoIn((List)bidingNoList);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingHeaderList.get(0).getBiddingNo());
        List biddingContentList = this.biddingContentService.queryAllObjByExample((IExample)biddingContentExample);
        if (CollectionUtils.isEmpty((Collection)biddingContentList)) {
            throw new CommonException("\u62db\u6807\u5355\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6574\uff0c\u4e0d\u53ef\u53d1\u9001\uff01");
        }
        for (int i = 0; CollectionUtils.isNotEmpty(biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            BiddingHeader header = biddingHeaderList.get(i);
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(header.getId());
            boolean flag = false;
            if (TenderStatusEumn.ISCANCEL.getValue().equals(header.getBiddingStatus())) {
                flag = true;
            }
            biddingHeader.setBiddingPreAuditstatus(SendBiddingStatusEnum.SEND.getValue());
            biddingHeader.setBiddingStatus(TenderStatusEumn.WAITBID.getValue());
            if (!flag) {
                biddingHeader.setPublishDate(new Date());
                try {
                    this.addIntoOffer(header, new ArrayList<BiddingSupplier>(), purCompany, purUser);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.biddingHeaderMapper.updateByPrimaryKeySelective(biddingHeader);
        }
    }

    private void addIntoOffer(BiddingHeader header, ArrayList<BiddingSupplier> biddingSupplierListSave, Company purCompany, User purUser) throws InstantiationException, IllegalAccessException {
        String biddingNo = header.getBiddingNo();
        BiddingContentExample biddingContentExample = new BiddingContentExample();
        biddingContentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentList = this.biddingContentService.queryAllObjByExample((IExample)biddingContentExample);
        String contentId = ((BiddingContent)biddingContentList.get(0)).getId();
        Integer effectiveNumber = ((BiddingContent)biddingContentList.get(0)).getEffectiveNumber();
        BiddingPlanExample biddingPlanExample = new BiddingPlanExample();
        biddingPlanExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        biddingPlanExample.setOrderByClause(" BIDDING_ROUNDS_NUMBER DESC ");
        List biddingPlanList = this.biddingPlanService.queryAllObjByExample((IExample)biddingPlanExample);
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        biddingSupplierExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        ArrayList<BiddingSupplier> biddingSupplierList = new ArrayList<BiddingSupplier>();
        if (CollectionUtils.isNotEmpty(biddingSupplierListSave)) {
            biddingSupplierList.addAll(biddingSupplierListSave);
        } else {
            List queryAllObjByExample = this.biddingSupplierService.queryAllObjByExample((IExample)biddingSupplierExample);
            biddingSupplierList.addAll(queryAllObjByExample);
        }
        for (int i = 0; CollectionUtils.isNotEmpty(biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
            this.saveMaterialInfo(header, (BiddingSupplier)biddingSupplierList.get(i), biddingPlanList, contentId, effectiveNumber);
            this.saveOtherInfo(header, (BiddingSupplier)biddingSupplierList.get(i), biddingPlanList, contentId, effectiveNumber);
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.WAITBID.getValue());
            this.biddingSupplierService.modifyObj(biddingSupplier);
        }
        BiddingTeamExample teamExample = new BiddingTeamExample();
        teamExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List teamList = this.biddingTeamService.queryAllObjByExample((IExample)teamExample);
        List technicalList = teamList.stream().filter(t -> BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue().equals(t.getBidGroup())).collect(Collectors.toList());
        List businessList = teamList.stream().filter(t -> BiddingGroupTypeEnum.BUSINESS_GROUP.getValue().equals(t.getBidGroup())).collect(Collectors.toList());
        BiddingTemplateInfoExample templateExample = new BiddingTemplateInfoExample();
        templateExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List templateList = this.biddingTemplateInfoService.queryAllObjByExample((IExample)templateExample);
        List<BiddingTemplateItem> technicalItemList = new ArrayList();
        List<BiddingTemplateItem> businessItemList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)templateList)) {
            BiddingTemplateItemExample itemExample = new BiddingTemplateItemExample();
            for (Iterator tem : templateList) {
                if (BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue().equals(((BiddingTemplateInfo)((Object)tem)).getTemplateType())) {
                    itemExample.createCriteria().andTemplateIdEqualTo(((BiddingTemplateInfo)((Object)tem)).getTemplateId()).andIsEnabledEqualTo(Constant.YES_INT);
                    technicalItemList = this.biddingTemplateItemService.queryAllObjByExample((IExample)itemExample);
                    ((BiddingTemplateItem)technicalItemList.get(0)).setTemplateName(((BiddingTemplateInfo)((Object)tem)).getTemplateName());
                    itemExample.clear();
                    continue;
                }
                if (!BiddingGroupTypeEnum.BUSINESS_GROUP.getValue().equals(((BiddingTemplateInfo)((Object)tem)).getTemplateType())) continue;
                itemExample.createCriteria().andTemplateIdEqualTo(((BiddingTemplateInfo)((Object)tem)).getTemplateId()).andIsEnabledEqualTo(Constant.YES_INT);
                businessItemList = this.biddingTemplateItemService.queryAllObjByExample((IExample)itemExample);
                ((BiddingTemplateItem)businessItemList.get(0)).setTemplateName(((BiddingTemplateInfo)((Object)tem)).getTemplateName());
                itemExample.clear();
            }
        }
        if (CollectionUtils.isNotEmpty(biddingSupplierList) && CollectionUtils.isNotEmpty((Collection)teamList) && CollectionUtils.isNotEmpty(technicalItemList) && CollectionUtils.isNotEmpty(businessItemList)) {
            for (BiddingSupplier sup : biddingSupplierList) {
                for (BiddingTeam t1 : technicalList) {
                    for (BiddingTemplateItem techItem : technicalItemList) {
                        this.setBiddingScoreInfo(header, purCompany, purUser, sup, t1, techItem, technicalItemList);
                    }
                }
                for (BiddingTeam t2 : businessList) {
                    for (BiddingTemplateItem bussItem : businessItemList) {
                        this.setBiddingScoreInfo(header, purCompany, purUser, sup, t2, bussItem, businessItemList);
                    }
                }
            }
            for (BiddingTeam t2 : teamList) {
                BiddingTeam te = new BiddingTeam();
                te.setId(t2.getId());
                te.setBidTimes(t2.getBidTimes() + 1);
                this.biddingTeamService.modifyObj(te);
                BiddingGroup biddingGroup = (BiddingGroup)this.biddingGroupService.queryObjById(t2.getGroupId());
                BiddingGroup group = new BiddingGroup();
                group.setId(biddingGroup.getId());
                group.setBidGroup(t2.getBidGroup());
                group.setBidTimes(biddingGroup.getBidTimes() + 1);
                this.biddingGroupService.modifyObj(group);
                this.sendMessage(header, t2);
            }
        }
    }

    private void setBiddingScoreInfo(BiddingHeader header, Company purCompany, User purUser, BiddingSupplier sup, BiddingTeam t, BiddingTemplateItem item, List<BiddingTemplateItem> list) {
        BiddingScore biddingScore = new BiddingScore();
        biddingScore.setPurCompanyId(purCompany.getId());
        biddingScore.setPurCompanyName(purCompany.getCompanyFullName());
        biddingScore.setPurCompanySapCode(purCompany.getCompanySapCode());
        biddingScore.setPurCompanySrmCode(purCompany.getCompanyCode());
        biddingScore.setPurUserId(purUser.getId());
        biddingScore.setPurUserName(purUser.getNickName());
        biddingScore.setBiddingNo(header.getBiddingNo());
        biddingScore.setBiddingRoundsNumber(header.getBiddingCurrentRound());
        biddingScore.setTemplateId(item.getTemplateId());
        biddingScore.setTemplateType(item.getStandardType());
        biddingScore.setSupCompanyCode(sup.getSupCompanySrmCode());
        biddingScore.setSupCompanyId(sup.getSupCompanyId());
        biddingScore.setSupCompanyName(sup.getSupCompanyName());
        biddingScore.setRatersId(t.getBidUserId());
        biddingScore.setRatersName(t.getBidUserName());
        biddingScore.setStandardCode(item.getStandardCode());
        biddingScore.setStandardName(item.getStandardName());
        biddingScore.setWeightCoefficient(item.getWeightCoefficient());
        biddingScore.setCreateTime(new Date());
        biddingScore.setIsEnabled(Constant.YES_INT);
        biddingScore.setTemplateName(list.get(0).getTemplateName());
        biddingScore.setBidStatus(Constant.NO_INT);
        this.biddingScoreService.addObj(biddingScore);
    }

    private void sendMessage(BiddingHeader header, BiddingTeam t) {
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("biddingNo", header.getBiddingNo());
        if (StringUtils.isNotBlank((String)t.getBidUserId())) {
            Message message = Message.init(msg).setCompanyCode(t.getPurCompanySrmCode()).setBusinessTypeCode("BIDDING_PUR_SEND_INFORMATION").setSenderId(t.getPurUserId()).addReceiverId(t.getBidUserId()).setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    @Override
    @Transactional
    public void biddingApprovalToOa(List<String> bidingNoList, Company purCompany, User purUser) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoIn((List)bidingNoList);
        List<BiddingHeader> biddingHeaderList = this.biddingHeaderMapper.selectByExample(biddingHeaderExample);
        Assert.isNotEmpty(biddingHeaderList, (String)"\u6839\u636e\u6240\u4f20\u7684\u62db\u6807\u7f16\u7801\u67e5\u8be2\u51fa\u7684\u62db\u6807\u4fe1\u606f\u4e3a\u7a7a\uff0c\u53d1\u9001\u5b9a\u6807\u5ba1\u6279\u5931\u8d25");
        this.checkBiddingResult(biddingHeaderList);
        for (BiddingHeader header : biddingHeaderList) {
            Assert.isNotBlank((String)header.getDepartId(), (String)("\u62db\u6807\u7f16\u53f7\u4e3a\uff1a" + header.getBiddingNo() + "\u7684\u62db\u6807\u5355\u6ca1\u6709\u9009\u62e9\u90e8\u95e8\uff0c\u53d1\u9001OA\u5ba1\u6279\u5931\u8d25"));
            String code = this.setTemplateIdToOA(header);
            Map<String, String> map = BiddingSendOaTemplateEnum.chooseTemplate(code);
            if (map.size() == 0) {
                throw new CommonException("\u6b64\u62db\u6807\u673a\u6784\u6ca1\u6709\u5bf9\u5e94\u7684OA\u5ba1\u6279\u6a21\u677fID");
            }
            String tid = map.get("templateId");
            String templateVersion = map.get("version");
            String createUser = purUser.getEmail();
            String title = "\u62db\u6295\u6807\u5b9a\u6807\u5ba1\u6279";
            this.setBidSupplier(header);
            TemplateCenter templateCenter = this.templateCenterService.queryObjByTemplateNo("zhaobiao_oa");
            Assert.isNotNull((Object)templateCenter, (String)"\u6839\u636e\u6a21\u677f\u7f16\u53f7\uff1azhaobiao_oa \u67e5\u8be2\u51fa\u7684\u6a21\u677f\u7ba1\u7406\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5728\u6a21\u677f\u4e2d\u5fc3\u914d\u7f6e\u6b64\u7f16\u53f7\u6a21\u677f");
            Assert.isNotBlank((String)templateCenter.getTemplateContent(), (String)"\u6a21\u677f\u7f16\u53f7\uff1azhaobiao_oa \u6a21\u677f\u4e2d\u7684\u52a8\u6001\u6a21\u677f\u5185\u5bb9\u6ca1\u6709\u7ef4\u62a4");
            HashMap<String, BiddingHeader> tempmMap = new HashMap<String, BiddingHeader>();
            tempmMap.put("header", header);
            String content = TemplateUtils.process((String)templateCenter.getTemplateContent(), tempmMap);
            logger.debug("\u53d1\u9001OA\u5b9a\u6807\u5ba1\u6279\u7684\u5185\u5bb9\uff1a" + content);
            List<BiddingFile> fileList = this.findPurchaseFile(header);
            List<BiddingFileSupplier> supFileList = this.findSupplierFile(header);
            HashMap attachements = new HashMap();
            if (CollectionUtils.isNotEmpty(fileList)) {
                fileList.forEach(file -> {
                    List fileDataList;
                    if (StringUtils.isNotBlank((String)file.getAttachmentPur()) && CollectionUtils.isNotEmpty((Collection)(fileDataList = JSON.parseArray((String)file.getAttachmentPur(), FileData.class)))) {
                        fileDataList.forEach(fileData -> attachements.put(fileData.getFileName(), SFFileUtils.getSFFileId((File)fileData.toFile())));
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(supFileList)) {
                supFileList.forEach(supFile -> {
                    List supFileDataList;
                    if (StringUtils.isNotBlank((String)supFile.getAttachmentSup()) && CollectionUtils.isNotEmpty((Collection)(supFileDataList = JSON.parseArray((String)supFile.getAttachmentSup(), FileData.class)))) {
                        supFileDataList.forEach(supFileData -> attachements.put(supFileData.getFileName(), SFFileUtils.getSFFileId((File)supFileData.toFile())));
                    }
                });
            }
            HashMap<String, String> otherParam = new HashMap<String, String>();
            otherParam.put("createSystem", "PCP");
            otherParam.put("biddingNo", header.getBiddingNo());
            otherParam.put("createUser", purUser.getEmail());
            otherParam.put("serviceId", "com.sinolife.pcp.bidding.callBackForOA");
            otherParam.put("companyCode\uff1a", header.getPurCompanyCode());
            otherParam.put("needbranchcode", "Y");
            otherParam.put("branchcode", header.getDepartId());
            Map resultMap = this.sinoLifeApiService.createFlow(tid, templateVersion, createUser, title, content, attachements, otherParam);
            if (resultMap.isEmpty()) {
                throw new CommonException("\u8c03\u7528OA\u63a5\u53e3\u5931\u8d25");
            }
            String flag = (String)resultMap.get("flag");
            if ("Y".equals(flag)) {
                String flowId = (String)resultMap.get("flowId");
                Assert.isNotBlank((String)flowId, (String)"\u8c03\u7528OA\u5ba1\u6279\u63a5\u53e3\u8fd4\u56de\u7684\u6d41\u7a0bID\u4e3a\u7a7a");
                BiddingHeader biddingHeader = new BiddingHeader();
                biddingHeader.setId(header.getId());
                biddingHeader.setBiddingAuditstatus(ApprovalStatusEnum.BEING_APPROVAL.getValue());
                biddingHeader.setApproveFlowId2(flowId);
                this.modifyObj(biddingHeader);
                continue;
            }
            if ("N".equals(flag)) {
                String msg = (String)resultMap.get("msg");
                throw new CommonException("\u62db\u6807\u7f16\u53f7\u4e3a\uff1a" + header.getBiddingNo() + "\u7684\u62db\u6807\u53d1\u9001OA\u5ba1\u6279\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + msg);
            }
            throw new CommonException("\u62db\u6807\u7f16\u53f7\u4e3a\uff1a" + header.getBiddingNo() + "\u7684\u62db\u6807\u53d1\u9001OA\u5ba1\u6279\u8fd4\u56de\u7684\u7ed3\u679c\u6807\u5fd7flag\u4e3a\uff1a" + flag + "\u5b83\u4e0d\u662fY/N\uff0c\u6240\u4ee5\u8c03\u7528OA\u63a5\u53e3\u5ba1\u6279\u5931\u8d25");
        }
    }

    private List<BiddingFileSupplier> findSupplierFile(BiddingHeader header) {
        List codeList = header.getScoreList().stream().map(BiddingScoreAndPrice::getSupCompanyCode).distinct().collect(Collectors.toList());
        BiddingFileSupplierExample fileExample = new BiddingFileSupplierExample();
        fileExample.createCriteria().andSupCompanySrmCodeIn(codeList);
        return this.biddingFileSupplierService.queryAllObjByExample((IExample)fileExample);
    }

    private List<BiddingFile> findPurchaseFile(BiddingHeader header) {
        BiddingFileExample fileExample = new BiddingFileExample();
        fileExample.createCriteria().andBiddingNoEqualTo(header.getBiddingNo());
        return this.biddingFileService.queryAllObjByExample((IExample)fileExample);
    }

    private String setTemplateIdToOA(BiddingHeader header) {
        Department depart = (Department)this.departmentService.queryObjById((Object)header.getDepartId());
        Assert.isNotNull((Object)depart, (String)"\u90e8\u95e8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u83b7\u53d6\u5ba1\u6279\u6a21\u677fID\u5931\u8d25");
        DepartmentExcelVO excelVO = this.departmentService.getDepartmentExcelVO(header.getDepartId());
        if (null != excelVO && StringUtils.isNotBlank((String)excelVO.getAccountSetId())) {
            if (AccountSetEnum.BK.getCode().equals(excelVO.getAccountCode())) {
                Department dt = (Department)this.departmentService.queryObjById((Object)depart.getParentId());
                if (dt != null && "5".equals(dt.getDepartmentType())) {
                    return BiddingSendOaTemplateEnum.INSURANCE_HOLDINGS_SECOND.getOrganizationCode();
                }
                return BiddingSendOaTemplateEnum.INSURANCE_HOLDINGS.getOrganizationCode();
            }
            if (AccountSetEnum.SX.getCode().equals(excelVO.getAccountCode())) {
                if (StringUtils.isNotBlank((String)excelVO.getInTheOrganizationId())) {
                    return BiddingSendOaTemplateEnum.LIFE_INSURANCE_THREE.getOrganizationCode();
                }
                if (StringUtils.isNotBlank((String)excelVO.getInstitutionsId())) {
                    return BiddingSendOaTemplateEnum.LIFE_INSURANCE_SECOND.getOrganizationCode();
                }
                return BiddingSendOaTemplateEnum.LIFE_INSURANCE.getOrganizationCode();
            }
            if (AccountSetEnum.CX.getCode().equals(excelVO.getAccountCode())) {
                if (StringUtils.isNotBlank((String)excelVO.getInTheOrganizationId())) {
                    return BiddingSendOaTemplateEnum.PRODUCT_INSURANCE_THREE.getOrganizationCode();
                }
                if (StringUtils.isNotBlank((String)excelVO.getInstitutionsId())) {
                    return BiddingSendOaTemplateEnum.PRODUCT_INSURANCE_SECOND.getOrganizationCode();
                }
                return BiddingSendOaTemplateEnum.PRODUCT_INSURANCE.getOrganizationCode();
            }
            if (AccountSetEnum.ZG.getCode().equals(excelVO.getAccountCode())) {
                return BiddingSendOaTemplateEnum.ASSET_INSURANCE.getOrganizationCode();
            }
            if (AccountSetEnum.XS.getCode().equals(excelVO.getAccountCode())) {
                if (StringUtils.isNotBlank((String)excelVO.getInstitutionsId())) {
                    return BiddingSendOaTemplateEnum.FUDE_SALE_SECOND.getOrganizationCode();
                }
                return BiddingSendOaTemplateEnum.FUDE_SALE.getOrganizationCode();
            }
        }
        return null;
    }

    private void setBidSupplier(BiddingHeader header) {
        if (BiddingTypeEnum.INVITATION.getValue().equals(header.getBiddingType())) {
            header.setBiddingType(BiddingTypeEnum.INVITATION.getName());
        } else if (BiddingTypeEnum.OPEN.getValue().equals(header.getBiddingType())) {
            header.setBiddingType(BiddingTypeEnum.OPEN.getName());
        }
        String createTime = DateUtils.formatDate((Date)header.getCreateTime(), (String)"yyyy/MM/dd");
        header.setCreateBiddingTime(createTime);
        String endDate = DateUtils.formatDate((Date)header.getBiddingEnddate(), (String)"yyyy/MM/dd");
        header.setBidEndTime(endDate);
        BiddingContactInfoExample contactExample = new BiddingContactInfoExample();
        contactExample.createCriteria().andBiddingNoEqualTo(header.getBiddingNo()).andAddressIsNotNull();
        List contactList = this.biddingContactInfoService.queryAllObjByExample((IExample)contactExample);
        if (CollectionUtils.isNotEmpty((Collection)contactList)) {
            header.setAddress(((BiddingContactInfo)contactList.get(0)).getAddress());
        }
        BiddingSupplierExample supExample = new BiddingSupplierExample();
        supExample.createCriteria().andBiddingNoEqualTo(header.getBiddingNo()).andSupBiddingEqualTo(String.valueOf(Constant.YES_INT));
        List supList = this.biddingSupplierService.queryAllObjByExample((IExample)supExample);
        BiddingOfferExample offExample = new BiddingOfferExample();
        offExample.createCriteria().andBiddingNoEqualTo(header.getBiddingNo()).andBiddingRoundsNumberEqualTo(header.getBiddingCurrentRound());
        List offList = this.biddingOfferService.queryAllObjByExample((IExample)offExample);
        ArrayList<BiddingScoreAndPrice> scoreList = new ArrayList<BiddingScoreAndPrice>();
        for (BiddingSupplier sup : supList) {
            BiddingScoreAndPrice score = new BiddingScoreAndPrice();
            Integer ranking = null;
            BigDecimal allScore = BigDecimal.ZERO;
            BigDecimal allPrice = BigDecimal.ZERO;
            String isBidding = "";
            for (BiddingOffer off : offList) {
                if (!sup.getSupCompanySrmCode().equals(off.getSupCompanySrmCode())) continue;
                allScore = off.getCompositeScore();
                ranking = off.getRanking();
                isBidding = off.getIsBidding();
                if ("material".equals(off.getRequirementTypeCode())) {
                    allPrice = allPrice.add(off.getSupplierQuotedPrice());
                    continue;
                }
                if (!"device".equals(off.getRequirementTypeCode())) continue;
                allPrice = allPrice.add(off.getOfferUnitPrice() == null ? BigDecimal.ZERO : new BigDecimal(off.getOfferUnitPrice()));
            }
            score.setAllPrice(allPrice);
            score.setAllScore(allScore);
            score.setIsBidding(isBidding);
            score.setRanking(ranking);
            score.setSupCompanyCode(sup.getSupCompanySrmCode());
            score.setSupCompanyName(sup.getSupCompanyName());
            scoreList.add(score);
        }
        List<BiddingScoreAndPrice> collect = new ArrayList<BiddingScoreAndPrice>();
        if (CollectionUtils.isNotEmpty(scoreList)) {
            collect = scoreList.stream().sorted(Comparator.comparing(BiddingScoreAndPrice::getRanking)).collect(Collectors.toList());
        }
        header.setScoreList(collect);
    }

    private String setBiddingData(BiddingHeader header) {
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>\r\n<html>\r\n<head>\r\n\t<meta charset='utf-8'></meta>\r\n\t<title>\u62db\u6295\u6807\u5b9a\u6807\u5ba1\u6279</title>\r\n\t<style type=\"text/css\">\r\n\t\t@font-face{\r\n        \tfont-family: SimSun;\r\n        \tsrc:url(\"${fontPath}\");\r\n    \t}\r\n\t\t* {\r\n\t\t\tpadding: 0px;\r\n\t\t\tmargin: 0px;\r\n\t\t}\r\n\t\t.billBody {\r\n\t\t\twidth: 300mm;\r\n\t\t\tposition: relative;\r\n\t\t\tpadding-top: 0px;\r\n\t\t\tmargin: 0 auto;\r\n\t\t}\r\n\t\t.billBody .title .content {\r\n\t\t\ttext-align: center;\r\n\t\t}\r\n\t\t.title .part1 {\r\n\t\t\tfont-size: 24px;\r\n\t\t\tline-height: 55px;\r\n\t\t}\r\n\t\ttd {\r\n\t\t\tborder: 1px solid gray;\r\n\t\t\tfont-size: 14px;\r\n            text-align: center;\r\n            padding: 5px 0;\r\n\t\t}\r\n\t\tth {\r\n\t\t\tborder: 1px solid gray;\r\n\t\t}\r\n\t\t.borderBN{\r\n            word-wrap: break-word;\r\n\t\t\tborder-bottom: none;\r\n            table-layout:fixed\r\n\t\t}\r\n\t</style>\r\n</head>\r\n<body>\r\n\t<div class=\"billBody\">\r\n\t\t<div class=\"title\">\r\n\t\t\t<div class=\"content\">\r\n\t\t\t\t<p class=\"part1\">\r\n\t\t\t\t\t<span>\u62db\u6295\u6807\u4e2d\u6807\u6c47\u603b\u8868</span>\r\n\t\t\t\t</p>\r\n\t\t\t</div>\r\n\t\t</div>\r\n        <table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" class=\"borderBN texinden\">\r\n            <tr>\r\n                <td colspan=\"2\">\u9879\u76ee\u540d\u79f0</td>\r\n                <td colspan=\"2\">");
        sb.append(header.getBiddingName());
        sb.append("</td>");
        sb.append("<td colspan=\"2\">\u9879\u76ee\u7f16\u53f7</td>");
        sb.append("<td colspan=\"2\">" + header.getBiddingNo() + "</td>");
        sb.append("<td colspan=\"2\">\u7acb\u9879\u65e5\u671f</td>");
        sb.append("<td colspan=\"2\">" + header.getCreateBiddingTime() + "</td>");
        sb.append("</tr>");
        sb.append("<tr>\r\n<td colspan=\"2\">\u91c7\u8d2d\u7ecf\u529e\u4eba</td>\r\n<td colspan=\"2\">" + header.getPurUserName() + "</td>");
        sb.append("<td colspan=\"2\">\u91c7\u8d2d\u90e8\u95e8</td>");
        sb.append("<td colspan=\"2\">" + header.getDepartName() + "</td>");
        sb.append("<td colspan=\"2\">\u6295\u6807\u622a\u6b62\u65e5\u671f</td>");
        sb.append("<td colspan=\"2\">" + header.getBidEndTime() + "</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td colspan=\"2\">\u9879\u76ee\u5730\u5740</td>");
        sb.append("<td colspan=\"10\">" + header.getAddress() + "</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td colspan=\"2\">\u62db\u6807\u65b9\u5f0f</td>");
        sb.append("<td colspan=\"10\">" + header.getBiddingType() + "</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td colspan=\"2\">\u9879\u76ee\u4ecb\u7ecd</td>");
        String biddingSummary = "";
        if (StringUtils.isNotBlank((String)header.getBiddingSummary())) {
            biddingSummary = header.getBiddingSummary();
        }
        sb.append("<td colspan=\"10\">" + biddingSummary + "</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" class=\"borderBN texinden\">");
        sb.append("<thead>\r\n                <tr><td colspan=\"12\">\u6295\u6807\u4eba\u8bc4\u6807\u7ed3\u679c</td></tr>\r\n                <tr>\r\n                    <td colspan=\"2\">\u6295\u6807\u4eba</td>\r\n                    <td colspan=\"2\">\u7efc\u5408\u8bc4\u6807\u5e73\u5747\u5f97\u5206</td>\r\n                    <td colspan=\"2\">\u6295\u6807\u62a5\u4ef7\uff08\u5143\uff09</td>\r\n                    <td colspan=\"6\">\u7efc\u5408\u8bc4\u5206\u540d\u6b21</td>\r\n                </tr>\r\n            </thead>");
        sb.append("<tbody>");
        if (CollectionUtils.isNotEmpty(header.getScoreList())) {
            for (BiddingScoreAndPrice score : header.getScoreList()) {
                sb.append("<tr>");
                sb.append("<td colspan=\"2\">" + score.getSupCompanyName() + "</td>");
                sb.append("<td colspan=\"2\">" + score.getAllScore() + "</td>");
                sb.append("<td colspan=\"2\">" + score.getAllPrice() + "</td>");
                sb.append("<td colspan=\"6\">" + score.getRanking() + "</td>");
                sb.append("</tr>");
            }
        }
        sb.append("</tbody>");
        sb.append("<tfoot>");
        sb.append("<tr>");
        sb.append("<td colspan=\"2\">\u63a8\u8350\u4e2d\u6807\u5355\u4f4d</td>");
        sb.append("<td colspan=\"10\"><select>");
        if (CollectionUtils.isNotEmpty(header.getScoreList())) {
            for (BiddingScoreAndPrice score : header.getScoreList()) {
                if (!"1".equals(score.getIsBidding())) continue;
                sb.append("<option>");
                sb.append(score.getSupCompanyName() + "\uff0c\u6295\u6807\u62a5\u4ef7" + score.getAllPrice() + "\u5143");
                sb.append("</option>");
            }
        }
        sb.append("</select></td>");
        sb.append("</tr>");
        sb.append("</tfoot>");
        sb.append("</table>");
        sb.append("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" class=\"borderBN texinden\">");
        sb.append("<thead><tr><td colspan=\"12\">\u5e8f\u53f7</td></tr></thead>");
        sb.append("<tbody>");
        sb.append("<tr><td colspan=\"12\">XX\u8d44\u6599\uff08\u652f\u6301\u591a\u79cd\u683c\u5f0f\uff09</td></tr>");
        sb.append("</tbody>");
        sb.append("</table>");
        sb.append("</div>\r\n</body>\r\n<script type=\"text/javascript\">\r\n</script>\r\n</html> ");
        return sb.toString();
    }

    private void checkBiddingResult(List<BiddingHeader> biddingHeaderList) {
        for (BiddingHeader head : biddingHeaderList) {
            if (!ApprovalStatusEnum.REJECT_APPROVAL.getValue().equals(head.getBiddingAuditstatus())) continue;
            BiddingTeamExample teamExample = new BiddingTeamExample();
            teamExample.createCriteria().andBiddingNoEqualTo(head.getBiddingNo()).andBidGroupEqualTo(BiddingGroupTypeEnum.BUSINESS_GROUP.getValue()).andConfirmStatusEqualTo(Constant.NO_INT);
            List teamList = this.biddingTeamService.queryAllObjByExample((IExample)teamExample);
            if (!CollectionUtils.isNotEmpty((Collection)teamList)) continue;
            throw new CommonException("\u62db\u6807\u7f16\u53f7\u4e3a\uff1a" + head.getBiddingNo() + "\u7684\u62db\u6807\uff0c\u8bc4\u6807\u5c0f\u7ec4\u4e2d\u7684\u5546\u52a1\u7ec4\u672a\u5168\u90e8\u786e\u8ba4\u8bc4\u6807\u7ed3\u679c\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279");
        }
    }

    @Transactional
    public Map<String, Object> processResult(Map<String, Object> objectMap) throws Exception {
        this.checkDataFromOA(objectMap);
        String flowId = (String)objectMap.get("flowId");
        String opinion = (String)objectMap.get("opinion");
        BiddingHeaderExample headerExample = new BiddingHeaderExample();
        headerExample.createCriteria().andApproveFlowId2EqualTo(flowId).andBiddingAuditstatusEqualTo(ApprovalStatusEnum.BEING_APPROVAL.getValue());
        List<BiddingHeader> headerList = this.biddingHeaderMapper.selectByExample(headerExample);
        if (CollectionUtils.isEmpty(headerList)) {
            logger.error("\u6839\u636e\u56de\u5199\u6240\u4f20\u7684\u6d41\u7a0bID\u67e5\u8be2\u7684\u62db\u6807\u4fe1\u606f\u4e3a\u7a7a\uff0c\u56de\u5199\u5931\u8d25");
            throw new CommonException("\u6839\u636e\u56de\u5199\u6240\u4f20\u7684\u6d41\u7a0bID\u67e5\u8be2\u7684\u62db\u6807\u4fe1\u606f\u4e3a\u7a7a\uff0c\u56de\u5199\u5931\u8d25");
        }
        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria().andBiddingNoEqualTo(headerList.get(0).getBiddingNo());
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
        BiddingHeader header = new BiddingHeader();
        header.setId(headerList.get(0).getId());
        if ("Y".equals(opinion)) {
            header.setBiddingAuditstatus(ApprovalStatusEnum.ADOPT_APPROVAL.getValue());
            header.setBiddingStatus(TenderStatusEumn.ISSCALING.getValue());
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
                this.modifySupplierData(headerList.get(0), (BiddingSupplier)biddingSupplierList.get(i));
            }
            this.addToMaterialPrice(headerList.get(0));
        } else if ("N".equals(opinion)) {
            header.setBiddingAuditstatus(ApprovalStatusEnum.REJECT_APPROVAL.getValue());
            header.setBiddingStatus(TenderStatusEumn.INBID.getValue());
            header.setBidSubmitDate(null);
            BiddingTeamExample teamExample = new BiddingTeamExample();
            teamExample.createCriteria().andBiddingNoEqualTo(headerList.get(0).getBiddingNo()).andIsEnabledEqualTo(Constant.YES_INT).andBidGroupEqualTo(BiddingGroupTypeEnum.BUSINESS_GROUP.getValue());
            BiddingTeam team = new BiddingTeam();
            team.setConfirmStatus(Constant.NO_INT);
            this.biddingTeamService.modifyByExample(teamExample, team);
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
                if (!TenderStatusEumn.BIDOVER.getValue().equals(((BiddingSupplier)biddingSupplierList.get(i)).getSupBiddingStatus())) continue;
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
                biddingSupplier.setSupBiddingStatus(TenderStatusEumn.INBID.getValue());
                this.biddingSupplierService.modifyObj(biddingSupplier);
            }
            BiddingOfferExample offerExample = new BiddingOfferExample();
            offerExample.createCriteria().andBiddingNoEqualTo(headerList.get(0).getBiddingNo()).andBiddingRoundsNumberEqualTo(headerList.get(0).getBiddingCurrentRound());
            List biddingOfferList = this.biddingOfferService.queryAllObjByExample((IExample)offerExample);
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingOfferList) && i < biddingOfferList.size(); ++i) {
                BiddingOffer biddingOffer = new BiddingOffer();
                biddingOffer.setId(((BiddingOffer)biddingOfferList.get(i)).getId());
                biddingOffer.setIsBidding("0");
                biddingOffer.setBidShare("0");
                biddingOffer.setIsSubmitBid("0");
                this.biddingOfferService.modifyObj(biddingOffer);
            }
        } else {
            logger.error("OA\u56de\u5199\u6240\u4f20\u7684\u6700\u7ec8\u610f\u89c1\u7684\u503c\u4e3a\uff1a" + opinion + "\uff0c\u4e0d\u662fY/N\uff0c\u6240\u4ee5\u56de\u5199\u5931\u8d25");
            throw new CommonException("OA\u56de\u5199\u6240\u4f20\u7684\u6700\u7ec8\u610f\u89c1\u7684\u503c\u4e3a\uff1a" + opinion + "\uff0c\u4e0d\u662fY/N\uff0c\u6240\u4ee5\u56de\u5199\u5931\u8d25");
        }
        this.customModifyObj(header);
        return null;
    }

    private void addToMaterialPrice(BiddingHeader biddingHeader) {
        BiddingOfferExample offExample = new BiddingOfferExample();
        offExample.createCriteria().andBiddingNoEqualTo(biddingHeader.getBiddingNo()).andBiddingRoundsNumberEqualTo(biddingHeader.getBiddingCurrentRound()).andIsBiddingEqualTo("1");
        List offerList = this.biddingOfferService.queryAllObjByExample((IExample)offExample);
        for (BiddingOffer offer : offerList) {
            MaterialPrice price;
            MaterialPriceExample priceExample = new MaterialPriceExample();
            MaterialPriceExample.Criteria cri = priceExample.createCriteria();
            cri.andInstitutionsIdEqualTo(biddingHeader.getInstitutionsId());
            cri.andSupCompanyCodeEqualTo(offer.getSupCompanySrmCode());
            if ("material".equals(offer.getRequirementTypeCode())) {
                cri.andMaterialCodeEqualTo(offer.getProjectNo());
            } else if ("device".equals(offer.getRequirementTypeCode())) {
                cri.andMaterialCodeEqualTo(offer.getTargetNo());
                cri.andDescriptionEqualTo(offer.getTaregtDesc());
            }
            List priceList = this.materialPriceService.queryAllObjByExample((IExample)priceExample);
            if (CollectionUtils.isEmpty((Collection)priceList)) {
                price = new MaterialPrice();
                price.setMaterialPriceOrigin("1");
                price.setBiddingNo(biddingHeader.getBiddingNo());
                if ("material".equals(offer.getRequirementTypeCode())) {
                    price.setMaterialCode(offer.getProjectNo());
                    price.setDescription(offer.getProjectDesc());
                } else if ("device".equals(offer.getRequirementTypeCode())) {
                    price.setMaterialCode(offer.getTargetNo());
                    price.setDescription(offer.getTaregtDesc());
                }
                price.setPrice(new BigDecimal(offer.getOfferUnitPrice()));
                price.setBasicUnit(offer.getUnit());
                price.setSupCompanyCode(offer.getSupCompanySrmCode());
                price.setSupCompanyName(offer.getSupCompanyName());
                price.setDepartId(biddingHeader.getDepartId());
                price.setDepartName(biddingHeader.getDepartName());
                price.setInstitutionsId(biddingHeader.getInstitutionsId());
                price.setInstitutionsName(biddingHeader.getInstitutionsName());
                price.setInTheOrganizationId(biddingHeader.getInTheOrganizationId());
                price.setInTheOrganizationName(biddingHeader.getInTheOrganizationName());
                price.setCreateTime(new Date());
                price.setCreateUserId(biddingHeader.getPurUserId());
                price.setCreateUserName(biddingHeader.getPurUserName());
                String code = this.generateCodeService.getNextCode("MATERIAL_PRICE");
                price.setMaterialPriceNo(code);
                this.materialPriceService.addObj((Serializable)price);
                continue;
            }
            price = new MaterialPrice();
            price.setId(((MaterialPrice)priceList.get(0)).getId());
            price.setPrice(new BigDecimal(offer.getOfferUnitPrice()));
            price.setUpdateTime(new Date());
            price.setUpdateUserId(biddingHeader.getPurUserId());
            price.setUpdateUserName(biddingHeader.getPurUserName());
            this.materialPriceService.modifyObj((Serializable)price);
        }
    }

    private void modifySupplierData(BiddingHeader biddingHeader, BiddingSupplier supplier) {
        if (TenderStatusEumn.BIDOVER.getValue().equals(supplier.getSupBiddingStatus())) {
            BiddingSupplier biddingSupplier = new BiddingSupplier();
            biddingSupplier.setId(supplier.getId());
            biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISSCALING.getValue());
            this.biddingSupplierService.modifyObj(biddingSupplier);
        }
    }

    private void checkDataFromOA(Map<String, Object> objectMap) {
        if (null == objectMap) {
            logger.error("OA\u56de\u5199PCP\u7cfb\u7edf\u65f6\u6240\u4f20\u53c2\u6570\u4e3a\u7a7a\uff0c\u56de\u5199\u5931\u8d25");
            throw new CommonException("OA\u56de\u5199PCP\u7cfb\u7edf\u65f6\u6240\u4f20\u53c2\u6570\u4e3a\u7a7a\uff0c\u56de\u5199\u5931\u8d25");
        }
        String flowId = (String)objectMap.get("flowId");
        String opinion = (String)objectMap.get("opinion");
        Map createFlowParam = (Map)objectMap.get("createFlowParam");
        if (StringUtils.isBlank((String)flowId)) {
            logger.error("OA\u56de\u5199\u5b9a\u6807\u5ba1\u6279\u7ed3\u679c\u65f6\uff0c\u6240\u4f20\u7684\u6d41\u7a0bID\u4e3a\u7a7a");
            throw new CommonException("OA\u56de\u5199\u5b9a\u6807\u5ba1\u6279\u7ed3\u679c\u65f6\uff0c\u6240\u4f20\u7684\u6d41\u7a0bID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)opinion)) {
            logger.error("OA\u56de\u5199\u5b9a\u6807\u5ba1\u6279\u7ed3\u679c\u65f6\uff0c\u6240\u4f20\u7684\u6700\u7ec8\u610f\u89c1\u4e3a\u7a7a");
            throw new CommonException("OA\u56de\u5199\u5b9a\u6807\u5ba1\u6279\u7ed3\u679c\u65f6\uff0c\u6240\u4f20\u7684\u6700\u7ec8\u610f\u89c1\u4e3a\u7a7a");
        }
        logger.debug("================OA\u56de\u5199\u7684\u62db\u6807\u7f16\u53f7" + createFlowParam.get("BiddingNo") + "==========================");
    }

    @Override
    @CacheEvict(value={"biddingHeader"}, allEntries=true)
    public void biddingFromPurchaseRequisition(BiddingBaseVo biddingBaseVo) {
        BiddingContent biddingContent;
        Company purCompany = biddingBaseVo.getCompany();
        Assert.isNotNull((Object)biddingBaseVo.getBiddingHeader(), (String)"\u62db\u6807\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8f6c\u62db\u6807\u5931\u8d25");
        BiddingHeader biddingHeader = biddingBaseVo.getBiddingHeader();
        User purUser = new User();
        purUser.setId(biddingHeader.getPurUserId());
        purUser.setNickName(biddingHeader.getPurUserName());
        Assert.isNotBlank((String)biddingHeader.getDepartId(), (String)"\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((String)biddingHeader.getBiddingMatterId())) {
            throw new CommonException("\u62db\u6807\u4e8b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        biddingHeader.setPurCompanyId(purCompany.getId());
        biddingHeader.setPurCompanyCode(purCompany.getCompanyCode());
        biddingHeader.setPurCompanyName(purCompany.getCompanyName());
        biddingHeader.setBiddingStatus(TenderStatusEumn.NOTPUBLISH.getValue());
        biddingHeader.setBiddingPreAuditstatus(SendBiddingStatusEnum.UNSEND.getValue());
        biddingHeader.setBiddingAuditstatus(ApprovalStatusEnum.NOT_APPROVAL.getValue());
        biddingHeader.setScoreStatus(ConfirmStatusEnum.NO_CONFIRM.getValue());
        BiddingMatter biddingMatter = (BiddingMatter)this.biddingMatterService.queryObjById(biddingHeader.getBiddingMatterId());
        biddingHeader.setTechnicalWeight(biddingMatter.getTechnicalWeight());
        biddingHeader.setBusniessWeight(biddingMatter.getBusniessWeight());
        biddingHeader.setBiddingMatterName(biddingMatter.getBiddingMatterName());
        this.addObj(biddingHeader);
        BiddingPower biddingPower = biddingHeader.getBiddingPower();
        if (biddingPower != null) {
            if (biddingPower.getId() == null) {
                this.addBiddingPower(biddingHeader, purCompany, purUser);
            } else {
                biddingPower.setLastUpdateTime(new Date());
                biddingPower.setLastUpdateUser(purUser.getNickName());
                this.biddingPowerService.modifyObj(biddingPower);
            }
        }
        if ((biddingContent = biddingBaseVo.getBiddingContent()) != null) {
            this.addBiddingContent(biddingContent, biddingHeader, purCompany, purUser);
        }
    }
}

