/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.BiddingTeam;
import com.els.base.bidding.entity.BiddingTeamExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.ManagementPage;
import com.els.base.bidding.enums.BiddingGroupTypeEnum;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.bidding.service.BiddingTeamService;
import com.els.base.company.entity.Department;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u62db\u6295\u6807-\u57fa\u672c\u4fe1\u606f"})
@Controller
@RequestMapping(value={"biddingHeader"})
public class BiddingHeaderController {
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected BiddingContentService biddingContentService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;
    @Resource
    protected UserRoleService userRoleService;
    @Resource
    protected RoleService roleService;
    @Resource
    private BiddingTeamService biddingTeamService;
    @Resource
    private DepartmentService departmentService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6295\u6807-\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingHeader biddingHeader) {
        this.biddingHeaderService.addObj(biddingHeader);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6295\u6807-\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingHeader biddingHeader) {
        Assert.isNotBlank((String)biddingHeader.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingHeaderService.modifyObj(biddingHeader);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u62db\u6295\u6807-\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingHeaderService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807-\u57fa\u672c\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingHeader", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingHeader>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingHeaderExample example = new BiddingHeaderExample();
        example.setPageView((PageView<BiddingHeader>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.biddingHeaderService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u62db\u6295\u6807\u5355\u636e\u4fe1\u606f")
    @RequestMapping(value={"service/saveBiddingInfo"})
    @ResponseBody
    public ResponseResult<BiddingBaseVo> saveBiddingInfo(@RequestBody BiddingBaseVo biddingBaseVo) {
        biddingBaseVo.setCompany(CompanyUtils.currentCompany());
        biddingBaseVo.setUser(SpringSecurityUtils.getLoginUser());
        this.biddingHeaderService.saveBiddingInfo(biddingBaseVo);
        return ResponseResult.success((Object)biddingBaseVo);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807\u7ba1\u7406\u9875\u9762(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingHeader", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findManagementByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<ManagementPage>> findManagementByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        User loginUser;
        List departList;
        String[] split = null;
        QueryParam confirgStatus = null;
        for (int i = 0; wapper != null && CollectionUtils.isNotEmpty((Collection)wapper.getQueryParams()) && i < wapper.getQueryParams().size(); ++i) {
            if (!((QueryParam)wapper.getQueryParams().get(i)).getProperty().equals("biddingStatus")) continue;
            confirgStatus = (QueryParam)wapper.getQueryParams().get(i);
            String[] value = confirgStatus.getValue();
            String b = value.replaceAll("[\\[\\]]", "");
            if (!StringUtils.isNotBlank((String)b)) break;
            String all = b.replaceAll("\"([^\"]*)\"", "$1");
            split = all.split(",");
            break;
        }
        if (confirgStatus != null) {
            wapper.getQueryParams().remove(confirgStatus);
        }
        ArrayList<String> biddingStatusList = new ArrayList<String>();
        if (split != null && split.length != 0) {
            for (void var10_13 : split) {
                biddingStatusList.add((String)var10_13);
            }
        }
        BiddingHeaderExample example = new BiddingHeaderExample();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)(departList = this.departmentService.queryDepartmentsOfUser((loginUser = SpringSecurityUtils.getLoginUser()).getId())))) {
            List list = departList.stream().map(Department::getId).distinct().collect(Collectors.toList());
            example.createCriteria().andDepartIdIn(list);
        }
        List list = this.biddingHeaderService.queryAllObjByExample((IExample)example);
        BiddingTeamExample teamExample = new BiddingTeamExample();
        teamExample.createCriteria().andBidUserIdEqualTo(loginUser.getId()).andIsEnabledEqualTo(Constant.YES_INT);
        List teamList = this.biddingTeamService.queryAllObjByExample((IExample)teamExample);
        List<BiddingHeader> allHeaderBidding = new ArrayList<BiddingHeader>();
        if (CollectionUtils.isNotEmpty((Collection)teamList)) {
            List biddingNoList = teamList.stream().map(BiddingTeam::getBiddingNo).distinct().collect(Collectors.toList());
            BiddingHeaderExample teamHeaderExample = new BiddingHeaderExample();
            teamHeaderExample.createCriteria().andBiddingNoIn(biddingNoList);
            allHeaderBidding = this.biddingHeaderService.queryAllObjByExample((IExample)teamHeaderExample);
        }
        allHeaderBidding.addAll(list);
        if (CollectionUtils.isNotEmpty(allHeaderBidding)) {
            allHeaderBidding = allHeaderBidding.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BiddingHeader>(Comparator.comparing(BiddingHeader::getBiddingNo))), ArrayList::new)).stream().sorted(Comparator.comparing(BiddingHeader::getBiddingNo).reversed()).collect(Collectors.toList());
        }
        List loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)loginUserRoleList) && i < loginUserRoleList.size(); ++i) {
            roleCodeList.add(((Role)loginUserRoleList.get(i)).getRoleCode());
        }
        List<ManagementPage> list2 = this.biddingHeaderService.transform(allHeaderBidding, loginUser, roleCodeList);
        List<ManagementPage> finalList = this.biddingHeaderService.screenDataByBiddingStatus(list2, biddingStatusList);
        if (CollectionUtils.isNotEmpty(finalList)) {
            for (ManagementPage m : finalList) {
                BiddingTeamExample tExample = new BiddingTeamExample();
                tExample.createCriteria().andBiddingNoEqualTo(m.getBiddingNo()).andIsEnabledEqualTo(Constant.YES_INT);
                List biddingTeamList = this.biddingTeamService.queryAllObjByExample((IExample)tExample);
                if (!CollectionUtils.isNotEmpty((Collection)biddingTeamList)) continue;
                int technicalsize = biddingTeamList.stream().filter(t -> t.getBidGroup().equals(BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue()) && t.getBidUserId().equals(loginUser.getId())).collect(Collectors.toList()).size();
                int businesssize = biddingTeamList.stream().filter(t -> t.getBidGroup().equals(BiddingGroupTypeEnum.BUSINESS_GROUP.getValue()) && t.getBidUserId().equals(loginUser.getId())).collect(Collectors.toList()).size();
                if (technicalsize > 0 && businesssize == 0) {
                    m.setBiddingGroupType(BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue());
                    continue;
                }
                if (technicalsize == 0 && businesssize > 0) {
                    m.setBiddingGroupType(BiddingGroupTypeEnum.BUSINESS_GROUP.getValue());
                    continue;
                }
                if (technicalsize <= 0 || businesssize <= 0) continue;
                m.setBiddingGroupType(BiddingGroupTypeEnum.ALL_GROUP.getValue());
            }
        }
        PageView page = new PageView(pageNo, pageSize);
        page.setRowCount(CollectionUtils.isEmpty(finalList) ? 0 : finalList.size());
        page.setQueryResult(finalList.subList(page.getStartRowNo(), page.getEndRowNo()));
        return ResponseResult.success((Object)page);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807\u7ba1\u7406\u9875\u9762(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingHeader", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findManagementByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<ManagementPage>> findManagementByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        String[] split = new String[]{};
        QueryParam confirgStatus = null;
        for (int i = 0; wapper != null && CollectionUtils.isNotEmpty((Collection)wapper.getQueryParams()) && i < wapper.getQueryParams().size(); ++i) {
            if (!((QueryParam)wapper.getQueryParams().get(i)).getProperty().equals("biddingStatus")) continue;
            confirgStatus = (QueryParam)wapper.getQueryParams().get(i);
            String value = confirgStatus.getValue();
            String b = value.replaceAll("[\\[\\]]", "");
            String b2 = b.replaceAll("\"", "");
            if (!StringUtils.isNotBlank((String)b2)) break;
            split = b2.split(",");
            break;
        }
        if (confirgStatus != null) {
            wapper.getQueryParams().remove(confirgStatus);
        }
        ArrayList<String> biddingStatusList = new ArrayList();
        if (split.length > 0) {
            biddingStatusList = Arrays.asList(split);
        }
        ArrayList<String> listStatus = new ArrayList<String>();
        listStatus.add(TenderStatusEumn.BIDDING.getValue());
        listStatus.add(TenderStatusEumn.BIDDINGEND.getValue());
        listStatus.add(TenderStatusEumn.INBID.getValue());
        listStatus.add(TenderStatusEumn.BIDOVER.getValue());
        listStatus.add(TenderStatusEumn.ISSCALING.getValue());
        listStatus.add(TenderStatusEumn.ISCANCEL.getValue());
        listStatus.add(TenderStatusEumn.ISFINISH.getValue());
        listStatus.add(TenderStatusEumn.INSTRUMENT.getValue());
        listStatus.add(TenderStatusEumn.WAITBID.getValue());
        listStatus.add(TenderStatusEumn.ISBID.getValue());
        listStatus.add(TenderStatusEumn.REFUSEBID.getValue());
        BiddingSupplierExample biddingSupplierExample = new BiddingSupplierExample();
        BiddingSupplierExample.Criteria criteriaStatus = biddingSupplierExample.createCriteria();
        criteriaStatus.andSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        criteriaStatus.andSupBiddingStatusIn(listStatus);
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)biddingSupplierExample);
        ArrayList<String> biddingNoList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
            biddingNoList.add(((BiddingSupplier)biddingSupplierList.get(i)).getBiddingNo());
        }
        ArrayList<BiddingHeader> biddingHeaderList = new ArrayList();
        ArrayList<ManagementPage> list = new ArrayList();
        List<Object> finalList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)biddingSupplierList)) {
            BiddingHeaderExample example = new BiddingHeaderExample();
            example.createCriteria().andBiddingNoIn(biddingNoList);
            example.setOrderByClause("CREATE_TIME DESC");
            if (wapper != null) {
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
            }
            biddingHeaderList = this.biddingHeaderService.queryAllObjByExample((IExample)example);
            ArrayList<String> roleCodeList = new ArrayList<String>();
            list = this.biddingHeaderService.transformSup(biddingHeaderList, SpringSecurityUtils.getLoginUser(), roleCodeList, CompanyUtils.currentCompany());
            finalList = this.biddingHeaderService.screenDataByBiddingStatus(list, biddingStatusList);
        }
        PageView page = new PageView(pageNo, pageSize);
        page.setRowCount(CollectionUtils.isEmpty(finalList) ? 0 : finalList.size());
        page.setQueryResult(finalList.subList(page.getStartRowNo(), page.getEndRowNo()));
        return ResponseResult.success((Object)page);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9-\u67e5\u8be2\u62db\u6295\u6807\u5355\u636e")
    @RequestMapping(value={"service/queryDocument"})
    @ResponseBody
    public ResponseResult<BiddingBaseVo> queryDocument(String biddingNo, String biddingGroupType) {
        User user = SpringSecurityUtils.getLoginUser();
        List loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)loginUserRoleList) && i < loginUserRoleList.size(); ++i) {
            roleCodeList.add(((Role)loginUserRoleList.get(i)).getRoleCode());
        }
        BiddingBaseVo biddingBaseVo = this.biddingHeaderService.queryDocument(biddingNo, biddingGroupType, CompanyUtils.currentCompany(), user, roleCodeList);
        return ResponseResult.success((Object)biddingBaseVo);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u65b9-\u67e5\u8be2\u62db\u6295\u6807\u5355\u636e")
    @RequestMapping(value={"service/queryDocumentSup"})
    @ResponseBody
    public ResponseResult<BiddingBaseVo> queryDocumentSup(String biddingNo, String biddingCurrentRound) {
        User user = SpringSecurityUtils.getLoginUser();
        BiddingBaseVo biddingBaseVo = this.biddingHeaderService.queryDocumentSup(biddingNo, biddingCurrentRound, CompanyUtils.currentCompany(), user, null);
        return ResponseResult.success((Object)biddingBaseVo);
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f\u62db\u6295\u6807\u5355\u636e")
    @RequestMapping(value={"service/toVoidDocument"})
    @ResponseBody
    public ResponseResult<String> toVoidDocument(String biddingNo) {
        this.biddingHeaderService.toVoidDocument(biddingNo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u62db\u6295\u6807\u5355\u636e")
    @RequestMapping(value={"service/deleteDocumentByBiddingNo"})
    @ResponseBody
    public ResponseResult<String> deleteDocumentByBiddingNo(@RequestBody List<String> bidingNoList) {
        for (String biddingNo : bidingNoList) {
            Assert.isNotBlank((String)biddingNo, (String)"\u5220\u9664\u5931\u8d25,biddingNo\u4e0d\u80fd\u4e3a\u7a7a");
            this.biddingHeaderService.deleteDocumentByBiddingNo(biddingNo);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u5e03\u524d\u5ba1\u6279")
    @RequestMapping(value={"service/sendBeforeApproval"})
    @ResponseBody
    public ResponseResult<String> sendBeforeApproval(@RequestBody List<String> bidingNoList) {
        if (CollectionUtils.isEmpty(bidingNoList)) {
            throw new CommonException("\u53d1\u9001\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.biddingHeaderService.sendToApprove(bidingNoList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u62db\u6807\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/sendBidding"})
    @ResponseBody
    public ResponseResult<String> sendBidding(@RequestBody List<String> bidingNoList) {
        if (CollectionUtils.isEmpty(bidingNoList)) {
            throw new CommonException("\u53d1\u9001\u5931\u8d25\uff0c\u62db\u6807\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.biddingHeaderService.sendBiddingToSupplier(bidingNoList, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5b9a\u6807\u524d\u5ba1\u6279")
    @RequestMapping(value={"service/biddingBeforeApproval"})
    @ResponseBody
    public ResponseResult<String> biddingBeforeApproval(@RequestBody List<String> bidingNoList) {
        if (CollectionUtils.isEmpty(bidingNoList)) {
            throw new CommonException("\u5ba1\u6279\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.biddingContentService.biddingBeforeApproval(bidingNoList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u62db\u6295\u6807-\u5b9a\u6807\u53d1\u9001OA\u5ba1\u6279\uff08\u5bcc\u5fb7\u9879\u76ee\u4e13\u7528\uff09")
    @RequestMapping(value={"service/biddingApprovalToOa"})
    @ResponseBody
    public ResponseResult<String> biddingApprovalToOa(@RequestBody List<String> bidingNoList) {
        if (CollectionUtils.isEmpty(bidingNoList)) {
            throw new CommonException("\u5ba1\u6279\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.biddingHeaderService.biddingApprovalToOa(bidingNoList, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u4e2d\u6807\u901a\u77e5")
    @RequestMapping(value={"service/finisnBidding"})
    @ResponseBody
    public ResponseResult<String> finisnBidding(String biddingNo) {
        if (StringUtils.isBlank((String)biddingNo)) {
            throw new CommonException("\u53d1\u9001\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.biddingHeaderService.finisnBidding(biddingNo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8bae\u6807")
    @RequestMapping(value={"service/instrument"})
    @ResponseBody
    public ResponseResult<String> instrument(@RequestBody List<BiddingOffer> biddingOfferList) {
        if (CollectionUtils.isEmpty(biddingOfferList)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u9700\u8981\u8bae\u6807\u7684\u6570\u636e!");
        }
        this.biddingHeaderService.instrument(biddingOfferList);
        return ResponseResult.success();
    }
}

