/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingScore;
import com.els.base.bidding.entity.BiddingScoreExample;
import com.els.base.bidding.service.BiddingScoreService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u8bc4\u5206-\u62db\u6807\u5355"})
@Controller
@RequestMapping(value={"biddingScore"})
public class BiddingScoreController {
    @Resource
    protected BiddingScoreService biddingScoreService;

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u8bc4\u5206-\u62db\u6807\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody List<BiddingScore> biddingScores) {
        Assert.isNotEmpty(biddingScores, (String)"\u8bc4\u5206\u4fe1\u606f\u4e3a\u7a7a\uff0c\u63d0\u4ea4\u5931\u8d25");
        this.biddingScoreService.saveObj(biddingScores, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8bc4\u5206-\u62db\u6807\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingScore biddingScore) {
        Assert.isNotBlank((String)biddingScore.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingScoreService.modifyObj(biddingScore);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8bc4\u5206-\u62db\u6807\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        BiddingScoreExample example = new BiddingScoreExample();
        example.createCriteria().andIdIn((List)ids);
        this.biddingScoreService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8bc4\u5206-\u62db\u6807\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingScore", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingScore>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingScoreExample example = new BiddingScoreExample();
        example.setPageView((PageView<BiddingScore>)new PageView(pageNo, pageSize));
        BiddingScoreExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.biddingScoreService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8bc4\u5206-\u62db\u6807\u5355")
    @RequestMapping(value={"service/findByList"})
    @ResponseBody
    public ResponseResult<List<BiddingScore>> findByList(@RequestParam(required=true) String supCompanyCode, @RequestParam(required=true) String biddingNo, @RequestParam(required=true) String roundsNumber) {
        Assert.isNotBlank((String)supCompanyCode, (String)"\u4f9b\u5e94\u5546srm\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingNo, (String)"\u62db\u6807\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)roundsNumber, (String)"\u62db\u6807\u5f53\u524d\u8f6e\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        User purUser = SpringSecurityUtils.getLoginUser();
        BiddingScoreExample example = new BiddingScoreExample();
        example.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyCodeEqualTo(supCompanyCode).andBiddingRoundsNumberEqualTo(roundsNumber).andRatersIdEqualTo(purUser.getId());
        List list = this.biddingScoreService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)list);
    }

    @ApiOperation(httpMethod="POST", value="\u5546\u52a1\u5c0f\u7ec4\u786e\u8ba4\u8bc4\u6807\u7ed3\u679c-\u62db\u6807\u5355")
    @RequestMapping(value={"service/confirmBidResults"})
    @ResponseBody
    public ResponseResult<String> confirmBidResults(String biddingNo, String biddingRoundsNumber) {
        Assert.isNotBlank((String)biddingNo, (String)"\u62db\u6807\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingRoundsNumber, (String)"\u5f53\u524d\u62db\u6807\u8f6e\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingScoreService.confirmBidResults(biddingNo, biddingRoundsNumber, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }
}

