/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingGroupMapper;
import com.els.base.bidding.entity.BiddingGroup;
import com.els.base.bidding.entity.BiddingGroupExample;
import com.els.base.bidding.service.BiddingGroupService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingGroupService")
public class BiddingGroupServiceImpl
implements BiddingGroupService {
    @Resource
    protected BiddingGroupMapper biddingGroupMapper;

    @CacheEvict(value={"biddingGroup"}, allEntries=true)
    public void addObj(BiddingGroup t) {
        this.biddingGroupMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"biddingGroup"}, allEntries=true)
    public void insert(BiddingGroup biddingGroup, Company purCompany, User loginUser) {
        Assert.isNotNull((Object)biddingGroup, (String)"\u6570\u636e\u4e3a\u7a7a\u64cd\u4f5c\u5931\u8d25");
        this.checkData(biddingGroup);
        if (StringUtils.isBlank((String)biddingGroup.getId())) {
            biddingGroup.setPurCompanyId(purCompany.getId());
            biddingGroup.setPurCompanyName(purCompany.getCompanyFullName());
            biddingGroup.setPurCompanySrmCode(purCompany.getCompanyCode());
            biddingGroup.setPurCompanySapCode(purCompany.getCompanySapCode());
            biddingGroup.setPurUserId(loginUser.getId());
            biddingGroup.setPurUserName(loginUser.getNickName());
            biddingGroup.setBidTimes(0);
            biddingGroup.setCreateTime(new Date());
            this.biddingGroupMapper.insertSelective(biddingGroup);
        } else {
            biddingGroup.setUpdateTime(new Date());
            biddingGroup.setUpdateUser(loginUser.getNickName());
            this.biddingGroupMapper.updateByPrimaryKeySelective(biddingGroup);
        }
    }

    private void checkData(BiddingGroup biddingGroup) {
        Assert.isNotBlank((String)biddingGroup.getBidGroup(), (String)"\u8bc4\u6807\u5c0f\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingGroup.getBidUserId(), (String)"\u8bc4\u6807\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingGroup.getBidUserCode(), (String)"\u8bc4\u6807\u4eba\u5458\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingGroup.getBidUserName(), (String)"\u8bc4\u6807\u4eba\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingGroup.getAffiliateId(), (String)"\u6240\u5c5e\u673a\u6784ID\uff08\u6240\u5c5e\u516c\u53f8ID\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingGroup.getAffiliateName(), (String)"\u6240\u5c5e\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingGroup.getDepartmentName(), (String)"\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)biddingGroup.getIsEnabled(), (String)"\u6fc0\u6d3b\u72b6\u6001\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        BiddingGroupExample example = new BiddingGroupExample();
        example.createCriteria().andBidUserIdEqualTo(biddingGroup.getBidUserId()).andAffiliateIdEqualTo(biddingGroup.getAffiliateId()).andIsEnabledEqualTo(Constant.YES_INT).andBidGroupEqualTo(biddingGroup.getBidGroup());
        if (this.biddingGroupMapper.countByExample(example) > 0) {
            throw new CommonException("\u540c\u4e00\u673a\u6784\u540c\u4e00\u4eba\u5458\u4e0d\u80fd\u91cd\u590d\u7ef4\u62a4");
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingGroup"}, allEntries=true)
    public void activation(List<String> ids, User loginUser) {
        BiddingGroupExample example = new BiddingGroupExample();
        example.createCriteria().andIdIn((List)ids);
        List<BiddingGroup> list = this.biddingGroupMapper.selectByExample(example);
        Assert.isNotEmpty(list, (String)"\u8bc4\u6807\u5c0f\u7ec4\u4eba\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
        for (BiddingGroup group : list) {
            BiddingGroup bidding = new BiddingGroup();
            bidding.setId(group.getId());
            bidding.setUpdateTime(new Date());
            bidding.setUpdateUser(loginUser.getNickName());
            if (group.getIsEnabled().equals(Constant.YES_INT)) {
                bidding.setIsEnabled(Constant.NO_INT);
            } else if (group.getIsEnabled().equals(Constant.NO_INT)) {
                example.clear();
                example.createCriteria().andAffiliateIdEqualTo(group.getAffiliateId()).andBidGroupEqualTo(group.getBidGroup()).andIsEnabledEqualTo(Constant.YES_INT).andBidUserIdEqualTo(group.getBidUserId());
                if (this.biddingGroupMapper.countByExample(example) == 0) {
                    bidding.setIsEnabled(Constant.YES_INT);
                } else {
                    throw new CommonException("\u5df2\u5b58\u5728\u540c\u673a\u6784\u540c\u4e00\u4eba\u5458\u4fe1\u606f\uff0c\u4e0d\u80fd\u518d\u6fc0\u6d3b");
                }
            }
            this.biddingGroupMapper.updateByPrimaryKeySelective(bidding);
        }
    }

    @Transactional
    @CacheEvict(value={"biddingGroup"}, allEntries=true)
    public void addAll(List<BiddingGroup> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingGroupMapper.insertBatch(list);
    }

    @CacheEvict(value={"biddingGroup"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingGroupMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingGroup"}, allEntries=true)
    public void deleteByExample(BiddingGroupExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingGroupMapper.deleteByExample(example);
    }

    @CacheEvict(value={"biddingGroup"}, allEntries=true)
    public void modifyObj(BiddingGroup t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        BiddingGroup group = this.biddingGroupMapper.selectByPrimaryKey(t.getId());
        if (!group.getBidGroup().equals(t.getBidGroup())) {
            BiddingGroupExample example = new BiddingGroupExample();
            example.createCriteria().andBidUserIdEqualTo(t.getBidUserId()).andAffiliateIdEqualTo(t.getAffiliateId()).andBidGroupEqualTo(t.getBidGroup()).andIsEnabledEqualTo(Constant.YES_INT);
            if (this.biddingGroupMapper.countByExample(example) > 0) {
                throw new CommonException("\u540c\u4e00\u8bc4\u6807\u5c0f\u7ec4\u7c7b\u578b\u540c\u4e00\u673a\u6784\u4e2d\u5df2\u5b58\u5728\u6b64\u8bc4\u6807\u4eba\u5458\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
        }
        this.biddingGroupMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingGroup"}, keyGenerator="redisKeyGenerator")
    public BiddingGroup queryObjById(String id) {
        return this.biddingGroupMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"biddingGroup"}, keyGenerator="redisKeyGenerator")
    public List<BiddingGroup> queryAllObjByExample(BiddingGroupExample example) {
        return this.biddingGroupMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingGroup"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingGroup> queryObjByPage(BiddingGroupExample example) {
        PageView<BiddingGroup> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingGroupMapper.selectByExampleByPage(example));
        return pageView;
    }
}

