/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingTemplateItemMapper;
import com.els.base.bidding.entity.BiddingTemplateItem;
import com.els.base.bidding.entity.BiddingTemplateItemExample;
import com.els.base.bidding.service.BiddingTemplateItemService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingTemplateItemService")
public class BiddingTemplateItemServiceImpl
implements BiddingTemplateItemService {
    @Resource
    protected BiddingTemplateItemMapper biddingTemplateItemMapper;

    @CacheEvict(value={"biddingTemplateItem"}, allEntries=true)
    public void addObj(BiddingTemplateItem t) {
        this.biddingTemplateItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"biddingTemplateItem"}, allEntries=true)
    public void addAll(List<BiddingTemplateItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingTemplateItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"biddingTemplateItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingTemplateItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingTemplateItem"}, allEntries=true)
    public void deleteByExample(BiddingTemplateItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingTemplateItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"biddingTemplateItem"}, allEntries=true)
    public void modifyObj(BiddingTemplateItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingTemplateItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingTemplateItem"}, keyGenerator="redisKeyGenerator")
    public BiddingTemplateItem queryObjById(String id) {
        return this.biddingTemplateItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"biddingTemplateItem"}, keyGenerator="redisKeyGenerator")
    public List<BiddingTemplateItem> queryAllObjByExample(BiddingTemplateItemExample example) {
        return this.biddingTemplateItemMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingTemplateItem"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingTemplateItem> queryObjByPage(BiddingTemplateItemExample example) {
        PageView<BiddingTemplateItem> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingTemplateItemMapper.selectByExampleByPage(example));
        return pageView;
    }
}

