/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingTradeConditionMapper;
import com.els.base.bidding.entity.BiddingTradeCondition;
import com.els.base.bidding.entity.BiddingTradeConditionExample;
import com.els.base.bidding.service.BiddingTradeConditionService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingTradeConditionService")
public class BiddingTradeConditionServiceImpl
implements BiddingTradeConditionService {
    @Resource
    protected BiddingTradeConditionMapper biddingTradeConditionMapper;

    @CacheEvict(value={"biddingTradeCondition"}, allEntries=true)
    public void addObj(BiddingTradeCondition t) {
        this.biddingTradeConditionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"biddingTradeCondition"}, allEntries=true)
    public void addAll(List<BiddingTradeCondition> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingTradeConditionMapper.insertBatch(list);
    }

    @CacheEvict(value={"biddingTradeCondition"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingTradeConditionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingTradeCondition"}, allEntries=true)
    public void deleteByExample(BiddingTradeConditionExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingTradeConditionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"biddingTradeCondition"}, allEntries=true)
    public void modifyObj(BiddingTradeCondition t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingTradeConditionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingTradeCondition"}, keyGenerator="redisKeyGenerator")
    public BiddingTradeCondition queryObjById(String id) {
        return this.biddingTradeConditionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"biddingTradeCondition"}, keyGenerator="redisKeyGenerator")
    public List<BiddingTradeCondition> queryAllObjByExample(BiddingTradeConditionExample example) {
        return this.biddingTradeConditionMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingTradeCondition"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingTradeCondition> queryObjByPage(BiddingTradeConditionExample example) {
        PageView<BiddingTradeCondition> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingTradeConditionMapper.selectByExampleByPage(example));
        return pageView;
    }
}

