/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.SaveBidInfoVo;
import com.els.base.bidding.entity.vo.TemporaryCodeReducedRate;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.IExtendable;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.json.DetailDeSerializer;
import com.els.base.inquiry.utils.json.DetailSerialzer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u62db\u6295\u6807-\u4f9b\u5e94\u5546\u62a5\u4ef7"})
@Controller
@RequestMapping(value={"biddingOffer"})
public class BiddingOfferController {
    @Resource
    protected BiddingOfferService biddingOfferService;
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingOffer biddingOffer) {
        this.biddingOfferService.addObj(biddingOffer);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingOffer biddingOffer) {
        Assert.isNotBlank((String)biddingOffer.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingOfferService.modifyObj(biddingOffer);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingOfferService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingOffer", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingOffer>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingOfferExample example = new BiddingOfferExample();
        example.setPageView((PageView<BiddingOffer>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.biddingOfferService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u8bc4\u6807\u754c\u9762")
    @RequestMapping(value={"service/findBidInfo"})
    @ResponseBody
    public ResponseResult<List<BiddingOffer>> findBidInfo(String biddingNo, String type, String isBidding, String currentRound) {
        List<BiddingOffer> biddingOffers = this.biddingOfferService.findBidInfo(biddingNo, type, isBidding, currentRound, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success(biddingOffers);
    }

    @ApiOperation(httpMethod="POST", value="\u8bc4\u6807\u754c\u9762-\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findBidInfoSup"})
    @ResponseBody
    public ResponseResult<List<BiddingOffer>> findBidInfoSup(String biddingNo, String type, String isBidding, String currentRound) {
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        List<BiddingOffer> biddingOffers = this.biddingOfferService.findBidInfoSup(biddingNo, type, isBidding, currentRound, user, company);
        return ResponseResult.success(biddingOffers);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u62a5\u4ef7\u4fdd\u5b58")
    @RequestMapping(value={"service/editUnitPrice"})
    @ResponseBody
    public ResponseResult<BiddingBaseVo> editUnitPrice(@RequestBody BiddingBaseVo biddingBaseVo) throws InstantiationException, IllegalAccessException {
        if (StringUtils.isBlank((String)biddingBaseVo.getBiddingHeader().getBiddingNo())) {
            throw new CommonException("\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u62db\u6807\u5355\u53f7\u4e3a\u7a7a"});
        }
        if (biddingBaseVo.getBiddingContent() == null) {
            throw new CommonException("\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u5185\u5bb9\u5217\u8868\u6570\u636e\u4e3a\u7a7a"});
        }
        if (StringUtils.isBlank((String)biddingBaseVo.getHandleType())) {
            throw new CommonException("\u7f16\u7801\u4e0d\u5b58\u5728\u4e0d\u80fd\u64cd\u4f5c", "finish_status", new Object[]{"\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a(\u4fdd\u5b58\u6216\u6295\u6807)"});
        }
        biddingBaseVo.setCompany(CompanyUtils.currentCompany());
        biddingBaseVo.setUser(SpringSecurityUtils.getLoginUser());
        this.biddingOfferService.saveUnitPrice(biddingBaseVo);
        return ResponseResult.success((Object)biddingBaseVo);
    }

    @ApiOperation(httpMethod="POST", value="\u8ba1\u7b97\u4e0d\u542b\u7a0e\u4ef7\u683c")
    @RequestMapping(value={"service/calculateItemDetailValue"})
    @ResponseBody
    public ResponseResult<List<PropertyValue>> calculateItemDetailValue(@RequestParam(required=true) String costAnalysisId, @RequestBody List<PropertyValue> propertyValueList) throws InstantiationException, IllegalAccessException {
        DetailDeSerializer serializer = new DetailDeSerializer(((TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById((Object)costAnalysisId)).getOrderItemDetailClass());
        IOrderItemDetail itemDetail = (IOrderItemDetail)serializer.transform(propertyValueList);
        itemDetail.calculate();
        itemDetail.setTemplateId(costAnalysisId);
        DetailSerialzer serialzer = new DetailSerialzer();
        return ResponseResult.success((Object)serialzer.getProperyValueClass((IExtendable)itemDetail));
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58(save)\uff0c\u63d0\u4ea4(submit)\u8bc4\u6807\u7ed3\u679c")
    @RequestMapping(value={"service/save"})
    @ResponseBody
    public ResponseResult<String> save(@RequestBody SaveBidInfoVo saveBidInfoVo, String saveOrSubmit) {
        BiddingHeaderExample headerExample = new BiddingHeaderExample();
        headerExample.createCriteria().andBiddingNoEqualTo(saveBidInfoVo.getBiddingOfferList().get(0).getBiddingNo());
        this.biddingOfferService.save(saveBidInfoVo, saveOrSubmit);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4e2d\u6807\u7684\u4f9b\u5e94\u5546\u548c\u4efd\u989d")
    @RequestMapping(value={"service/findBidSupplier"})
    @ResponseBody
    public ResponseResult<List<TemporaryCodeReducedRate>> findBidSupplier(String biddingNo, String type, String currentRound) {
        List<TemporaryCodeReducedRate> codeReducedRates = this.biddingOfferService.findBidSupplier(biddingNo, type, currentRound);
        return ResponseResult.success(codeReducedRates);
    }
}

