/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.dao.BiddingContentMapper;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentExample;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentMatterExample;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.BiddingTeam;
import com.els.base.bidding.entity.BiddingTeamExample;
import com.els.base.bidding.enums.ApprovalStatusEnum;
import com.els.base.bidding.enums.BiddingGroupTypeEnum;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.bidding.service.BiddingTeamService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.materialprice.entity.MaterialPrice;
import com.els.base.materialprice.entity.MaterialPriceExample;
import com.els.base.materialprice.service.MaterialPriceService;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingContentService")
public class BiddingContentServiceImpl
implements BiddingContentService,
ITaskListener {
    @Resource
    protected BiddingContentMapper biddingContentMapper;
    @Resource
    protected BiddingContentMatterService biddingContentMatterService;
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;
    @Resource
    protected BiddingOfferService biddingOfferService;
    @Resource
    protected WorkFlowService workFlowService;
    @Resource
    protected BiddingContentModelService biddingContentModelService;
    @Resource
    protected BiddingContentOtherService biddingContentOtherService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected BiddingTeamService biddingTeamService;
    @Resource
    protected BiddingMatterStepService biddingMatterStepService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected MaterialPriceService materialPriceService;

    @CacheEvict(value={"biddingContent"}, allEntries=true)
    public void addObj(BiddingContent t) {
        t.setCreateTime(new Date());
        this.biddingContentMapper.insertSelective(t);
    }

    @CacheEvict(value={"biddingContent"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingContentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingContent"}, allEntries=true)
    public void modifyObj(BiddingContent t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingContentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingContent"}, keyGenerator="redisKeyGenerator")
    public BiddingContent queryObjById(String id) {
        return this.biddingContentMapper.selectByPrimaryKey(id);
    }

    public List<BiddingContent> queryAllObjByExample(BiddingContentExample example) {
        return this.biddingContentMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingContent"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingContent> queryObjByPage(BiddingContentExample example) {
        PageView<BiddingContent> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingContentMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingContentMatterExample matterExample = new BiddingContentMatterExample();
        matterExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentMatterList = this.biddingContentMatterService.queryAllObjByExample((IExample)matterExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingContentMatterList) && i < biddingContentMatterList.size(); ++i) {
            this.biddingContentMatterService.deleteObjById(((BiddingContentMatter)biddingContentMatterList.get(i)).getId());
            this.biddingMatterStepService.deleteObjByMatterId(((BiddingContentMatter)biddingContentMatterList.get(i)).getId());
        }
        BiddingContentModelExample modelExample = new BiddingContentModelExample();
        modelExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentModelList = this.biddingContentModelService.queryAllObjByExample((IExample)modelExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingContentModelList) && i < biddingContentModelList.size(); ++i) {
            this.biddingContentModelService.deleteObjById(((BiddingContentModel)biddingContentModelList.get(i)).getId());
        }
        BiddingContentOtherExample otherExample = new BiddingContentOtherExample();
        otherExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List biddingContentOtherList = this.biddingContentOtherService.queryAllObjByExample((IExample)otherExample);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingContentOtherList) && i < biddingContentOtherList.size(); ++i) {
            this.biddingContentOtherService.deleteObjById(((BiddingContentOther)biddingContentOtherList.get(i)).getId());
        }
        BiddingContentExample contentExample = new BiddingContentExample();
        contentExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContent> biddingContentList = this.biddingContentMapper.selectByExample(contentExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContentList) && i < biddingContentList.size(); ++i) {
            this.biddingContentMapper.deleteByPrimaryKey(biddingContentList.get(i).getId());
        }
    }

    @Override
    @Transactional
    public void biddingBeforeApproval(List<String> bidingNoList) {
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoIn((List)bidingNoList);
        List biddingHeaderList = this.biddingHeaderService.queryAllObjByExample((IExample)biddingHeaderExample);
        this.checkBiddingResult(biddingHeaderList);
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingHeaderList) && i < biddingHeaderList.size(); ++i) {
            ProcessStartVO vo = ProcessStartVO.newInstance((String)"ztbdbsp", (String)((BiddingHeader)biddingHeaderList.get(i)).getBiddingNo(), (String)((BiddingHeader)biddingHeaderList.get(i)).getId(), (String)("/targetBiddingresult?biddingNo=" + ((BiddingHeader)biddingHeaderList.get(i)).getBiddingNo() + "&state=evaluationresults&biddingRoundsNumber=" + ((BiddingHeader)biddingHeaderList.get(i)).getBiddingCurrentRound()));
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(((BiddingHeader)biddingHeaderList.get(i)).getId());
            biddingHeader.setBiddingAuditstatus("1");
            biddingHeader.setApproveFlowId2(startProcess.getProcessInstanceId());
            this.biddingHeaderService.modifyObj(biddingHeader);
        }
    }

    @Transactional
    public void listen(TaskOperateEvent event) {
        Assert.isNotBlank((String)event.getBusinessId(), (String)"\u5ba1\u6279\u5355\u636eID\u4e3a\u7a7a");
        BiddingHeader biddingHeader = new BiddingHeader();
        biddingHeader.setId(event.getBusinessId());
        BiddingHeader queryObjById = (BiddingHeader)this.biddingHeaderService.queryObjById(event.getBusinessId());
        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria().andBiddingHeaderIdEqualTo(event.getBusinessId());
        List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
        if (event.isFinished() && event.isPass()) {
            biddingHeader.setBiddingAuditstatus("2");
            biddingHeader.setBiddingStatus(TenderStatusEumn.ISSCALING.getValue());
            Company company = CompanyUtils.currentCompany();
            User user = SpringSecurityUtils.getLoginUser();
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
                if (TenderStatusEumn.BIDOVER.getValue().equals(((BiddingSupplier)biddingSupplierList.get(i)).getSupBiddingStatus())) {
                    BiddingSupplier biddingSupplier = new BiddingSupplier();
                    biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
                    biddingSupplier.setSupBiddingStatus(TenderStatusEumn.ISSCALING.getValue());
                    this.biddingSupplierService.modifyObj(biddingSupplier);
                }
                BiddingOfferExample example = new BiddingOfferExample();
                BiddingOfferExample.Criteria criteria = example.createCriteria();
                criteria.andBiddingNoEqualTo(queryObjById.getBiddingNo());
                criteria.andSupCompanyIdEqualTo(((BiddingSupplier)biddingSupplierList.get(i)).getSupCompanyId());
                criteria.andBiddingRoundsNumberEqualTo(queryObjById.getBiddingCurrentRound());
                List biddingOfferList = this.biddingOfferService.queryAllObjByExample((IExample)example);
                ArrayList<String> strList = new ArrayList<String>();
                for (BiddingOffer biddingOffer : biddingOfferList) {
                    strList.add(biddingOffer.getIsBidding() == null ? "0" : biddingOffer.getIsBidding());
                }
                String str = "";
                str = Collections.frequency(strList, "1") == strList.size() ? "\u5168\u90e8\u4e2d\u6807" : (Collections.frequency(strList, "1") < strList.size() && Collections.frequency(strList, "1") > 0 ? "\u90e8\u5206\u4e2d\u6807" : "\u672a\u4e2d\u6807");
                HashMap<String, String> msg = new HashMap<String, String>();
                msg.put("biddingNo", ((BiddingSupplier)biddingSupplierList.get(i)).getBiddingNo());
                msg.put("isBid", str);
                if (!StringUtils.isNotBlank((String)((BiddingSupplier)biddingSupplierList.get(i)).getSupCompanyId())) continue;
                List idList = this.companyUserRefService.queryUserOfCompany(((BiddingSupplier)biddingSupplierList.get(i)).getSupCompanyId());
                for (String userid : idList) {
                    if (!StringUtils.isNotBlank((String)userid)) continue;
                    Message message = Message.init(msg).setCompanyCode(company.getCompanyCode()).setSenderId(user.getId()).addReceiverId(userid).setBusinessTypeCode("BIDDING_SEND_BID_INFORMATION").setMsgLevel(MessageLevelEnum.HIGH);
                    MessageSendUtils.sendMessage((Message)message);
                }
            }
            this.addToMaterialPrice(queryObjById);
        } else if (event.isFinished() && !event.isPass()) {
            biddingHeader.setBiddingAuditstatus("3");
            biddingHeader.setBiddingStatus(TenderStatusEumn.INBID.getValue());
            biddingHeader.setBidSubmitDate(null);
            BiddingTeamExample teamExample = new BiddingTeamExample();
            teamExample.createCriteria().andBiddingNoEqualTo(queryObjById.getBiddingNo()).andIsEnabledEqualTo(Constant.YES_INT).andBidGroupEqualTo(BiddingGroupTypeEnum.BUSINESS_GROUP.getValue());
            BiddingTeam team = new BiddingTeam();
            team.setConfirmStatus(Constant.NO_INT);
            this.biddingTeamService.modifyByExample(teamExample, team);
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
                if (!TenderStatusEumn.BIDOVER.getValue().equals(((BiddingSupplier)biddingSupplierList.get(i)).getSupBiddingStatus())) continue;
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
                biddingSupplier.setSupBiddingStatus(TenderStatusEumn.INBID.getValue());
                this.biddingSupplierService.modifyObj(biddingSupplier);
            }
            BiddingOfferExample offerExample = new BiddingOfferExample();
            offerExample.createCriteria().andBiddingNoEqualTo(queryObjById.getBiddingNo()).andBiddingRoundsNumberEqualTo(queryObjById.getBiddingCurrentRound());
            List biddingOfferList = this.biddingOfferService.queryAllObjByExample((IExample)offerExample);
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingOfferList) && i < biddingOfferList.size(); ++i) {
                BiddingOffer biddingOffer = new BiddingOffer();
                biddingOffer.setId(((BiddingOffer)biddingOfferList.get(i)).getId());
                biddingOffer.setIsBidding("0");
                biddingOffer.setBidShare("0");
                biddingOffer.setIsSubmitBid("0");
                this.biddingOfferService.modifyObj(biddingOffer);
            }
        } else {
            biddingHeader.setBiddingPreAuditstatus("1");
        }
        this.biddingHeaderService.customModifyObj(biddingHeader);
    }

    private void addToMaterialPrice(BiddingHeader biddingHeader) {
        BiddingOfferExample offExample = new BiddingOfferExample();
        offExample.createCriteria().andBiddingNoEqualTo(biddingHeader.getBiddingNo()).andBiddingRoundsNumberEqualTo(biddingHeader.getBiddingCurrentRound()).andIsBiddingEqualTo("1");
        List offerList = this.biddingOfferService.queryAllObjByExample((IExample)offExample);
        for (BiddingOffer offer : offerList) {
            MaterialPrice price;
            MaterialPriceExample priceExample = new MaterialPriceExample();
            MaterialPriceExample.Criteria cri = priceExample.createCriteria();
            cri.andInstitutionsIdEqualTo(biddingHeader.getInstitutionsId());
            cri.andSupCompanyCodeEqualTo(offer.getSupCompanySrmCode());
            if ("material".equals(offer.getRequirementTypeCode())) {
                if (StringUtils.isNotBlank((String)offer.getProjectNo())) {
                    cri.andMaterialCodeEqualTo(offer.getProjectNo());
                } else {
                    cri.andDescriptionEqualTo(offer.getProjectDesc());
                }
            } else if ("device".equals(offer.getRequirementTypeCode())) {
                cri.andDescriptionEqualTo(offer.getTaregtDesc());
            }
            List priceList = this.materialPriceService.queryAllObjByExample((IExample)priceExample);
            if (CollectionUtils.isEmpty((Collection)priceList)) {
                price = new MaterialPrice();
                price.setMaterialPriceOrigin("1");
                price.setBiddingNo(biddingHeader.getBiddingNo());
                if ("material".equals(offer.getRequirementTypeCode())) {
                    price.setMaterialCode(offer.getProjectNo());
                    price.setDescription(offer.getProjectDesc());
                } else if ("device".equals(offer.getRequirementTypeCode())) {
                    price.setMaterialCode(offer.getTargetNo());
                    price.setDescription(offer.getTaregtDesc());
                }
                price.setPrice(new BigDecimal(offer.getOfferUnitPrice()));
                price.setBasicUnit(offer.getUnit());
                price.setSupCompanyCode(offer.getSupCompanySrmCode());
                price.setSupCompanyName(offer.getSupCompanyName());
                price.setDepartId(biddingHeader.getDepartId());
                price.setDepartName(biddingHeader.getDepartName());
                price.setInstitutionsId(biddingHeader.getInstitutionsId());
                price.setInstitutionsName(biddingHeader.getInstitutionsName());
                price.setInTheOrganizationId(biddingHeader.getInTheOrganizationId());
                price.setInTheOrganizationName(biddingHeader.getInTheOrganizationName());
                price.setCreateTime(new Date());
                price.setCreateUserId(biddingHeader.getPurUserId());
                price.setCreateUserName(biddingHeader.getPurUserName());
                String code = this.generateCodeService.getNextCode("MATERIAL_PRICE");
                price.setMaterialPriceNo(code);
                this.materialPriceService.addObj((Serializable)price);
                continue;
            }
            price = new MaterialPrice();
            price.setId(((MaterialPrice)priceList.get(0)).getId());
            price.setPrice(new BigDecimal(offer.getOfferUnitPrice()));
            price.setUpdateTime(new Date());
            price.setUpdateUserId(biddingHeader.getPurUserId());
            price.setUpdateUserName(biddingHeader.getPurUserName());
            this.materialPriceService.modifyObj((Serializable)price);
        }
    }

    public void deleteByExample(BiddingContentExample example) {
    }

    public void addAll(List<BiddingContent> list) {
    }

    private void checkBiddingResult(List<BiddingHeader> biddingHeaderList) {
        for (BiddingHeader head : biddingHeaderList) {
            if (!ApprovalStatusEnum.REJECT_APPROVAL.getValue().equals(head.getBiddingAuditstatus())) continue;
            BiddingTeamExample teamExample = new BiddingTeamExample();
            teamExample.createCriteria().andBiddingNoEqualTo(head.getBiddingNo()).andBidGroupEqualTo(BiddingGroupTypeEnum.BUSINESS_GROUP.getValue()).andConfirmStatusEqualTo(Constant.NO_INT);
            List teamList = this.biddingTeamService.queryAllObjByExample((IExample)teamExample);
            if (!CollectionUtils.isNotEmpty((Collection)teamList)) continue;
            throw new CommonException("\u62db\u6807\u7f16\u53f7\u4e3a\uff1a" + head.getBiddingNo() + "\u7684\u62db\u6807\uff0c\u8bc4\u6807\u5c0f\u7ec4\u4e2d\u7684\u5546\u52a1\u7ec4\u672a\u5168\u90e8\u786e\u8ba4\u8bc4\u6807\u7ed3\u679c\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279");
        }
    }
}

