/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingOfferMapper;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingContentMatterExample;
import com.els.base.bidding.entity.BiddingContentModel;
import com.els.base.bidding.entity.BiddingContentModelExample;
import com.els.base.bidding.entity.BiddingContentOther;
import com.els.base.bidding.entity.BiddingContentOtherExample;
import com.els.base.bidding.entity.BiddingFileSupplierExample;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingMatterStepSup;
import com.els.base.bidding.entity.BiddingMatterStepSupExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingScore;
import com.els.base.bidding.entity.BiddingScoreExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.BiddingTeam;
import com.els.base.bidding.entity.BiddingTeamExample;
import com.els.base.bidding.entity.BiddingTradeCondition;
import com.els.base.bidding.entity.BiddingTradeConditionExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.BiddingScoreAndPrice;
import com.els.base.bidding.entity.vo.ReportShow;
import com.els.base.bidding.entity.vo.SaveBidInfoVo;
import com.els.base.bidding.entity.vo.TemporaryCodeReducedRate;
import com.els.base.bidding.enums.ApprovalStatusEnum;
import com.els.base.bidding.enums.BiddingGroupTypeEnum;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingContentMatterService;
import com.els.base.bidding.service.BiddingContentModelService;
import com.els.base.bidding.service.BiddingContentOtherService;
import com.els.base.bidding.service.BiddingContentService;
import com.els.base.bidding.service.BiddingFileSupplierService;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterStepSupService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.bidding.service.BiddingScoreService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.bidding.service.BiddingTeamService;
import com.els.base.bidding.service.BiddingTradeConditionService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingOfferService")
public class BiddingOfferServiceImpl
implements BiddingOfferService {
    @Resource
    protected BiddingOfferMapper biddingOfferMapper;
    @Resource
    protected BiddingContentMatterService biddingContentMatterService;
    @Resource
    protected BiddingContentModelService biddingContentModelService;
    @Resource
    protected BiddingContentOtherService biddingContentOtherService;
    @Resource
    protected BiddingMatterStepSupService biddingMatterStepSupService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected BiddingContentService biddingContentService;
    @Resource
    protected BiddingHeaderService biddingHeaderService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    @Resource
    protected BiddingTradeConditionService biddingTradeConditionService;
    @Resource
    protected BiddingScoreService biddingScoreService;
    @Resource
    protected BiddingTeamService biddingTeamService;
    @Resource
    protected BiddingFileSupplierService biddingFileSupplierService;

    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    public void addObj(BiddingOffer t) {
        this.biddingOfferMapper.insertSelective(t);
    }

    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingOfferMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    public void modifyObj(BiddingOffer t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.biddingOfferMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingOffer"}, keyGenerator="redisKeyGenerator")
    public BiddingOffer queryObjById(String id) {
        return this.biddingOfferMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"biddingOffer"}, keyGenerator="redisKeyGenerator")
    public List<BiddingOffer> queryAllObjByExample(BiddingOfferExample example) {
        return this.biddingOfferMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingOffer"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingOffer> queryObjByPage(BiddingOfferExample example) {
        PageView<BiddingOffer> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingOfferMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"biddingOffer"}, allEntries=true)
    @Transactional
    public void saveUnitPrice(BiddingBaseVo biddingBaseVo) throws InstantiationException, IllegalAccessException {
        Company supCompany = biddingBaseVo.getCompany();
        User supUser = biddingBaseVo.getUser();
        BiddingHeader biddingHeader = biddingBaseVo.getBiddingHeader();
        String biddingNo = biddingHeader.getBiddingNo();
        Assert.isNotBlank((String)biddingNo, (String)"biddingHeader\u5bf9\u8c61\u4e2d\u62db\u6807\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String handleType = biddingBaseVo.getHandleType();
        BiddingContent biddingContent = biddingBaseVo.getBiddingContent();
        if (biddingContent != null) {
            this.updateBiddingOfferPrice(biddingContent, supCompany, supUser, handleType);
            if ("send".equals(handleType)) {
                BiddingFileSupplierExample fileExample = new BiddingFileSupplierExample();
                fileExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(supCompany.getId());
                List fileList = this.biddingFileSupplierService.queryAllObjByExample((IExample)fileExample);
                Assert.isNotEmpty((Collection)fileList, (String)"\u5fc5\u987b\u4e0a\u4f20\u6280\u672f\u3001\u5546\u52a1\u4e24\u79cd\u7c7b\u578b\u7684\u6587\u4ef6\u624d\u80fd\u62a5\u4ef7");
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setLastUpdateTime(new Date());
                biddingSupplier.setLastUpdateUser(supUser.getNickName());
                biddingSupplier.setSupBidding("1");
                BiddingSupplierExample example = new BiddingSupplierExample();
                BiddingSupplierExample.Criteria biddingCriteria = example.createCriteria();
                biddingCriteria.andBiddingNoEqualTo(biddingBaseVo.getBiddingHeader().getBiddingNo());
                biddingCriteria.andSupCompanyIdEqualTo(supCompany.getId());
                this.biddingSupplierService.modifyObjSup(biddingSupplier, example);
            }
        }
    }

    private boolean isUpdateOfferPrice(BiddingOffer biddingOffer) {
        biddingOffer.getEffectiveNumber();
        biddingOffer.getRestEffectiveNumber();
        return Integer.valueOf(biddingOffer.getRestEffectiveNumber() == null ? "0" : biddingOffer.getRestEffectiveNumber()) > 0;
    }

    private void updatebiddingOfferRestEffectiveNumber(BiddingOffer BiddingOffer2, String requirementTypeCode, Company supCompany) {
        BiddingOfferExample example = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = example.createCriteria();
        criteria.andBiddingNoEqualTo(BiddingOffer2.getBiddingNo());
        criteria.andSupCompanyIdEqualTo(supCompany.getId());
        criteria.andBiddingRoundsNumberEqualTo(BiddingOffer2.getBiddingRoundsNumber());
        criteria.andRequirementTypeCodeEqualTo(requirementTypeCode);
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferMapper.selectByExample(example);
        for (BiddingOffer biddingOffer : biddingOfferMatterList) {
            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOffer.getId());
            offer.setRestEffectiveNumber(String.valueOf(Integer.valueOf(biddingOffer.getRestEffectiveNumber()) - 1));
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);
        }
    }

    private void updateBiddingOfferPrice(BiddingContent biddingContent, Company supCompany, User supUser, String handleType) throws InstantiationException, IllegalAccessException {
        if (biddingContent != null) {
            Boolean isInstrumentStatus;
            boolean flag;
            BiddingOffer biddingOffer;
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferMatterList())) {
                List<BiddingOffer> biddingOfferMatterList = biddingContent.getBiddingOfferMatterList();
                biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferMatterList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferMatterList.get(0).getRestEffectiveNumber());
                flag = this.isUpdateOfferPrice(biddingOffer);
                isInstrumentStatus = biddingOfferMatterList.stream().allMatch(b -> "0".equals(b.getInstrumentStatus()));
                if (!isInstrumentStatus.booleanValue()) {
                    flag = true;
                }
                if (flag) {
                    this.updateBiddingOfferMatter(biddingOfferMatterList, supCompany, supUser, handleType);
                    if ("send".equals(handleType) && isInstrumentStatus.booleanValue()) {
                        this.updatebiddingOfferRestEffectiveNumber(biddingOfferMatterList.get(0), "material", supCompany);
                    }
                } else {
                    throw new CommonException("\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4fdd\u5b58\u5931\u8d25", "finish_status", new Object[]{"\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7\uff01"});
                }
            }
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferModelList())) {
                List<BiddingOffer> biddingOfferModelList = biddingContent.getBiddingOfferModelList();
                biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferModelList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferModelList.get(0).getRestEffectiveNumber());
                flag = this.isUpdateOfferPrice(biddingOffer);
                isInstrumentStatus = biddingOfferModelList.stream().allMatch(b -> "0".equals(b.getInstrumentStatus()));
                if (!isInstrumentStatus.booleanValue()) {
                    flag = true;
                }
                if (flag) {
                    this.updateBiddingOffer(biddingOfferModelList, supCompany, supUser, "die", handleType);
                    if ("send".equals(handleType) && isInstrumentStatus.booleanValue()) {
                        this.updatebiddingOfferRestEffectiveNumber(biddingOfferModelList.get(0), "die", supCompany);
                    }
                } else {
                    throw new CommonException("\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4fdd\u5b58\u5931\u8d25", "finish_status", new Object[]{"\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7\uff01"});
                }
            }
            if (CollectionUtils.isNotEmpty(biddingContent.getBiddingOfferOtherList())) {
                List<BiddingOffer> biddingOfferOtherList = biddingContent.getBiddingOfferOtherList();
                biddingOffer = new BiddingOffer();
                biddingOffer.setEffectiveNumber(biddingOfferOtherList.get(0).getEffectiveNumber());
                biddingOffer.setRestEffectiveNumber(biddingOfferOtherList.get(0).getRestEffectiveNumber());
                flag = this.isUpdateOfferPrice(biddingOffer);
                isInstrumentStatus = biddingOfferOtherList.stream().allMatch(b -> "0".equals(b.getInstrumentStatus()));
                if (!isInstrumentStatus.booleanValue()) {
                    flag = true;
                }
                if (flag) {
                    this.updateBiddingOffer(biddingOfferOtherList, supCompany, supUser, "device", handleType);
                    if ("send".equals(handleType) && isInstrumentStatus.booleanValue()) {
                        this.updatebiddingOfferRestEffectiveNumber(biddingOfferOtherList.get(0), "device", supCompany);
                    }
                } else {
                    throw new CommonException("\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4fdd\u5b58\u5931\u8d25", "finish_status", new Object[]{"\u5269\u4f59\u6709\u6548\u62a5\u4ef7\u6b21\u6570\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u4ef7\uff01"});
                }
            }
        }
    }

    private void updateBiddingOfferMatter(List<BiddingOffer> BiddingOfferList, Company supCompany, User supUser, String handleType) throws InstantiationException, IllegalAccessException {
        for (BiddingOffer biddingOfferMatter : BiddingOfferList) {
            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOfferMatter.getId());
            offer.setPromiseReducedRate(biddingOfferMatter.getPromiseReducedRate());
            if ("save".equals(handleType)) {
                offer.setTempOfferUnitPrice(biddingOfferMatter.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOfferMatter.getTempOfferSetPrice());
            } else if ("send".equals(handleType)) {
                offer.setTempOfferUnitPrice(biddingOfferMatter.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOfferMatter.getTempOfferSetPrice());
                offer.setOfferUnitPrice(biddingOfferMatter.getOfferUnitPrice());
                offer.setOfferSetPrice(biddingOfferMatter.getOfferSetPrice());
                BiddingOffer biddingOffer = this.biddingOfferMapper.selectByPrimaryKey(biddingOfferMatter.getId());
                if ("1".equals(biddingOffer.getInstrumentStatus())) {
                    offer.setInstrumentStatus("0");
                }
            }
            offer.setFactBarnd(biddingOfferMatter.getFactBarnd());
            offer.setFactSpec(biddingOfferMatter.getFactSpec());
            offer.setFactModel(biddingOfferMatter.getFactModel());
            offer.setLastUpdateUser(supUser.getNickName());
            offer.setLastUpdateTime(new Date());
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);
            List<BiddingMatterStepSup> biddingMatterStepSupList = biddingOfferMatter.getBiddingMatterStepSupList();
            if (CollectionUtils.isNotEmpty(biddingMatterStepSupList)) {
                for (BiddingMatterStepSup biddingMatterStepSup : biddingMatterStepSupList) {
                    BiddingMatterStepSup mstepsup = new BiddingMatterStepSup();
                    mstepsup.setId(biddingMatterStepSup.getId());
                    mstepsup.setOfferUnitPrice(biddingMatterStepSup.getOfferUnitPrice());
                    mstepsup.setOfferSetPrice(biddingMatterStepSup.getOfferSetPrice());
                    mstepsup.setLastUpdateUser(supUser.getNickName());
                    mstepsup.setLastUpdateTime(new Date());
                    this.biddingMatterStepSupService.modifyObj(mstepsup);
                }
            }
            if ("send".equals(handleType)) {
                this.updateCurrentRanking(biddingOfferMatter, "material");
            }
            if (StringUtils.isNotBlank((String)biddingOfferMatter.getCostAnalysisId())) {
                this.updateMaterialAcostAnalysis(biddingOfferMatter);
            }
            List<BiddingTradeCondition> biddingTradeConditionList = biddingOfferMatter.getBiddingTradeConditionList();
            BiddingTradeConditionExample tradeConditionExample = new BiddingTradeConditionExample();
            tradeConditionExample.createCriteria().andSupItemIdEqualTo(biddingOfferMatter.getId());
            this.biddingTradeConditionService.deleteByExample((IExample)tradeConditionExample);
            if (!CollectionUtils.isNotEmpty(biddingTradeConditionList)) continue;
            for (BiddingTradeCondition biddingTradeCondition : biddingTradeConditionList) {
                BiddingTradeCondition biddingTrade = new BiddingTradeCondition();
                biddingTrade.setId(null);
                biddingTrade.setSupItemId(biddingOfferMatter.getId());
                biddingTrade.setPurItemId(biddingOfferMatter.getMatterId());
                biddingTrade.setConditionDesc(biddingTradeCondition.getConditionDesc());
                biddingTrade.setBiddingNo(biddingOfferMatter.getBiddingNo());
                biddingTrade.setUntaxedUnitPrice(biddingTradeCondition.getUntaxedUnitPrice());
                biddingTrade.setTempMaterialNo(biddingOfferMatter.getTempMaterialNo());
                biddingTrade.setCreateTime(new Date());
                this.biddingTradeConditionService.addObj(biddingTrade);
            }
        }
    }

    private void updateMaterialAcostAnalysis(BiddingOffer biddingOfferMatter) throws InstantiationException, IllegalAccessException {
        TplOrderItemDetail tpl = (TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById((Object)biddingOfferMatter.getCostAnalysisId());
        IOrderItemDetailService service = tpl.getOrderItemDetailService();
        ArrayList<String> orderItemIdList = new ArrayList<String>();
        orderItemIdList.add(biddingOfferMatter.getId());
        service.deleteByOrderItemIds(orderItemIdList);
        ArrayList<IOrderItemDetail> detailList = new ArrayList<IOrderItemDetail>();
        IOrderItemDetail detail = biddingOfferMatter.getOrderItemDetail();
        detail.setOrderItemId(biddingOfferMatter.getId());
        detail.setTemplateId(biddingOfferMatter.getCostAnalysisId());
        detail.setMaterialCode(biddingOfferMatter.getProjectNo() == null ? "" : biddingOfferMatter.getProjectNo());
        detail.setMaterialDesc(biddingOfferMatter.getProjectDesc() == null ? "" : biddingOfferMatter.getProjectDesc());
        detailList.add(detail);
        service.addAll(detailList);
    }

    private void updateCurrentRanking(BiddingOffer BiddingOffer2, String requirementTypeCode) {
        BiddingOfferExample matterExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria matterCriteria = matterExample.createCriteria();
        matterCriteria.andBiddingNoEqualTo(BiddingOffer2.getBiddingNo());
        switch (requirementTypeCode) {
            case "material": {
                matterCriteria.andMatterIdEqualTo(BiddingOffer2.getMatterId());
                break;
            }
            case "die": {
                matterCriteria.andModelIdEqualTo(BiddingOffer2.getModelId());
                break;
            }
            case "device": {
                matterCriteria.andOtherIdEqualTo(BiddingOffer2.getOtherId());
            }
        }
        matterCriteria.andBiddingRoundsNumberEqualTo(BiddingOffer2.getBiddingRoundsNumber());
        matterCriteria.andRequirementTypeCodeEqualTo(requirementTypeCode);
        matterCriteria.andOfferUnitPriceGreaterThan("0");
        List<BiddingOffer> biddingOfferMatterList = this.biddingOfferMapper.selectByExample(matterExample);
        Collections.sort(biddingOfferMatterList, new Comparator<BiddingOffer>(){

            @Override
            public int compare(BiddingOffer o1, BiddingOffer o2) {
                return new BigDecimal(o2.getOfferUnitPrice() == null ? "0" : o2.getOfferUnitPrice()).compareTo(new BigDecimal(o1.getOfferUnitPrice() == null ? "0" : o1.getOfferUnitPrice()));
            }
        });
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferMatterList) && j < biddingOfferMatterList.size(); ++j) {
            System.err.println("\u6392\u5e8f\u540e==\u6807\u5355\u53f7\uff1a" + biddingOfferMatterList.get(j).getBiddingNo() + "\u62a5\u4ef7\uff1a" + biddingOfferMatterList.get(j).getOfferUnitPrice() + "\u6392\u540d\uff1a" + (biddingOfferMatterList.size() - j));
            BiddingOffer offerSort = new BiddingOffer();
            offerSort.setId(biddingOfferMatterList.get(j).getId());
            offerSort.setCurrentRanking(String.valueOf(biddingOfferMatterList.size() - j));
            this.biddingOfferMapper.updateByPrimaryKeySelective(offerSort);
        }
    }

    private void updateBiddingOffer(List<BiddingOffer> BiddingOfferList, Company supCompany, User supUser, String requirementTypeCode, String handleType) {
        for (BiddingOffer biddingOffer : BiddingOfferList) {
            BiddingOffer offer = new BiddingOffer();
            offer.setId(biddingOffer.getId());
            if ("save".equals(handleType)) {
                offer.setTempOfferUnitPrice(biddingOffer.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOffer.getTempOfferSetPrice());
            } else if ("send".equals(handleType)) {
                offer.setOfferUnitPrice(biddingOffer.getOfferUnitPrice());
                offer.setOfferSetPrice(biddingOffer.getOfferSetPrice());
                offer.setTempOfferUnitPrice(biddingOffer.getTempOfferUnitPrice());
                offer.setTempOfferSetPrice(biddingOffer.getTempOfferSetPrice());
                BiddingOffer biddingOffers = this.biddingOfferMapper.selectByPrimaryKey(biddingOffer.getId());
                if ("1".equals(biddingOffer.getInstrumentStatus())) {
                    offer.setInstrumentStatus("0");
                }
            }
            offer.setLastUpdateUser(supUser.getNickName());
            offer.setLastUpdateTime(new Date());
            this.biddingOfferMapper.updateByPrimaryKeySelective(offer);
            if (!"send".equals(handleType)) continue;
            this.updateCurrentRanking(biddingOffer, requirementTypeCode);
        }
    }

    @Override
    public List<BiddingOffer> findBidInfo(String biddingNo, String type, String isBidding, String currentRound, User loginUser) {
        BiddingSupplierExample supplierExample = new BiddingSupplierExample();
        supplierExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupBiddingEqualTo(String.valueOf(Constant.YES_INT));
        List bidSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.setOrderByClause(" SUP_COMPANY_SRM_CODE DESC,PROJECT_DESC DESC,MATERIAL_DEVEL ASC ");
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound);
        if (StringUtils.isNotBlank((String)isBidding)) {
            criteria.andIsBiddingEqualTo(isBidding);
        }
        List<BiddingOffer> offerList = this.biddingOfferMapper.selectByExample(offerExample);
        if (CollectionUtils.isEmpty((Collection)bidSupplierList)) {
            return new ArrayList<BiddingOffer>();
        }
        ArrayList<BiddingOffer> biddingOfferList = new ArrayList<BiddingOffer>(offerList.size());
        for (BiddingSupplier sup : bidSupplierList) {
            for (BiddingOffer bidOff : offerList) {
                if (!sup.getSupCompanySrmCode().equals(bidOff.getSupCompanySrmCode())) continue;
                biddingOfferList.add(bidOff);
            }
        }
        List<String> stringsCodeList = this.getStringsCode(biddingNo, type);
        for (int i = 0; CollectionUtils.isNotEmpty(stringsCodeList) && i < stringsCodeList.size(); ++i) {
            for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
                BiddingOffer biddingOffer = (BiddingOffer)biddingOfferList.get(j);
                if (!type.equals("material")) continue;
                BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
                example.createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId()).andBiddingRoundsNumberEqualTo(currentRound);
                example.setOrderByClause(" QUANTITY_START ASC");
                List biddingMatterStepSups = this.biddingMatterStepSupService.queryAllObjByExample((IExample)example);
                biddingOffer.setBiddingMatterStepSupList(biddingMatterStepSups);
                BigDecimal offerUnitPrice = biddingOffer.getOfferUnitPrice() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getOfferUnitPrice());
                BigDecimal biddingQuantity = biddingOffer.getBiddingQuantity() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getBiddingQuantity());
                biddingOffer.setSupplierQuotedPrice(offerUnitPrice.multiply(biddingQuantity));
            }
        }
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List headerList = this.biddingHeaderService.queryAllObjByExample((IExample)biddingHeaderExample);
        BiddingScoreExample scoreExample = new BiddingScoreExample();
        scoreExample.createCriteria().andBiddingNoEqualTo(biddingNo).andBiddingRoundsNumberEqualTo(currentRound);
        List scoreList = this.biddingScoreService.queryAllObjByExample((IExample)scoreExample);
        List srmCodeList = biddingOfferList.stream().map(BiddingOffer::getSupCompanySrmCode).distinct().collect(Collectors.toList());
        ArrayList<BiddingScoreAndPrice> scoreAndPriceList = new ArrayList<BiddingScoreAndPrice>();
        if (CollectionUtils.isNotEmpty(srmCodeList) && CollectionUtils.isNotEmpty((Collection)scoreList)) {
            for (String srmCode : srmCodeList) {
                String techTemplateName = "";
                String bussTemplateName = "";
                BigDecimal techAllScore = BigDecimal.ZERO;
                BigDecimal bussAllScore = BigDecimal.ZERO;
                HashSet<String> techUserId = new HashSet<String>();
                HashSet<String> bussUserId = new HashSet<String>();
                for (BiddingScore score : scoreList) {
                    BigDecimal getScale;
                    if (!srmCode.equals(score.getSupCompanyCode())) continue;
                    if (BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue().equals(score.getTemplateType())) {
                        techTemplateName = score.getTemplateName();
                        if (null != score.getScore()) {
                            getScale = score.getScore().multiply(score.getWeightCoefficient()).divide(new BigDecimal(100)).setScale(2, 4);
                            techAllScore = techAllScore.add(getScale);
                        }
                        if (!Constant.YES_INT.equals(score.getBidStatus())) continue;
                        techUserId.add(score.getRatersId());
                        continue;
                    }
                    if (!BiddingGroupTypeEnum.BUSINESS_GROUP.getValue().equals(score.getTemplateType())) continue;
                    bussTemplateName = score.getTemplateName();
                    if (null != score.getScore()) {
                        getScale = score.getScore().multiply(score.getWeightCoefficient()).divide(new BigDecimal(100)).setScale(2, 4);
                        bussAllScore = bussAllScore.add(getScale);
                    }
                    if (!Constant.YES_INT.equals(score.getBidStatus())) continue;
                    bussUserId.add(score.getRatersId());
                }
                BigDecimal techAugScore = BigDecimal.ZERO;
                BigDecimal bussAugScore = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(techUserId)) {
                    techAugScore = techAllScore.divide(new BigDecimal(techUserId.size()), 2, 4);
                }
                if (CollectionUtils.isNotEmpty(bussUserId)) {
                    bussAugScore = bussAllScore.divide(new BigDecimal(bussUserId.size()), 2, 4);
                }
                BiddingScoreAndPrice scoreAndPrice = new BiddingScoreAndPrice();
                scoreAndPrice.setSupCompanyCode(srmCode);
                BigDecimal technicalWeight = ((BiddingHeader)headerList.get(0)).getTechnicalWeight();
                BigDecimal busniessWeight = ((BiddingHeader)headerList.get(0)).getBusniessWeight();
                if (technicalWeight != null && busniessWeight != null) {
                    BigDecimal techScore = techAugScore.multiply(technicalWeight).divide(new BigDecimal(100));
                    BigDecimal busScore = bussAugScore.multiply(busniessWeight).divide(new BigDecimal(100));
                    scoreAndPrice.setAllScore(techScore.add(busScore).setScale(2, 4));
                }
                BigDecimal techCurrentDidScore = BigDecimal.ZERO;
                BigDecimal businessCurrentDidScore = BigDecimal.ZERO;
                for (BiddingScore bs : scoreList) {
                    if (!srmCode.equals(bs.getSupCompanyCode()) || !loginUser.getId().equals(bs.getRatersId())) continue;
                    if (BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue().equals(bs.getTemplateType())) {
                        techCurrentDidScore = bs.getFinalScore();
                        continue;
                    }
                    if (!BiddingGroupTypeEnum.BUSINESS_GROUP.getValue().equals(bs.getTemplateType())) continue;
                    businessCurrentDidScore = bs.getBusinessFinalScore();
                }
                BigDecimal allPrice = BigDecimal.ZERO;
                for (BiddingOffer off : biddingOfferList) {
                    if (!srmCode.equals(off.getSupCompanySrmCode())) continue;
                    if (type.equals("material")) {
                        allPrice = allPrice.add(off.getSupplierQuotedPrice());
                    } else if (type.equals("device")) {
                        allPrice = allPrice.add(off.getOfferUnitPrice() == null ? BigDecimal.ZERO : new BigDecimal(off.getOfferUnitPrice()));
                    }
                    off.setScore(techAugScore);
                    off.setTemplateName(techTemplateName);
                    off.setBusinessScore(bussAugScore);
                    off.setBusinessTemplateName(bussTemplateName);
                    off.setTechCurrentDidScore(techCurrentDidScore);
                    off.setBusinessCurrentDidScore(businessCurrentDidScore);
                }
                scoreAndPrice.setAllPrice(allPrice);
                scoreAndPriceList.add(scoreAndPrice);
            }
        }
        if (CollectionUtils.isNotEmpty(scoreAndPriceList)) {
            List collect = scoreAndPriceList.stream().sorted(Comparator.comparing(BiddingScoreAndPrice::getAllScore).reversed().thenComparing(BiddingScoreAndPrice::getAllPrice)).collect(Collectors.toList());
            for (int i = 0; i < collect.size(); ++i) {
                for (BiddingOffer offer : biddingOfferList) {
                    if (!((BiddingScoreAndPrice)collect.get(i)).getSupCompanyCode().equals(offer.getSupCompanySrmCode())) continue;
                    if (i == 0) {
                        offer.setIsGroomMaterial(String.valueOf(Constant.YES_INT));
                    } else {
                        offer.setIsGroomMaterial(String.valueOf(Constant.NO_INT));
                    }
                    offer.setRanking(i + 1);
                    offer.setCompositeScore(((BiddingScoreAndPrice)collect.get(i)).getAllScore());
                }
            }
        }
        return biddingOfferList;
    }

    @Override
    public List<BiddingOffer> findBidInfoSup(String biddingNo, String type, String isBidding, String currentRound, User user, Company company) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.setOrderByClause(" SUP_COMPANY_SRM_CODE DESC,PROJECT_DESC DESC,MATERIAL_DEVEL ASC ");
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId());
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
            BiddingOffer biddingOffer = biddingOfferList.get(j);
            if (type.equals("material")) {
                BiddingMatterStepSupExample example = new BiddingMatterStepSupExample();
                example.createCriteria().andBiddingOfferIdEqualTo(biddingOffer.getId()).andBiddingRoundsNumberEqualTo(currentRound).andSupCompanyIdEqualTo(company.getId());
                List biddingMatterStepSups = this.biddingMatterStepSupService.queryAllObjByExample((IExample)example);
                biddingOffer.setBiddingMatterStepSupList(biddingMatterStepSups);
                BigDecimal offerUnitPrice = biddingOffer.getOfferUnitPrice() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getOfferUnitPrice());
                BigDecimal quantity = biddingOffer.getQuantity() == null ? BigDecimal.ZERO : new BigDecimal(biddingOffer.getQuantity());
                biddingOffer.setOfferSetPrice(offerUnitPrice.multiply(quantity).toString());
            }
            BiddingHeaderExample headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
            List biddingHeaders = this.biddingHeaderService.queryAllObjByExample((IExample)headerExample);
            String biddingSendBidder = ((BiddingHeader)biddingHeaders.get(0)).getBiddingSendBidder();
            if ("0".equals(biddingSendBidder)) {
                biddingOffer.setUnitPrice(BigDecimal.valueOf(-1L));
                biddingOffer.setAmount(BigDecimal.valueOf(-1L));
                continue;
            }
            if (!"1".equals(biddingSendBidder) || !"0".equals(biddingOffer.getIsBidding())) continue;
            biddingOffer.setUnitPrice(BigDecimal.valueOf(-1L));
            biddingOffer.setAmount(BigDecimal.valueOf(-1L));
        }
        return biddingOfferList;
    }

    private List<String> getStringsCode(String biddingNo, String type) {
        ArrayList<String> stringsCode = new ArrayList<String>();
        switch (type) {
            case "material": {
                BiddingContentMatterExample contentMatterExample = new BiddingContentMatterExample();
                contentMatterExample.createCriteria().andBiddingNoEqualTo(biddingNo);
                List biddingContentMatters = this.biddingContentMatterService.queryAllObjByExample((IExample)contentMatterExample);
                for (int j = 0; CollectionUtils.isNotEmpty((Collection)biddingContentMatters) && j < biddingContentMatters.size(); ++j) {
                    stringsCode.add(((BiddingContentMatter)biddingContentMatters.get(j)).getId());
                }
                break;
            }
            case "die": {
                BiddingContentModelExample contentModelExample = new BiddingContentModelExample();
                contentModelExample.createCriteria().andBiddingNoEqualTo(biddingNo);
                List biddingContentModels = this.biddingContentModelService.queryAllObjByExample((IExample)contentModelExample);
                for (int j = 0; CollectionUtils.isNotEmpty((Collection)biddingContentModels) && j < biddingContentModels.size(); ++j) {
                    stringsCode.add(((BiddingContentModel)biddingContentModels.get(j)).getId());
                }
                break;
            }
            case "device": {
                BiddingContentOtherExample contentOtherExample = new BiddingContentOtherExample();
                contentOtherExample.createCriteria().andBiddingNoEqualTo(biddingNo);
                List biddingContentOthers = this.biddingContentOtherService.queryAllObjByExample((IExample)contentOtherExample);
                for (int j = 0; CollectionUtils.isNotEmpty((Collection)biddingContentOthers) && j < biddingContentOthers.size(); ++j) {
                    stringsCode.add(((BiddingContentOther)biddingContentOthers.get(j)).getId());
                }
                break;
            }
        }
        return stringsCode;
    }

    @Override
    public void save(SaveBidInfoVo saveBidInfoVo, String saveOrSubmit) {
        boolean boo;
        List<BiddingOffer> biddingOfferList = saveBidInfoVo.getBiddingOfferList();
        List<TemporaryCodeReducedRate> codeReducedRates = saveBidInfoVo.getCodeReducedRates();
        if (CollectionUtils.isEmpty(biddingOfferList)) {
            throw new CommonException("\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u53ef\u64cd\u4f5c", "isNull", new Object[]{"\u6570\u636e"});
        }
        for (int j = 0; j < biddingOfferList.size(); ++j) {
            BiddingOffer biddingOffer = biddingOfferList.get(j);
            if (biddingOfferList.get(0).getAllBidding().equals("0")) {
                if (CollectionUtils.isEmpty(codeReducedRates)) {
                    throw new CommonException("\u5168\u90e8\u6295\u6807\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e\u4e2d\u6807\u4f9b\u5e94\u5546", "most_set_bid_supplier");
                }
                biddingOffer.setBidShare("0");
                for (TemporaryCodeReducedRate temporaryCodeReducedRate : codeReducedRates) {
                    if (!temporaryCodeReducedRate.getTemporaryCode().equals(biddingOffer.getSupplierTemporaryCode())) continue;
                    biddingOffer.setBidShare(temporaryCodeReducedRate.getReducedRate());
                    biddingOffer.setIsBidding("1");
                }
            }
            if (StringUtils.isNotBlank((String)saveOrSubmit) && saveOrSubmit.equals("submit")) {
                biddingOffer.setIsSubmitBid("1");
            }
            this.biddingOfferMapper.updateByPrimaryKeySelective(biddingOffer);
        }
        BiddingContent biddingContent = saveBidInfoVo.getBiddingContent();
        if (biddingContent != null) {
            BiddingContent bidContent = new BiddingContent();
            bidContent.setId(biddingContent.getId());
            bidContent.setBidExplain(biddingContent.getBidExplain());
            this.biddingContentService.modifyObj(bidContent);
        }
        if (StringUtils.isNotBlank((String)saveOrSubmit) && saveOrSubmit.equals("submit") && (boo = this.isAllSetBidSupplier(biddingOfferList))) {
            BiddingHeaderExample headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo());
            List biddingHeaders = this.biddingHeaderService.queryAllObjByExample((IExample)headerExample);
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setId(((BiddingHeader)biddingHeaders.get(0)).getId());
            biddingHeader.setBiddingStatus(TenderStatusEumn.BIDOVER.getValue());
            biddingHeader.setBidSubmitDate(new Date());
            this.biddingHeaderService.modifyObj(biddingHeader);
            BiddingSupplierExample supplierExample = new BiddingSupplierExample();
            supplierExample.createCriteria().andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo());
            List biddingSupplierList = this.biddingSupplierService.queryAllObjByExample((IExample)supplierExample);
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)biddingSupplierList) && i < biddingSupplierList.size(); ++i) {
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setId(((BiddingSupplier)biddingSupplierList.get(i)).getId());
                biddingSupplier.setSupBiddingStatus(TenderStatusEumn.BIDOVER.getValue());
                this.biddingSupplierService.modifyObj(biddingSupplier);
            }
            if (ApprovalStatusEnum.REJECT_APPROVAL.getValue().equals(((BiddingHeader)biddingHeaders.get(0)).getBiddingAuditstatus())) {
                BiddingTeamExample teamExample = new BiddingTeamExample();
                teamExample.createCriteria().andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo()).andBiddingRoundsNumberEqualTo(biddingOfferList.get(0).getBiddingRoundsNumber()).andBidGroupEqualTo(BiddingGroupTypeEnum.BUSINESS_GROUP.getValue());
                List teamList = this.biddingTeamService.queryAllObjByExample((IExample)teamExample);
                if (CollectionUtils.isNotEmpty((Collection)teamList)) {
                    for (BiddingTeam t : teamList) {
                        this.sendMessage((BiddingHeader)biddingHeaders.get(0), t);
                    }
                }
            }
        }
    }

    private void sendMessage(BiddingHeader biddingHeader, BiddingTeam t) {
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("biddingNo", biddingHeader.getBiddingNo());
        if (StringUtils.isNotBlank((String)t.getBidUserId())) {
            Message message = Message.init(msg).setCompanyCode(t.getPurCompanySrmCode()).setBusinessTypeCode("BIDDING_PUR_SEND_INFORMATION_TO_TEAM").setSenderId(t.getPurUserId()).addReceiverId(t.getBidUserId()).setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    private boolean isAllSetBidSupplier(List<BiddingOffer> biddingOfferList) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingOfferList.get(0).getBiddingNo()).andBiddingRoundsNumberEqualTo(biddingOfferList.get(0).getBiddingRoundsNumber());
        List<BiddingOffer> biddingOfferAllList = this.biddingOfferMapper.selectByExample(offerExample);
        ArrayList<String> biddingOfferMatterList = new ArrayList<String>();
        ArrayList<String> biddingOfferModelList = new ArrayList<String>();
        ArrayList<String> biddingOfferOtherList = new ArrayList<String>();
        ArrayList<String> booleanList = new ArrayList<String>();
        for (BiddingOffer biddingOffer : biddingOfferAllList) {
            if (biddingOffer.getRequirementTypeCode().equals("material")) {
                biddingOfferMatterList.add(biddingOffer.getIsSubmitBid());
                continue;
            }
            if (biddingOffer.getRequirementTypeCode().equals("die")) {
                biddingOfferModelList.add(biddingOffer.getIsSubmitBid());
                continue;
            }
            biddingOfferOtherList.add(biddingOffer.getIsSubmitBid());
        }
        if (CollectionUtils.isEmpty(biddingOfferMatterList) || biddingOfferMatterList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        if (CollectionUtils.isEmpty(biddingOfferModelList) || biddingOfferModelList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        if (CollectionUtils.isEmpty(biddingOfferOtherList) || biddingOfferOtherList.contains("1")) {
            booleanList.add("Y");
        } else {
            booleanList.add("N");
        }
        return Collections.frequency(booleanList, "Y") == booleanList.size();
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        for (int j = 0; CollectionUtils.isNotEmpty(biddingOfferList) && j < biddingOfferList.size(); ++j) {
            this.biddingOfferMapper.deleteByPrimaryKey(biddingOfferList.get(j).getId());
        }
    }

    @Override
    public void deleteBySupCompanyId(String biddingNo, String supCompanyId) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        offerExample.createCriteria().andBiddingNoEqualTo(biddingNo).andSupCompanyIdEqualTo(supCompanyId);
        this.biddingOfferMapper.deleteByExample(offerExample);
    }

    @Override
    public List<TemporaryCodeReducedRate> findBidSupplier(String biddingNo, String type, String currentRound) {
        BiddingOfferExample offerExample = new BiddingOfferExample();
        BiddingOfferExample.Criteria criteria = offerExample.createCriteria();
        criteria.andBiddingNoEqualTo(biddingNo).andRequirementTypeCodeEqualTo(type).andBiddingRoundsNumberEqualTo(currentRound).andBidShareGreaterThan("0").andBidShareIsNotNull();
        List<BiddingOffer> biddingOfferList = this.biddingOfferMapper.selectByExample(offerExample);
        ArrayList<TemporaryCodeReducedRate> codeReducedRates = new ArrayList<TemporaryCodeReducedRate>();
        for (int i = 0; CollectionUtils.isNotEmpty(biddingOfferList) && i < biddingOfferList.size(); ++i) {
            TemporaryCodeReducedRate codeReducedRate = new TemporaryCodeReducedRate();
            codeReducedRate.setTemporaryCode(biddingOfferList.get(i).getSupplierTemporaryCode());
            codeReducedRate.setReducedRate(biddingOfferList.get(i).getBidShare());
            codeReducedRates.add(codeReducedRate);
        }
        TreeSet<TemporaryCodeReducedRate> personSet = new TreeSet<TemporaryCodeReducedRate>((o1, o2) -> o1.getTemporaryCode().compareTo(o2.getTemporaryCode()));
        personSet.addAll(codeReducedRates);
        return new ArrayList<TemporaryCodeReducedRate>(personSet);
    }

    @Override
    public ReportShow queryPriceReport(List<BiddingOffer> reportList) {
        ReportShow monthlyReportShow = new ReportShow();
        ArrayList<Map<String, String>> fristTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> secondTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> dataToTypeMapList = new ArrayList<Map<String, String>>();
        for (int i = 0; CollectionUtils.isNotEmpty(reportList) && i < reportList.size(); ++i) {
            HashMap<String, String> titleMapFristList = new HashMap<String, String>();
            titleMapFristList.put("projectType", reportList.get(i).getSupCompanySrmCode());
            titleMapFristList.put("projectTypeName", reportList.get(i).getSupCompanyName());
            fristTitleList.add(titleMapFristList);
            HashMap<String, String> titleMapSecondList = new HashMap<String, String>();
            titleMapSecondList.put("projectType", reportList.get(i).getSupCompanySrmCode());
            titleMapSecondList.put("projectCode", reportList.get(i).getSupCompanySrmCode());
            titleMapSecondList.put("projectName", reportList.get(i).getSupCompanyName());
            secondTitleList.add(titleMapSecondList);
            HashMap<String, String> mapFinalData = new HashMap<String, String>();
            mapFinalData.put("projectCode", reportList.get(i).getSupCompanySrmCode());
            mapFinalData.put("projectDesc", reportList.get(i).getProjectDesc());
            mapFinalData.put("price", reportList.get(i).getOfferUnitPrice() == null ? "" : reportList.get(i).getOfferUnitPrice().toString());
            dataToTypeMapList.add(mapFinalData);
        }
        monthlyReportShow.setFristTitleList(this.removalOfRepetitionList(fristTitleList, "projectType"));
        monthlyReportShow.setSecondTitleList(this.removalOfRepetitionList(secondTitleList, "projectCode"));
        TreeSet<BiddingOffer> personSet = new TreeSet<BiddingOffer>((o1, o2) -> o1.getProjectDesc().compareTo(o2.getProjectDesc()));
        personSet.addAll(reportList);
        ArrayList<BiddingOffer> finalDataList = new ArrayList<BiddingOffer>(personSet);
        for (int i = 0; CollectionUtils.isNotEmpty(finalDataList) && i < finalDataList.size(); ++i) {
            String projectDesc = ((BiddingOffer)finalDataList.get(i)).getProjectDesc();
            BiddingOffer kpiMonthReport = (BiddingOffer)finalDataList.get(i);
            kpiMonthReport.setDataToTypeMapList(this.selectPointsOfSupCompanyIdScore(projectDesc, dataToTypeMapList));
        }
        monthlyReportShow.setFinalDataList(finalDataList);
        return monthlyReportShow;
    }

    @Override
    public ReportShow queryPriceReport2(List<BiddingOffer> reportList) {
        ReportShow monthlyReportShow = new ReportShow();
        ArrayList<Map<String, String>> titles = new ArrayList<Map<String, String>>();
        StringBuffer titleBuffer = new StringBuffer();
        for (int i = 0; CollectionUtils.isNotEmpty(reportList) && i < reportList.size(); ++i) {
            HashMap<String, String> titleMap = new HashMap<String, String>();
            titleBuffer.setLength(0);
            titleBuffer.append(reportList.get(i).getSupCompanySrmCode()).append("\u3010").append(reportList.get(i).getSupCompanyName()).append("\u3011");
            titleMap.put("supCompanyId", reportList.get(i).getSupCompanyId());
            titleMap.put("supCompanySrmCode", reportList.get(i).getSupCompanySrmCode());
            titleMap.put("supplierTemporaryCode", reportList.get(i).getSupplierTemporaryCode());
            titleMap.put("supCompanyName", reportList.get(i).getSupCompanyName());
            titleMap.put("supCompanyRemark", titleBuffer.toString());
            titleMap.put("type", "\u62a5\u4ef7");
            titles.add(titleMap);
        }
        monthlyReportShow.setTitles(this.removalOfRepetitionList(titles, "supCompanyId"));
        TreeSet<BiddingOffer> personSet = new TreeSet<BiddingOffer>((o1, o2) -> o1.getProjectDesc().compareTo(o2.getProjectDesc()));
        personSet.addAll(reportList);
        ArrayList finalDataList = new ArrayList(personSet);
        ArrayList<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>();
        for (int i = 0; CollectionUtils.isNotEmpty(finalDataList) && i < finalDataList.size(); ++i) {
            String projectDesc = ((BiddingOffer)finalDataList.get(i)).getProjectDesc();
            String projectNo = ((BiddingOffer)finalDataList.get(i)).getProjectNo();
            String tempMaterialNo = ((BiddingOffer)finalDataList.get(i)).getTempMaterialNo();
            HashMap<String, String> item = new HashMap<String, String>();
            for (int j = 0; CollectionUtils.isNotEmpty(reportList) && j < reportList.size(); ++j) {
                if (!projectDesc.equals(reportList.get(j).getProjectDesc())) continue;
                item.put("tempMaterialNo", tempMaterialNo);
                item.put("projectNo", projectNo);
                item.put("projectDesc", projectDesc);
                item.put(reportList.get(j).getSupCompanyId(), reportList.get(j).getOfferUnitPrice());
            }
            itemList.add(item);
        }
        monthlyReportShow.setItemList(itemList);
        return monthlyReportShow;
    }

    private List<Map<String, String>> removalOfRepetitionList(List<Map<String, String>> titleList, String string) {
        ArrayList<Map<String, String>> newList = new ArrayList<Map<String, String>>();
        for (int i = 0; CollectionUtils.isNotEmpty(titleList) && i < titleList.size(); ++i) {
            Map<String, String> oldMap = titleList.get(i);
            if (StringUtils.isBlank((String)oldMap.get(string))) continue;
            if (newList.size() > 0) {
                boolean isContain = false;
                for (int j = 0; j < newList.size(); ++j) {
                    Map newMap = (Map)newList.get(j);
                    if (!((String)newMap.get(string)).equals(oldMap.get(string))) continue;
                    for (String key : oldMap.keySet()) {
                        newMap.put(key, oldMap.get(key));
                    }
                    isContain = true;
                    break;
                }
                if (isContain) continue;
                newList.add(oldMap);
                continue;
            }
            newList.add(oldMap);
        }
        return newList;
    }

    private List<Map<String, String>> selectPointsOfSupCompanyIdScore(String projectDesc, List<Map<String, String>> dataToTypeMapList) {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        for (int j = 0; CollectionUtils.isNotEmpty(dataToTypeMapList) && j < dataToTypeMapList.size(); ++j) {
            Map<String, String> map = dataToTypeMapList.get(j);
            if (StringUtils.isBlank((String)map.get("projectCode")) || !map.get("projectDesc").equals(projectDesc)) continue;
            maps.add(map);
        }
        return maps;
    }

    public void deleteByExample(BiddingOfferExample example) {
    }

    public void addAll(List<BiddingOffer> list) {
    }
}

