/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingGroup;
import com.els.base.bidding.entity.BiddingGroupExample;
import com.els.base.bidding.entity.BiddingTeam;
import com.els.base.bidding.entity.vo.BiddingTeamVO;
import com.els.base.bidding.service.BiddingGroupService;
import com.els.base.bidding.web.controller.BiddingGroupVO;
import com.els.base.company.entity.Department;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.web.vo.DepartmentExcelVO;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4"})
@Controller
@RequestMapping(value={"biddingGroup"})
public class BiddingGroupController {
    @Resource
    protected BiddingGroupService biddingGroupService;
    @Resource
    protected DepartmentService departmentService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingGroup biddingGroup) {
        this.biddingGroupService.insert(biddingGroup, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)biddingGroup.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingGroup biddingGroup) {
        Assert.isNotBlank((String)biddingGroup.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        biddingGroup.setUpdateTime(new Date());
        biddingGroup.setUpdateUser(SpringSecurityUtils.getLoginUser().getNickName());
        this.biddingGroupService.modifyObj(biddingGroup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6fc0\u6d3b\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
    @RequestMapping(value={"service/activationByIds"})
    @ResponseBody
    public ResponseResult<String> activationByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u6fc0\u6d3b\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingGroupService.activation(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        BiddingGroupExample example = new BiddingGroupExample();
        example.createCriteria().andIdIn((List)ids);
        this.biddingGroupService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6295\u6807-\u8bc4\u6807\u5c0f\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingGroup", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingGroup>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BiddingGroupExample example = new BiddingGroupExample();
        example.setPageView((PageView<BiddingGroup>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        BiddingGroupExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnabledEqualTo(Constant.YES_INT);
        User loginUser = SpringSecurityUtils.getLoginUser();
        List departList = this.departmentService.getDepartmentByUserId(loginUser.getId());
        if (CollectionUtils.isNotEmpty((Collection)departList)) {
            List ids = departList.stream().map(DepartmentExcelVO::getInTheOrganizationId).distinct().collect(Collectors.toList());
            criteria.andAffiliateIdIn(ids);
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.biddingGroupService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6807\u5355\u65f6\u6dfb\u52a0\u8bc4\u6807\u4eba\u5458")
    @RequestMapping(value={"service/findGroup"})
    @ResponseBody
    public ResponseResult<List<BiddingTeam>> findGroup(@RequestBody BiddingGroupVO biddingGroupVO) {
        List<BiddingTeamVO> list = biddingGroupVO.getBiddingTeamVOS();
        Assert.isNotEmpty(list, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        list.forEach(vo -> {
            Assert.isNotBlank((String)vo.getBidGroup(), (String)"\u8bc4\u6807\u5c0f\u7ec4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)vo.getDepartId(), (String)"\u90e8\u95e8ID\u4e0d\u80fd\u4e3a\u7a7a");
            if (vo.getNumber() == null || vo.getNumber() == 0) {
                throw new CommonException("\u8f93\u5165\u7684\u6210\u5458\u4eba\u6570\u4e0d\u80fd\u4e3a\u7a7a\u62160");
            }
        });
        ArrayList allTeamList = new ArrayList();
        list.stream().forEach(vo -> {
            List groupList;
            BiddingGroupExample example = new BiddingGroupExample();
            BiddingGroupExample.Criteria criteria = example.createCriteria();
            criteria.andDepartmentIdEqualTo(vo.getDepartId()).andBidGroupEqualTo(vo.getBidGroup()).andIsEnabledEqualTo(Constant.YES_INT);
            if (CollectionUtils.isNotEmpty(biddingGroupVO.getBiddingGroups())) {
                List ids = biddingGroupVO.getBiddingGroups().stream().map(BiddingGroup::getBidUserId).collect(Collectors.toList());
                criteria.andBidUserIdNotIn(ids);
            }
            if (CollectionUtils.isEmpty((Collection)(groupList = this.biddingGroupService.queryAllObjByExample((IExample)example))) || groupList.size() < vo.getNumber()) {
                Department department = (Department)this.departmentService.queryObjById((Object)vo.getDepartId());
                Assert.isNotNull((Object)department, (String)"\u6839\u636e\u90e8\u95e8ID\u67e5\u8be2\u90e8\u95e8\u4fe1\u606f\u4e0d\u5b58\u5728");
                throw new CommonException(department.getDepartmentName() + "\u90e8\u95e8\u6ca1\u6709\u5728\u8bc4\u6807\u5c0f\u7ec4\u7ba1\u7406\u4e2d\u7ef4\u62a4\u4eba\u5458\u4fe1\u606f\u6216\u8005\u8be5\u90e8\u95e8\u5df2\u6709\u7684\u8bc4\u6807\u4eba\u5458\u6570\u5c11\u4e8e\u4f60\u8f93\u5165\u7684\u4eba\u5458\u6570");
            }
            List<BiddingTeam> teamList = this.chooseTeamGroup((BiddingTeamVO)vo, groupList);
            allTeamList.addAll(teamList);
            example.clear();
        });
        return ResponseResult.success(allTeamList);
    }

    private List<BiddingTeam> chooseTeamGroup(BiddingTeamVO vo, List<BiddingGroup> list) {
        ArrayList<BiddingTeam> bidList = new ArrayList<BiddingTeam>();
        Collections.shuffle(list);
        List<BiddingGroup> subList = list.subList(0, vo.getNumber());
        subList.stream().forEach(group -> {
            BiddingTeam t = new BiddingTeam();
            BeanUtils.copyProperties((Object)group, (Object)t);
            t.setId(null);
            t.setGroupId(group.getId());
            t.setBidStatus(Constant.NO_INT);
            bidList.add(t);
        });
        return bidList;
    }
}

