/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingMatterMapper;
import com.els.base.bidding.entity.BiddingMatter;
import com.els.base.bidding.entity.BiddingMatterExample;
import com.els.base.bidding.service.BiddingMatterService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingMatterService")
public class BiddingMatterServiceImpl
implements BiddingMatterService {
    @Resource
    protected BiddingMatterMapper biddingMatterMapper;

    @CacheEvict(value={"biddingMatter"}, allEntries=true)
    public void addObj(BiddingMatter t) {
        this.biddingMatterMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"biddingMatter"}, allEntries=true)
    public void addAll(List<BiddingMatter> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingMatterMapper.insertBatch(list);
    }

    @CacheEvict(value={"biddingMatter"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingMatterMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingMatter"}, allEntries=true)
    public void deleteByExample(BiddingMatterExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingMatterMapper.deleteByExample(example);
    }

    @CacheEvict(value={"biddingMatter"}, allEntries=true)
    public void modifyObj(BiddingMatter t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingMatterMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingMatter"}, keyGenerator="redisKeyGenerator")
    public BiddingMatter queryObjById(String id) {
        return this.biddingMatterMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"biddingMatter"}, keyGenerator="redisKeyGenerator")
    public List<BiddingMatter> queryAllObjByExample(BiddingMatterExample example) {
        return this.biddingMatterMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingMatter"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingMatter> queryObjByPage(BiddingMatterExample example) {
        PageView<BiddingMatter> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingMatterMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"biddingMatter"}, allEntries=true)
    public void insertAndModifyObj(BiddingMatter biddingMatter, Company company, User loginUser) {
        Assert.isNotBlank((String)biddingMatter.getBiddingMatterName(), (String)"\u62db\u6807\u4e8b\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)biddingMatter.getTechnicalWeight(), (String)"\u6280\u672f\u5f97\u5206\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)biddingMatter.getBusniessWeight(), (String)"\u5546\u52a1\u5f97\u5206\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal decimal = biddingMatter.getTechnicalWeight().add(biddingMatter.getBusniessWeight());
        if (decimal.compareTo(BigDecimal.valueOf(100L)) != 0) {
            throw new CommonException("\u6280\u672f\u5f97\u5206\u6743\u91cd\u52a0\u4e0a\u5546\u52a1\u5f97\u5206\u6743\u91cd\u5fc5\u987b\u7b49\u4e8e100");
        }
        if (StringUtils.isBlank((String)biddingMatter.getId())) {
            biddingMatter.setCreater(loginUser.getNickName());
            biddingMatter.setPurCompanyId(company.getId());
            biddingMatter.setPurCompanyCode(company.getCompanyCode());
            biddingMatter.setPurCompanyName(company.getCompanyFullName());
            biddingMatter.setPurUserId(loginUser.getId());
            biddingMatter.setIsEnabled(Constant.YES_INT);
            biddingMatter.setCreateTime(new Date());
            this.biddingMatterMapper.insertSelective(biddingMatter);
        } else {
            biddingMatter.setUpdater(loginUser.getNickName());
            biddingMatter.setUpdateTime(new Date());
            this.biddingMatterMapper.updateByPrimaryKeySelective(biddingMatter);
        }
    }
}

