/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingStandardMapper;
import com.els.base.bidding.entity.BiddingStandard;
import com.els.base.bidding.entity.BiddingStandardExample;
import com.els.base.bidding.entity.BiddingTemplateItemExample;
import com.els.base.bidding.service.BiddingStandardService;
import com.els.base.bidding.service.BiddingTemplateItemService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingStandardService")
public class BiddingStandardServiceImpl
implements BiddingStandardService {
    @Resource
    protected BiddingStandardMapper biddingStandardMapper;
    @Resource
    private BiddingTemplateItemService biddingTemplateItemService;

    @CacheEvict(value={"biddingStandard"}, allEntries=true)
    public void addObj(BiddingStandard t) {
        this.biddingStandardMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"biddingStandard"}, allEntries=true)
    public void insertObj(BiddingStandard biddingStandard, Company purCompany, User loginUser) {
        Assert.isNotNull((Object)biddingStandard, (String)"\u8bc4\u6807\u6807\u51c6\u6570\u636e\u4e3a\u7a7a\uff0c\u65b0\u589e\u5931\u8d25");
        Assert.isNotBlank((String)biddingStandard.getStandardType(), (String)"\u6807\u51c6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingStandard.getStandardCode(), (String)"\u6807\u51c6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingStandard.getStandardName(), (String)"\u6807\u51c6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        biddingStandard.setPurCompanyId(purCompany.getId());
        biddingStandard.setPurCompanyName(purCompany.getCompanyFullName());
        biddingStandard.setPurCompanySapCode(purCompany.getCompanySapCode());
        biddingStandard.setPurCompanySrmCode(purCompany.getCompanyCode());
        biddingStandard.setPurUserId(loginUser.getId());
        biddingStandard.setPurUserName(loginUser.getNickName());
        biddingStandard.setIsEnabled(Constant.YES_INT);
        biddingStandard.setCreateTime(new Date());
        this.biddingStandardMapper.insertSelective(biddingStandard);
    }

    @Override
    @CacheEvict(value={"biddingStandard"}, allEntries=true)
    public void updateObj(BiddingStandard biddingStandard, User loginUser) {
        BiddingTemplateItemExample itemExample = new BiddingTemplateItemExample();
        itemExample.createCriteria().andStandardIdEqualTo(biddingStandard.getId());
        List itemList = this.biddingTemplateItemService.queryAllObjByExample((IExample)itemExample);
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            throw new CommonException("\u6b64\u6807\u51c6\u5df2\u5728\u8bc4\u6807\u6a21\u677f\u4e2d\u4f7f\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539");
        }
        Assert.isNotBlank((String)biddingStandard.getStandardType(), (String)"\u6807\u51c6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingStandard.getStandardCode(), (String)"\u6807\u51c6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingStandard.getStandardName(), (String)"\u6807\u51c6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        biddingStandard.setUpdateTime(new Date());
        biddingStandard.setUpdateUser(loginUser.getNickName());
        this.biddingStandardMapper.updateByPrimaryKeySelective(biddingStandard);
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingStandard"}, allEntries=true)
    public void activation(List<String> ids, User loginUser) {
        BiddingStandardExample example = new BiddingStandardExample();
        example.createCriteria().andIdIn((List)ids);
        List<BiddingStandard> list = this.biddingStandardMapper.selectByExample(example);
        Assert.isNotEmpty(list, (String)"\u8bc4\u6807\u6807\u51c6\u4e0d\u5b58\u5728\uff0c\u6fc0\u6d3b\u64cd\u4f5c\u5931\u8d25");
        for (BiddingStandard stan : list) {
            BiddingStandard biddingStandard = new BiddingStandard();
            biddingStandard.setId(stan.getId());
            biddingStandard.setUpdateTime(new Date());
            biddingStandard.setUpdateUser(loginUser.getNickName());
            if (stan.getActivationStatus() == 1) {
                biddingStandard.setActivationStatus(Constant.NO_INT);
            } else if (stan.getActivationStatus() == 0) {
                biddingStandard.setActivationStatus(Constant.YES_INT);
            }
            this.biddingStandardMapper.updateByPrimaryKeySelective(biddingStandard);
        }
    }

    @Transactional
    @CacheEvict(value={"biddingStandard"}, allEntries=true)
    public void addAll(List<BiddingStandard> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingStandardMapper.insertBatch(list);
    }

    @CacheEvict(value={"biddingStandard"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingStandardMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingStandard"}, allEntries=true)
    public void deleteByExample(BiddingStandardExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingStandardMapper.deleteByExample(example);
    }

    @CacheEvict(value={"biddingStandard"}, allEntries=true)
    public void modifyObj(BiddingStandard t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingStandardMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingStandard"}, keyGenerator="redisKeyGenerator")
    public BiddingStandard queryObjById(String id) {
        return this.biddingStandardMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"biddingStandard"}, keyGenerator="redisKeyGenerator")
    public List<BiddingStandard> queryAllObjByExample(BiddingStandardExample example) {
        return this.biddingStandardMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingStandard"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingStandard> queryObjByPage(BiddingStandardExample example) {
        PageView<BiddingStandard> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingStandardMapper.selectByExampleByPage(example));
        return pageView;
    }
}

