/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingTemplateMapper;
import com.els.base.bidding.entity.BiddingTemplate;
import com.els.base.bidding.entity.BiddingTemplateExample;
import com.els.base.bidding.entity.BiddingTemplateInfoExample;
import com.els.base.bidding.entity.BiddingTemplateItem;
import com.els.base.bidding.entity.BiddingTemplateItemExample;
import com.els.base.bidding.service.BiddingTemplateInfoService;
import com.els.base.bidding.service.BiddingTemplateItemService;
import com.els.base.bidding.service.BiddingTemplateService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingTemplateService")
public class BiddingTemplateServiceImpl
implements BiddingTemplateService {
    @Resource
    protected BiddingTemplateMapper biddingTemplateMapper;
    @Resource
    private BiddingTemplateItemService biddingTemplateItemService;
    @Resource
    private BiddingTemplateInfoService biddingTemplateInfoService;

    @CacheEvict(value={"biddingTemplate"}, allEntries=true)
    public void addObj(BiddingTemplate t) {
        this.biddingTemplateMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingTemplate"}, allEntries=true)
    public void insetObj(BiddingTemplate biddingTemplate, Company purCompany, User loginUser) {
        this.checkData(biddingTemplate);
        this.setPurCompanyInfo(biddingTemplate, purCompany, loginUser);
        this.biddingTemplateMapper.insertSelective(biddingTemplate);
        this.checkDataByItem(biddingTemplate);
        biddingTemplate.getItemList().stream().forEach(item -> {
            item.setTemplateId(biddingTemplate.getId());
            item.setCreateTime(new Date());
            item.setCreater(loginUser.getNickName());
            item.setIsEnabled(Constant.YES_INT);
        });
        this.biddingTemplateItemService.addAll(biddingTemplate.getItemList());
    }

    private void checkDataByItem(BiddingTemplate biddingTemplate) {
        List<BiddingTemplateItem> itemList = biddingTemplate.getItemList();
        BigDecimal weight = BigDecimal.ZERO;
        for (BiddingTemplateItem item : itemList) {
            Assert.isNotBlank((String)item.getStandardId(), (String)"\u8bc4\u6807\u6807\u51c6ID\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getStandardCode(), (String)"\u8bc4\u6807\u6807\u51c6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            if (item.getWeightCoefficient() == null || item.getWeightCoefficient().compareTo(BigDecimal.ZERO) == 0) {
                throw new CommonException("\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a\u96f6");
            }
            weight = weight.add(item.getWeightCoefficient());
        }
        if (weight.compareTo(BigDecimal.valueOf(100L)) != 0) {
            throw new CommonException("\u6743\u91cd\u603b\u548c\u5fc5\u987b\u7b49\u4e8e100");
        }
    }

    private void setPurCompanyInfo(BiddingTemplate biddingTemplate, Company purCompany, User loginUser) {
        biddingTemplate.setPurCompanyId(purCompany.getId());
        biddingTemplate.setPurCompanyName(purCompany.getCompanyFullName());
        biddingTemplate.setPurCompanySapCode(purCompany.getCompanySapCode());
        biddingTemplate.setPurCompanySrmCode(purCompany.getCompanyCode());
        biddingTemplate.setPurUserId(loginUser.getId());
        biddingTemplate.setPurUserName(loginUser.getNickName());
        biddingTemplate.setCreateTime(new Date());
        biddingTemplate.setIsEnabled(Constant.YES_INT);
    }

    private void checkData(BiddingTemplate biddingTemplate) {
        Assert.isNotBlank((String)biddingTemplate.getTemplateType(), (String)"\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingTemplate.getTemplateCode(), (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingTemplate.getTemplateName(), (String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)biddingTemplate.getApplyScope(), (String)"\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional
    @CacheEvict(value={"biddingTemplate"}, allEntries=true)
    public void addAll(List<BiddingTemplate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingTemplateMapper.insertBatch(list);
    }

    @CacheEvict(value={"biddingTemplate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingTemplateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingTemplate"}, allEntries=true)
    public void deleteByExample(BiddingTemplateExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingTemplateMapper.deleteByExample(example);
    }

    @CacheEvict(value={"biddingTemplate"}, allEntries=true)
    public void modifyObj(BiddingTemplate t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingTemplateMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingTemplate"}, allEntries=true)
    public void updateObj(BiddingTemplate biddingTemplate, User loginUser) {
        BiddingTemplateInfoExample infoExample = new BiddingTemplateInfoExample();
        infoExample.createCriteria().andTemplateIdEqualTo(biddingTemplate.getId());
        List infoList = this.biddingTemplateInfoService.queryAllObjByExample((IExample)infoExample);
        if (CollectionUtils.isNotEmpty((Collection)infoList)) {
            throw new CommonException("\u6b64\u6a21\u677f\u5df2\u5173\u8054\u62db\u6807\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539");
        }
        this.checkData(biddingTemplate);
        this.checkDataByItem(biddingTemplate);
        biddingTemplate.setUpdateTime(new Date());
        biddingTemplate.setUpdateUser(loginUser.getNickName());
        this.biddingTemplateMapper.updateByPrimaryKeySelective(biddingTemplate);
        BiddingTemplateItemExample itemExample = new BiddingTemplateItemExample();
        itemExample.createCriteria().andTemplateIdEqualTo(biddingTemplate.getId());
        this.biddingTemplateItemService.deleteByExample((IExample)itemExample);
        biddingTemplate.getItemList().stream().forEach(item -> {
            item.setTemplateId(biddingTemplate.getId());
            item.setCreater(loginUser.getNickName());
            item.setCreateTime(new Date());
            item.setIsEnabled(Constant.YES_INT);
        });
        this.biddingTemplateItemService.addAll(biddingTemplate.getItemList());
    }

    @Cacheable(value={"biddingTemplate"}, keyGenerator="redisKeyGenerator")
    public BiddingTemplate queryObjById(String id) {
        BiddingTemplate template = this.biddingTemplateMapper.selectByPrimaryKey(id);
        BiddingTemplateItemExample itemExample = new BiddingTemplateItemExample();
        itemExample.createCriteria().andTemplateIdEqualTo(id);
        List list = this.biddingTemplateItemService.queryAllObjByExample((IExample)itemExample);
        template.setItemList(list);
        return template;
    }

    @Cacheable(value={"biddingTemplate"}, keyGenerator="redisKeyGenerator")
    public List<BiddingTemplate> queryAllObjByExample(BiddingTemplateExample example) {
        return this.biddingTemplateMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingTemplate"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingTemplate> queryObjByPage(BiddingTemplateExample example) {
        PageView<BiddingTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingTemplate"}, allEntries=true)
    public void deleteObjByIds(List<String> ids) {
        BiddingTemplateExample example = new BiddingTemplateExample();
        example.createCriteria().andIdIn((List)ids);
        List<BiddingTemplate> list = this.biddingTemplateMapper.selectByExample(example);
        for (BiddingTemplate biddingTemplate : list) {
            BiddingTemplateInfoExample infoExample = new BiddingTemplateInfoExample();
            infoExample.createCriteria().andTemplateIdEqualTo(biddingTemplate.getId());
            List infoList = this.biddingTemplateInfoService.queryAllObjByExample((IExample)infoExample);
            if (!CollectionUtils.isNotEmpty((Collection)infoList)) continue;
            throw new CommonException("\u6a21\u677f\u7f16\u53f7\uff1a" + biddingTemplate.getTemplateCode() + ",\u6a21\u677f\u540d\u79f0\uff1a" + biddingTemplate.getTemplateName() + "\u7684\u6a21\u677f\u5df2\u5173\u8054\u62db\u6807\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664");
        }
        this.biddingTemplateMapper.deleteByExample(example);
        BiddingTemplateItemExample itemExample = new BiddingTemplateItemExample();
        itemExample.createCriteria().andTemplateIdIn((List)ids);
        this.biddingTemplateItemService.deleteByExample((IExample)itemExample);
    }
}

