/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingFileSupplier;
import com.els.base.bidding.entity.BiddingFileSupplierExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.BiddingSupplierExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.enums.BiddingFileTypeEnum;
import com.els.base.bidding.enums.BiddingGroupTypeEnum;
import com.els.base.bidding.service.BiddingFileSupplierService;
import com.els.base.bidding.service.BiddingSupplierService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u62db\u6807\u6587\u4ef6\u56de\u7b7e"})
@Controller
@RequestMapping(value={"biddingFileSupplier"})
public class BiddingFileSupplierController {
    @Resource
    protected BiddingFileSupplierService biddingFileSupplierService;
    @Resource
    protected BiddingSupplierService biddingSupplierService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u62db\u6807\u6587\u4ef6\u56de\u7b7e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BiddingFileSupplier biddingFileSupplier) {
        this.biddingFileSupplierService.addObj(biddingFileSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u62db\u6807\u6587\u4ef6\u56de\u7b7e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BiddingFileSupplier biddingFileSupplier) {
        Assert.isNotBlank((String)biddingFileSupplier.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.biddingFileSupplierService.modifyObj(biddingFileSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u62db\u6807\u6587\u4ef6\u56de\u7b7e")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.biddingFileSupplierService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62db\u6807\u6587\u4ef6\u56de\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="999"), @ApiImplicitParam(name="biddingGroupType", required=false, value="\u8bc4\u6807\u5c0f\u7ec4\u7c7b\u578b", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BiddingFileSupplier", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BiddingFileSupplier>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="999") int pageSize, @RequestParam String biddingGroupType, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        List fileList;
        BiddingFileSupplierExample example = new BiddingFileSupplierExample();
        example.setPageView((PageView<BiddingFileSupplier>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(fileList = (pageData = this.biddingFileSupplierService.queryObjByPage((IExample)example)).getQueryResult()))) {
            return ResponseResult.success((Object)pageData);
        }
        ArrayList<BiddingFileSupplier> fileSupplierList = new ArrayList<BiddingFileSupplier>();
        if (StringUtils.isNotBlank((CharSequence)biddingGroupType)) {
            if (BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue().equals(biddingGroupType)) {
                fileList = fileList.stream().filter(supFile -> !BiddingFileTypeEnum.BUSINESS_DOCUMENTS.getValue().equals(supFile.getFileType())).collect(Collectors.toList());
            } else if (BiddingGroupTypeEnum.BUSINESS_GROUP.getValue().equals(biddingGroupType)) {
                fileList = fileList.stream().filter(supFile -> !BiddingFileTypeEnum.TECHNOLOGY_DOCUMENTS.getValue().equals(supFile.getFileType())).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fileList)) {
            BiddingSupplierExample supExample = new BiddingSupplierExample();
            supExample.createCriteria().andBiddingNoEqualTo(((BiddingFileSupplier)fileList.get(0)).getBiddingNo()).andSupBiddingEqualTo(Constant.YES_INT.toString());
            List supplierList = this.biddingSupplierService.queryAllObjByExample((IExample)supExample);
            List<Object> ids = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)supplierList)) {
                ids = supplierList.stream().map(BiddingSupplier::getSupCompanyId).collect(Collectors.toList());
            }
            for (BiddingFileSupplier fileSupplier : fileList) {
                if (!ids.contains(fileSupplier.getSupCompanyId())) continue;
                fileSupplierList.add(fileSupplier);
            }
        }
        pageData.setQueryResult(fileSupplierList);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u56de\u7b7e\u6587\u4ef6\u4e0a\u4f20\u4fdd\u5b58")
    @RequestMapping(value={"service/saveFileSupplier"})
    @ResponseBody
    public ResponseResult<BiddingBaseVo> saveFileSupplier(@RequestBody BiddingBaseVo biddingBaseVo) {
        if (CollectionUtils.isEmpty(biddingBaseVo.getBiddingFileSupplier())) {
            throw new CommonException("\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", new Object[]{"\u56de\u7b7e\u5217\u8868\u6570\u636e"});
        }
        biddingBaseVo.setCompany(CompanyUtils.currentCompany());
        biddingBaseVo.setUser(SpringSecurityUtils.getLoginUser());
        this.biddingFileSupplierService.saveFileSupplier(biddingBaseVo);
        return ResponseResult.success((Object)biddingBaseVo);
    }
}

