/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingScoreMapper;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingScore;
import com.els.base.bidding.entity.BiddingScoreExample;
import com.els.base.bidding.entity.BiddingTeam;
import com.els.base.bidding.entity.BiddingTeamExample;
import com.els.base.bidding.enums.BiddingGroupTypeEnum;
import com.els.base.bidding.enums.ConfirmStatusEnum;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingScoreService;
import com.els.base.bidding.service.BiddingTeamService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingScoreService")
public class BiddingScoreServiceImpl
implements BiddingScoreService {
    @Resource
    protected BiddingScoreMapper biddingScoreMapper;
    @Resource
    protected BiddingTeamService biddingTeamService;
    @Resource
    protected BiddingHeaderService biddingHeaderService;

    @CacheEvict(value={"biddingScore"}, allEntries=true)
    public void addObj(BiddingScore t) {
        this.biddingScoreMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"biddingScore"}, allEntries=true)
    public void addAll(List<BiddingScore> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingScoreMapper.insertBatch(list);
    }

    @CacheEvict(value={"biddingScore"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingScoreMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingScore"}, allEntries=true)
    public void deleteByExample(BiddingScoreExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingScoreMapper.deleteByExample(example);
    }

    @CacheEvict(value={"biddingScore"}, allEntries=true)
    public void modifyObj(BiddingScore t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingScoreMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingScore"}, keyGenerator="redisKeyGenerator")
    public BiddingScore queryObjById(String id) {
        return this.biddingScoreMapper.selectByPrimaryKey(id);
    }

    public List<BiddingScore> queryAllObjByExample(BiddingScoreExample example) {
        return this.biddingScoreMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingScore"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingScore> queryObjByPage(BiddingScoreExample example) {
        PageView<BiddingScore> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingScoreMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingScore"}, allEntries=true)
    public void saveObj(List<BiddingScore> biddingScores, Company purCompany, User purUser) {
        BigDecimal technicalFinalScore = BigDecimal.ZERO;
        BigDecimal businessFinalScore = BigDecimal.ZERO;
        for (BiddingScore bs : biddingScores) {
            BigDecimal tScore;
            if (BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue().equals(bs.getTemplateType())) {
                if (bs.getScore() == null) continue;
                tScore = bs.getScore().multiply(bs.getWeightCoefficient()).divide(BigDecimal.valueOf(100L)).setScale(2, 4);
                technicalFinalScore = technicalFinalScore.add(tScore);
                continue;
            }
            if (!BiddingGroupTypeEnum.BUSINESS_GROUP.getValue().equals(bs.getTemplateType()) || bs.getScore() == null) continue;
            tScore = bs.getScore().multiply(bs.getWeightCoefficient()).divide(BigDecimal.valueOf(100L)).setScale(2, 4);
            businessFinalScore = businessFinalScore.add(tScore);
        }
        for (BiddingScore biddingScore : biddingScores) {
            Assert.isNotBlank((String)biddingScore.getId(), (String)"id\u4e3a\u7a7a\u4fdd\u5b58\u5931\u8d25");
            BiddingScore score = new BiddingScore();
            score.setId(biddingScore.getId());
            score.setScore(biddingScore.getScore());
            score.setPurCompanyId(purCompany.getId());
            score.setPurCompanyName(purCompany.getCompanyFullName());
            score.setPurCompanySapCode(purCompany.getCompanySapCode());
            score.setPurCompanySrmCode(purCompany.getCompanyCode());
            score.setPurUserId(purUser.getId());
            score.setPurUserName(purUser.getNickName());
            score.setUpdateTime(new Date());
            score.setUpdateUser(purUser.getNickName());
            score.setBidStatus(Constant.YES_INT);
            if (BiddingGroupTypeEnum.TECHNICAL_GROUP.getValue().equals(biddingScore.getTemplateType())) {
                score.setFinalScore(technicalFinalScore);
            } else if (BiddingGroupTypeEnum.BUSINESS_GROUP.getValue().equals(biddingScore.getTemplateType())) {
                score.setBusinessFinalScore(businessFinalScore);
            }
            this.biddingScoreMapper.updateByPrimaryKeySelective(score);
        }
        BiddingScoreExample scoreExample = new BiddingScoreExample();
        scoreExample.createCriteria().andBiddingNoEqualTo(biddingScores.get(0).getBiddingNo()).andBiddingRoundsNumberEqualTo(biddingScores.get(0).getBiddingRoundsNumber()).andRatersIdEqualTo(purUser.getId()).andBidStatusEqualTo(Constant.NO_INT);
        List<BiddingScore> list = this.biddingScoreMapper.selectByExample(scoreExample);
        if (CollectionUtils.isEmpty(list)) {
            BiddingTeamExample teamExample = new BiddingTeamExample();
            teamExample.createCriteria().andBiddingNoEqualTo(biddingScores.get(0).getBiddingNo()).andBiddingRoundsNumberEqualTo(biddingScores.get(0).getBiddingRoundsNumber()).andBidUserIdEqualTo(purUser.getId());
            BiddingTeam team = new BiddingTeam();
            team.setBidStatus(Constant.YES_INT);
            this.biddingTeamService.modifyByExample(teamExample, team);
            teamExample.clear();
            teamExample.createCriteria().andBiddingNoEqualTo(biddingScores.get(0).getBiddingNo()).andBiddingRoundsNumberEqualTo(biddingScores.get(0).getBiddingRoundsNumber()).andBidStatusEqualTo(Constant.NO_INT);
            List teamList = this.biddingTeamService.queryAllObjByExample((IExample)teamExample);
            BiddingHeaderExample headerExample = new BiddingHeaderExample();
            headerExample.createCriteria().andBiddingNoEqualTo(biddingScores.get(0).getBiddingNo());
            BiddingHeader header = new BiddingHeader();
            if (CollectionUtils.isNotEmpty((Collection)teamList)) {
                header.setScoreStatus(ConfirmStatusEnum.PART_CONFIRM.getValue());
            } else {
                header.setScoreStatus(ConfirmStatusEnum.ALL_CONFIRM.getValue());
            }
            this.biddingHeaderService.editStatus(header, headerExample);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingScore"}, allEntries=true)
    public void confirmBidResults(String biddingNo, String biddingRoundsNumber, Company purompany, User purUser) {
        BiddingTeamExample teamExample = new BiddingTeamExample();
        teamExample.createCriteria().andBiddingNoEqualTo(biddingNo).andBiddingRoundsNumberEqualTo(biddingRoundsNumber).andBidGroupEqualTo(BiddingGroupTypeEnum.BUSINESS_GROUP.getValue()).andBidUserIdEqualTo(purUser.getId());
        BiddingTeam team = new BiddingTeam();
        team.setConfirmStatus(Constant.YES_INT);
        this.biddingTeamService.modifyByExample(teamExample, team);
    }

    @Override
    @CacheEvict(value={"biddingScore"}, allEntries=true)
    @Transactional
    public void deleteByBiddingNo(String biddingNo) {
        Assert.isNotBlank((String)biddingNo, (String)"\u62db\u6807\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5220\u9664\u8bc4\u5206\u4fe1\u606f\u5931\u8d25");
        BiddingScoreExample example = new BiddingScoreExample();
        example.createCriteria().andBiddingNoEqualTo(biddingNo);
        this.biddingScoreMapper.deleteByExample(example);
    }
}

