/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bidding.service.impl;

import com.els.base.bidding.dao.BiddingTeamMapper;
import com.els.base.bidding.entity.BiddingTeam;
import com.els.base.bidding.entity.BiddingTeamExample;
import com.els.base.bidding.service.BiddingTeamService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBiddingTeamService")
public class BiddingTeamServiceImpl
implements BiddingTeamService {
    @Resource
    protected BiddingTeamMapper biddingTeamMapper;

    @CacheEvict(value={"biddingTeam"}, allEntries=true)
    public void addObj(BiddingTeam t) {
        this.biddingTeamMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"biddingTeam"}, allEntries=true)
    public void addAll(List<BiddingTeam> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.biddingTeamMapper.insertBatch(list);
    }

    @CacheEvict(value={"biddingTeam"}, allEntries=true)
    public void deleteObjById(String id) {
        this.biddingTeamMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"biddingTeam"}, allEntries=true)
    public void deleteByExample(BiddingTeamExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.biddingTeamMapper.deleteByExample(example);
    }

    @CacheEvict(value={"biddingTeam"}, allEntries=true)
    public void modifyObj(BiddingTeam t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.biddingTeamMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"biddingTeam"}, keyGenerator="redisKeyGenerator")
    public BiddingTeam queryObjById(String id) {
        return this.biddingTeamMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"biddingTeam"}, keyGenerator="redisKeyGenerator")
    public List<BiddingTeam> queryAllObjByExample(BiddingTeamExample example) {
        return this.biddingTeamMapper.selectByExample(example);
    }

    @Cacheable(value={"biddingTeam"}, keyGenerator="redisKeyGenerator")
    public PageView<BiddingTeam> queryObjByPage(BiddingTeamExample example) {
        PageView<BiddingTeam> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingTeamMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"biddingTeam"}, allEntries=true)
    public void deleteByBiddingNo(String biddingNo) {
        BiddingTeamExample example = new BiddingTeamExample();
        example.createCriteria().andBiddingNoEqualTo(biddingNo);
        this.biddingTeamMapper.deleteByExample(example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"biddingTeam"}, allEntries=true)
    public void modifyByExample(BiddingTeamExample teamExample, BiddingTeam team) {
        this.biddingTeamMapper.updateByExampleSelective(team, teamExample);
    }
}

